/*
 * Decompiled with CFR 0.152.
 */
package com.mediakind.contentapi.module.title.controller;

import com.mediakind.contentapi.module.title.domain.entity.TitleEntity;
import com.mediakind.contentapi.module.title.mapper.TitleMapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"Catalog Management"}, value="APIs about Catalog Management")
@RestController
@RequestMapping(value={"/v1/assets"})
public class TitleController {
    private static final Logger log = LogManager.getLogger(TitleController.class);
    @Autowired
    private TitleMapper titleMapper;

    @ApiOperation(value="List Assets")
    @GetMapping(produces={"application/json"})
    public List<Map<String, Object>> listAssets() {
        log.info("new api  ----  List assets");
        return null;
    }

    @ApiOperation(value="Get Asset")
    @GetMapping(value={"/{id}"})
    public TitleEntity getAsset(@PathVariable String id) {
        log.info("new api  ----  Get assets");
        return this.titleMapper.getById(Long.parseLong(id));
    }

    @ApiOperation(value="Create Asset")
    @PostMapping
    public List<TitleEntity> createAsset() {
        return this.titleMapper.getTitles();
    }

    @ApiOperation(value="Update Asset")
    @PutMapping(value={"/{id}"})
    public List<TitleEntity> updateAsset() {
        return this.titleMapper.getTitles();
    }

    @ApiOperation(value="Delete Asset")
    @DeleteMapping(value={"{id}"})
    public List<TitleEntity> deleteAsset() {
        return this.titleMapper.getTitles();
    }
}

