/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.security.authprovider;

import com.ericsson.neptune.security.NeptunePrincipal;
import com.ericsson.neptune.security.User;
import com.ericsson.neptune.security.authprovider.TokenInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;

public class AuthProviderClient {
    private static int CONNECTION_TIMEOUT = 15000;
    private String validateUrl;
    private Logger logger = Logger.getLogger(AuthProviderClient.class);

    public void setValidateUrl(String validateUrl) {
        this.validateUrl = validateUrl;
    }

    public AuthProviderClient() {
        this.disableSSLValidation();
    }

    public TokenInfo validateToken(String token, HttpServletRequest originalRequest) {
        this.logger.debug((Object)"Validating token with provider");
        if (token == null || token.trim().isEmpty() || originalRequest == null) {
            throw new IllegalArgumentException("Token and original request are required");
        }
        try {
            URL url = this.buildValidateUrl(token);
            HttpURLConnection conn = this.makeValidationRequest(url, originalRequest.getCookies());
            String validationResponse = this.readValidationResponse(conn);
            this.logger.debug((Object)("Response: " + validationResponse));
            if (conn.getResponseCode() == 200 && !validationResponse.isEmpty()) {
                return TokenInfo.parse(validationResponse);
            }
            this.logger.warn((Object)("Got invalid response with status " + conn.getResponseCode() + " and response " + validationResponse));
            return null;
        }
        catch (SocketTimeoutException e) {
            this.logger.error((Object)"Connection timed out. ", (Throwable)e);
            return null;
        }
        catch (Exception e) {
            this.logger.error((Object)"Could not validate token with Provider. ", (Throwable)e);
            e.printStackTrace();
            return null;
        }
    }

    public NeptunePrincipal getRoles(String webserviceUrl, HttpServletRequest request, NeptunePrincipal principalObject) throws MalformedURLException {
        block11: {
            HttpSession session;
            URL url = new URL(webserviceUrl);
            String NEPTUNE_SSO_OAUTH2_AUTHENTICATION_PRINCIPAL = "neptune_sso_oauth2_principal";
            boolean isUIRequest = true;
            Enumeration headerNames = request.getHeaderNames();
            HashMap<String, String> headers = new HashMap<String, String>();
            if (headerNames != null) {
                while (headerNames.hasMoreElements()) {
                    String headerName = (String)headerNames.nextElement();
                    if (headerName.equals("Authorization")) {
                        isUIRequest = false;
                    }
                    String header = request.getHeader(headerName);
                    headers.put(headerName, header);
                }
            }
            if (isUIRequest && (session = request.getSession(false)) != null && (principalObject = (NeptunePrincipal)session.getAttribute(NEPTUNE_SSO_OAUTH2_AUTHENTICATION_PRINCIPAL)) != null) {
                headers.put("Authorization", "Bearer " + principalObject.getToken());
            }
            try {
                HttpURLConnection conn = this.makeWebServiceRequest(url, headers);
                String validationResponse = this.readValidationResponse(conn);
                if (conn.getResponseCode() == 200 && validationResponse != null && !validationResponse.isEmpty()) {
                    ObjectMapper mapper = new ObjectMapper();
                    TypeReference<HashMap<String, Set<User>>> jsonUsersNRoles = new TypeReference<HashMap<String, Set<User>>>(){};
                    try {
                        HashMap userrolemap = (HashMap)mapper.readValue(validationResponse.getBytes(), (TypeReference)jsonUsersNRoles);
                        Set set = (Set)userrolemap.get("usersAndRoles");
                        for (User user : set) {
                            if (principalObject == null) {
                                principalObject = new NeptunePrincipal(user.getUserName());
                            }
                            principalObject.setRoles(user.getRoleSets());
                        }
                        break block11;
                    }
                    catch (Exception e) {
                        this.logger.error((Object)("Got invalid response with status " + conn.getResponseCode() + " and response " + validationResponse));
                        return null;
                    }
                }
                this.logger.error((Object)("Got invalid response from neptune with status " + conn.getResponseCode() + " and response " + validationResponse));
                return null;
            }
            catch (IOException e) {
                this.logger.error((Object)"Could get roles from neptune. ", (Throwable)e);
                e.printStackTrace();
                return null;
            }
        }
        return principalObject;
    }

    private HttpURLConnection makeValidationRequest(URL url, Cookie[] originalRequestCookies) throws IOException, ProtocolException {
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setDoOutput(true);
        conn.setRequestMethod("GET");
        conn.setRequestProperty("Content-Type", "application/text");
        conn.setConnectTimeout(CONNECTION_TIMEOUT);
        conn.setReadTimeout(CONNECTION_TIMEOUT);
        if (originalRequestCookies != null) {
            for (Cookie cookie : originalRequestCookies) {
                conn.addRequestProperty("Cookie", cookie.getName() + "=" + cookie.getValue());
            }
        }
        conn.connect();
        return conn;
    }

    private URL buildValidateUrl(String token) throws MalformedURLException {
        StringBuilder result = new StringBuilder();
        result.append(this.validateUrl);
        result.append("?access_token=");
        result.append(token);
        String resultStr = result.toString();
        this.logger.debug((Object)("Provider url: " + resultStr));
        return new URL(resultStr);
    }

    private void disableSSLValidation() {
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new TolerantTrustManager()};
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HostnameVerifier allHostsValid = new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            };
            HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
        }
        catch (NoSuchAlgorithmException e) {
            this.logger.error((Object)"Could nog disable SSL validation", (Throwable)e);
        }
        catch (KeyManagementException e) {
            this.logger.error((Object)"Could nog disable SSL validation", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readValidationResponse(HttpURLConnection conn) {
        BufferedReader reader = null;
        try {
            StringBuilder buff = new StringBuilder();
            reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String line = null;
            while ((line = reader.readLine()) != null) {
                buff.append(line);
            }
            String string = buff.toString();
            return string;
        }
        catch (IOException e) {
            this.logger.warn((Object)"Could not parse validation response", (Throwable)e);
            String string = "";
            return string;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public HttpURLConnection makeWebServiceRequest(URL url, HashMap<String, String> headers) throws IOException, ProtocolException {
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setDoOutput(true);
        conn.setRequestMethod("GET");
        conn.setRequestProperty("Content-Type", "application/json");
        if (headers != null) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                conn.setRequestProperty(header.getKey(), header.getValue());
            }
        }
        conn.connect();
        return conn;
    }

    public Properties readProperties(String filePath) throws ServletException {
        InputStream inputStream = null;
        try {
            File urlPropertiesFile = new File(filePath);
            Properties providerUrls = new Properties();
            inputStream = new FileInputStream(urlPropertiesFile);
            providerUrls.load(inputStream);
            Properties properties = providerUrls;
            return properties;
        }
        catch (Exception e) {
            this.logger.error((Object)"Could not load provider urls configuration", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    this.logger.error((Object)"Can not close input stream for properties file", (Throwable)e);
                }
            }
        }
    }

    static class TolerantTrustManager
    implements X509TrustManager {
        TolerantTrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }
    }
}

