/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.security.filter;

import com.ericsson.neptune.security.NeptunePrincipal;
import com.ericsson.neptune.security.authprovider.AuthProviderClient;
import java.io.IOException;
import java.util.Properties;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class AuthorizationFilter
implements Filter {
    private Logger logger = Logger.getLogger(AuthorizationFilter.class);
    private static final String NEPTUNE_SSO_OAUTH2_AUTHENTICATION_PRINCIPAL = "neptune_sso_oauth2_principal";
    protected static final String NEPTUNE_SSO_OAUTH2_PROVIDER_URLS_PROPERTIES = "neptune_sso_oauth2_provider_urls_properties";
    protected static final String NEPTUNE_SSO_WEBSERVICE_URL = "neptune_sso_webservice_url";
    String webserviceUrl;
    private boolean isNeptune;
    private AuthProviderClient providerClient;

    public void destroy() {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        NeptunePrincipal updatedPrincipal;
        if (!this.isHttp(servletRequest, servletResponse)) {
            this.logger.debug((Object)"Neptune OAuth SSO Filter NOT interrupting the request since either request or response is not of HTTP type");
            this.logger.debug((Object)"Continuing with rest of the filters in the filter chain");
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        this.logger.debug((Object)"Neptune OAuth SSO Filter interrupting the request");
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        if (!this.isNeptune) {
            NeptunePrincipal principalObject = (NeptunePrincipal)request.getAttribute(NEPTUNE_SSO_OAUTH2_AUTHENTICATION_PRINCIPAL);
            updatedPrincipal = this.providerClient.getRoles(this.webserviceUrl, request, principalObject);
            if (updatedPrincipal == null) {
                this.logger.error((Object)"Unable to get the roles.");
                response.sendError(403);
                return;
            }
        } else {
            this.logger.error((Object)"Wrong filter configuration.Should have configured the LocalAuthorizationFilter for Neptune.");
            response.sendError(417, "This component is not Neptune. Need to configure webservice url in provider properties file");
            return;
        }
        request.setAttribute(NEPTUNE_SSO_OAUTH2_AUTHENTICATION_PRINCIPAL, (Object)updatedPrincipal);
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private boolean isHttp(ServletRequest request, ServletResponse response) {
        return request instanceof HttpServletRequest && response instanceof HttpServletResponse;
    }

    public void init(FilterConfig config) throws ServletException {
        this.providerClient = new AuthProviderClient();
        Properties providerUrls = this.providerClient.readProperties(config.getInitParameter(NEPTUNE_SSO_OAUTH2_PROVIDER_URLS_PROPERTIES));
        this.webserviceUrl = providerUrls.getProperty(NEPTUNE_SSO_WEBSERVICE_URL);
        if (this.webserviceUrl == null) {
            this.logger.debug((Object)"neptune_sso_webservice_url is not set. Setting it to empty");
            this.isNeptune = true;
        } else if (this.webserviceUrl.isEmpty()) {
            this.logger.debug((Object)"This is neptune running the filter. DB is accessed directly.");
            this.isNeptune = true;
        } else {
            this.isNeptune = false;
        }
    }
}

