/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.security.filter;

import com.ericsson.neptune.security.NeptunePrincipal;
import com.ericsson.neptune.security.authprovider.AuthProviderClient;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.jboss.web.tomcat.security.login.WebAuthentication;

public class JBossJAASUIFilter
implements Filter {
    private static final String NEPTUNE_SSO_OAUTH2_AUTHENTICATION_PRINCIPAL = "neptune_sso_oauth2_principal";
    private Logger logger = Logger.getLogger(JBossJAASUIFilter.class);
    protected AuthProviderClient providerClient;

    public void init(FilterConfig config) throws ServletException {
        this.logger.info((Object)"init started...");
    }

    public void destroy() {
        this.logger.debug((Object)"Destroy called - nothing to do in here!");
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (!this.isHttp(servletRequest, servletResponse)) {
            this.logger.debug((Object)"JBossJAASUIFilter NOT interrupting the request since either request or response is not of HTTP type");
            this.logger.debug((Object)"Continuing with rest of the filters in the filter chain");
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        this.logger.debug((Object)"JBossJAASUIFilter interrupting the request");
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        HttpSession session = request.getSession(false);
        if (session != null && session.getAttribute("webAuthentication") == null) {
            NeptunePrincipal principal = (NeptunePrincipal)session.getAttribute(NEPTUNE_SSO_OAUTH2_AUTHENTICATION_PRINCIPAL);
            if (principal == null) {
                this.logger.debug((Object)"Could not get Neptune Principal from Session");
                throw new ServletException("Could not get Neptune Principal from Session");
            }
            String password = "";
            this.logger.debug((Object)"Calling Neptune Login module");
            this.mapSSOUserToJAASUser(session, principal.getUserName(), password);
        }
        this.logger.debug((Object)"Continuing with rest of the filters in the filter chain");
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private boolean isHttp(ServletRequest request, ServletResponse response) {
        return request instanceof HttpServletRequest && response instanceof HttpServletResponse;
    }

    private void mapSSOUserToJAASUser(HttpSession session, String userName, String password) {
        this.logger.debug((Object)"Calling web authentication login");
        WebAuthentication webAuthentication = new WebAuthentication();
        if (!webAuthentication.login(userName, (Object)password)) {
            this.logger.error((Object)"WebAuthentication login failed!");
            return;
        }
        session.setAttribute("webAuthentication", (Object)webAuthentication);
        session.setAttribute("username", (Object)userName);
    }
}

