/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.security.filter;

import com.ericsson.neptune.security.NeptunePrincipal;
import com.ericsson.neptune.security.authprovider.AuthProviderClient;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.jboss.web.tomcat.security.login.WebAuthentication;

public class JBossJAASWebServiceFilter
implements Filter {
    private static final String NEPTUNE_SSO_OAUTH2_AUTHENTICATION_PRINCIPAL = "neptune_sso_oauth2_principal";
    private Logger logger = Logger.getLogger(JBossJAASWebServiceFilter.class);
    protected AuthProviderClient providerClient;

    public void init(FilterConfig config) throws ServletException {
        this.logger.info((Object)"init started...");
    }

    public void destroy() {
        this.logger.debug((Object)"Destroy called - nothing to do in here!");
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (!this.isHttp(servletRequest, servletResponse)) {
            this.logger.debug((Object)"JBossJAASWebServiceFilter NOT interrupting the request since either request or response is not of HTTP type");
            this.logger.debug((Object)"Continuing with rest of the filters in the filter chain");
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        this.logger.debug((Object)"JBossJAASWebServiceFilter interrupting the request");
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String authHeader = request.getHeader("Authorization");
        if (authHeader != null && authHeader.startsWith("Basic")) {
            NeptunePrincipal principal = (NeptunePrincipal)request.getAttribute(NEPTUNE_SSO_OAUTH2_AUTHENTICATION_PRINCIPAL);
            if (principal == null) {
                this.logger.debug((Object)"Could not get Neptune Principal from Session");
                response.sendError(403, "Basic Authentication is not allowed from a remote component.");
                return;
            }
            String password = principal.getToken() != null ? principal.getToken() : "";
            this.logger.debug((Object)"Calling Neptune Login module");
            WebAuthentication webAuthentication = new WebAuthentication();
            if (!webAuthentication.login(principal.getUserName(), (Object)password)) {
                this.logger.error((Object)"WebAuthentication login failed!");
                response.sendError(401, "Wrong Username/Password.");
                return;
            }
        }
        this.logger.debug((Object)"Continuing with rest of the filters in the filter chain");
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private boolean isHttp(ServletRequest request, ServletResponse response) {
        return request instanceof HttpServletRequest && response instanceof HttpServletResponse;
    }
}

