/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.security.filter;

import com.ericsson.neptune.security.NeptunePrincipal;
import com.ericsson.neptune.security.authprovider.AuthProviderClient;
import com.ericsson.neptune.security.authprovider.TokenInfo;
import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import java.io.IOException;
import java.util.Properties;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class WebServicesAuthenticationFilter
implements Filter {
    private static final String NEPTUNE_SSO_OAUTH2_AUTHENTICATION_PRINCIPAL = "neptune_sso_oauth2_principal";
    protected static final String NEPTUNE_SSO_OAUTH2_PROVIDER_URLS_PROPERTIES = "neptune_sso_oauth2_provider_urls_properties";
    protected static final String NEPTUNE_SSO_OAUTH2_PROVIDER_VALIDATE_URL = "neptune_sso_oauth2_provider_validate_url";
    protected static final String NEPTUNE_SSO_OAUTH2_PROVIDER_WEBSERVICES_URL = "neptune_sso_webservice_url";
    private static final String DEFAULT_PROVIDER_VALIDATE_URL = "https://localhost:8443/provider/oauth/validate";
    private Logger logger = Logger.getLogger(WebServicesAuthenticationFilter.class);
    HttpServletResponse modifiedResponse;
    protected String providerValidateUrl;
    protected AuthProviderClient providerClient;
    private String providerWebserviceUrl;
    private boolean isNeptune;

    private NeptunePrincipal doBasic(String header, NeptunePrincipal nsp, HttpServletResponse response) {
        try {
            String base64Val = header.substring(6);
            String decodedVal = new String(Base64.decode(base64Val));
            int ColonIndex = decodedVal.indexOf(":");
            String username = decodedVal.substring(0, ColonIndex);
            String password = decodedVal.substring(ColonIndex + 1);
            nsp = new NeptunePrincipal(username);
            nsp.setToken(password);
        }
        catch (Exception ex) {
            this.logger.error((Object)"Error while doing Basic Authorization", (Throwable)ex);
            this.doError401(response);
        }
        return nsp;
    }

    private NeptunePrincipal doBearer(String header, HttpServletRequest request, NeptunePrincipal principal, HttpServletResponse response) {
        String accessToken = header.substring(7);
        TokenInfo tokenInfo = this.providerClient.validateToken(accessToken, request);
        if (tokenInfo == null) {
            this.logger.error((Object)"Internal server error, could not proceed. Please check previous exception.");
            this.doError500(response);
            return null;
        }
        if (!tokenInfo.isValid()) {
            this.logger.error((Object)("Invalid token found: " + tokenInfo));
            this.doError401(response);
            return null;
        }
        this.logger.debug((Object)"Login succeeded at provider, caching user info");
        principal = new NeptunePrincipal(tokenInfo, accessToken);
        return principal;
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (this.isHttp(servletRequest, servletResponse) && this.isNeptune) {
            HttpServletRequest request = (HttpServletRequest)servletRequest;
            HttpServletResponse response = (HttpServletResponse)servletResponse;
            NeptunePrincipal nsp = null;
            String authHeader = request.getHeader("Authorization");
            if (authHeader == null || authHeader.isEmpty()) {
                this.doError401(response);
                this.logger.error((Object)"Authorization header was absent.Could not proceed.");
                return;
            }
            if (authHeader.startsWith("Basic")) {
                nsp = this.doBasic(authHeader, nsp, response);
            } else if (authHeader.startsWith("Bearer")) {
                nsp = this.doBearer(authHeader, request, nsp, response);
            } else {
                this.doError401(response);
                this.logger.error((Object)"Authorization header was invalid.Could not proceed.");
                return;
            }
            if (nsp != null) {
                this.logger.debug((Object)"Continuing with rest of the filters in the filter chain");
                request.setAttribute(NEPTUNE_SSO_OAUTH2_AUTHENTICATION_PRINCIPAL, (Object)nsp);
            } else {
                return;
            }
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    private void doError401(HttpServletResponse response) {
        try {
            response.sendError(401, "Invalid user credentials");
        }
        catch (IOException e) {
            this.logger.error((Object)"Error while setting response to the filter.", (Throwable)e);
        }
    }

    private void doError500(HttpServletResponse response) {
        try {
            response.sendError(500, "Internal server error");
        }
        catch (IOException e) {
            this.logger.error((Object)"Error while setting response to the filter.", (Throwable)e);
        }
    }

    public void init(FilterConfig config) throws ServletException {
        this.providerClient = new AuthProviderClient();
        Properties providerUrls = this.providerClient.readProperties(config.getInitParameter(NEPTUNE_SSO_OAUTH2_PROVIDER_URLS_PROPERTIES));
        this.providerValidateUrl = providerUrls.getProperty(NEPTUNE_SSO_OAUTH2_PROVIDER_VALIDATE_URL);
        this.providerWebserviceUrl = providerUrls.getProperty(NEPTUNE_SSO_OAUTH2_PROVIDER_WEBSERVICES_URL);
        if (this.isEmpty(this.providerValidateUrl)) {
            this.logger.debug((Object)"neptune_sso_oauth2_provider_validate_url is not set. Set it to the default value: https://watchpoint-app:8443/provider/oauth/validate");
            this.providerValidateUrl = DEFAULT_PROVIDER_VALIDATE_URL;
        }
        this.providerClient.setValidateUrl(this.providerValidateUrl);
        if (this.providerWebserviceUrl == null) {
            this.logger.debug((Object)"neptune_sso_webservice_url is not set. Setting it to empty");
            this.isNeptune = true;
        } else if (this.providerWebserviceUrl.isEmpty()) {
            this.logger.debug((Object)"This is neptune running the filter. DB is accessed directly.");
            this.isNeptune = true;
        } else {
            this.isNeptune = false;
        }
    }

    private boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    private boolean isHttp(ServletRequest request, ServletResponse response) {
        return request instanceof HttpServletRequest && response instanceof HttpServletResponse;
    }
}

