/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.security.util;

import com.ericsson.neptune.security.NeptunePrincipal;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;

public class EndpointAuthorizationUtil {
    private static final String NEPTUNE_SSO_OAUTH2_AUTHENTICATION_PRINCIPAL = "neptune_sso_oauth2_principal";

    public static Response.ResponseBuilder authorize(HttpServletRequest httpRequest, Response.ResponseBuilder builder, String requestMethod, String ... permissions) {
        NeptunePrincipal nsp = (NeptunePrincipal)httpRequest.getAttribute(NEPTUNE_SSO_OAUTH2_AUTHENTICATION_PRINCIPAL);
        if (nsp != null && nsp.getRoles() != null) {
            if (httpRequest.getMethod().equals(requestMethod)) {
                for (String permission : permissions) {
                    if (nsp.getRoles().contains(permission)) continue;
                    builder = Response.status((Response.Status)Response.Status.UNAUTHORIZED);
                    return builder;
                }
            }
        } else {
            builder = Response.status((Response.Status)Response.Status.FORBIDDEN);
            return builder;
        }
        return builder;
    }
}

