/*
 * Decompiled with CFR 0.152.
 */
package com.mediakind.ctmanager.service;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mediakind.cms.service.api.kube.exception.KubeOperationException;
import com.mediakind.cms.service.api.kube.helper.ClusterInfo;
import com.mediakind.cms.service.api.kube.helper.YamlHelper;
import com.mediakind.cms.service.api.kube.service.impl.KubeConfigMapService;
import com.mediakind.cms.service.api.kube.utils.KubeClientUtil;
import com.mediakind.ctmanager.model.po.CtInfo;
import com.mediakind.ctmanager.model.po.CtInfoItem;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.models.V1ConfigMap;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CTInfoService {
    private static final Logger logger = LoggerFactory.getLogger(CTInfoService.class);
    private KubeConfigMapService configMapService;

    public CTInfoService() throws IOException {
        ApiClient apiClient = KubeClientUtil.getLocalClient();
        this.configMapService = new KubeConfigMapService(apiClient);
    }

    public List<ClusterInfo> getCTInfoList() {
        try {
            V1ConfigMap configMap = this.configMapService.read("cms-ct-info", KubeClientUtil.getNamespace());
            if (configMap != null && configMap.getData() != null) {
                String content = (String)configMap.getData().get("cms-ct-info.json");
                return this.getCTInfoList(content);
            }
        }
        catch (KubeOperationException e) {
            logger.error("Get CT info from ConfigMap failed.", (Throwable)e);
        }
        return new ArrayList<ClusterInfo>();
    }

    public List<ClusterInfo> getCTInfoList(String ctInfoStr) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        ArrayList<ClusterInfo> clusterInfoList = new ArrayList<ClusterInfo>();
        try {
            if (StringUtils.isNotEmpty((String)ctInfoStr)) {
                CtInfo ctInfo = (CtInfo)mapper.readValue(ctInfoStr, CtInfo.class);
                List<CtInfoItem> ctInfoItemList = ctInfo.getCtInfoItemList();
                for (CtInfoItem ct : ctInfoItemList) {
                    clusterInfoList.add(this.createClusterInfo(ct));
                }
            }
        }
        catch (Exception e) {
            logger.error("Transfer CT info failed.", (Throwable)e);
        }
        return clusterInfoList;
    }

    private ClusterInfo createClusterInfo(CtInfoItem ct) {
        ClusterInfo.ClusterInfoBuider builder = ClusterInfo.getBuilder();
        builder.name(ct.getName()).type(ct.getType()).namespace(KubeClientUtil.getNamespace());
        if (ct.isExternal()) {
            String kubeConfigPath = "/opt/ssl/cms-ct-ssl" + File.separator + ct.getName() + ".cms_common_kubeconfig";
            if (!KubeClientUtil.checkFileExistWithRetry((String)kubeConfigPath)) {
                throw new RuntimeException(String.format("Instance ApiClient failed for kube config file does not exist. File path: %s", kubeConfigPath));
            }
            String ctNamespace = CTInfoService.getNamespaceFromKubeConfig(kubeConfigPath);
            if (ctNamespace != null) {
                builder.namespace(ctNamespace);
            }
            builder.kubeConfig(kubeConfigPath);
        }
        return builder.build();
    }

    private static String getNamespaceFromKubeConfig(String kubeConfigPath) {
        Map context;
        String yamlBody;
        try {
            yamlBody = FileUtils.readFileToString((File)new File(kubeConfigPath), (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            logger.warn("Failed to read file to get ct namespace: " + kubeConfigPath, (Throwable)e);
            return null;
        }
        Map map = (Map)YamlHelper.load((String)yamlBody);
        List contexts = (List)map.get("contexts");
        if (!CollectionUtils.isEmpty((Collection)contexts) && (context = (Map)((Map)contexts.get(0)).get("context")) != null) {
            return (String)context.get("namespace");
        }
        return null;
    }
}

