/*
 * Decompiled with CFR 0.152.
 */
package com.mediakind.ctmanager.service;

import com.mediakind.cms.service.api.kube.helper.ClusterInfo;
import com.mediakind.cms.service.api.kube.utils.KubeClientUtil;
import com.mediakind.ctmanager.service.CTInfoService;
import com.mediakind.ctmanager.service.CTResourceInfoService;
import com.mediakind.ctmanager.service.WfsResourceSyncService;
import io.kubernetes.client.informer.ResourceEventHandler;
import io.kubernetes.client.informer.SharedIndexInformer;
import io.kubernetes.client.informer.SharedInformerFactory;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.apis.AppsV1Api;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1ConfigMap;
import io.kubernetes.client.openapi.models.V1ConfigMapList;
import io.kubernetes.client.openapi.models.V1Deployment;
import io.kubernetes.client.openapi.models.V1DeploymentList;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class KubeResMonitorService {
    private static final Logger logger = LoggerFactory.getLogger(KubeResMonitorService.class);
    private final Set<String> deploymentInformerRegister = new HashSet<String>();
    @Autowired
    private WfsResourceSyncService wfsResourceSyncService;
    @Autowired
    private CTInfoService ctInfoService;
    @Autowired
    private CTResourceInfoService ctResourceInfoService;

    public synchronized void startKubeResourceMonitor() throws IOException {
        this.startMonitorDeployments();
        this.startMonitorConfigMaps();
    }

    public synchronized void startMonitorConfigMaps() throws IOException {
        logger.info("Start to monitor ConfigMap");
        ApiClient apiClient = KubeClientUtil.getLocalClient();
        apiClient.setHttpClient(apiClient.getHttpClient().newBuilder().readTimeout(0L, TimeUnit.SECONDS).build());
        CoreV1Api api = new CoreV1Api(apiClient);
        SharedInformerFactory factory = new SharedInformerFactory(apiClient);
        this.listenConfigMapEvents(false, "cms-ct-info", "cms-ct-info.json", api, factory);
        this.listenConfigMapEvents(true, "cms-ct-resource-info", "cms-ct-resource-info.json", api, factory);
    }

    public synchronized void startMonitorDeployments() throws IOException {
        logger.info("Start to monitor Deployment");
        List<ClusterInfo> ctClusters = this.ctInfoService.getCTInfoList();
        Set<String> deploymentSet = this.ctResourceInfoService.getDistinctDeployments();
        for (ClusterInfo ct : ctClusters) {
            ApiClient apiClient = KubeClientUtil.getClient((ClusterInfo)ct);
            apiClient.setHttpClient(apiClient.getHttpClient().newBuilder().readTimeout(0L, TimeUnit.SECONDS).build());
            AppsV1Api api = new AppsV1Api(apiClient);
            SharedInformerFactory factory = new SharedInformerFactory(apiClient);
            for (String deploymentName : deploymentSet) {
                this.listenDeploymentEvents(ct, deploymentName, api, factory);
            }
        }
    }

    private void listenConfigMapEvents(final boolean needDoUpdate, final String configMapName, final String itemKey, CoreV1Api api, SharedInformerFactory factory) {
        logger.info("Monitor ConfigMap {}", (Object)configMapName);
        SharedIndexInformer informer = factory.sharedIndexInformerFor(params -> api.listNamespacedConfigMapCall(KubeClientUtil.getNamespace(), null, null, null, "metadata.name=" + configMapName, null, null, null, null, params.watch, null), V1ConfigMap.class, V1ConfigMapList.class);
        informer.addEventHandler((ResourceEventHandler)new ResourceEventHandler<V1ConfigMap>(){

            public void onAdd(V1ConfigMap obj) {
                logger.info("Received add event for Configmap {}. To do a full sync.", (Object)configMapName);
                if (needDoUpdate) {
                    KubeResMonitorService.this.wfsResourceSyncService.syncFullResourcesWithUpdate();
                } else {
                    KubeResMonitorService.this.wfsResourceSyncService.syncFullResources();
                }
                try {
                    KubeResMonitorService.this.startMonitorDeployments();
                }
                catch (IOException e) {
                    logger.error("Start monitor deployment failed.", (Throwable)e);
                }
            }

            public void onUpdate(V1ConfigMap oldObj, V1ConfigMap newObj) {
                if (!((String)oldObj.getData().get(itemKey)).equals(newObj.getData().get(itemKey))) {
                    logger.info("Received update event for Configmap {} {}. To do a full sync.", (Object)configMapName, (Object)itemKey);
                    if (needDoUpdate) {
                        KubeResMonitorService.this.wfsResourceSyncService.syncFullResourcesWithUpdate();
                    } else {
                        KubeResMonitorService.this.wfsResourceSyncService.syncFullResources();
                    }
                    try {
                        KubeResMonitorService.this.startMonitorDeployments();
                    }
                    catch (IOException e) {
                        logger.error("Start monitor deployment failed.", (Throwable)e);
                    }
                }
            }

            public void onDelete(V1ConfigMap obj, boolean deletedFinalStateUnknown) {
                logger.info("configmap {} delete, do nothing", (Object)configMapName);
            }
        });
        informer.run();
    }

    private void listenDeploymentEvents(final ClusterInfo ctInfo, final String deploymentName, AppsV1Api api, SharedInformerFactory factory) {
        final String clusterName = ctInfo.getName();
        logger.info("To monitor cluster {}, deployment {}", (Object)clusterName, (Object)deploymentName);
        String informerKey = this.getDeploymentInformerRegisterKey(clusterName, deploymentName);
        if (this.deploymentInformerRegister.contains(informerKey)) {
            logger.info("Skip monitor clusterName[{}] deployment[{}] for it has been monitored.", (Object)clusterName, (Object)deploymentName);
            return;
        }
        SharedIndexInformer informer = factory.sharedIndexInformerFor(params -> api.listNamespacedDeploymentCall(ctInfo.getNamespace(), null, null, null, "metadata.name=" + deploymentName, null, null, null, null, params.watch, null), V1Deployment.class, V1DeploymentList.class);
        informer.addEventHandler((ResourceEventHandler)new ResourceEventHandler<V1Deployment>(){

            public void onAdd(V1Deployment obj) {
                logger.info("Received add event for cluster {} deployment: {}. To do a specific sync.", (Object)clusterName, (Object)deploymentName);
                KubeResMonitorService.this.wfsResourceSyncService.syncSpecificResource(ctInfo, deploymentName);
            }

            public void onUpdate(V1Deployment oldObj, V1Deployment newObj) {
                if (!oldObj.getSpec().getReplicas().equals(newObj.getSpec().getReplicas())) {
                    logger.info("Received replica change event for cluster {} deployment {}. To do a specific sync.", (Object)clusterName, (Object)deploymentName);
                    KubeResMonitorService.this.wfsResourceSyncService.syncSpecificResource(ctInfo, deploymentName);
                }
            }

            public void onDelete(V1Deployment obj, boolean deletedFinalStateUnknown) {
                logger.info("Received delete event for cluster {} deployment {}. To do a specific sync.", (Object)clusterName, (Object)deploymentName);
                KubeResMonitorService.this.wfsResourceSyncService.syncSpecificResource(ctInfo, deploymentName);
            }
        });
        informer.run();
        this.deploymentInformerRegister.add(informerKey);
        logger.info("ClusterName[{}] deployment[{}] success monitored.", (Object)clusterName, (Object)deploymentName);
    }

    private String getDeploymentInformerRegisterKey(String clusterName, String deploymentName) {
        return clusterName + "_" + deploymentName;
    }
}

