/*
 * Decompiled with CFR 0.152.
 */
package com.mediakind.ctmanager.service;

import com.mediakind.cms.service.api.kube.helper.ClusterInfo;
import com.mediakind.cms.service.api.kube.utils.KubeClientUtil;
import com.mediakind.ctmanager.service.CTInfoService;
import com.mediakind.ctmanager.service.CTResourceInfoService;
import com.mediakind.ctmanager.service.WfsResourceSyncService;
import io.kubernetes.client.informer.ResourceEventHandler;
import io.kubernetes.client.informer.SharedIndexInformer;
import io.kubernetes.client.informer.SharedInformerFactory;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.apis.AppsV1Api;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1ConfigMap;
import io.kubernetes.client.openapi.models.V1ConfigMapList;
import io.kubernetes.client.openapi.models.V1Deployment;
import io.kubernetes.client.openapi.models.V1DeploymentList;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class KubeResMonitorService {
    private static final Logger logger = LoggerFactory.getLogger(KubeResMonitorService.class);
    protected final Set<String> deploymentInformerRegister = new HashSet();
    private WfsResourceSyncService wfsResourceSyncService;
    private CTInfoService ctInfoService;
    private CTResourceInfoService ctResourceInfoService;

    @Autowired
    public void setWfsResourceSyncService(WfsResourceSyncService wfsResourceSyncService) {
        this.wfsResourceSyncService = wfsResourceSyncService;
    }

    @Autowired
    public void setCtInfoService(CTInfoService ctInfoService) {
        this.ctInfoService = ctInfoService;
    }

    @Autowired
    public void setCtResourceInfoService(CTResourceInfoService ctResourceInfoService) {
        this.ctResourceInfoService = ctResourceInfoService;
    }

    public synchronized void startKubeResourceMonitor() throws IOException {
        this.startMonitorDeployments();
        this.startMonitorConfigMaps();
    }

    public synchronized void startMonitorConfigMaps() throws IOException {
        logger.info("Start to monitor ConfigMap");
        ApiClient apiClient = KubeClientUtil.getLocalClient();
        apiClient.setHttpClient(apiClient.getHttpClient().newBuilder().readTimeout(0L, TimeUnit.SECONDS).build());
        CoreV1Api api = new CoreV1Api(apiClient);
        SharedInformerFactory factory = new SharedInformerFactory(apiClient);
        this.listenConfigMapEvents(false, "cms-ct-info", "cms-ct-info.json", api, factory);
        this.listenConfigMapEvents(true, "cms-ct-resource-info", "cms-ct-resource-info.json", api, factory);
    }

    public synchronized void startMonitorDeployments() throws IOException {
        logger.info("Start to monitor Deployment");
        List ctClusters = this.ctInfoService.getCTInfoList();
        Set deploymentSet = this.ctResourceInfoService.getDistinctDeployments();
        for (ClusterInfo ct : ctClusters) {
            ApiClient apiClient = KubeClientUtil.getClient((ClusterInfo)ct);
            apiClient.setHttpClient(apiClient.getHttpClient().newBuilder().readTimeout(0L, TimeUnit.SECONDS).build());
            AppsV1Api api = new AppsV1Api(apiClient);
            SharedInformerFactory factory = new SharedInformerFactory(apiClient);
            for (String deploymentName : deploymentSet) {
                this.listenDeploymentEvents(ct, deploymentName, api, factory);
            }
        }
    }

    protected void listenConfigMapEvents(boolean needDoUpdate, String configMapName, String itemKey, CoreV1Api api, SharedInformerFactory factory) {
        logger.info("Monitor ConfigMap {}", (Object)configMapName);
        SharedIndexInformer informer = factory.sharedIndexInformerFor(params -> api.listNamespacedConfigMapCall(KubeClientUtil.getNamespace(), null, null, null, "metadata.name=" + configMapName, null, null, null, null, null, params.watch, null), V1ConfigMap.class, V1ConfigMapList.class);
        informer.addEventHandler((ResourceEventHandler)new /* Unavailable Anonymous Inner Class!! */);
        informer.run();
    }

    protected void listenDeploymentEvents(ClusterInfo ctInfo, String deploymentName, AppsV1Api api, SharedInformerFactory factory) {
        String clusterName = ctInfo.getName();
        logger.info("To monitor cluster {}, deployment {}", (Object)clusterName, (Object)deploymentName);
        String informerKey = this.getDeploymentInformerRegisterKey(clusterName, deploymentName);
        if (this.deploymentInformerRegister.contains(informerKey)) {
            logger.info("Skip monitor clusterName[{}] deployment[{}] for it has been monitored.", (Object)clusterName, (Object)deploymentName);
            return;
        }
        SharedIndexInformer informer = factory.sharedIndexInformerFor(params -> api.listNamespacedDeploymentCall(ctInfo.getNamespace(), null, null, null, "metadata.name=" + deploymentName, null, null, null, null, null, params.watch, null), V1Deployment.class, V1DeploymentList.class);
        informer.addEventHandler((ResourceEventHandler)new /* Unavailable Anonymous Inner Class!! */);
        informer.run();
        this.deploymentInformerRegister.add(informerKey);
        logger.info("ClusterName[{}] deployment[{}] success monitored.", (Object)clusterName, (Object)deploymentName);
    }

    private String getDeploymentInformerRegisterKey(String clusterName, String deploymentName) {
        return clusterName + "_" + deploymentName;
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }

    static /* synthetic */ WfsResourceSyncService access$100(KubeResMonitorService x0) {
        return x0.wfsResourceSyncService;
    }
}

