/*
 * Decompiled with CFR 0.152.
 */
package com.mediakind.ctmanager.service;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mediakind.ctmanager.constant.AppConstants;
import com.mediakind.ctmanager.model.po.ResourceListResp;
import com.mediakind.ctmanager.model.po.ResourceListRespItem;
import com.mediakind.ctmanager.model.po.ResourceResp;
import com.mediakind.neptune.common.http.CommonHttpClient;
import com.mediakind.neptune.common.http.ResponseEntity;
import com.mediakind.neptune.common.http.util.HttpMethod;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class WfsResourceService {
    private static final Logger logger = LoggerFactory.getLogger(WfsResourceService.class);
    private static final String RESOURCE_BASE_URL = "/workflow/resources";
    private static final int CHECK_INTERVAL_SECONDS = 10;
    private static final int CHECK_TIMEOUT_SECONDS = 300;
    private static final Map<String, String> COMMON_HEADER = new HashMap();
    private CommonHttpClient httpClient;

    public WfsResourceService() {
        this.httpClient = new CommonHttpClient.CommonHttpClientBuilder().connectionRequestTimeOut(60000).connectionTimeOut(60000).build();
    }

    public WfsResourceService(CommonHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public Integer countResourceByPattern(String namePattern) throws Exception {
        return this.getResourceListByPattern(namePattern).size();
    }

    public List<ResourceListRespItem> getResourceListByPattern(String namePattern) throws Exception {
        ResourceListResp resourceListResp = this.listWfsResources();
        List<Object> itemList = new ArrayList<ResourceListRespItem>();
        if (resourceListResp != null) {
            List resourceList = resourceListResp.getResources();
            itemList = resourceList.stream().filter(item -> item.getName().startsWith(namePattern)).collect(Collectors.toList());
        }
        return itemList;
    }

    public ResourceResp getResourceById(Integer id) throws Exception {
        String url = "/workflow/resources/" + id;
        ResponseEntity entity = this.httpClient.sendHttpRequest(url, null, HttpMethod.GET, COMMON_HEADER);
        if (entity.getStatusCode() == HttpStatus.OK.value()) {
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            return (ResourceResp)mapper.readValue(entity.getBody(), ResourceResp.class);
        }
        throw new Exception(String.format("Get resource failed. response code:%s, message:%s", entity.getStatusCode(), entity.getBody()));
    }

    public ResourceListRespItem getResourceByName(String name) throws Exception {
        Optional<ResourceListRespItem> first;
        ResourceListResp resourceListResp = this.listWfsResources();
        if (resourceListResp != null && (first = resourceListResp.getResources().stream().filter(item -> name.equals(item.getName())).findAny()).isPresent()) {
            return first.get();
        }
        return null;
    }

    public ResourceListResp listWfsResources() throws Exception {
        String url = "/workflow/resources?count=10000";
        ResponseEntity entity = this.httpClient.sendHttpRequest(url, null, HttpMethod.GET, COMMON_HEADER);
        if (entity.getStatusCode() == HttpStatus.OK.value()) {
            String jsonResp = entity.getBody();
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            return (ResourceListResp)mapper.readValue(jsonResp, ResourceListResp.class);
        }
        throw new Exception(String.format("Get resource failed. response code:%s, message:%s", entity.getStatusCode(), entity.getBody()));
    }

    public boolean isOK() {
        String url = "/workflow/resources?count=1";
        ResponseEntity entity = this.httpClient.sendHttpRequest(url, null, HttpMethod.GET, COMMON_HEADER);
        if (entity.getStatusCode() == HttpStatus.OK.value()) {
            return true;
        }
        logger.error(String.format("Test resource api failed. response code:%s, message:%s", entity.getStatusCode(), entity.getBody()));
        return false;
    }

    public void createResource(String resourceName, String body) {
        ResponseEntity entity = this.httpClient.sendHttpRequest("/workflow/resources", (Object)body, HttpMethod.POST, COMMON_HEADER);
        int statusCode = entity.getStatusCode();
        if (statusCode != HttpStatus.OK.value()) {
            logger.error("create resource {} failed. response code:{}, message:{}", new Object[]{resourceName, statusCode, entity.getBody()});
            WfsResourceService.setSyncFlag((String)resourceName, (int)statusCode);
        } else {
            logger.info("Resource {} success created.", (Object)resourceName);
        }
    }

    public void updateResource(String resourceName, Integer id, String body) {
        this.takeOffline(resourceName, id);
        boolean isOperationalOffline = this.waitCompletedOffline(id, 300);
        if (!isOperationalOffline) {
            WfsResourceService.setSyncFlag((String)resourceName, (int)HttpStatus.SERVICE_UNAVAILABLE.value());
            logger.error("Delete resource {} failed. OperationalState is not Offline", (Object)resourceName);
            return;
        }
        logger.info("Resource {} take offline successfully.", (Object)resourceName);
        String url = "/workflow/resources/" + id;
        ResponseEntity entity = this.httpClient.sendHttpRequest(url, (Object)body, HttpMethod.PUT, COMMON_HEADER);
        int statusCode = entity.getStatusCode();
        if (statusCode != HttpStatus.OK.value()) {
            logger.error("Update resource {} failed. response code:{}, message:{}", new Object[]{resourceName, statusCode, entity.getBody()});
            WfsResourceService.setSyncFlag((String)resourceName, (int)statusCode);
        } else {
            logger.info("Resource {} success updated.", (Object)resourceName);
        }
    }

    public void deleteResource(String resourceName, Integer id) {
        this.takeOffline(resourceName, id);
        boolean isOperationalOffline = this.waitCompletedOffline(id, 300);
        if (!isOperationalOffline) {
            WfsResourceService.setSyncFlag((String)resourceName, (int)HttpStatus.SERVICE_UNAVAILABLE.value());
            logger.error("Delete resource {} failed. OperationalState is not Offline", (Object)resourceName);
            return;
        }
        logger.info("Resource {} take offline successfully.", (Object)resourceName);
        String url = "/workflow/resources/" + id;
        ResponseEntity entity = this.httpClient.sendHttpRequest(url, null, HttpMethod.DELETE, COMMON_HEADER);
        int statusCode = entity.getStatusCode();
        if (statusCode != HttpStatus.OK.value()) {
            logger.error("Delete resource {} failed. response code:{}, message:{}", new Object[]{resourceName, statusCode, entity.getBody()});
            WfsResourceService.setSyncFlag((String)resourceName, (int)statusCode);
        }
        logger.info("Resource {} success deleted.", (Object)resourceName);
    }

    private boolean waitCompletedOffline(Integer id, int timeoutSeconds) {
        ResourceResp resource;
        if (timeoutSeconds <= 0) {
            return false;
        }
        try {
            resource = this.getResourceById(id);
        }
        catch (Exception e) {
            logger.error("Get resource by id failed.", (Throwable)e);
            return false;
        }
        if (resource != null && "Offline".equals(resource.getOperationalState())) {
            return true;
        }
        timeoutSeconds -= 10;
        try {
            TimeUnit.SECONDS.sleep(10L);
        }
        catch (InterruptedException e) {
            logger.error("Interrupted while sleeping", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        return this.waitCompletedOffline(id, timeoutSeconds);
    }

    private void takeOffline(String resourceName, Integer id) {
        String url = "/workflow/resources/actions/offline?id=" + id;
        ResponseEntity entity = this.httpClient.sendHttpRequest(url, null, HttpMethod.PUT, COMMON_HEADER);
        int statusCode = entity.getStatusCode();
        if (statusCode != HttpStatus.OK.value()) {
            logger.error("take resource {} offline failed. response code:{}, message:{}", new Object[]{resourceName, statusCode, entity.getBody()});
            WfsResourceService.setSyncFlag((String)resourceName, (int)statusCode);
        }
    }

    private static void setSyncFlag(String resourceName, int statusCode) {
        if (statusCode == HttpStatus.SERVICE_UNAVAILABLE.value()) {
            logger.debug("Set sync flag to true for resource {} operate failed while Workflow service down.", (Object)resourceName);
            AppConstants.NEED_TO_TRIGGER_SYNC_FLAG = true;
        }
    }

    static {
        COMMON_HEADER.put("Content-Type", "application/json");
        COMMON_HEADER.put("Accept", "application/json");
        COMMON_HEADER.put("X-API-VERSION", "1");
    }
}

