/*
 * Decompiled with CFR 0.152.
 */
package com.mediakind.ctmanager.handler;

import com.mediakind.ctmanager.constant.AppConstants;
import com.mediakind.ctmanager.service.WfsHealthService;
import com.mediakind.ctmanager.service.WfsResourceService;
import com.mediakind.ctmanager.service.WfsResourceSyncService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
public class ProbeScheduler {
    private static final Logger logger = LoggerFactory.getLogger(ProbeScheduler.class);
    @Autowired
    private WfsResourceSyncService resourceSyncService;
    @Autowired
    private WfsHealthService wfsHealthService;
    @Autowired
    private WfsResourceService wfsResourceService;

    public void setResourceSyncService(WfsResourceSyncService resourceSyncService) {
        this.resourceSyncService = resourceSyncService;
    }

    public void setWfsHealthService(WfsHealthService wfsHealthService) {
        this.wfsHealthService = wfsHealthService;
    }

    public void setWfsResourceService(WfsResourceService wfsResourceService) {
        this.wfsResourceService = wfsResourceService;
    }

    @Scheduled(cron="0 * * * * ?")
    public void wfsProbe() {
        if (logger.isDebugEnabled()) {
            logger.debug("Workflow ReadinessProbe scheduler. Need sync flag is {}", (Object)AppConstants.NEED_TO_TRIGGER_SYNC_FLAG);
        }
        if (AppConstants.NEED_TO_TRIGGER_SYNC_FLAG && this.wfsHealthService.isUp() && this.wfsResourceService.isOK()) {
            logger.info("Sync flag is true and workflow service is up, so do a full resource sync.");
            AppConstants.NEED_TO_TRIGGER_SYNC_FLAG = false;
            this.resourceSyncService.syncFullResourcesWithUpdate();
        }
    }
}

