/*
 * Decompiled with CFR 0.152.
 */
package com.mediakind.ctmanager.service;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mediakind.cms.service.api.kube.exception.KubeOperationException;
import com.mediakind.cms.service.api.kube.helper.ClusterType;
import com.mediakind.cms.service.api.kube.helper.KubeResEnum;
import com.mediakind.cms.service.api.kube.service.impl.KubeConfigMapService;
import com.mediakind.cms.service.api.kube.service.impl.KubeEndpointsService;
import com.mediakind.cms.service.api.kube.service.impl.KubeSecretService;
import com.mediakind.cms.service.api.kube.service.impl.KubeServiceService;
import com.mediakind.cms.service.api.kube.utils.KubeClientUtil;
import com.mediakind.ctmanager.model.dto.CTBaseInfo;
import com.mediakind.ctmanager.model.dto.CTCertInfo;
import com.mediakind.ctmanager.model.dto.CTKubeInfo;
import com.mediakind.ctmanager.model.dto.CTRedisInfo;
import com.mediakind.ctmanager.model.dto.RegCtInfo;
import com.mediakind.ctmanager.model.po.CtInfo;
import com.mediakind.ctmanager.model.po.CtInfoItem;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.models.V1ConfigMap;
import io.kubernetes.client.openapi.models.V1Secret;
import io.kubernetes.client.util.ClientBuilder;
import io.kubernetes.client.util.KubeConfig;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.yaml.snakeyaml.Yaml;

@Service
public class RegistrationService {
    private static final Logger logger = LoggerFactory.getLogger(RegistrationService.class);
    private static final String NAMESPACE_NAME = KubeClientUtil.getNamespace();
    private static final String CONFIGMAP_NAME_CMS_CT_INFO = "cms-ct-info";
    private static final String CONFIGMAP_KEY_CMS_CT_INFO_JSON = "cms-ct-info.json";
    private static final String CONFIGMAP_NAME_CMS_LOGSTASH_REDIS = "cms-logstash-redis-input-pipeline";
    private static final String CONFIGMAP_KEY_REDIS_INPUT = "redis-input.conf";
    private static final String SECRET_CMS_CT_SSL = "cms-ct-ssl";
    private static final Pattern REDIS_PASSWORD_PATTERN = Pattern.compile("password\\s*=>\\s*\"(.*?)\"");
    private static final Pattern REDIS_PORT_PATTERN = Pattern.compile("port\\s*=>\\s*\"(.*?)\"");
    private final KubeConfigMapService configMapService;
    private final KubeSecretService secretService;
    private final KubeServiceService serviceService;
    private final KubeEndpointsService endpointsService;

    public RegistrationService() throws IOException {
        ApiClient apiClient = this.getProdClient();
        this.configMapService = new KubeConfigMapService(apiClient);
        this.secretService = new KubeSecretService(apiClient);
        this.serviceService = new KubeServiceService(apiClient);
        this.endpointsService = new KubeEndpointsService(apiClient);
    }

    public RegistrationService(KubeConfigMapService configMapService, KubeSecretService secretService, KubeServiceService serviceService, KubeEndpointsService endpointsService) {
        this.configMapService = configMapService;
        this.secretService = secretService;
        this.serviceService = serviceService;
        this.endpointsService = endpointsService;
    }

    public ApiClient getProdClient() throws IOException {
        return KubeClientUtil.getLocalClient();
    }

    public ApiClient getDevClient() throws IOException {
        return ClientBuilder.kubeconfig((KubeConfig)KubeConfig.loadKubeConfig((Reader)new FileReader(this.getClass().getClassLoader().getResource("dev-test-kube-config").getFile()))).build();
    }

    public void createCluster(String clusterName, RegCtInfo regCtInfo) throws IOException, KubeOperationException {
        CTBaseInfo newBaseInfo = regCtInfo.getCtBaseInfo();
        CTCertInfo newCertInfo = regCtInfo.getCtCertInfo();
        CTKubeInfo newKubeInfo = regCtInfo.getCtKubeInfo();
        CTRedisInfo newRedisInfo = regCtInfo.getCtRedisInfo();
        CTBaseInfo oldBaseInfo = this.getCtBaseInfoFromConfigMap(clusterName);
        CTRedisInfo oldRedisInfo = this.getRedisInfoFromConfigMap(clusterName);
        this.updateCtInfoConfigMap(clusterName, oldBaseInfo, newBaseInfo);
        this.createOrUpdateEndpointAndService(newBaseInfo, newRedisInfo);
        this.updateCmsCtSslSecret(clusterName, newCertInfo, newKubeInfo);
        this.updateHaproxyConfig(clusterName, oldBaseInfo, newBaseInfo);
        this.updateLogstashInputPipeline(oldBaseInfo, newBaseInfo, oldRedisInfo, newRedisInfo);
    }

    public void updateCluster(String clusterName, RegCtInfo regCtInfo) throws KubeOperationException {
        CTCertInfo newCertInfo = regCtInfo.getCtCertInfo();
        CTKubeInfo newKubeInfo = regCtInfo.getCtKubeInfo();
        this.updateCmsCtSslSecret(clusterName, newCertInfo, newKubeInfo);
    }

    public CTBaseInfo getCtBaseInfoFromConfigMap(String clusterName) throws KubeOperationException, JsonProcessingException {
        V1ConfigMap configMap = this.configMapService.read(CONFIGMAP_NAME_CMS_CT_INFO, NAMESPACE_NAME);
        Map configMapData = configMap.getData();
        if (configMapData == null) {
            return null;
        }
        String latestCtInfoJson = (String)configMapData.get(CONFIGMAP_KEY_CMS_CT_INFO_JSON);
        if (StringUtils.isEmpty((CharSequence)latestCtInfoJson)) {
            return null;
        }
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        CtInfo ctInfo = (CtInfo)mapper.readValue(latestCtInfoJson, CtInfo.class);
        CtInfoItem infoItem = Optional.ofNullable(ctInfo).map(CtInfo::getCtInfoItemList).orElse(Collections.emptyList()).stream().filter(item -> clusterName.equals(item.getName())).findFirst().orElse(null);
        if (infoItem != null) {
            CTBaseInfo baseInfo = new CTBaseInfo();
            baseInfo.setClusterName(infoItem.getName());
            baseInfo.setHost(infoItem.getHost());
            baseInfo.setClusterPort(infoItem.getPort());
            baseInfo.setDisplayName(infoItem.getDisplayName());
            return baseInfo;
        }
        return null;
    }

    private CTRedisInfo getRedisInfoFromConfigMap(String clusterName) throws KubeOperationException, JsonProcessingException {
        V1ConfigMap configMap = this.configMapService.read(CONFIGMAP_NAME_CMS_LOGSTASH_REDIS, NAMESPACE_NAME);
        Map configMapData = configMap.getData();
        if (configMapData == null) {
            return null;
        }
        String redisInfoStr = (String)configMapData.get(CONFIGMAP_KEY_REDIS_INPUT);
        if (StringUtils.isEmpty((CharSequence)redisInfoStr)) {
            return null;
        }
        String password = null;
        Matcher passwordMatcher = REDIS_PASSWORD_PATTERN.matcher(redisInfoStr);
        if (passwordMatcher.find()) {
            password = passwordMatcher.group(1);
        }
        Integer port = null;
        Matcher portMatcher = REDIS_PORT_PATTERN.matcher(redisInfoStr);
        if (portMatcher.find()) {
            port = Integer.valueOf(portMatcher.group(1));
        }
        CTRedisInfo info = new CTRedisInfo();
        info.setRedisPassword(password);
        info.setRedisPort(port);
        return info;
    }

    public void unregisterCluster(String clusterName, String host) throws IOException, KubeOperationException {
        this.removeClusterFromCtInfoConfigMap(clusterName);
        this.deleteService(host);
        this.deleteEndpoint(host);
        this.removeClusterInfoFromCmsCtSslSecret(clusterName);
        this.updateGlobalAclInConfigMap();
        this.deleteConfigMaps(clusterName);
        this.removeClusterFromLogstashInputPipline(host);
    }

    private void deleteConfigMaps(String clusterName) throws KubeOperationException {
        for (String configMapName : Arrays.asList(this.buildFrontendConfigMapName(clusterName), this.buildBackendConfigMapName(clusterName))) {
            if (!Optional.ofNullable(this.configMapService.read(configMapName, NAMESPACE_NAME)).isPresent()) continue;
            this.configMapService.delete(configMapName, NAMESPACE_NAME);
        }
    }

    private String buildFrontendConfigMapName(String clusterName) {
        return clusterName + "-frontend";
    }

    private String buildBackendConfigMapName(String clusterName) {
        return clusterName + "-backend";
    }

    private void deleteService(String host) throws KubeOperationException {
        if (StringUtils.isEmpty((CharSequence)host)) {
            return;
        }
        if (Optional.ofNullable(this.serviceService.read(host, NAMESPACE_NAME)).isPresent()) {
            try {
                this.serviceService.delete(host, NAMESPACE_NAME);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void deleteEndpoint(String host) throws KubeOperationException {
        if (StringUtils.isEmpty((CharSequence)host)) {
            return;
        }
        if (Optional.ofNullable(this.endpointsService.read(host, NAMESPACE_NAME)).isPresent()) {
            this.endpointsService.delete(host, NAMESPACE_NAME);
        }
    }

    public void updateCtInfoConfigMap(String clusterName, CTBaseInfo oldBaseInfo, CTBaseInfo newBaseInfo) throws IOException, KubeOperationException {
        String newCtInfoJson;
        String oldCtInfoJson;
        newBaseInfo = Optional.ofNullable(newBaseInfo).orElse(new CTBaseInfo());
        String newHost = newBaseInfo.getHost();
        String newClusterVip = newBaseInfo.getClusterVip();
        String newClusterPort = newBaseInfo.getClusterPort();
        String newDisplayName = newBaseInfo.getDisplayName();
        if (StringUtils.isBlank((CharSequence)newHost) && StringUtils.isBlank((CharSequence)newClusterVip) && StringUtils.isBlank((CharSequence)newClusterPort) && StringUtils.isBlank((CharSequence)newDisplayName)) {
            return;
        }
        oldBaseInfo = Optional.ofNullable(oldBaseInfo).orElse(new CTBaseInfo());
        String oldClusterName = oldBaseInfo.getClusterName();
        String oldHost = oldBaseInfo.getHost();
        String oldClusterVip = oldBaseInfo.getClusterVip();
        String oldClusterPort = oldBaseInfo.getClusterPort();
        String oldDisplayName = oldBaseInfo.getDisplayName();
        String finalClusterName = StringUtils.isNotBlank((CharSequence)clusterName) ? clusterName : oldClusterName;
        String finalHost = StringUtils.isNotBlank((CharSequence)newHost) ? newHost : oldHost;
        String finalClusterVip = StringUtils.isNotBlank((CharSequence)newClusterVip) ? newClusterVip : oldClusterVip;
        String finalClusterPort = StringUtils.isNotBlank((CharSequence)newClusterPort) ? newClusterPort : oldClusterPort;
        String finalDisplayName = StringUtils.isNotBlank((CharSequence)newDisplayName) ? newDisplayName : oldDisplayName;
        CTBaseInfo mergedBaseInfo = new CTBaseInfo();
        mergedBaseInfo.setClusterName(finalClusterName);
        mergedBaseInfo.setHost(finalHost);
        mergedBaseInfo.setClusterVip(finalClusterVip);
        mergedBaseInfo.setClusterPort(finalClusterPort);
        mergedBaseInfo.setDisplayName(finalDisplayName);
        V1ConfigMap oldConfigMap = this.configMapService.read(CONFIGMAP_NAME_CMS_CT_INFO, NAMESPACE_NAME);
        HashMap<String, String> oldConfigMapData = oldConfigMap.getData();
        if (oldConfigMapData == null) {
            oldConfigMapData = new HashMap<String, String>();
        }
        if (!Objects.equals(oldCtInfoJson = (String)oldConfigMapData.get(CONFIGMAP_KEY_CMS_CT_INFO_JSON), newCtInfoJson = this.rebuildCtInfoJson(clusterName, oldCtInfoJson, mergedBaseInfo))) {
            oldConfigMapData.put(CONFIGMAP_KEY_CMS_CT_INFO_JSON, newCtInfoJson);
            oldConfigMap.setData(oldConfigMapData);
            this.configMapService.replace((Object)oldConfigMap);
        }
    }

    public void removeClusterFromCtInfoConfigMap(String clusterName) throws IOException, KubeOperationException {
        V1ConfigMap configMap = this.configMapService.read(CONFIGMAP_NAME_CMS_CT_INFO, NAMESPACE_NAME);
        Map configMapData = configMap.getData();
        if (configMapData == null) {
            return;
        }
        String ctInfoJson = (String)configMapData.get(CONFIGMAP_KEY_CMS_CT_INFO_JSON);
        if (StringUtils.isEmpty((CharSequence)ctInfoJson)) {
            return;
        }
        String value = this.rebuildRemovedCtInfoJson(ctInfoJson, clusterName);
        configMapData.put(CONFIGMAP_KEY_CMS_CT_INFO_JSON, value);
        configMap.setData(configMapData);
        this.configMapService.replace((Object)configMap);
    }

    private String rebuildCtInfoJson(String clusterName, String oldCtInfoJson, CTBaseInfo mergedBaseInfo) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        CtInfo ctInfo = StringUtils.isNotEmpty((CharSequence)oldCtInfoJson) ? (CtInfo)mapper.readValue(oldCtInfoJson, CtInfo.class) : new CtInfo();
        boolean shouldCreateItem = this.updateExistCtInfoItem(clusterName, ctInfo, mergedBaseInfo);
        if (shouldCreateItem) {
            CtInfoItem item = new CtInfoItem(mergedBaseInfo.getClusterName(), ClusterType.EXTERNAL.getVal(), mergedBaseInfo.getHost(), mergedBaseInfo.getClusterVip(), mergedBaseInfo.getClusterPort(), mergedBaseInfo.getDisplayName());
            ctInfo.getCtInfoItemList().add(item);
        }
        return mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)ctInfo);
    }

    private boolean updateExistCtInfoItem(String clusterName, CtInfo oldCtInfo, CTBaseInfo ctBaseInfo) {
        boolean shouldCreateItem = true;
        List<CtInfoItem> itemList = oldCtInfo.getCtInfoItemList();
        for (CtInfoItem item : itemList) {
            if (!clusterName.equals(item.getName())) continue;
            shouldCreateItem = false;
            item.setType(ClusterType.EXTERNAL.getVal());
            item.setHost(ctBaseInfo.getHost());
            item.setIp(ctBaseInfo.getClusterVip());
            item.setPort(ctBaseInfo.getClusterPort());
            item.setDisplayName(ctBaseInfo.getDisplayName());
            break;
        }
        return shouldCreateItem;
    }

    private String rebuildRemovedCtInfoJson(String ctInfoJson, String clusterName) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        CtInfo ctInfo = (CtInfo)mapper.readValue(ctInfoJson, CtInfo.class);
        List<CtInfoItem> itemList = ctInfo.getCtInfoItemList();
        boolean removeItem = false;
        Iterator<CtInfoItem> it = itemList.iterator();
        while (it.hasNext()) {
            CtInfoItem item = it.next();
            if (!clusterName.equals(item.getName())) continue;
            it.remove();
            removeItem = true;
        }
        if (removeItem) {
            ctInfoJson = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)ctInfo);
        }
        return ctInfoJson;
    }

    public void createOrUpdateEndpointAndService(CTBaseInfo ctBaseInfo, CTRedisInfo redisInfo) throws KubeOperationException {
        String host = ctBaseInfo.getHost();
        if (this.serviceService.exist(host, NAMESPACE_NAME)) {
            try {
                this.serviceService.delete(host, NAMESPACE_NAME);
            }
            catch (Exception e) {
                logger.warn("", (Throwable)e);
            }
        }
        if (this.endpointsService.exist(host, NAMESPACE_NAME)) {
            this.endpointsService.delete(host, NAMESPACE_NAME);
        }
        String endpointYaml = this.buildEndpointYaml(ctBaseInfo, redisInfo);
        this.endpointsService.create(endpointYaml);
        String serviceYaml = this.buildHeadlessServices(ctBaseInfo, redisInfo);
        this.serviceService.create(serviceYaml);
    }

    private String buildEndpointYaml(CTBaseInfo baseInfo, CTRedisInfo redisInfo) {
        String endpointName = baseInfo.getHost();
        String clusterVip = baseInfo.getClusterVip();
        String clusterPort = baseInfo.getClusterPort();
        Integer redisPort = redisInfo.getRedisPort();
        return "kind: " + KubeResEnum.ENDPOINTS.getVal() + "\nmetadata:\n  name: " + endpointName + "\n  namespace: " + NAMESPACE_NAME + "\nsubsets:\n  - addresses:\n      - ip: " + clusterVip + "\n    ports:\n      - name: https\n        port: " + clusterPort + "\n        protocol: TCP\n      - name: redis\n        port: " + redisPort + "\n        protocol: TCP";
    }

    private String buildHeadlessServices(CTBaseInfo baseInfo, CTRedisInfo redisInfo) {
        String serviceName = baseInfo.getHost();
        String clusterPort = baseInfo.getClusterPort();
        Integer redisPort = redisInfo.getRedisPort();
        return "kind: " + KubeResEnum.SERVICE.getVal() + "\nmetadata:\n  name: " + serviceName + "\n  namespace: " + NAMESPACE_NAME + "\nspec:\n  ports:\n    - name: https\n      protocol: TCP\n      port: " + clusterPort + "\n      targetPort: " + clusterPort + "\n    - name: redis\n      protocol: TCP\n      port: " + redisPort + "\n      targetPort: " + redisPort + "\n  clusterIP: None\n";
    }

    public void updateCmsCtSslSecret(String clusterName, CTCertInfo ctCertInfo, CTKubeInfo kubeInfo) throws KubeOperationException {
        List<String> patcherList = this.buildSecretPatcherList(clusterName, ctCertInfo, kubeInfo);
        if (patcherList.size() > 0) {
            this.secretService.patch(SECRET_CMS_CT_SSL, NAMESPACE_NAME, patcherList);
        }
    }

    private List<String> buildSecretPatcherList(String clusterName, CTCertInfo ctCertInfo, CTKubeInfo kubeInfo) {
        HashMap<String, String> secretsMap = new HashMap<String, String>();
        if (ctCertInfo != null) {
            secretsMap.put("client.pem", ctCertInfo.getClientPem());
            secretsMap.put("app.pem", ctCertInfo.getAppPem());
            secretsMap.put("client_auth_keystorejks", ctCertInfo.getClientAuthKeystorejks());
            secretsMap.put("cms_fingerprint", ctCertInfo.getCmsFingerprint());
            secretsMap.put("cms_truststorejks", ctCertInfo.getCmsTruststorejks());
            secretsMap.put("keystorepass", ctCertInfo.getKeystorepass());
        }
        if (kubeInfo != null) {
            secretsMap.put("cms_common_kubeconfig", kubeInfo.getCmsCommonKubeconfig());
        }
        return secretsMap.entrySet().stream().filter(entry -> StringUtils.isNotBlank((CharSequence)((CharSequence)entry.getValue()))).map(entry -> String.format("{\"op\": \"replace\", \"path\": \"/data/%s.%s\", \"value\":\"%s\"}", clusterName, entry.getKey(), entry.getValue())).collect(Collectors.toList());
    }

    public void removeClusterInfoFromCmsCtSslSecret(String clusterName) throws KubeOperationException {
        V1Secret secret = this.secretService.read(SECRET_CMS_CT_SSL, NAMESPACE_NAME);
        Map secretDate = secret.getData();
        List<String> patcherList = this.buildSecretRemovePatcherList(clusterName, secretDate);
        this.secretService.patch(SECRET_CMS_CT_SSL, NAMESPACE_NAME, patcherList);
    }

    private List<String> buildSecretRemovePatcherList(String clusterName, Map secretDate) {
        ArrayList<String> pathList = new ArrayList<String>();
        pathList.add("client.pem");
        pathList.add("app.pem");
        pathList.add("client_auth_keystorejks");
        pathList.add("cms_fingerprint");
        pathList.add("cms_truststorejks");
        pathList.add("keystorepass");
        pathList.add("cms_common_kubeconfig");
        ArrayList<String> patcherList = new ArrayList<String>();
        pathList.stream().filter(item -> secretDate.containsKey(clusterName + "." + item)).forEach(path -> patcherList.add(String.format("{\"op\": \"remove\", \"path\": \"/data/%s.%s\"}", clusterName, path)));
        return patcherList;
    }

    public void updateHaproxyConfig(String clusterName, CTBaseInfo oldBaseInfo, CTBaseInfo newBaseInfo) throws JsonProcessingException, KubeOperationException {
        if (newBaseInfo == null) {
            return;
        }
        this.updateGlobalAclInConfigMap();
        this.createCtInfoBackend(clusterName, newBaseInfo, oldBaseInfo);
        this.createCtInfoFrontend(clusterName);
    }

    private void updateGlobalAclInConfigMap() throws JsonProcessingException, KubeOperationException {
        String ctAclConfigName;
        V1ConfigMap ctAclConfigMap;
        V1ConfigMap configMap = this.configMapService.read(CONFIGMAP_NAME_CMS_CT_INFO, NAMESPACE_NAME);
        Map configMapData = configMap.getData();
        String ctInfoJson = (String)configMapData.get(CONFIGMAP_KEY_CMS_CT_INFO_JSON);
        String onlySingleLocal = "always_false";
        String onlySingleExternal = "always_false";
        if (StringUtils.isNotEmpty((CharSequence)ctInfoJson)) {
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            CtInfo ctInfo = (CtInfo)mapper.readValue(ctInfoJson, CtInfo.class);
            List<CtInfoItem> itemList = ctInfo.getCtInfoItemList();
            if (itemList.size() == 1) {
                String type = itemList.get(0).getType();
                if (ClusterType.LOCAL.getVal().equalsIgnoreCase(type)) {
                    onlySingleLocal = "always_true";
                } else if (ClusterType.EXTERNAL.getVal().equalsIgnoreCase(type)) {
                    onlySingleExternal = "always_true";
                }
            }
        }
        if ((ctAclConfigMap = this.configMapService.read(ctAclConfigName = "cms-ct-acl-configmap", NAMESPACE_NAME)) != null) {
            String newAclStr;
            String oldAclStr;
            HashMap<String, String> dataMap = ctAclConfigMap.getData();
            if (dataMap == null) {
                dataMap = new HashMap<String, String>();
            }
            if (!Objects.equals(oldAclStr = (String)dataMap.get("globalCtAcl"), newAclStr = "acl single_ct_and_is_local " + onlySingleLocal + "\n        acl single_ct_and_is_external " + onlySingleExternal)) {
                dataMap.put("globalCtAcl", newAclStr);
                ctAclConfigMap.setData(dataMap);
                this.configMapService.replace((Object)ctAclConfigMap);
            }
        }
    }

    private void createCtInfoFrontend(String clusterName) throws KubeOperationException {
        String frontendYaml = this.buildCtInfoFrontendConfigMap(clusterName);
        this.configMapService.createOrReplace(frontendYaml);
    }

    private String buildCtInfoFrontendConfigMap(String clusterName) {
        String label = "ext-ct-frontend";
        String locationParam = "ct-location";
        return "kind: " + KubeResEnum.CONFIGMAP.getVal() + "\nmetadata:\n  labels:\n    cm: " + label + "\n  name: " + this.buildFrontendConfigMapName(clusterName) + "\n  namespace: " + NAMESPACE_NAME + "\ndata:\n  frontend: |-\n    acl acl-" + clusterName + " urlp(" + locationParam + ") " + clusterName + "\n            use_backend " + this.buildBackendConfigMapName(clusterName) + " if content_access_url acl-" + clusterName + "\n            use_backend " + this.buildBackendConfigMapName(clusterName) + " if fileuploader_url acl-" + clusterName + "\n            use_backend " + this.buildBackendConfigMapName(clusterName) + " if content_access_url single_ct_and_is_external\n            use_backend " + this.buildBackendConfigMapName(clusterName) + " if fileuploader_url single_ct_and_is_external";
    }

    private void createCtInfoBackend(String clusterName, CTBaseInfo newBaseInfo, CTBaseInfo oldBaseInfo) throws KubeOperationException {
        String finalPort;
        String newHost = newBaseInfo.getHost();
        String newPort = newBaseInfo.getClusterPort();
        if (StringUtils.isBlank((CharSequence)newHost) && StringUtils.isBlank((CharSequence)newPort)) {
            return;
        }
        oldBaseInfo = Optional.ofNullable(oldBaseInfo).orElse(new CTBaseInfo());
        String oldHost = oldBaseInfo.getHost();
        String oldPort = oldBaseInfo.getClusterPort();
        String finalHost = StringUtils.isNotBlank((CharSequence)newHost) ? newHost : oldHost;
        String string = finalPort = StringUtils.isNotBlank((CharSequence)newPort) ? newPort : oldPort;
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{finalHost, finalPort})) {
            return;
        }
        String backendYaml = this.buildCtInfoBackendConfigMap(clusterName, finalHost, finalPort);
        this.configMapService.createOrReplace(backendYaml);
    }

    private String buildCtInfoBackendConfigMap(String clusterName, String host, String port) {
        String kind = KubeResEnum.CONFIGMAP.getVal();
        String label = "ext-ct-backend";
        String ctLocationName = "ct-location";
        return "kind: " + kind + "\nmetadata:\n  labels:\n    cm: " + label + "\n  name: " + this.buildBackendConfigMapName(clusterName) + "\n  namespace: " + NAMESPACE_NAME + "\ndata:\n  backend: |\n    backend " + this.buildBackendConfigMapName(clusterName) + "\n      mode http\n        option forwardfor\n        http-request replace-uri ([^/:]*://[^?]*)?([^&]*)([&]?)" + ctLocationName + "=[^&]*(.*) \\1\\2\\3\\4\n        server ext-server-" + clusterName + " " + host + ":" + port + " ssl crt /usr/local/etc/haproxy/ct-ssl/" + clusterName + ".client.pem ca-file /usr/local/etc/haproxy/ct-ssl/" + clusterName + ".app.pem verify required check inter 5s";
    }

    public void updateLogstashInputPipeline(CTBaseInfo oldBaseInfo, CTBaseInfo newBaseInfo, CTRedisInfo oldRedisInfo, CTRedisInfo newRedisInfo) throws KubeOperationException {
        String oldRedisInputData;
        Map<String, List<Map<String, Object>>> dataMap;
        List<Map<String, Object>> oldInputList;
        Integer finalPort;
        newBaseInfo = Optional.ofNullable(newBaseInfo).orElse(new CTBaseInfo());
        newRedisInfo = Optional.ofNullable(newRedisInfo).orElse(new CTRedisInfo());
        String newHost = newBaseInfo.getHost();
        String newPassword = newRedisInfo.getRedisPassword();
        Integer newPort = newRedisInfo.getRedisPort();
        if (StringUtils.isEmpty((CharSequence)newHost) && StringUtils.isEmpty((CharSequence)newPassword) && newPort == null) {
            return;
        }
        oldBaseInfo = Optional.ofNullable(oldBaseInfo).orElse(new CTBaseInfo());
        oldRedisInfo = Optional.ofNullable(oldRedisInfo).orElse(new CTRedisInfo());
        String oldHost = oldBaseInfo.getHost();
        String oldPassword = oldRedisInfo.getRedisPassword();
        Integer oldPort = oldRedisInfo.getRedisPort();
        String finalHost = StringUtils.isNotBlank((CharSequence)newHost) ? newHost : oldHost;
        String finalPassword = StringUtils.isNotBlank((CharSequence)newPassword) ? newPassword : oldPassword;
        Integer n = finalPort = newPort != null ? newPort : oldPort;
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{finalHost, finalPassword}) || finalPort == null) {
            return;
        }
        V1ConfigMap oldConfigMap = this.configMapService.read(CONFIGMAP_NAME_CMS_LOGSTASH_REDIS, NAMESPACE_NAME);
        if (oldConfigMap == null) {
            logger.warn("Can't find the configmap: cms-logstash-redis-input-pipeline to update, Skipping.");
            return;
        }
        HashMap oldConfigMapData = oldConfigMap.getData();
        if (oldConfigMapData == null) {
            oldConfigMapData = new HashMap();
        }
        if ((oldInputList = (dataMap = this.convertRedisInputToMap(oldRedisInputData = (String)oldConfigMapData.get(CONFIGMAP_KEY_REDIS_INPUT))).get("input")) == null) {
            oldInputList = new ArrayList<Map<String, Object>>();
        }
        oldInputList.removeIf(inputItem -> inputItem.get("host") != null && inputItem.get("host").equals(oldHost));
        LinkedHashMap<String, Object> newItem = new LinkedHashMap<String, Object>();
        newItem.put("host", finalHost);
        newItem.put("port", finalPort);
        newItem.put("data_type", "list");
        newItem.put("password", finalPassword);
        newItem.put("key", "logstash");
        newItem.put("threads", 5);
        oldInputList.add(newItem);
        dataMap.put("input", oldInputList);
        String resConf = this.convertRedisInputToOriginalFormat(dataMap);
        resConf = StringEscapeUtils.escapeEcmaScript((String)resConf);
        List<String> patcherList = Collections.singletonList(String.format("{\"op\":\"replace\",\"path\":\"/data/%s\",\"value\":\"%s\"}", CONFIGMAP_KEY_REDIS_INPUT, resConf));
        this.configMapService.patch(CONFIGMAP_NAME_CMS_LOGSTASH_REDIS, NAMESPACE_NAME, patcherList);
    }

    public void removeClusterFromLogstashInputPipline(String host) throws KubeOperationException {
        String redisInputData;
        Map<String, List<Map<String, Object>>> dataMap;
        List<Map<String, Object>> inputList;
        V1ConfigMap configMap = this.configMapService.read(CONFIGMAP_NAME_CMS_LOGSTASH_REDIS, NAMESPACE_NAME);
        if (configMap == null) {
            logger.warn("Can't find the configmap: cms-logstash-redis-input-pipeline to update, Skipping.");
            return;
        }
        HashMap configMapData = configMap.getData();
        if (configMapData == null) {
            configMapData = new HashMap();
        }
        if ((inputList = (dataMap = this.convertRedisInputToMap(redisInputData = (String)configMapData.get(CONFIGMAP_KEY_REDIS_INPUT))).get("input")) == null) {
            inputList = new ArrayList<Map<String, Object>>();
        }
        Iterator<Map<String, Object>> iterator = inputList.iterator();
        while (iterator.hasNext()) {
            Map<String, Object> inputItem = iterator.next();
            if (!host.equals(inputItem.get("host"))) continue;
            iterator.remove();
        }
        dataMap.put("input", inputList);
        String resConf = this.convertRedisInputToOriginalFormat(dataMap);
        resConf = StringEscapeUtils.escapeEcmaScript((String)resConf);
        List<String> patcherList = Collections.singletonList(String.format("{\"op\":\"replace\",\"path\":\"/data/%s\",\"value\":\"%s\"}", CONFIGMAP_KEY_REDIS_INPUT, resConf));
        this.configMapService.patch(CONFIGMAP_NAME_CMS_LOGSTASH_REDIS, NAMESPACE_NAME, patcherList);
    }

    private Map<String, List<Map<String, Object>>> convertRedisInputToMap(String conf) {
        Map<String, List<Map<String, Object>>> map = new HashMap<String, List<Map<String, Object>>>();
        if (StringUtils.isNotEmpty((CharSequence)conf)) {
            conf = conf.replaceAll("(^[\\w]+)[\\s]*\\{", "$1:");
            conf = conf.replaceAll("([\\w]+)[\\s]*\\{", "- $1:");
            conf = conf.replace("=>", ":");
            conf = conf.replace("}", "");
            map = (Map)new Yaml().load(conf);
        }
        return map;
    }

    private String convertRedisInputToOriginalFormat(Map<String, List<Map<String, Object>>> map) {
        List<Map<String, Object>> list = map.get("input");
        return list.stream().map(item -> String.format("  redis {\n    host        =>    \"%s\"\n    port        =>    \"%s\"\n    data_type   =>    \"%s\"\n    password    =>    \"%s\"\n    key         =>    \"%s\"\n    threads     =>    \"%s\"\n  }\n", item.get("host"), item.get("port"), item.get("data_type"), item.get("password"), item.get("key"), item.get("threads"))).collect(Collectors.joining("", "input {\n", "}"));
    }
}

