/*
 * Decompiled with CFR 0.152.
 */
package com.mediakind.ctmanager.controller;

import com.mediakind.ctmanager.model.dto.CTBaseInfo;
import com.mediakind.ctmanager.model.dto.RegCtInfo;
import com.mediakind.ctmanager.service.RegistrationService;
import java.util.HashMap;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RegistrationController {
    private static final Logger logger = LoggerFactory.getLogger(RegistrationController.class);
    @Autowired
    private RegistrationService registrationService;

    @PutMapping(value={"/registration"})
    @ResponseBody
    public Object registration(@Valid @RequestBody RegCtInfo regCtInfo) {
        logger.info("External CT register begin");
        try {
            String clusterName = regCtInfo.getCtBaseInfo().getClusterName();
            this.registrationService.createCluster(clusterName, regCtInfo);
        }
        catch (Exception e) {
            logger.error("External CT register failed", (Throwable)e);
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("status", HttpStatus.INTERNAL_SERVER_ERROR.value());
            result.put("errors", e.getMessage());
            return result;
        }
        logger.info("External CT register success");
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("status", HttpStatus.OK.value());
        result.put("message", "External CT cluster register success");
        return result;
    }

    @GetMapping(value={"/unregistration"})
    @ResponseBody
    public Object unregistration(@Valid @RequestParam(name="clustername") String clusterName) {
        logger.info("External CT unregister begin");
        try {
            CTBaseInfo clusterInfo = this.registrationService.getCtBaseInfoFromConfigMap(clusterName);
            String host = null;
            if (clusterInfo != null) {
                host = clusterInfo.getHost();
            }
            this.registrationService.unregisterCluster(clusterName, host);
        }
        catch (Exception e) {
            logger.error("External CT unregister failed", (Throwable)e);
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("status", HttpStatus.INTERNAL_SERVER_ERROR.value());
            result.put("errors", e.getMessage());
            return result;
        }
        logger.info("External CT unregister success");
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("status", HttpStatus.OK.value());
        result.put("message", "External CT cluster unregister success");
        return result;
    }

    @PutMapping(value={"/update/{clusterName}"})
    @ResponseBody
    public Object update(@PathVariable String clusterName, @RequestBody RegCtInfo regCtInfo) {
        logger.info("External CT update begin");
        try {
            CTBaseInfo clusterInfo = this.registrationService.getCtBaseInfoFromConfigMap(clusterName);
            if (clusterInfo == null) {
                String errorMsg = "External CT update failed. cluster name" + clusterName + " not exist!";
                logger.error(errorMsg);
                HashMap<String, String> result = new HashMap<String, String>();
                result.put("errors", errorMsg);
                return result;
            }
            this.registrationService.updateCluster(clusterName, regCtInfo);
        }
        catch (Exception e) {
            logger.error("External CT update failed", (Throwable)e);
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("status", HttpStatus.INTERNAL_SERVER_ERROR.value());
            result.put("errors", e.getMessage());
            return result;
        }
        logger.info("External CT update success");
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("status", HttpStatus.OK.value());
        result.put("message", "External CT cluster update success");
        return result;
    }
}

