/*
 * Decompiled with CFR 0.152.
 */
package com.mediakind.ctmanager.service;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mediakind.cms.service.api.kube.exception.KubeOperationException;
import com.mediakind.cms.service.api.kube.service.impl.KubeConfigMapService;
import com.mediakind.cms.service.api.kube.utils.KubeClientUtil;
import com.mediakind.ctmanager.model.po.CtResourceInfo;
import com.mediakind.ctmanager.model.po.CtResourceInfoItem;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.models.V1ConfigMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CTResourceInfoService {
    private static final Logger logger = LoggerFactory.getLogger(CTResourceInfoService.class);
    private KubeConfigMapService configMapService;

    public void setConfigMapService(KubeConfigMapService configMapService) {
        this.configMapService = configMapService;
    }

    public CTResourceInfoService() throws IOException {
        ApiClient apiClient = KubeClientUtil.getLocalClient();
        this.configMapService = new KubeConfigMapService(apiClient);
    }

    public List<CtResourceInfoItem> getCTResourceInfoList() {
        try {
            V1ConfigMap configMap = this.configMapService.read("cms-ct-resource-info", KubeClientUtil.getNamespace());
            if (configMap != null && configMap.getData() != null) {
                String content = (String)configMap.getData().get("cms-ct-resource-info.json");
                return this.getCTResourceInfoList(content);
            }
        }
        catch (KubeOperationException e) {
            logger.error("Get CT resource info from ConfigMap failed.", (Throwable)e);
        }
        return new ArrayList<CtResourceInfoItem>();
    }

    public List<CtResourceInfoItem> getCTResourceInfoList(String resourceInfoStr) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        List<Object> resourceInfoList = new ArrayList<CtResourceInfoItem>();
        try {
            if (StringUtils.isNotEmpty((CharSequence)resourceInfoStr)) {
                CtResourceInfo resourceInfo = (CtResourceInfo)mapper.readValue(resourceInfoStr, CtResourceInfo.class);
                resourceInfoList = resourceInfo.getItemList();
            }
        }
        catch (Exception e) {
            logger.error("Transfer CT resource info failed.", (Throwable)e);
        }
        return resourceInfoList;
    }

    public String getResourceNamePattern(String namePrefix, String clusterName) {
        return namePrefix + "_" + clusterName + "_server";
    }

    public List<CtResourceInfoItem> getCTResourceInfoListByDeployment(String deploymentName) {
        List resInfoList = this.getCTResourceInfoList();
        return resInfoList.stream().filter(r -> deploymentName.equals(r.getDeployment())).collect(Collectors.toList());
    }

    public Set<String> getDistinctDeployments() {
        List resourceItems = this.getCTResourceInfoList();
        HashSet<String> deploymentSet = new HashSet<String>();
        for (CtResourceInfoItem item : resourceItems) {
            deploymentSet.add(item.getDeployment());
        }
        return deploymentSet;
    }
}

