/*
 * Decompiled with CFR 0.152.
 */
package com.mediakind.ctmanager.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mediakind.cms.service.api.kube.exception.KubeOperationException;
import com.mediakind.cms.service.api.kube.helper.ClusterInfo;
import com.mediakind.cms.service.api.kube.service.impl.KubeDeploymentService;
import com.mediakind.cms.service.api.kube.utils.KubeClientUtil;
import com.mediakind.ctmanager.constant.AppConstants;
import com.mediakind.ctmanager.model.dto.ResourceOptType;
import com.mediakind.ctmanager.model.dto.ResourceSyncInfo;
import com.mediakind.ctmanager.model.po.CtResourceInfoItem;
import com.mediakind.ctmanager.model.po.ResourceListRespItem;
import com.mediakind.ctmanager.model.po.ResourceResp;
import com.mediakind.ctmanager.model.po.ResourceRespGroupItem;
import com.mediakind.ctmanager.service.CTInfoService;
import com.mediakind.ctmanager.service.CTResourceInfoService;
import com.mediakind.ctmanager.service.WfsHealthService;
import com.mediakind.ctmanager.service.WfsResourceService;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.models.V1Deployment;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class WfsResourceSyncService {
    private static final Logger logger = LoggerFactory.getLogger(WfsResourceSyncService.class);
    private WfsResourceService resourceService;
    private CTResourceInfoService ctResourceInfoService;
    private CTInfoService ctInfoService;
    private WfsHealthService wfsHealthService;

    @Autowired
    public void setResourceService(WfsResourceService resourceService) {
        this.resourceService = resourceService;
    }

    @Autowired
    public void setCtResourceInfoService(CTResourceInfoService ctResourceInfoService) {
        this.ctResourceInfoService = ctResourceInfoService;
    }

    @Autowired
    public void setCtInfoService(CTInfoService ctInfoService) {
        this.ctInfoService = ctInfoService;
    }

    @Autowired
    public void setWfsHealthService(WfsHealthService wfsHealthService) {
        this.wfsHealthService = wfsHealthService;
    }

    public synchronized void syncFullResourcesWithUpdate() {
        this.syncFullResources(true);
    }

    public synchronized void syncFullResources() {
        this.syncFullResources(false);
    }

    public synchronized void deleteResourceByClusterName(String clusterName) {
        try {
            this.resourceService.deleteResourceByClusterName(clusterName);
        }
        catch (Exception e) {
            logger.error("Delete resource by clusterName " + clusterName, (Throwable)e);
        }
    }

    private synchronized void syncFullResources(boolean needDoUpdate) {
        if (this.wfsHealthService.isDown()) {
            logger.error("Workflow service is down, skip this full sync.");
            AppConstants.NEED_TO_TRIGGER_SYNC_FLAG = true;
            return;
        }
        List ctInfoList = this.ctInfoService.getCTInfoList();
        for (ClusterInfo cluster : ctInfoList) {
            ApiClient apiClient;
            String clusterName = cluster.getName();
            try {
                apiClient = KubeClientUtil.getClient((ClusterInfo)cluster);
            }
            catch (IOException e) {
                logger.error(String.format("Sync cluster %s failed for instance ApiClient", clusterName), (Throwable)e);
                continue;
            }
            apiClient.setHttpClient(apiClient.getHttpClient().newBuilder().readTimeout(0L, TimeUnit.SECONDS).build());
            KubeDeploymentService depService = new KubeDeploymentService(apiClient);
            Set deploymentSet = this.ctResourceInfoService.getDistinctDeployments();
            for (String deploymentName : deploymentSet) {
                try {
                    this.syncSpecificDeployment(needDoUpdate, depService, cluster, deploymentName);
                }
                catch (KubeOperationException e) {
                    logger.error(String.format("Sync cluster %s deployment %s failed.", clusterName, deploymentName), (Throwable)e);
                }
            }
        }
    }

    public synchronized void syncSpecificResource(ClusterInfo ct, String deploymentName) {
        if (this.wfsHealthService.isDown()) {
            logger.error("Workflow service is down, skip this specific sync, deployment={}.", (Object)deploymentName);
            AppConstants.NEED_TO_TRIGGER_SYNC_FLAG = true;
            return;
        }
        String clusterName = ct.getName();
        logger.info("Start to sync specific resource. cluster {} deployment {}", (Object)clusterName, (Object)deploymentName);
        try {
            KubeDeploymentService service = new KubeDeploymentService(KubeClientUtil.getClient((ClusterInfo)ct));
            this.syncSpecificDeployment(false, service, ct, deploymentName);
        }
        catch (Exception e) {
            logger.error(String.format("Sync cluster %s deployment %s failed.", clusterName, deploymentName), (Throwable)e);
        }
    }

    protected synchronized void syncSpecificDeployment(boolean needDoUpdate, KubeDeploymentService service, ClusterInfo ct, String deploymentName) throws KubeOperationException {
        String clusterName = ct.getName();
        String ctNamespace = ct.getNamespace();
        V1Deployment deployment = service.read(deploymentName, ctNamespace);
        Integer replica = 0;
        if (deployment != null && deployment.getSpec() != null) {
            replica = deployment.getSpec().getReplicas();
        }
        List resInfoList = this.ctResourceInfoService.getCTResourceInfoListByDeployment(deploymentName);
        for (CtResourceInfoItem resourceInfo : resInfoList) {
            ResourceSyncInfo resourceSyncInfo;
            String resPrefix = this.ctResourceInfoService.getResourceNamePattern(resourceInfo.getNamePrefix(), clusterName);
            try {
                resourceSyncInfo = this.resourceService.getExistResourceDetail(resPrefix);
            }
            catch (Exception e) {
                logger.error(String.format("Fail to get exist resource detail for prefix %s, to skip sync this item.", resPrefix), (Throwable)e);
                continue;
            }
            Map resourceIndexAndItemMap = resourceSyncInfo.getResourceMap();
            Map resourceIndexMap = this.getCreateAndDeleteAndUpdateResource(resourceSyncInfo, replica);
            Set createResourceIndex = (Set)resourceIndexMap.get(ResourceOptType.CREATE);
            this.createSomeResources(createResourceIndex, clusterName, resPrefix, resourceInfo);
            Set deleteResourceIndex = (Set)resourceIndexMap.get(ResourceOptType.DELETE);
            this.deleteSomeResources(deleteResourceIndex, resourceIndexAndItemMap);
            if (!needDoUpdate) continue;
            Set updateResourceIndex = (Set)resourceIndexMap.get(ResourceOptType.UPDATE);
            this.updateExistResource(updateResourceIndex, resourceIndexAndItemMap, resourceInfo);
        }
    }

    protected Map<ResourceOptType, Set<Integer>> getCreateAndDeleteAndUpdateResource(ResourceSyncInfo resourceSyncInfo, Integer replica) {
        Set finalResourceSet = IntStream.rangeClosed(1, replica).boxed().collect(Collectors.toSet());
        Set existResourceSet = resourceSyncInfo.getResourceIndexSet();
        HashSet createResourceIndex = new HashSet(finalResourceSet);
        HashSet deleteResourceIndex = new HashSet(existResourceSet);
        HashSet updateResourceIndex = new HashSet(finalResourceSet);
        createResourceIndex.removeAll(existResourceSet);
        deleteResourceIndex.removeAll(finalResourceSet);
        updateResourceIndex.retainAll(existResourceSet);
        HashMap<ResourceOptType, Set<Integer>> result = new HashMap<ResourceOptType, Set<Integer>>();
        result.put(ResourceOptType.CREATE, createResourceIndex);
        result.put(ResourceOptType.DELETE, deleteResourceIndex);
        result.put(ResourceOptType.UPDATE, updateResourceIndex);
        return result;
    }

    private void updateExistResource(Set<Integer> updateResourceIndex, Map<Integer, ResourceListRespItem> resourceIndexAndItemMap, CtResourceInfoItem resourceInfo) {
        for (Integer index : updateResourceIndex) {
            ResourceListRespItem res = resourceIndexAndItemMap.get(index);
            ResourceResp resourceResp = null;
            if (res != null) {
                int resourceId = res.getId();
                try {
                    resourceResp = this.resourceService.getResourceById(Integer.valueOf(resourceId));
                }
                catch (Exception e) {
                    logger.error(String.format("Get resource by Id %d failed, skip this one.", resourceId), (Throwable)e);
                    continue;
                }
            }
            if (resourceResp == null) continue;
            String preConnectionString = resourceResp.getConnectionString();
            Integer preHeartbeatFrequency = resourceResp.getHeartbeatFrequency();
            Integer preMaxConcurrentUsage = resourceResp.getMaxConcurrentUsage();
            Boolean preIgnoreTimeout = resourceResp.getIgnoreTimeout();
            HashSet<String> preResourceGroupsSet = new HashSet<String>();
            List preResourceGroups = resourceResp.getResourceGroups();
            if (preResourceGroups != null) {
                for (ResourceRespGroupItem item : preResourceGroups) {
                    preResourceGroupsSet.add(item.getName());
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Resource previous info, ConnectionString={}, HeartbeatFrequency={},MaxConcurrentUsage={},IgnoreTimeout={},GroupSet={}", new Object[]{preConnectionString, preHeartbeatFrequency, preMaxConcurrentUsage, preIgnoreTimeout, preResourceGroupsSet});
            }
            String newConnectionString = WfsResourceSyncService.replaceParameter((String)preConnectionString, (String)"deployment", (String)resourceInfo.getDeployment());
            Integer newHeartbeatFrequency = resourceInfo.getHeartbeatFrequency();
            Integer newMaxConcurrentUsage = resourceInfo.getMaxConcurrentUsage();
            Boolean newIgnoreTimeout = resourceInfo.getIgnoreTimeout();
            HashSet<String> newResourceGroupsSet = new HashSet<String>();
            ArrayList<ResourceRespGroupItem> newGroupList = new ArrayList<ResourceRespGroupItem>();
            if (resourceInfo.getGroup() != null) {
                for (String groupName : resourceInfo.getGroup()) {
                    ResourceRespGroupItem group = new ResourceRespGroupItem();
                    group.setName(groupName);
                    newGroupList.add(group);
                    newResourceGroupsSet.add(groupName);
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Resource current info, ConnectionString={}, HeartbeatFrequency={},MaxConcurrentUsage={},IgnoreTimeout={},GroupSet={}", new Object[]{newConnectionString, newHeartbeatFrequency, newMaxConcurrentUsage, newIgnoreTimeout, newResourceGroupsSet});
            }
            if (newConnectionString.equals(preConnectionString) && newHeartbeatFrequency.equals(preHeartbeatFrequency) && newMaxConcurrentUsage.equals(preMaxConcurrentUsage) && newIgnoreTimeout.equals(preIgnoreTimeout) && WfsResourceSyncService.setIsEquals(newResourceGroupsSet, preResourceGroupsSet)) {
                logger.info("Resource {} unchanged, skip to update it.", (Object)res.getName());
                continue;
            }
            resourceResp.setResourceGroups(newGroupList);
            resourceResp.setConnectionString(newConnectionString);
            resourceResp.setHeartbeatConnectionString(newConnectionString);
            resourceResp.setHeartbeatFrequency(newHeartbeatFrequency);
            resourceResp.setMaxConcurrentUsage(newMaxConcurrentUsage);
            resourceResp.setIgnoreTimeout(newIgnoreTimeout);
            ObjectMapper mapper = new ObjectMapper();
            try {
                String requestJson = mapper.writeValueAsString((Object)resourceResp);
                if (logger.isDebugEnabled()) {
                    logger.debug("Update resources request json: {}", (Object)requestJson);
                }
                this.resourceService.updateResource(res.getName(), resourceResp.getId(), requestJson);
            }
            catch (JsonProcessingException e) {
                logger.error("Java Object to Json failed while update exist resources.", (Throwable)e);
            }
        }
    }

    private static boolean setIsEquals(Set<?> set1, Set<?> set2) {
        if (set1.size() != set2.size()) {
            return false;
        }
        return set1.containsAll(set2);
    }

    private static String replaceParameter(String url, String paramName, String paramValue) {
        return url.replaceAll("(" + paramName + "=[^&]*)", paramName + "=" + paramValue);
    }

    private void createSomeResources(Set<Integer> createResourceIndex, String clusterName, String namePrefix, CtResourceInfoItem item) {
        for (Integer index : createResourceIndex) {
            String connectionString;
            String resourceName = namePrefix + index;
            try {
                connectionString = this.getResourceURL(clusterName, item, index.intValue());
            }
            catch (Exception e) {
                logger.error("Get resource URL failed.", (Throwable)e);
                continue;
            }
            String heartbeatConnectionString = connectionString;
            JsonObject requestJson = new JsonObject();
            requestJson.addProperty("resourceTypeName", item.getResourceType());
            requestJson.addProperty("adminState", "Online");
            requestJson.addProperty("name", resourceName);
            requestJson.addProperty("connectionString", connectionString);
            requestJson.addProperty("heartbeatConnectionString", heartbeatConnectionString);
            requestJson.addProperty("heartbeatFrequency", (Number)item.getHeartbeatFrequency());
            requestJson.addProperty("maxConcurrentUsage", (Number)item.getMaxConcurrentUsage());
            requestJson.addProperty("ignoreTimeout", item.getIgnoreTimeout());
            JsonArray groupArray = new JsonArray();
            List groupList = item.getGroup();
            for (String group : groupList) {
                JsonObject groupObj = new JsonObject();
                groupObj.addProperty("name", group);
                groupArray.add((JsonElement)groupObj);
            }
            requestJson.add("resourceGroups", (JsonElement)groupArray);
            if (logger.isDebugEnabled()) {
                logger.debug("Create resources request json: {}", (Object)requestJson);
            }
            logger.info("To create resource {}", (Object)resourceName);
            this.resourceService.createResource(resourceName, requestJson.toString());
        }
    }

    private String getResourceURL(String clusterName, CtResourceInfoItem item, int number) throws Exception {
        String resourceTypeName = item.getResourceType();
        String baseUrl = (String)AppConstants.WFS_RESOURCE_BASEURL_MAP.get(resourceTypeName);
        if (StringUtils.isEmpty((CharSequence)baseUrl)) {
            throw new Exception(String.format("Non-supported resourceType %s", resourceTypeName));
        }
        StringBuilder url = new StringBuilder(baseUrl);
        url.append("?ct-location=");
        url.append(clusterName);
        url.append("&deployment=");
        url.append(item.getDeployment());
        url.append("&server=server");
        url.append(number);
        url.append("&name-prefix=");
        url.append(item.getNamePrefix());
        return url.toString();
    }

    private void deleteSomeResources(Set<Integer> deleteResourceIndex, Map<Integer, ResourceListRespItem> resourceIndexAndItemMap) {
        for (Integer index : deleteResourceIndex) {
            ResourceListRespItem res = resourceIndexAndItemMap.get(index);
            this.resourceService.deleteResource(res.getName(), res.getId());
        }
    }
}

