/*
 * Decompiled with CFR 0.152.
 */
package com.mediakind.ctmanager.service;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mediakind.cms.service.api.kube.exception.KubeOperationException;
import com.mediakind.cms.service.api.kube.helper.ClusterInfo;
import com.mediakind.cms.service.api.kube.helper.ClusterType;
import com.mediakind.cms.service.api.kube.service.impl.KubeConfigMapService;
import com.mediakind.cms.service.api.kube.utils.KubeClientUtil;
import com.mediakind.ctmanager.model.po.CtInfo;
import com.mediakind.ctmanager.model.po.CtInfoItem;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.models.V1ConfigMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CTInfoService {
    private static final Logger logger = LoggerFactory.getLogger(CTInfoService.class);
    private KubeConfigMapService configMapService;

    public CTInfoService() throws IOException {
        ApiClient apiClient = KubeClientUtil.getLocalClient();
        this.configMapService = new KubeConfigMapService(apiClient);
    }

    public List<ClusterInfo> getCTInfoList() {
        try {
            V1ConfigMap configMap = this.configMapService.read("cms-ct-info", KubeClientUtil.getNamespace());
            if (configMap != null && configMap.getData() != null) {
                String content = (String)configMap.getData().get("cms-ct-info.json");
                return this.getCTInfoList(content);
            }
        }
        catch (KubeOperationException e) {
            logger.error("Get CT info from ConfigMap failed.", (Throwable)e);
        }
        return new ArrayList<ClusterInfo>();
    }

    public List<ClusterInfo> getCTInfoList(String ctInfoStr) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        ArrayList<ClusterInfo> clusterInfoList = new ArrayList<ClusterInfo>();
        try {
            if (StringUtils.isNotEmpty((String)ctInfoStr)) {
                CtInfo ctInfo = (CtInfo)mapper.readValue(ctInfoStr, CtInfo.class);
                List ctInfoItemList = ctInfo.getCtInfoItemList();
                for (CtInfoItem ct : ctInfoItemList) {
                    clusterInfoList.add(new ClusterInfo(ct.getName(), ct.getType(), this.getKubeConfigPath(ct)));
                }
            }
        }
        catch (Exception e) {
            logger.error("Transfer CT info failed.", (Throwable)e);
        }
        return clusterInfoList;
    }

    private String getKubeConfigPath(CtInfoItem ct) {
        if (ClusterType.EXTERNAL.getVal().equals(ct.getType())) {
            return "/opt/ssl/cms-ct-ssl" + File.separator + ct.getName() + ".cms_common_kubeconfig";
        }
        return null;
    }
}

