/*
 * Decompiled with CFR 0.152.
 */
package com.mediakind.ctmanager.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mediakind.cms.service.api.kube.exception.KubeOperationException;
import com.mediakind.cms.service.api.kube.helper.ClusterType;
import com.mediakind.cms.service.api.kube.helper.KubeResEnum;
import com.mediakind.cms.service.api.kube.service.impl.KubeConfigMapService;
import com.mediakind.cms.service.api.kube.service.impl.KubeEndpointsService;
import com.mediakind.cms.service.api.kube.service.impl.KubeSecretService;
import com.mediakind.cms.service.api.kube.service.impl.KubeServiceService;
import com.mediakind.cms.service.api.kube.utils.KubeClientUtil;
import com.mediakind.ctmanager.model.dto.CTBaseInfo;
import com.mediakind.ctmanager.model.dto.CTCertInfo;
import com.mediakind.ctmanager.model.dto.CTKubeInfo;
import com.mediakind.ctmanager.model.dto.CTRedisInfo;
import com.mediakind.ctmanager.model.dto.RegCtInfo;
import com.mediakind.ctmanager.model.po.CtInfo;
import com.mediakind.ctmanager.model.po.CtInfoItem;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.models.V1ConfigMap;
import io.kubernetes.client.util.ClientBuilder;
import io.kubernetes.client.util.KubeConfig;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;
import org.yaml.snakeyaml.Yaml;

@Service
public class RegistrationService {
    private static final String NAMESPACE_NAME = KubeClientUtil.getNamespace();
    private static final String CONFIGMAP_NAME_CMS_CT_INFO = "cms-ct-info";
    private static final String CONFIGMAP_KEY_CMS_CT_INFO_JSON = "cms-ct-info.json";
    private KubeConfigMapService configMapService;
    private KubeSecretService secretService;
    private KubeServiceService serviceService;
    private KubeEndpointsService endpointsService;

    public RegistrationService() throws IOException {
        ApiClient apiClient = this.getProdClient();
        this.configMapService = new KubeConfigMapService(apiClient);
        this.secretService = new KubeSecretService(apiClient);
        this.serviceService = new KubeServiceService(apiClient);
        this.endpointsService = new KubeEndpointsService(apiClient);
    }

    public ApiClient getProdClient() throws IOException {
        return KubeClientUtil.getLocalClient();
    }

    public ApiClient getDevClient() throws IOException {
        return ClientBuilder.kubeconfig((KubeConfig)KubeConfig.loadKubeConfig((Reader)new FileReader(this.getClass().getClassLoader().getResource("dev-test-kube-config").getFile()))).build();
    }

    public void registerCluster(RegCtInfo regCtInfo) throws IOException, KubeOperationException {
        CTBaseInfo baseInfo = regCtInfo.getCtBaseInfo();
        CTCertInfo certInfo = regCtInfo.getCtCertInfo();
        CTKubeInfo kubeInfo = regCtInfo.getCtKubeInfo();
        CTRedisInfo redisInfo = regCtInfo.getCtRedisInfo();
        this.updateCtInfoConfigMap(baseInfo);
        this.createOrUpdateEndpointAndService(baseInfo, redisInfo);
        this.updateCmsCtSslSecret(baseInfo, certInfo, kubeInfo);
        this.updateHaproxyConfig(regCtInfo);
        this.updateLogstashInputPipline(regCtInfo);
    }

    public void updateCtInfoConfigMap(CTBaseInfo ctBaseInfo) throws IOException, KubeOperationException {
        V1ConfigMap configMap = this.configMapService.read(CONFIGMAP_NAME_CMS_CT_INFO, NAMESPACE_NAME);
        Map configMapData = configMap.getData();
        String value = (String)configMapData.get(CONFIGMAP_KEY_CMS_CT_INFO_JSON);
        value = this.rebuildCtInfoJson(value, ctBaseInfo);
        configMapData.put(CONFIGMAP_KEY_CMS_CT_INFO_JSON, value);
        configMap.setData(configMapData);
        this.configMapService.replace((Object)configMap);
    }

    private String rebuildCtInfoJson(String ctInfoJson, CTBaseInfo ctBaseInfo) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        CtInfo ctInfo = StringUtils.isNotEmpty((String)ctInfoJson) ? (CtInfo)mapper.readValue(ctInfoJson, CtInfo.class) : new CtInfo();
        String clusterName = ctBaseInfo.getClusterName();
        List itemList = ctInfo.getCtInfoItemList();
        boolean createItem = true;
        for (CtInfoItem item : itemList) {
            if (!clusterName.equals(item.getName())) continue;
            createItem = false;
            item.setType(ClusterType.EXTERNAL.getVal());
            item.setHost(ctBaseInfo.getHost());
            item.setIp(ctBaseInfo.getClusterVip());
            item.setPort(ctBaseInfo.getClusterPort());
            item.setDisplayName(ctBaseInfo.getDisplayName());
            break;
        }
        if (createItem) {
            CtInfoItem item = new CtInfoItem(ctBaseInfo.getClusterName(), ClusterType.EXTERNAL.getVal(), ctBaseInfo.getHost(), ctBaseInfo.getClusterVip(), ctBaseInfo.getClusterPort(), ctBaseInfo.getDisplayName());
            itemList.add(item);
        }
        ctInfoJson = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)ctInfo);
        return ctInfoJson;
    }

    public void createOrUpdateEndpointAndService(CTBaseInfo ctBaseInfo, CTRedisInfo redisInfo) throws KubeOperationException {
        String serviceYaml = this.buildHeadlessServices(ctBaseInfo, redisInfo);
        this.serviceService.createOrReset(serviceYaml);
        String endpointYaml = this.buildEndpointYaml(ctBaseInfo, redisInfo);
        this.endpointsService.createOrReplace(endpointYaml);
    }

    private String buildEndpointYaml(CTBaseInfo baseInfo, CTRedisInfo redisInfo) {
        String endpointName = baseInfo.getHost();
        String clusterVip = baseInfo.getClusterVip();
        String clusterPort = baseInfo.getClusterPort();
        Integer redisPort = redisInfo.getRedisPort();
        return "kind: " + KubeResEnum.ENDPOINTS.getVal() + "\nmetadata:\n  name: " + endpointName + "\n  namespace: " + NAMESPACE_NAME + "\nsubsets:\n  - addresses:\n      - ip: " + clusterVip + "\n    ports:\n      - name: https\n        port: " + clusterPort + "\n        protocol: TCP\n      - name: redis\n        port: " + redisPort + "\n        protocol: TCP";
    }

    private String buildHeadlessServices(CTBaseInfo baseInfo, CTRedisInfo redisInfo) {
        String serviceName = baseInfo.getHost();
        String clusterPort = baseInfo.getClusterPort();
        Integer redisPort = redisInfo.getRedisPort();
        return "kind: " + KubeResEnum.SERVICE.getVal() + "\nmetadata:\n  name: " + serviceName + "\n  namespace: " + NAMESPACE_NAME + "\nspec:\n  ports:\n    - name: https\n      protocol: TCP\n      port: " + clusterPort + "\n      targetPort: " + clusterPort + "\n    - name: redis\n      protocol: TCP\n      port: " + redisPort + "\n      targetPort: " + redisPort + "\n  clusterIP: None\n";
    }

    public void updateCmsCtSslSecret(CTBaseInfo baseInfo, CTCertInfo ctCertInfo, CTKubeInfo kubeInfo) throws KubeOperationException {
        List patcherList = this.buildSecretPatcherList(baseInfo, ctCertInfo, kubeInfo);
        String name = "cms-ct-ssl";
        this.secretService.patch(name, NAMESPACE_NAME, patcherList);
    }

    private List<String> buildSecretPatcherList(CTBaseInfo baseInfo, CTCertInfo ctCertInfo, CTKubeInfo kubeInfo) {
        String clusterName = baseInfo.getClusterName();
        HashMap<String, String> secretsMap = new HashMap<String, String>();
        secretsMap.put("client.pem", ctCertInfo.getClientPem());
        secretsMap.put("haproxy.pem", ctCertInfo.getHaproxyPem());
        secretsMap.put("client_auth_keystorejks", ctCertInfo.getClientAuthKeystorejks());
        secretsMap.put("cms_fingerprint", ctCertInfo.getCmsFingerprint());
        secretsMap.put("cms_truststorejks", ctCertInfo.getCmsTruststorejks());
        secretsMap.put("keystorepass", ctCertInfo.getKeystorepass());
        secretsMap.put("cms_common_kubeconfig", kubeInfo.getCmsCommonKubeconfig());
        ArrayList<String> patcherList = new ArrayList<String>();
        secretsMap.forEach((key, value) -> patcherList.add(String.format("{\"op\": \"replace\", \"path\": \"/data/%s.%s\", \"value\":\"%s\"}", clusterName, key, value)));
        return patcherList;
    }

    public void updateHaproxyConfig(RegCtInfo regCtInfo) throws JsonProcessingException, KubeOperationException {
        this.updateGlobalAclInConfigMap();
        this.createCtInfoBackend(regCtInfo);
        this.createCtInfoFrontend(regCtInfo);
    }

    private void updateGlobalAclInConfigMap() throws JsonProcessingException, KubeOperationException {
        String ctAclConfigName;
        V1ConfigMap ctAclConfigMap;
        V1ConfigMap configMap = this.configMapService.read(CONFIGMAP_NAME_CMS_CT_INFO, NAMESPACE_NAME);
        Map configMapData = configMap.getData();
        String ctInfoJson = (String)configMapData.get(CONFIGMAP_KEY_CMS_CT_INFO_JSON);
        String onlySingleLocal = "always_false";
        String onlySingleExternal = "always_false";
        if (StringUtils.isNotEmpty((String)ctInfoJson)) {
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            CtInfo ctInfo = (CtInfo)mapper.readValue(ctInfoJson, CtInfo.class);
            List itemList = ctInfo.getCtInfoItemList();
            if (itemList.size() == 1) {
                String type = ((CtInfoItem)itemList.get(0)).getType();
                if (ClusterType.LOCAL.getVal().equalsIgnoreCase(type)) {
                    onlySingleLocal = "always_true";
                } else if (ClusterType.EXTERNAL.getVal().equalsIgnoreCase(type)) {
                    onlySingleExternal = "always_true";
                }
            }
        }
        if ((ctAclConfigMap = this.configMapService.read(ctAclConfigName = "cms-ct-acl-configmap", NAMESPACE_NAME)) != null) {
            Map dataMap = ctAclConfigMap.getData();
            String aclStr = "acl single_ct_and_is_local " + onlySingleLocal + "\n        acl single_ct_and_is_external " + onlySingleExternal;
            dataMap.put("globalCtAcl", aclStr);
            ctAclConfigMap.setData(dataMap);
            this.configMapService.replace((Object)ctAclConfigMap);
        }
    }

    private void createCtInfoFrontend(RegCtInfo regCtInfo) throws KubeOperationException {
        String frontendYaml = this.buildCtInfoFrontendConfigMap(regCtInfo);
        this.configMapService.createOrReplace(frontendYaml);
    }

    private String buildCtInfoFrontendConfigMap(RegCtInfo regCtInfo) {
        CTBaseInfo baseInfo = regCtInfo.getCtBaseInfo();
        String clusterName = baseInfo.getClusterName();
        String label = "ext-ct-frontend";
        String locationParam = "ct-location";
        return "kind: " + KubeResEnum.CONFIGMAP.getVal() + "\nmetadata:\n  labels:\n    cm: " + label + "\n  name: " + clusterName + "-frontend\n  namespace: " + NAMESPACE_NAME + "\ndata:\n  frontend: |-\n    acl acl-" + clusterName + " urlp(" + locationParam + ") " + clusterName + "\n            use_backend " + clusterName + "-backend if content_access_url acl-" + clusterName + "\n            use_backend " + clusterName + "-backend if fileuploader_url acl-" + clusterName + "\n            use_backend " + clusterName + "-backend if content_access_url single_ct_and_is_external\n            use_backend " + clusterName + "-backend if fileuploader_url single_ct_and_is_external";
    }

    private void createCtInfoBackend(RegCtInfo regCtInfo) throws KubeOperationException {
        String backendYaml = this.buildCtInfoBackendConfigMap(regCtInfo);
        this.configMapService.createOrReplace(backendYaml);
    }

    private String buildCtInfoBackendConfigMap(RegCtInfo regCtInfo) {
        CTBaseInfo baseInfo = regCtInfo.getCtBaseInfo();
        String clusterName = baseInfo.getClusterName();
        String host = baseInfo.getHost();
        String port = baseInfo.getClusterPort();
        String kind = KubeResEnum.CONFIGMAP.getVal();
        String label = "ext-ct-backend";
        String ctLocationName = "ct-location";
        return "kind: " + kind + "\nmetadata:\n  labels:\n    cm: " + label + "\n  name: " + clusterName + "-backend\n  namespace: " + NAMESPACE_NAME + "\ndata:\n  backend: |\n    backend " + clusterName + "-backend\n      mode http\n        option forwardfor\n        http-request replace-uri ([^/:]*://[^?]*)?([^&]*)([&]?)" + ctLocationName + "=[^&]*(.*) \\1\\2\\3\\4\n        server ext-server-" + clusterName + " " + host + ":" + port + " ssl crt /usr/local/etc/haproxy/ct-ssl/" + clusterName + ".client.pem ca-file /usr/local/etc/haproxy/ct-ssl/" + clusterName + ".haproxy.pem verify required check inter 5s";
    }

    public void updateLogstashInputPipline(RegCtInfo regCtInfo) throws KubeOperationException {
        String key;
        String host = regCtInfo.getCtBaseInfo().getHost();
        String password = regCtInfo.getCtRedisInfo().getRedisPassword();
        Integer port = regCtInfo.getCtRedisInfo().getRedisPort();
        String name = "cms-logstash-redis-input-pipeline";
        V1ConfigMap configMap = this.configMapService.read(name, NAMESPACE_NAME);
        Map configMapData = configMap.getData();
        String redisInputData = (String)configMapData.get(key = "redis-input.conf");
        Map dataMap = this.convertRedisInputToMap(redisInputData);
        ArrayList inputList = (ArrayList)dataMap.get("input");
        if (inputList == null) {
            inputList = new ArrayList();
        }
        Iterator iterator = inputList.iterator();
        while (iterator.hasNext()) {
            Map inputItem = (Map)iterator.next();
            if (!host.equals(inputItem.get("host"))) continue;
            iterator.remove();
        }
        LinkedHashMap<String, Object> newItem = new LinkedHashMap<String, Object>();
        newItem.put("host", host);
        newItem.put("port", port);
        newItem.put("data_type", "list");
        newItem.put("password", password);
        newItem.put("key", "logstash");
        newItem.put("threads", 5);
        inputList.add(newItem);
        dataMap.put("input", inputList);
        String resConf = this.convertRedisInputToOriginalFormat(dataMap);
        resConf = StringEscapeUtils.escapeJavaScript((String)resConf);
        List<String> patcherList = Arrays.asList(String.format("{\"op\":\"replace\",\"path\":\"/data/%s\",\"value\":\"%s\"}", key, resConf));
        this.configMapService.patch(name, NAMESPACE_NAME, patcherList);
    }

    private Map<String, List<Map<String, Object>>> convertRedisInputToMap(String conf) {
        conf = conf.replaceAll("(^[\\w]+)[\\s]*\\{", "$1:");
        conf = conf.replaceAll("([\\w]+)[\\s]*\\{", "- $1:");
        conf = conf.replace("=>", ":");
        conf = conf.replace("}", "");
        return (Map)new Yaml().load(conf);
    }

    private String convertRedisInputToOriginalFormat(Map<String, List<Map<String, Object>>> map) {
        List<Map<String, Object>> list = map.get("input");
        return list.stream().map(item -> String.format("  redis {\n    host        =>    \"%s\"\n    port        =>    \"%s\"\n    data_type   =>    \"%s\"\n    password    =>    \"%s\"\n    key         =>    \"%s\"\n    threads     =>    \"%s\"\n  }\n", item.get("host"), item.get("port"), item.get("data_type"), item.get("password"), item.get("key"), item.get("threads"))).collect(Collectors.joining("", "input {\n", "}"));
    }
}

