/*
 * Decompiled with CFR 0.152.
 */
package com.mediakind.ctmanager.handler;

import com.mediakind.ctmanager.service.KubeResMonitorService;
import com.mediakind.ctmanager.service.WfsResourceSyncService;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class ApplicationStartupListener
implements ApplicationListener<ApplicationReadyEvent> {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationStartupListener.class);
    @Autowired
    private KubeResMonitorService monitorService;
    @Autowired
    private WfsResourceSyncService wfsResourceSyncService;

    public void onApplicationEvent(ApplicationReadyEvent event) {
        logger.info("CT manager is ready, to do a resource full sync.");
        try {
            this.wfsResourceSyncService.syncFullResourcesWithUpdate();
            logger.info("Resource full sync completed while CT manager startup.");
        }
        catch (Exception e) {
            logger.error("Workflow resources full sync failed while CT manager start up.", (Throwable)e);
        }
        logger.info("CT manager is ready, to monitor Deployments and ConfigMaps.");
        try {
            this.monitorService.startKubeResourceMonitor();
            logger.info("Deployments and ConfigMaps monitored success.");
        }
        catch (IOException e) {
            logger.error("Start Kubernetes resource monitor failed.", (Throwable)e);
        }
    }
}

