/*
 * Decompiled with CFR 0.152.
 */
package com.mediakind.ctmanager.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mediakind.cms.service.api.kube.exception.KubeOperationException;
import com.mediakind.cms.service.api.kube.helper.ClusterInfo;
import com.mediakind.cms.service.api.kube.service.impl.KubeDeploymentService;
import com.mediakind.cms.service.api.kube.utils.KubeClientUtil;
import com.mediakind.ctmanager.constant.AppConstants;
import com.mediakind.ctmanager.model.po.CtResourceInfoItem;
import com.mediakind.ctmanager.model.po.ResourceListRespItem;
import com.mediakind.ctmanager.model.po.ResourceResp;
import com.mediakind.ctmanager.model.po.ResourceRespGroupItem;
import com.mediakind.ctmanager.service.CTInfoService;
import com.mediakind.ctmanager.service.CTResourceInfoService;
import com.mediakind.ctmanager.service.WfsHealthService;
import com.mediakind.ctmanager.service.WfsResourceService;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.models.V1Deployment;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class WfsResourceSyncService {
    private static final Logger logger = LoggerFactory.getLogger(WfsResourceSyncService.class);
    @Autowired
    private WfsResourceService resourceService;
    @Autowired
    private CTResourceInfoService ctResourceInfoService;
    @Autowired
    private CTInfoService ctInfoService;
    @Autowired
    private WfsHealthService wfsHealthService;

    public synchronized void syncFullResourcesWithUpdate() {
        this.syncFullResources(true);
    }

    public synchronized void syncFullResources() {
        this.syncFullResources(false);
    }

    private synchronized void syncFullResources(boolean needDoUpdate) {
        if (this.wfsHealthService.isDown()) {
            logger.error("Workflow service is down, skip this full sync.");
            AppConstants.NEED_TO_TRIGGER_SYNC_FLAG = true;
            return;
        }
        List ctInfoList = this.ctInfoService.getCTInfoList();
        for (ClusterInfo cluster : ctInfoList) {
            ApiClient apiClient;
            String clusterName = cluster.getName();
            try {
                apiClient = KubeClientUtil.getClient((ClusterInfo)cluster);
            }
            catch (IOException e) {
                logger.error(String.format("Sync cluster %s failed for instance ApiClient", clusterName), (Throwable)e);
                continue;
            }
            apiClient.setHttpClient(apiClient.getHttpClient().newBuilder().readTimeout(0L, TimeUnit.SECONDS).build());
            KubeDeploymentService depService = new KubeDeploymentService(apiClient);
            Set deploymentSet = this.ctResourceInfoService.getDistinctDeployments();
            for (String deploymentName : deploymentSet) {
                try {
                    this.syncSpecificDeployment(needDoUpdate, depService, clusterName, deploymentName);
                }
                catch (KubeOperationException e) {
                    logger.error(String.format("Sync cluster %s deployment %s failed.", clusterName, deploymentName), (Throwable)e);
                }
            }
        }
    }

    public synchronized void syncSpecificResource(ClusterInfo ct, String deploymentName) {
        if (this.wfsHealthService.isDown()) {
            logger.error("Workflow service is down, skip this specific sync, deployment={}.", (Object)deploymentName);
            AppConstants.NEED_TO_TRIGGER_SYNC_FLAG = true;
            return;
        }
        String clusterName = ct.getName();
        logger.info("Start to sync specific resource. cluster {} deployment {}", (Object)clusterName, (Object)deploymentName);
        try {
            KubeDeploymentService service = new KubeDeploymentService(KubeClientUtil.getClient((ClusterInfo)ct));
            this.syncSpecificDeployment(false, service, clusterName, deploymentName);
        }
        catch (Exception e) {
            logger.error(String.format("Sync cluster %s deployment %s failed.", clusterName, deploymentName), (Throwable)e);
        }
    }

    private synchronized void syncSpecificDeployment(boolean needDoUpdate, KubeDeploymentService service, String clusterName, String deploymentName) throws KubeOperationException {
        V1Deployment deployment = service.read(deploymentName, KubeClientUtil.getNamespace());
        Integer replica = 0;
        if (deployment != null && deployment.getSpec() != null) {
            replica = deployment.getSpec().getReplicas();
        }
        List resInfoList = this.ctResourceInfoService.getCTResourceInfoListByDeployment(deploymentName);
        for (CtResourceInfoItem resourceInfo : resInfoList) {
            Integer resourceCount;
            String resPrefix = this.ctResourceInfoService.getResourceNamePattern(resourceInfo.getNamePrefix(), clusterName);
            try {
                resourceCount = this.resourceService.countResourceByPattern(resPrefix);
            }
            catch (Exception e) {
                logger.error("Get resource count failed.", (Throwable)e);
                continue;
            }
            if (needDoUpdate) {
                this.updateExistResource(resPrefix, replica.intValue(), resourceCount.intValue(), resourceInfo);
            }
            if (replica > resourceCount) {
                logger.info("To create some resources. replica={}, resourceCount={}, clusterName={}, resPrefix={}", new Object[]{replica, resourceCount, clusterName, resPrefix});
                this.createSomeResources(replica, resourceCount, clusterName, resPrefix, resourceInfo);
                continue;
            }
            if (replica >= resourceCount) continue;
            logger.info("To delete extra resources. replica={}, resourceCount={}, resPrefix={}", new Object[]{replica, resourceCount, resPrefix});
            this.deleteSomeResources(replica, resourceCount, resPrefix);
        }
    }

    private int getExistResourceMaxNum(int replica, int resourceCount) {
        int currentExistResourceNum = replica > resourceCount ? resourceCount : (replica < resourceCount ? replica : resourceCount);
        return currentExistResourceNum;
    }

    private void updateExistResource(String resPrefix, int replica, int resourceCount, CtResourceInfoItem resourceInfo) {
        logger.info("Start to update exist resources. resPrefix={}, replica={}, resourceCount={}", new Object[]{resPrefix, replica, resourceCount});
        int currentExistResourceNum = this.getExistResourceMaxNum(replica, resourceCount);
        for (int i = 1; i <= currentExistResourceNum; ++i) {
            ResourceListRespItem res;
            String resourceName = resPrefix + i;
            logger.info("To update resource {}.", (Object)resourceName);
            try {
                res = this.resourceService.getResourceByName(resourceName);
            }
            catch (Exception e) {
                logger.error("Get resource by name failed.", (Throwable)e);
                continue;
            }
            ResourceResp resourceResp = null;
            if (res != null) {
                int resourceId = res.getId();
                try {
                    resourceResp = this.resourceService.getResourceById(Integer.valueOf(resourceId));
                }
                catch (Exception e) {
                    logger.error(String.format("Get resource by Id %d failed.", resourceId), (Throwable)e);
                    continue;
                }
            }
            if (resourceResp == null) continue;
            String preConnectionString = resourceResp.getConnectionString();
            Integer preHeartbeatFrequency = resourceResp.getHeartbeatFrequency();
            Integer preMaxConcurrentUsage = resourceResp.getMaxConcurrentUsage();
            Boolean preIgnoreTimeout = resourceResp.getIgnoreTimeout();
            HashSet<String> preResourceGroupsSet = new HashSet<String>();
            List preResourceGroups = resourceResp.getResourceGroups();
            if (preResourceGroups != null) {
                for (ResourceRespGroupItem item : preResourceGroups) {
                    preResourceGroupsSet.add(item.getName());
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Resource previous info, ConnectionString={}, HeartbeatFrequency={},MaxConcurrentUsage={},IgnoreTimeout={},GroupSet={}", new Object[]{preConnectionString, preHeartbeatFrequency, preMaxConcurrentUsage, preIgnoreTimeout, preResourceGroupsSet});
            }
            String newConnectionString = WfsResourceSyncService.replaceParameter((String)preConnectionString, (String)"deployment", (String)resourceInfo.getDeployment());
            Integer newHeartbeatFrequency = resourceInfo.getHeartbeatFrequency();
            Integer newMaxConcurrentUsage = resourceInfo.getMaxConcurrentUsage();
            Boolean newIgnoreTimeout = resourceInfo.getIgnoreTimeout();
            HashSet<String> newResourceGroupsSet = new HashSet<String>();
            ArrayList<ResourceRespGroupItem> newGroupList = new ArrayList<ResourceRespGroupItem>();
            if (resourceInfo.getGroup() != null) {
                for (String groupName : resourceInfo.getGroup()) {
                    ResourceRespGroupItem group = new ResourceRespGroupItem();
                    group.setName(groupName);
                    newGroupList.add(group);
                    newResourceGroupsSet.add(groupName);
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Resource current info, ConnectionString={}, HeartbeatFrequency={},MaxConcurrentUsage={},IgnoreTimeout={},GroupSet={}", new Object[]{newConnectionString, newHeartbeatFrequency, newMaxConcurrentUsage, newIgnoreTimeout, newResourceGroupsSet});
            }
            if (newConnectionString.equals(preConnectionString) && newHeartbeatFrequency.equals(preHeartbeatFrequency) && newMaxConcurrentUsage.equals(preMaxConcurrentUsage) && newIgnoreTimeout.equals(preIgnoreTimeout) && WfsResourceSyncService.setIsEquals(newResourceGroupsSet, preResourceGroupsSet)) {
                logger.info("Resource {} unchanged, skip to update it.", (Object)resourceName);
                continue;
            }
            resourceResp.setResourceGroups(newGroupList);
            resourceResp.setConnectionString(newConnectionString);
            resourceResp.setHeartbeatConnectionString(newConnectionString);
            resourceResp.setHeartbeatFrequency(newHeartbeatFrequency);
            resourceResp.setMaxConcurrentUsage(newMaxConcurrentUsage);
            resourceResp.setIgnoreTimeout(newIgnoreTimeout);
            ObjectMapper mapper = new ObjectMapper();
            try {
                String requestJson = mapper.writeValueAsString((Object)resourceResp);
                if (logger.isDebugEnabled()) {
                    logger.debug("Update resources request json: {}", (Object)requestJson);
                }
                this.resourceService.updateResource(resourceName, resourceResp.getId(), requestJson);
                continue;
            }
            catch (JsonProcessingException e) {
                logger.error("Java Object to Json failed while update exist resources.", (Throwable)e);
            }
        }
    }

    private static boolean setIsEquals(Set<?> set1, Set<?> set2) {
        if (set1.size() != set2.size()) {
            return false;
        }
        return set1.containsAll(set2);
    }

    private static String replaceParameter(String url, String paramName, String paramValue) {
        return url.replaceAll("(" + paramName + "=[^&]*)", paramName + "=" + paramValue);
    }

    private void createSomeResources(Integer replica, Integer resourceCount, String clusterName, String namePrefix, CtResourceInfoItem item) {
        logger.info("To create resource");
        for (int i = resourceCount + 1; i <= replica; ++i) {
            String connectionString;
            String resourceName = namePrefix + i;
            try {
                connectionString = this.getResourceURL(clusterName, item, i);
            }
            catch (Exception e) {
                logger.error("Get resource URL failed.", (Throwable)e);
                continue;
            }
            String heartbeatConnectionString = connectionString;
            JsonObject requestJson = new JsonObject();
            requestJson.addProperty("resourceTypeName", item.getResourceType());
            requestJson.addProperty("adminState", "Online");
            requestJson.addProperty("name", resourceName);
            requestJson.addProperty("connectionString", connectionString);
            requestJson.addProperty("heartbeatConnectionString", heartbeatConnectionString);
            requestJson.addProperty("heartbeatFrequency", (Number)item.getHeartbeatFrequency());
            requestJson.addProperty("maxConcurrentUsage", (Number)item.getMaxConcurrentUsage());
            requestJson.addProperty("ignoreTimeout", item.getIgnoreTimeout());
            JsonArray groupArray = new JsonArray();
            List groupList = item.getGroup();
            for (String group : groupList) {
                JsonObject groupObj = new JsonObject();
                groupObj.addProperty("name", group);
                groupArray.add((JsonElement)groupObj);
            }
            requestJson.add("resourceGroups", (JsonElement)groupArray);
            if (logger.isDebugEnabled()) {
                logger.debug("Create resources request json: {}", (Object)requestJson);
            }
            logger.info("To create resource {}", (Object)resourceName);
            this.resourceService.createResource(resourceName, requestJson.toString());
        }
    }

    private String getResourceURL(String clusterName, CtResourceInfoItem item, int number) throws Exception {
        String resourceTypeName = item.getResourceType();
        String baseUrl = (String)AppConstants.WFS_RESOURCE_BASEURL_MAP.get(resourceTypeName);
        if (StringUtils.isEmpty((String)baseUrl)) {
            throw new Exception(String.format("Non-supported resourceType %s", resourceTypeName));
        }
        StringBuilder url = new StringBuilder(baseUrl);
        url.append("?ct-location=");
        url.append(clusterName);
        url.append("&deployment=");
        url.append(item.getDeployment());
        url.append("&server=server");
        url.append(number);
        url.append("&name-prefix=");
        url.append(item.getNamePrefix());
        return url.toString();
    }

    private void deleteSomeResources(Integer replica, Integer resourceCount, String namePrefix) {
        logger.info("To delete extra resources.");
        for (int i = resourceCount.intValue(); i > replica; --i) {
            ResourceListRespItem res;
            String resourceName = namePrefix + i;
            logger.info("To delete resource {}.", (Object)resourceName);
            try {
                res = this.resourceService.getResourceByName(resourceName);
            }
            catch (Exception e) {
                logger.error(String.format("Get resource by name %s failed.", resourceName), (Throwable)e);
                continue;
            }
            if (res == null) continue;
            this.resourceService.deleteResource(resourceName, res.getId());
        }
    }
}

