/*
 * Decompiled with CFR 0.152.
 */
package com.mediakind.ctregistration.controller;

import com.mediakind.ctregistration.model.dto.RegCtInfo;
import com.mediakind.ctregistration.service.ICtRegistrationService;
import java.util.HashMap;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class CtRegistrationController {
    private static Logger logger = LoggerFactory.getLogger(CtRegistrationController.class);
    @Autowired
    private ICtRegistrationService registrationService;

    @PutMapping(value={"/registration"})
    @ResponseBody
    public Object registration(@Valid @RequestBody RegCtInfo regCtInfo) {
        logger.info("External CT register begin");
        try {
            this.registrationService.registerCluster(regCtInfo);
        }
        catch (Exception e) {
            logger.error("External CT register failed", (Throwable)e);
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("status", HttpStatus.INTERNAL_SERVER_ERROR.value());
            result.put("errors", e.getMessage());
            return result;
        }
        logger.info("External CT register success");
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("status", HttpStatus.OK.value());
        result.put("message", "External CT cluster register success");
        return result;
    }
}

