/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.builder;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.zip.CRC32;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.api.tools.internal.builder.ApiAnalysisBuilder;
import org.eclipse.pde.api.tools.internal.builder.BuilderMessages;
import org.eclipse.pde.api.tools.internal.comparator.Delta;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.comparator.IDelta;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.build.IBuildModel;

public class BuildState {
    private static final IDelta[] EMPTY_DELTAS = new IDelta[0];
    private static final String[] NO_REEXPORTED_COMPONENTS = new String[0];
    private static final int VERSION = 32;
    private Map compatibleChanges = new HashMap();
    private Map breakingChanges = new HashMap();
    private Map manifestChanges = new HashMap();
    private Map buildPropChanges = new HashMap();
    private String[] reexportedComponents;
    private Set apiToolingDependentProjects;
    private long buildpathCRC = -1L;

    BuildState() {
    }

    public static BuildState read(DataInputStream in) throws IOException {
        String pluginID = in.readUTF();
        if (!pluginID.equals("org.eclipse.pde.api.tools")) {
            throw new IOException(BuilderMessages.build_wrongFileFormat);
        }
        String kind = in.readUTF();
        if (!kind.equals("STATE")) {
            throw new IOException(BuilderMessages.build_wrongFileFormat);
        }
        if (in.readInt() != 32) {
            return null;
        }
        if (in.readBoolean()) {
            BuildState state = new BuildState();
            state.buildpathCRC = in.readLong();
            int count = in.readInt();
            int i = 0;
            while (i < count) {
                state.addCompatibleChange(BuildState.readDelta(in));
                ++i;
            }
            count = in.readInt();
            i = 0;
            while (i < count) {
                state.addBreakingChange(BuildState.readDelta(in));
                ++i;
            }
            count = in.readInt();
            String[] components = new String[count];
            int i2 = 0;
            while (i2 < count) {
                components[i2] = in.readUTF();
                ++i2;
            }
            state.reexportedComponents = components;
            count = in.readInt();
            i2 = 0;
            while (i2 < count) {
                state.addApiToolingDependentProject(in.readUTF());
                ++i2;
            }
            if (in.available() > 0) {
                String value;
                String key;
                int i3;
                count = in.readInt();
                if (count > 0) {
                    HashMap<String, String> map = new HashMap<String, String>(count);
                    i3 = 0;
                    while (i3 < count) {
                        key = in.readUTF();
                        value = in.readUTF();
                        map.put(key, value);
                        ++i3;
                    }
                    state.setManifestState(map);
                }
                if ((count = in.readInt()) > 0) {
                    HashMap<String, String> map = new HashMap<String, String>(count);
                    i3 = 0;
                    while (i3 < count) {
                        key = in.readUTF();
                        value = in.readUTF();
                        map.put(key, value);
                        ++i3;
                    }
                    state.setBuildPropertiesState(map);
                }
            }
            return state;
        }
        return null;
    }

    public static void write(BuildState state, DataOutputStream out) throws IOException {
        out.writeUTF("org.eclipse.pde.api.tools");
        out.writeUTF("STATE");
        out.writeInt(32);
        out.writeBoolean(true);
        out.writeLong(state.buildpathCRC);
        IDelta[] compatibleChangesDeltas = state.getCompatibleChanges();
        int length = compatibleChangesDeltas.length;
        out.writeInt(length);
        int i = 0;
        while (i < length) {
            BuildState.writeDelta(compatibleChangesDeltas[i], out);
            ++i;
        }
        IDelta[] breakingChangesDeltas = state.getBreakingChanges();
        length = breakingChangesDeltas.length;
        out.writeInt(length);
        int i2 = 0;
        while (i2 < length) {
            BuildState.writeDelta(breakingChangesDeltas[i2], out);
            ++i2;
        }
        String[] reexportedComponents = state.getReexportedComponents();
        length = reexportedComponents.length;
        out.writeInt(length);
        int i3 = 0;
        while (i3 < length) {
            out.writeUTF(reexportedComponents[i3]);
            ++i3;
        }
        Set apiToolingDependentsProjects = state.getApiToolingDependentProjects();
        length = apiToolingDependentsProjects.size();
        out.writeInt(length);
        Iterator iterator = apiToolingDependentsProjects.iterator();
        while (iterator.hasNext()) {
            out.writeUTF((String)iterator.next());
        }
        Map map = state.getManifestState();
        out.writeInt(map.size());
        Map.Entry entry = null;
        Iterator i4 = map.entrySet().iterator();
        while (i4.hasNext()) {
            entry = i4.next();
            out.writeUTF((String)entry.getKey());
            out.writeUTF((String)entry.getValue());
        }
        map = state.getBuildPropertiesState();
        out.writeInt(map.size());
        entry = null;
        i4 = map.entrySet().iterator();
        while (i4.hasNext()) {
            entry = i4.next();
            out.writeUTF((String)entry.getKey());
            out.writeUTF((String)entry.getValue());
        }
    }

    private static IDelta readDelta(DataInputStream in) throws IOException {
        boolean hasComponentID = in.readBoolean();
        String componentID = null;
        if (hasComponentID) {
            in.readUTF();
        }
        int elementType = in.readInt();
        int kind = in.readInt();
        int flags = in.readInt();
        int restrictions = in.readInt();
        int modifiers = in.readInt();
        String typeName = in.readUTF();
        String key = in.readUTF();
        int length = in.readInt();
        String[] datas = null;
        if (length != 0) {
            ArrayList<String> arguments = new ArrayList<String>();
            int i = 0;
            while (i < length) {
                arguments.add(in.readUTF());
                ++i;
            }
            datas = new String[length];
            arguments.toArray(datas);
        } else {
            datas = new String[]{typeName.replace('$', '.')};
        }
        int oldModifiers = modifiers & 0xFFFF;
        int newModifiers = modifiers >>> 16;
        int previousRestrictions = restrictions >>> 16;
        int currentRestrictions = restrictions & 0xFFFF;
        return new Delta(componentID, elementType, kind, flags, currentRestrictions, previousRestrictions, oldModifiers, newModifiers, typeName, key, datas);
    }

    private static void writeDelta(IDelta delta, DataOutputStream out) throws IOException {
        String apiComponentID = delta.getComponentVersionId();
        boolean hasComponentID = apiComponentID != null;
        out.writeBoolean(hasComponentID);
        if (hasComponentID) {
            out.writeUTF(apiComponentID);
        }
        out.writeInt(delta.getElementType());
        out.writeInt(delta.getKind());
        out.writeInt(delta.getFlags());
        out.writeInt(delta.getCurrentRestrictions());
        int modifiers = delta.getNewModifiers() << 16 | delta.getOldModifiers();
        out.writeInt(modifiers);
        out.writeUTF(delta.getTypeName());
        out.writeUTF(delta.getKey());
        String[] arguments = delta.getArguments();
        int length = arguments.length;
        out.writeInt(length);
        int i = 0;
        while (i < length) {
            out.writeUTF(arguments[i]);
            ++i;
        }
    }

    public void addCompatibleChange(IDelta delta) {
        String typeName = delta.getTypeName();
        Set object = (Set)this.compatibleChanges.get(typeName);
        if (object == null) {
            HashSet<IDelta> changes = new HashSet<IDelta>();
            changes.add(delta);
            this.compatibleChanges.put(typeName, changes);
        } else {
            object.add(delta);
        }
    }

    public void addBreakingChange(IDelta delta) {
        String typeName = delta.getTypeName();
        Set object = (Set)this.breakingChanges.get(typeName);
        if (object == null) {
            HashSet<IDelta> changes = new HashSet<IDelta>();
            changes.add(delta);
            this.breakingChanges.put(typeName, changes);
        } else {
            object.add(delta);
        }
    }

    public IDelta[] getBreakingChanges() {
        if (this.breakingChanges == null || this.breakingChanges.size() == 0) {
            return EMPTY_DELTAS;
        }
        HashSet collector = new HashSet();
        Collection values = this.breakingChanges.values();
        Iterator iterator = values.iterator();
        while (iterator.hasNext()) {
            collector.addAll((HashSet)iterator.next());
        }
        return collector.toArray(new IDelta[collector.size()]);
    }

    public IDelta[] getCompatibleChanges() {
        if (this.compatibleChanges == null || this.compatibleChanges.size() == 0) {
            return EMPTY_DELTAS;
        }
        HashSet collector = new HashSet();
        Collection values = this.compatibleChanges.values();
        Iterator iterator = values.iterator();
        while (iterator.hasNext()) {
            collector.addAll((HashSet)iterator.next());
        }
        return collector.toArray(new IDelta[collector.size()]);
    }

    public String[] getReexportedComponents() {
        if (this.reexportedComponents == null) {
            return NO_REEXPORTED_COMPONENTS;
        }
        return this.reexportedComponents;
    }

    public void cleanup(String typeName) {
        this.breakingChanges.remove(typeName);
        this.compatibleChanges.remove(typeName);
        this.reexportedComponents = null;
    }

    public void setReexportedComponents(IApiComponent[] components) {
        if (components == null) {
            return;
        }
        if (this.reexportedComponents == null) {
            int length = components.length;
            String[] result = new String[length];
            int i = 0;
            while (i < length) {
                result[i] = components[i].getSymbolicName();
                ++i;
            }
            this.reexportedComponents = result;
        }
    }

    public void addApiToolingDependentProject(String projectName) {
        if (this.apiToolingDependentProjects == null) {
            this.apiToolingDependentProjects = new HashSet(3);
        }
        this.apiToolingDependentProjects.add(projectName);
    }

    public Set getApiToolingDependentProjects() {
        return this.apiToolingDependentProjects == null ? Collections.EMPTY_SET : this.apiToolingDependentProjects;
    }

    public void setManifestState(Map state) {
        if (state != null) {
            HashMap compact = new HashMap(7);
            Iterator i = ApiAnalysisBuilder.IMPORTANT_HEADERS.iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                Object val = state.get(key);
                if (val == null) continue;
                compact.put(key, val);
            }
            this.manifestChanges = compact;
        } else {
            this.manifestChanges.clear();
        }
    }

    public Map getManifestState() {
        return this.manifestChanges;
    }

    public void setBuildPropertiesState(IBuildModel model) {
        if (model != null) {
            IBuildEntry[] entries = model.getBuild().getBuildEntries();
            String name = null;
            int i = 0;
            while (i < entries.length) {
                name = entries[i].getName();
                if ("custom".equals(name)) {
                    this.buildPropChanges.put("custom", Util.deepToString(entries[i].getTokens()));
                } else if (name.startsWith("source.")) {
                    this.buildPropChanges.put(name, Util.deepToString(entries[i].getTokens()));
                } else if (name.startsWith("extra.")) {
                    this.buildPropChanges.put(name, Util.deepToString(entries[i].getTokens()));
                }
                ++i;
            }
        } else {
            this.buildPropChanges.clear();
        }
    }

    void setBuildPropertiesState(Map map) {
        if (map != null) {
            this.buildPropChanges = map;
        } else {
            this.buildPropChanges.clear();
        }
    }

    public Map getBuildPropertiesState() {
        return this.buildPropChanges;
    }

    public long getBuildPathCRC() {
        return this.buildpathCRC;
    }

    public void setBuildPathCRC(long crc32) {
        this.buildpathCRC = crc32;
    }

    public static BuildState getLastBuiltState(IProject project) throws CoreException {
        if (!Util.isApiProject(project)) {
            return null;
        }
        return BuildState.readState(project);
    }

    static BuildState readState(IProject project) throws CoreException {
        File file = BuildState.getSerializationFile(project);
        if (file != null && file.exists()) {
            BuildState buildState;
            DataInputStream in;
            block10: {
                in = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
                try {
                    buildState = BuildState.read(in);
                    if (!ApiPlugin.DEBUG_BUILDER) break block10;
                    System.out.println("ApiAnalysisBuilder: Saved state thinks last build failed for " + project.getName());
                }
                catch (Throwable throwable) {
                    try {
                        if (ApiPlugin.DEBUG_BUILDER) {
                            System.out.println("ApiAnalysisBuilder: Saved state thinks last build failed for " + project.getName());
                        }
                        in.close();
                        throw throwable;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.core", 2, "Error reading last build state for project " + project.getName(), (Throwable)e));
                    }
                }
            }
            in.close();
            return buildState;
        }
        if (ApiPlugin.DEBUG_BUILDER) {
            if (file == null) {
                System.out.println("ApiAnalysisBuilder: Project does not exist: " + project);
            } else {
                System.out.println("ApiAnalysisBuilder: Build state file " + file.getPath() + " does not exist");
            }
        }
        return null;
    }

    public static void setLastBuiltState(IProject project, BuildState state) throws CoreException {
        if (Util.isApiProject(project)) {
            if (state != null) {
                BuildState.saveBuiltState(project, state);
            } else {
                try {
                    File file = BuildState.getSerializationFile(project);
                    if (file != null && file.exists()) {
                        file.delete();
                    }
                }
                catch (SecurityException securityException) {}
            }
        }
    }

    static File getSerializationFile(IProject project) {
        if (!project.exists()) {
            return null;
        }
        IPath workingLocation = project.getWorkingLocation("org.eclipse.pde.api.tools");
        return workingLocation.append("state.dat").toFile();
    }

    static void saveBuiltState(IProject project, BuildState state) throws CoreException {
        File file;
        if (ApiPlugin.DEBUG_BUILDER) {
            System.out.println("ApiAnalysisBuilder: Saving build state for project: " + project.getName());
        }
        if ((file = BuildState.getSerializationFile(project)) == null) {
            return;
        }
        long t = 0L;
        if (ApiPlugin.DEBUG_BUILDER) {
            t = System.currentTimeMillis();
        }
        try {
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            try {
                BuildState.write(state, out);
            }
            finally {
                out.close();
            }
        }
        catch (RuntimeException e) {
            try {
                file.delete();
            }
            catch (SecurityException securityException) {}
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.api.tools", 2, NLS.bind((String)BuilderMessages.build_cannotSaveState, (Object)project.getName()), (Throwable)e));
        }
        catch (IOException e) {
            try {
                file.delete();
            }
            catch (SecurityException securityException) {}
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.api.tools", 2, NLS.bind((String)BuilderMessages.build_cannotSaveState, (Object)project.getName()), (Throwable)e));
        }
        if (ApiPlugin.DEBUG_BUILDER) {
            t = System.currentTimeMillis() - t;
            System.out.println(NLS.bind((String)BuilderMessages.build_saveStateComplete, (Object)String.valueOf(t)));
        }
    }

    public static long computeBuildPathCRC(IProject project) {
        IJavaProject jp = JavaCore.create((IProject)project);
        try {
            IClasspathEntry[] classpath = jp.getResolvedClasspath(true);
            CRC32 crc32 = new CRC32();
            int i = 0;
            while (i < classpath.length) {
                IClasspathEntry entry = classpath[i];
                crc32.update(entry.getPath().toPortableString().getBytes());
                ++i;
            }
            return crc32.getValue();
        }
        catch (JavaModelException javaModelException) {
            return -1L;
        }
    }
}

