/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.provisional.comparator;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.pde.api.tools.internal.comparator.ClassFileComparator;
import org.eclipse.pde.api.tools.internal.comparator.Delta;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.IApiAnnotations;
import org.eclipse.pde.api.tools.internal.provisional.IApiDescription;
import org.eclipse.pde.api.tools.internal.provisional.IRequiredComponentDescription;
import org.eclipse.pde.api.tools.internal.provisional.comparator.CompareApiScopeVisitor;
import org.eclipse.pde.api.tools.internal.provisional.comparator.DeltaVisitor;
import org.eclipse.pde.api.tools.internal.provisional.comparator.IDelta;
import org.eclipse.pde.api.tools.internal.provisional.model.ApiTypeContainerVisitor;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiScope;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiType;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeContainer;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeRoot;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.osgi.framework.Version;

public class ApiComparator {
    public static final IDelta NO_DELTA = new Delta();

    static IDelta checkBundleVersionChanges(IApiComponent apiComponent2, String id, String apiComponentVersion, String apiComponentVersion2) {
        Version version = null;
        try {
            version = new Version(apiComponentVersion);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        Version version2 = null;
        try {
            version2 = new Version(apiComponentVersion2);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        if (version != null && version2 != null) {
            if (version.getMajor() != version2.getMajor()) {
                return new Delta(Util.getDeltaComponentVersionsId(apiComponent2), 2, 2, 59, 0, 0, 0, 0, null, id, new String[]{id, apiComponentVersion, apiComponentVersion2});
            }
            if (version.getMinor() != version2.getMinor()) {
                return new Delta(Util.getDeltaComponentVersionsId(apiComponent2), 2, 2, 60, 0, 0, 0, 0, null, id, new String[]{id, apiComponentVersion, apiComponentVersion2});
            }
        }
        return null;
    }

    public static IDelta compare(IApiBaseline referenceBaseline, IApiBaseline baseline, int visibilityModifiers, boolean force, IProgressMonitor monitor) {
        SubMonitor localmonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        try {
            String id;
            IApiComponent apiComponent;
            if (referenceBaseline == null || baseline == null) {
                throw new IllegalArgumentException("None of the baselines must be null");
            }
            IApiComponent[] apiComponents = referenceBaseline.getApiComponents();
            IApiComponent[] apiComponents2 = baseline.getApiComponents();
            HashSet<String> apiComponentsIds = new HashSet<String>();
            Delta globalDelta = new Delta();
            int i = 0;
            int max = apiComponents.length;
            while (i < max) {
                Util.updateMonitor((IProgressMonitor)localmonitor);
                apiComponent = apiComponents[i];
                if (!apiComponent.isSystemComponent()) {
                    id = apiComponent.getSymbolicName();
                    IApiComponent apiComponent2 = baseline.getApiComponent(id);
                    IDelta delta = null;
                    if (apiComponent2 == null) {
                        delta = new Delta(null, 3, 3, 3, null, id, id);
                    } else {
                        apiComponentsIds.add(id);
                        String versionString = apiComponent.getVersion();
                        String versionString2 = apiComponent2.getVersion();
                        IDelta bundleVersionChangesDelta = ApiComparator.checkBundleVersionChanges(apiComponent2, id, versionString, versionString2);
                        if (bundleVersionChangesDelta != null) {
                            globalDelta.add(bundleVersionChangesDelta);
                        }
                        if (!versionString.equals(versionString2) || force) {
                            long time = System.currentTimeMillis();
                            try {
                                delta = ApiComparator.compare(apiComponent, apiComponent2, referenceBaseline, baseline, visibilityModifiers, (IProgressMonitor)localmonitor.newChild(1));
                            }
                            finally {
                                if (ApiPlugin.DEBUG_API_COMPARATOR) {
                                    System.out.println("Time spent for " + id + " " + versionString + " : " + (System.currentTimeMillis() - time) + "ms");
                                }
                            }
                        }
                    }
                    if (delta != null && delta != NO_DELTA) {
                        globalDelta.add(delta);
                    }
                }
                ++i;
            }
            Util.updateMonitor((IProgressMonitor)localmonitor, 1);
            i = 0;
            max = apiComponents2.length;
            while (i < max) {
                Util.updateMonitor((IProgressMonitor)localmonitor);
                apiComponent = apiComponents2[i];
                if (!apiComponent.isSystemComponent() && !apiComponentsIds.contains(id = apiComponent.getSymbolicName())) {
                    globalDelta.add(new Delta(null, 3, 1, 3, null, id, id));
                }
                ++i;
            }
            IDelta iDelta = globalDelta.isEmpty() ? NO_DELTA : globalDelta;
            return iDelta;
        }
        finally {
            localmonitor.done();
        }
    }

    public static IDelta compare(IApiComponent component, IApiBaseline referenceBaseline, int visibilityModifiers, boolean force, IProgressMonitor monitor) {
        SubMonitor localmonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        try {
            if (component == null) {
                throw new IllegalArgumentException("The composent cannot be null");
            }
            if (referenceBaseline == null) {
                throw new IllegalArgumentException("The reference baseline cannot be null");
            }
            Util.updateMonitor((IProgressMonitor)localmonitor, 1);
            IDelta delta = null;
            if (!component.isSystemComponent()) {
                String id = component.getSymbolicName();
                IApiComponent apiComponent2 = referenceBaseline.getApiComponent(id);
                if (apiComponent2 == null) {
                    delta = new Delta(null, 3, 1, 3, null, id, id);
                } else if (!component.getVersion().equals(apiComponent2.getVersion()) || force) {
                    long time = System.currentTimeMillis();
                    try {
                        delta = ApiComparator.compare(apiComponent2, component, visibilityModifiers, (IProgressMonitor)localmonitor.newChild(1));
                    }
                    finally {
                        if (ApiPlugin.DEBUG_API_COMPARATOR) {
                            System.out.println("Time spent for " + id + " " + component.getVersion() + " : " + (System.currentTimeMillis() - time) + "ms");
                        }
                    }
                }
                if (delta != null && delta != NO_DELTA) {
                    Delta delta2 = delta;
                    return delta2;
                }
            }
            IDelta iDelta = NO_DELTA;
            return iDelta;
        }
        finally {
            localmonitor.done();
        }
    }

    public static IDelta compare(IApiComponent referenceComponent, IApiComponent component2, IApiBaseline referenceBaseline, IApiBaseline baseline, int visibilityModifiers, IProgressMonitor monitor) {
        SubMonitor localmonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
        try {
            String currentEE;
            if (referenceComponent == null) {
                if (component2 == null) {
                    throw new IllegalArgumentException("Both components cannot be null");
                }
                Delta delta = new Delta(null, 3, 1, 3, null, component2.getSymbolicName(), Util.getComponentVersionsId(component2));
                return delta;
            }
            if (component2 == null) {
                String referenceComponentId = referenceComponent.getSymbolicName();
                Delta delta = new Delta(null, 3, 3, 3, null, referenceComponentId, Util.getComponentVersionsId(referenceComponent));
                return delta;
            }
            Util.updateMonitor((IProgressMonitor)localmonitor, 1);
            if (referenceBaseline == null || baseline == null) {
                throw new IllegalArgumentException("The baselines cannot be null");
            }
            String referenceComponentId = referenceComponent.getSymbolicName();
            Delta globalDelta = new Delta();
            Set referenceEEs = Util.convertAsSet(referenceComponent.getExecutionEnvironments());
            Set componentsEEs = Util.convertAsSet(component2.getExecutionEnvironments());
            Util.updateMonitor((IProgressMonitor)localmonitor, 1);
            Iterator iterator = referenceEEs.iterator();
            while (iterator.hasNext()) {
                Util.updateMonitor((IProgressMonitor)localmonitor);
                currentEE = (String)iterator.next();
                if (componentsEEs.remove(currentEE)) continue;
                globalDelta.add(new Delta(Util.getDeltaComponentVersionsId(referenceComponent), 2, 3, 13, 0, 0, 0, 0, null, referenceComponentId, new String[]{currentEE, Util.getComponentVersionsId(referenceComponent)}));
            }
            iterator = componentsEEs.iterator();
            while (iterator.hasNext()) {
                Util.updateMonitor((IProgressMonitor)localmonitor);
                currentEE = (String)iterator.next();
                globalDelta.add(new Delta(Util.getDeltaComponentVersionsId(referenceComponent), 2, 1, 13, 0, 0, 0, 0, null, referenceComponentId, new String[]{currentEE, Util.getComponentVersionsId(referenceComponent)}));
            }
            IDelta iDelta = ApiComparator.internalCompare(referenceComponent, component2, referenceBaseline, baseline, visibilityModifiers, globalDelta, (IProgressMonitor)localmonitor.newChild(1));
            return iDelta;
        }
        catch (CoreException coreException) {
            return null;
        }
        finally {
            localmonitor.done();
        }
    }

    public static IDelta compare(IApiComponent referenceComponent, IApiComponent component, int visibilityModifiers, IProgressMonitor monitor) {
        try {
            return ApiComparator.compare(referenceComponent, component, referenceComponent == null ? null : referenceComponent.getBaseline(), component.getBaseline(), visibilityModifiers, monitor);
        }
        catch (CoreException e) {
            ApiPlugin.log(e);
            return null;
        }
    }

    public static IDelta compare(IApiTypeRoot typeRoot2, IApiComponent component, IApiComponent component2, IApiComponent reexporter, IApiBaseline referenceBaseline, IApiBaseline baseline, int visibilityModifiers, IProgressMonitor monitor) {
        if (typeRoot2 == null) {
            throw new IllegalArgumentException("The given class file is null");
        }
        if (component == null || component2 == null) {
            throw new IllegalArgumentException("One of the given components is null");
        }
        if (referenceBaseline == null || baseline == null) {
            throw new IllegalArgumentException("One of the given baselines is null");
        }
        SubMonitor localmonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)6);
        try {
            IStatus status;
            IApiType typeDescriptor2 = typeRoot2.getStructure();
            if (typeDescriptor2.isMemberType() || typeDescriptor2.isAnonymous() || typeDescriptor2.isLocal()) {
                IDelta iDelta = NO_DELTA;
                return iDelta;
            }
            String typeName = typeRoot2.getTypeName();
            IApiTypeRoot typeRoot = null;
            String id = component.getSymbolicName();
            typeRoot = "org.eclipse.swt".equals(id) ? component.findTypeRoot(typeName) : component.findTypeRoot(typeName, id);
            IApiDescription apiDescription2 = component2.getApiDescription();
            IApiAnnotations elementDescription2 = apiDescription2.resolveAnnotations(typeDescriptor2.getHandle());
            int visibility = 0;
            if (elementDescription2 != null) {
                visibility = elementDescription2.getVisibility();
            }
            Util.updateMonitor((IProgressMonitor)localmonitor, 1);
            IApiDescription referenceApiDescription = component.getApiDescription();
            IApiAnnotations refElementDescription = referenceApiDescription.resolveAnnotations(typeDescriptor2.getHandle());
            int refVisibility = 0;
            if (refElementDescription != null) {
                refVisibility = refElementDescription.getVisibility();
            }
            Util.updateMonitor((IProgressMonitor)localmonitor, 1);
            String deltaComponentID = Util.getDeltaComponentVersionsId(component2);
            if (typeRoot == null) {
                if (Util.isAPI(visibility, typeDescriptor2)) {
                    Delta delta = new Delta(deltaComponentID, 2, 1, reexporter == null ? 46 : 70, elementDescription2 != null ? elementDescription2.getRestrictions() : 0, 0, 0, typeDescriptor2.getModifiers(), typeName, typeName, new String[]{typeName, Util.getComponentVersionsId(component2)});
                    return delta;
                }
                IDelta iDelta = NO_DELTA;
                return iDelta;
            }
            Util.updateMonitor((IProgressMonitor)localmonitor, 1);
            IApiType typeDescriptor = typeRoot.getStructure();
            if ((visibility & visibilityModifiers) == 0) {
                if ((refVisibility & visibilityModifiers) == 0) {
                    IDelta iDelta = NO_DELTA;
                    return iDelta;
                }
                if (Util.isAPI(refVisibility, typeDescriptor)) {
                    Delta delta = new Delta(deltaComponentID, 2, 3, 56, elementDescription2 != null ? elementDescription2.getRestrictions() : 0, 0, typeDescriptor.getModifiers(), typeDescriptor2.getModifiers(), typeName, typeName, new String[]{typeName, Util.getComponentVersionsId(component2)});
                    return delta;
                }
            } else if (!Util.isAPI(refVisibility, typeDescriptor) && Util.isAPI(visibility, typeDescriptor2)) {
                Delta delta = new Delta(deltaComponentID, 2, 1, 46, elementDescription2 != null ? elementDescription2.getRestrictions() : 0, 0, typeDescriptor.getModifiers(), typeDescriptor2.getModifiers(), typeName, typeName, new String[]{typeName, Util.getComponentVersionsId(component2)});
                return delta;
            }
            Util.updateMonitor((IProgressMonitor)localmonitor, 1);
            if (visibilityModifiers == 1 && (Util.isDefault(typeDescriptor2.getModifiers()) || Flags.isPrivate((int)typeDescriptor2.getModifiers()))) {
                if (Flags.isPublic((int)typeDescriptor.getModifiers()) || Flags.isProtected((int)typeDescriptor.getModifiers())) {
                    Delta delta = new Delta(deltaComponentID, 2, 3, 56, elementDescription2 != null ? elementDescription2.getRestrictions() : 0, 0, typeDescriptor.getModifiers(), typeDescriptor2.getModifiers(), typeName, typeName, new String[]{typeName, Util.getComponentVersionsId(component2)});
                    return delta;
                }
                IDelta iDelta = NO_DELTA;
                return iDelta;
            }
            Util.updateMonitor((IProgressMonitor)localmonitor, 1);
            ClassFileComparator comparator = new ClassFileComparator(typeDescriptor, typeRoot2, component, component2, referenceBaseline, baseline, visibilityModifiers);
            IDelta delta = comparator.getDelta((IProgressMonitor)localmonitor.newChild(1));
            if (ApiPlugin.DEBUG_API_COMPARATOR && (status = comparator.getStatus()) != null) {
                ApiPlugin.log(status);
            }
            IDelta iDelta = delta;
            return iDelta;
        }
        catch (CoreException coreException) {
            return null;
        }
        finally {
            localmonitor.done();
        }
    }

    public static IDelta compare(IApiTypeRoot typeRoot, IApiTypeRoot typeRoot2, IApiComponent component, IApiComponent component2, IApiBaseline referenceBaseline, IApiBaseline baseline, int visibilityModifiers, IProgressMonitor monitor) {
        if (typeRoot == null || typeRoot2 == null) {
            throw new IllegalArgumentException("One of the given class files is null");
        }
        if (component == null || component2 == null) {
            throw new IllegalArgumentException("One of the given components is null");
        }
        if (referenceBaseline == null || baseline == null) {
            throw new IllegalArgumentException("One of the given baselines is null");
        }
        IDelta delta = null;
        try {
            IStatus status;
            ClassFileComparator comparator = new ClassFileComparator(typeRoot, typeRoot2, component, component2, referenceBaseline, baseline, visibilityModifiers);
            delta = comparator.getDelta((IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor));
            if (ApiPlugin.DEBUG_API_COMPARATOR && (status = comparator.getStatus()) != null) {
                ApiPlugin.log(status);
            }
        }
        catch (CoreException e) {
            ApiPlugin.log(e);
        }
        return delta;
    }

    public static IDelta compare(IApiScope scope, IApiBaseline baseline, int visibilityModifiers, boolean force, IProgressMonitor monitor) throws CoreException {
        return ApiComparator.compare(scope, baseline, visibilityModifiers, force, false, monitor);
    }

    public static IDelta compare(IApiScope scope, IApiBaseline baseline, int visibilityModifiers, boolean force, boolean continueOnResolverError, IProgressMonitor monitor) throws CoreException {
        if (scope == null || baseline == null) {
            throw new IllegalArgumentException("None of the scope or the baseline must be null");
        }
        SubMonitor localmonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        try {
            HashSet deltas = new HashSet();
            CompareApiScopeVisitor visitor = new CompareApiScopeVisitor(deltas, baseline, force, visibilityModifiers, continueOnResolverError, (IProgressMonitor)localmonitor.newChild(1));
            scope.accept(visitor);
            if (!continueOnResolverError && visitor.containsError()) {
                return null;
            }
            if (deltas.isEmpty()) {
                IDelta iDelta = NO_DELTA;
                return iDelta;
            }
            final Delta globalDelta = new Delta();
            Iterator iterator = deltas.iterator();
            while (iterator.hasNext()) {
                IDelta delta = (IDelta)iterator.next();
                delta.accept(new DeltaVisitor(){

                    public void endVisit(IDelta localDelta) {
                        if (localDelta.getChildren().length == 0) {
                            switch (localDelta.getElementType()) {
                                case 1: 
                                case 2: 
                                case 3: 
                                case 4: 
                                case 5: 
                                case 6: 
                                case 7: 
                                case 8: 
                                case 9: {
                                    globalDelta.add(localDelta);
                                }
                            }
                        }
                    }
                });
            }
            Util.updateMonitor((IProgressMonitor)localmonitor, 1);
            IDelta iDelta = globalDelta.isEmpty() ? NO_DELTA : globalDelta;
            return iDelta;
        }
        finally {
            localmonitor.done();
        }
    }

    static boolean filterType(int visibilityModifiers, IApiAnnotations elementDescription, IApiType typeDescriptor) {
        if (elementDescription != null && (elementDescription.getVisibility() & visibilityModifiers) == 0) {
            return true;
        }
        return visibilityModifiers == 1 && (elementDescription == null || Util.isDefault(typeDescriptor.getModifiers()) || Flags.isPrivate((int)typeDescriptor.getModifiers()));
    }

    private static IDelta internalCompare(final IApiComponent component, final IApiComponent component2, final IApiBaseline referenceBaseline, final IApiBaseline baseline, final int visibilityModifiers, final Delta globalDelta, IProgressMonitor monitor) throws CoreException {
        IApiTypeContainer container;
        int max;
        int i;
        IApiComponent currentRequiredApiComponent;
        String descriptionID;
        String currentComponentID;
        final HashSet typeRootBaseLineNames = new HashSet();
        final String id = component.getSymbolicName();
        IApiTypeContainer[] typeRootContainers = null;
        IApiTypeContainer[] typeRootContainers2 = null;
        final SubMonitor localmonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)4);
        final boolean isSWT = "org.eclipse.swt".equals(id);
        if (isSWT) {
            typeRootContainers = component.getApiTypeContainers();
            typeRootContainers2 = component2.getApiTypeContainers();
        } else {
            typeRootContainers = component.getApiTypeContainers(id);
            typeRootContainers2 = component2.getApiTypeContainers(id);
        }
        final IApiDescription apiDescription = component.getApiDescription();
        final IApiDescription apiDescription2 = component2.getApiDescription();
        Util.updateMonitor((IProgressMonitor)localmonitor, 1);
        if (typeRootContainers != null) {
            int i2 = 0;
            int max2 = typeRootContainers.length;
            while (i2 < max2) {
                Util.updateMonitor((IProgressMonitor)localmonitor);
                IApiTypeContainer container2 = typeRootContainers[i2];
                try {
                    container2.accept(new ApiTypeContainerVisitor(){

                        public void visit(String packageName, IApiTypeRoot typeRoot) {
                            Util.updateMonitor((IProgressMonitor)localmonitor);
                            String typeName = typeRoot.getTypeName();
                            try {
                                IApiType typeDescriptor = typeRoot.getStructure();
                                IApiAnnotations elementDescription = apiDescription.resolveAnnotations(typeDescriptor.getHandle());
                                if (typeDescriptor.isMemberType() || typeDescriptor.isAnonymous() || typeDescriptor.isLocal()) {
                                    return;
                                }
                                int visibility = 0;
                                if (elementDescription != null) {
                                    visibility = elementDescription.getVisibility();
                                }
                                IApiTypeRoot typeRoot2 = null;
                                typeRoot2 = isSWT ? component2.findTypeRoot(typeName) : component2.findTypeRoot(typeName, id);
                                String deltaComponentID = null;
                                IApiComponent provider = null;
                                IApiDescription providerApiDesc = null;
                                boolean reexported = false;
                                if (typeRoot2 == null) {
                                    IApiComponent[] providers = component2.getBaseline().resolvePackage(component2, packageName);
                                    int index = 0;
                                    while (typeRoot2 == null && index < providers.length) {
                                        String id2;
                                        Util.updateMonitor((IProgressMonitor)localmonitor);
                                        IApiComponent p = providers[index];
                                        if (!p.equals(component2) && (typeRoot2 = "org.eclipse.swt".equals(id2 = p.getSymbolicName()) ? p.findTypeRoot(typeName) : p.findTypeRoot(typeName, id2)) != null) {
                                            provider = p;
                                            providerApiDesc = p.getApiDescription();
                                            IRequiredComponentDescription[] required = component2.getRequiredComponents();
                                            int k = 0;
                                            while (k < required.length) {
                                                IRequiredComponentDescription description = required[k];
                                                if (description.getId().equals(id2)) {
                                                    reexported = description.isExported();
                                                    break;
                                                }
                                                ++k;
                                            }
                                        }
                                        ++index;
                                    }
                                } else {
                                    provider = component2;
                                    providerApiDesc = apiDescription2;
                                }
                                Util.updateMonitor((IProgressMonitor)localmonitor);
                                deltaComponentID = Util.getDeltaComponentVersionsId(component2);
                                if (typeRoot2 == null) {
                                    if ((visibility & visibilityModifiers) == 0) {
                                        return;
                                    }
                                    if (visibilityModifiers == 1 && (Util.isDefault(typeDescriptor.getModifiers()) || Flags.isPrivate((int)typeDescriptor.getModifiers()))) {
                                        return;
                                    }
                                    globalDelta.add(new Delta(deltaComponentID, 2, 3, 46, 0, 0, typeDescriptor.getModifiers(), 0, typeName, typeName, new String[]{typeName, Util.getComponentVersionsId(component2)}));
                                } else {
                                    IStatus status;
                                    if ((visibility & visibilityModifiers) == 0) {
                                        return;
                                    }
                                    IApiType typeDescriptor2 = typeRoot2.getStructure();
                                    IApiAnnotations elementDescription2 = providerApiDesc.resolveAnnotations(typeDescriptor2.getHandle());
                                    int visibility2 = 0;
                                    if (elementDescription2 != null) {
                                        visibility2 = elementDescription2.getVisibility();
                                    }
                                    if (visibilityModifiers == 1 && (Util.isDefault(typeDescriptor.getModifiers()) || Flags.isPrivate((int)typeDescriptor.getModifiers()))) {
                                        return;
                                    }
                                    if (Util.isAPI(visibility, typeDescriptor) && !Util.isAPI(visibility2, typeDescriptor2)) {
                                        globalDelta.add(new Delta(deltaComponentID, 2, 3, reexported ? 71 : 56, elementDescription2 != null ? elementDescription2.getRestrictions() : 0, 0, typeDescriptor.getModifiers(), typeDescriptor2.getModifiers(), typeName, typeName, new String[]{typeName, Util.getComponentVersionsId(component2)}));
                                        return;
                                    }
                                    if ((visibility2 & visibilityModifiers) == 0) {
                                        globalDelta.add(new Delta(deltaComponentID, 2, 2, 52, elementDescription2 != null ? elementDescription2.getRestrictions() : 0, 0, typeDescriptor.getModifiers(), typeDescriptor2.getModifiers(), typeName, typeName, new String[]{typeName, Util.getComponentVersionsId(component2)}));
                                    }
                                    typeRootBaseLineNames.add(typeName);
                                    ClassFileComparator comparator = new ClassFileComparator(typeDescriptor, typeRoot2, component, provider, referenceBaseline, baseline, visibilityModifiers);
                                    IDelta delta = comparator.getDelta((IProgressMonitor)localmonitor.newChild(1));
                                    if (ApiPlugin.DEBUG_API_COMPARATOR && (status = comparator.getStatus()) != null) {
                                        ApiPlugin.log(status);
                                    }
                                    if (delta != null && delta != NO_DELTA) {
                                        globalDelta.add(delta);
                                    }
                                }
                                Util.updateMonitor((IProgressMonitor)localmonitor);
                            }
                            catch (CoreException e) {
                                ApiPlugin.log(e);
                            }
                        }
                    });
                }
                catch (CoreException e) {
                    ApiPlugin.log(e);
                }
                ++i2;
            }
        }
        Util.updateMonitor((IProgressMonitor)localmonitor, 1);
        IRequiredComponentDescription[] requiredComponents = component.getRequiredComponents();
        int length = requiredComponents.length;
        if (length != 0) {
            int j = 0;
            while (j < length) {
                Util.updateMonitor((IProgressMonitor)localmonitor);
                IRequiredComponentDescription description = requiredComponents[j];
                if (description.isExported()) {
                    currentComponentID = Util.getDeltaComponentVersionsId(component);
                    descriptionID = description.getId();
                    currentRequiredApiComponent = referenceBaseline.getApiComponent(descriptionID);
                    if (currentRequiredApiComponent != null) {
                        final IApiDescription reexportedApiDescription = currentRequiredApiComponent.getApiDescription();
                        IApiTypeContainer[] apiTypeContainers = currentRequiredApiComponent.getApiTypeContainers();
                        if (apiTypeContainers != null) {
                            i = 0;
                            max = apiTypeContainers.length;
                            while (i < max) {
                                Util.updateMonitor((IProgressMonitor)localmonitor);
                                container = apiTypeContainers[i];
                                try {
                                    container.accept(new ApiTypeContainerVisitor(){

                                        public void visit(String packageName, IApiTypeRoot typeRoot) {
                                            Util.updateMonitor((IProgressMonitor)localmonitor);
                                            String typeName = typeRoot.getTypeName();
                                            try {
                                                IApiType typeDescriptor = typeRoot.getStructure();
                                                IApiAnnotations elementDescription = reexportedApiDescription.resolveAnnotations(typeDescriptor.getHandle());
                                                if (typeDescriptor.isMemberType() || typeDescriptor.isAnonymous() || typeDescriptor.isLocal()) {
                                                    return;
                                                }
                                                int visibility = 0;
                                                if (elementDescription != null) {
                                                    visibility = elementDescription.getVisibility();
                                                }
                                                IApiTypeRoot typeRoot2 = null;
                                                typeRoot2 = isSWT ? component2.findTypeRoot(typeName) : component2.findTypeRoot(typeName, id);
                                                IApiDescription providerApiDesc = null;
                                                if (typeRoot2 == null) {
                                                    IApiComponent[] providers = component2.getBaseline().resolvePackage(component2, packageName);
                                                    int index = 0;
                                                    while (typeRoot2 == null && index < providers.length) {
                                                        String id2;
                                                        IApiComponent p = providers[index];
                                                        if (!p.equals(component2) && (typeRoot2 = "org.eclipse.swt".equals(id2 = p.getSymbolicName()) ? p.findTypeRoot(typeName) : p.findTypeRoot(typeName, id2)) != null) {
                                                            providerApiDesc = p.getApiDescription();
                                                        }
                                                        ++index;
                                                    }
                                                } else {
                                                    providerApiDesc = apiDescription2;
                                                }
                                                if (typeRoot2 == null) {
                                                    if ((visibility & visibilityModifiers) == 0) {
                                                        return;
                                                    }
                                                    if (visibilityModifiers == 1 && (Util.isDefault(typeDescriptor.getModifiers()) || Flags.isPrivate((int)typeDescriptor.getModifiers()))) {
                                                        return;
                                                    }
                                                    globalDelta.add(new Delta(currentComponentID, 2, 3, 70, 0, 0, typeDescriptor.getModifiers(), 0, typeName, typeName, new String[]{typeName, Util.getComponentVersionsId(component)}));
                                                } else {
                                                    typeRootBaseLineNames.add(typeName);
                                                    IApiType typeDescriptor2 = typeRoot2.getStructure();
                                                    IApiAnnotations elementDescription2 = providerApiDesc.resolveAnnotations(typeDescriptor2.getHandle());
                                                    int visibility2 = 0;
                                                    if (elementDescription2 != null) {
                                                        visibility2 = elementDescription2.getVisibility();
                                                    }
                                                    if (Util.isDefault(typeDescriptor.getModifiers()) || Flags.isPrivate((int)typeDescriptor.getModifiers())) {
                                                        return;
                                                    }
                                                    if (Util.isAPI(visibility, typeDescriptor) && !Util.isAPI(visibility2, typeDescriptor2)) {
                                                        globalDelta.add(new Delta(currentComponentID, 2, 3, 71, elementDescription2 != null ? elementDescription2.getRestrictions() : 0, 0, typeDescriptor.getModifiers(), typeDescriptor2.getModifiers(), typeName, typeName, new String[]{typeName, Util.getComponentVersionsId(component)}));
                                                        return;
                                                    }
                                                }
                                            }
                                            catch (CoreException e) {
                                                ApiPlugin.log(e);
                                            }
                                        }
                                    });
                                }
                                catch (CoreException e) {
                                    ApiPlugin.log(e);
                                }
                                ++i;
                            }
                        }
                    }
                }
                ++j;
            }
        }
        Util.updateMonitor((IProgressMonitor)localmonitor, 1);
        if (typeRootContainers2 != null) {
            int i3 = 0;
            int max3 = typeRootContainers2.length;
            while (i3 < max3) {
                Util.updateMonitor((IProgressMonitor)localmonitor);
                IApiTypeContainer container3 = typeRootContainers2[i3];
                try {
                    container3.accept(new ApiTypeContainerVisitor(){

                        public void visit(String packageName, IApiTypeRoot typeRoot) {
                            Util.updateMonitor((IProgressMonitor)localmonitor);
                            String typeName = typeRoot.getTypeName();
                            try {
                                IApiType type = typeRoot.getStructure();
                                IApiAnnotations elementDescription = apiDescription2.resolveAnnotations(type.getHandle());
                                if (type.isMemberType() || type.isLocal() || type.isAnonymous()) {
                                    return;
                                }
                                if (ApiComparator.filterType(visibilityModifiers, elementDescription, type)) {
                                    return;
                                }
                                if (typeRootBaseLineNames.contains(typeName)) {
                                    return;
                                }
                                typeRootBaseLineNames.add(typeName);
                                String deltaComponentID = Util.getDeltaComponentVersionsId(component2);
                                globalDelta.add(new Delta(deltaComponentID, 2, 1, 46, elementDescription != null ? elementDescription.getRestrictions() : 0, 0, 0, type.getModifiers(), typeName, typeName, new String[]{typeName, Util.getComponentVersionsId(component2)}));
                            }
                            catch (CoreException e) {
                                ApiPlugin.log(e);
                            }
                        }
                    });
                }
                catch (CoreException e) {
                    ApiPlugin.log(e);
                }
                ++i3;
            }
        }
        Util.updateMonitor((IProgressMonitor)localmonitor, 1);
        requiredComponents = component2.getRequiredComponents();
        length = requiredComponents.length;
        if (length != 0) {
            int j = 0;
            while (j < length) {
                Util.updateMonitor((IProgressMonitor)localmonitor);
                IRequiredComponentDescription description = requiredComponents[j];
                if (description.isExported()) {
                    currentComponentID = Util.getDeltaComponentVersionsId(component);
                    descriptionID = description.getId();
                    currentRequiredApiComponent = baseline.getApiComponent(descriptionID);
                    if (currentRequiredApiComponent != null) {
                        IApiTypeContainer[] apiTypeContainers = currentRequiredApiComponent.getApiTypeContainers();
                        final IApiDescription reexportedApiDescription = currentRequiredApiComponent.getApiDescription();
                        if (apiTypeContainers != null) {
                            i = 0;
                            max = apiTypeContainers.length;
                            while (i < max) {
                                Util.updateMonitor((IProgressMonitor)localmonitor);
                                container = apiTypeContainers[i];
                                try {
                                    container.accept(new ApiTypeContainerVisitor(){

                                        public void visit(String packageName, IApiTypeRoot typeRoot) {
                                            Util.updateMonitor((IProgressMonitor)localmonitor);
                                            String typeName = typeRoot.getTypeName();
                                            try {
                                                IApiType typeDescriptor = typeRoot.getStructure();
                                                IApiAnnotations elementDescription = reexportedApiDescription.resolveAnnotations(typeDescriptor.getHandle());
                                                if (typeDescriptor.isMemberType() || typeDescriptor.isAnonymous() || typeDescriptor.isLocal()) {
                                                    return;
                                                }
                                                if (ApiComparator.filterType(visibilityModifiers, elementDescription, typeDescriptor)) {
                                                    return;
                                                }
                                                if (typeRootBaseLineNames.contains(typeName)) {
                                                    return;
                                                }
                                                typeRootBaseLineNames.add(typeName);
                                                globalDelta.add(new Delta(currentComponentID, 2, 1, 70, elementDescription != null ? elementDescription.getRestrictions() : 0, 0, 0, typeDescriptor.getModifiers(), typeName, typeName, new String[]{typeName, Util.getComponentVersionsId(component)}));
                                            }
                                            catch (CoreException e) {
                                                ApiPlugin.log(e);
                                            }
                                        }
                                    });
                                }
                                catch (CoreException e) {
                                    ApiPlugin.log(e);
                                }
                                ++i;
                            }
                        }
                    }
                }
                ++j;
            }
        }
        return globalDelta.isEmpty() ? NO_DELTA : globalDelta;
    }
}

