/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.installer;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.buckminster.cmdline.AbstractCommand;
import org.eclipse.buckminster.cmdline.UsageException;
import org.eclipse.buckminster.installer.Messages;
import org.eclipse.buckminster.runtime.Buckminster;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.IProvisioningAgentProvider;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Install
extends AbstractCommand {
    private URI site;
    private Version version;
    private String feature;

    static ProvisioningContext createContext(IProvisioningAgent agent, URI site) {
        URI[] repoLocations = new URI[]{site};
        ProvisioningContext context = new ProvisioningContext(agent);
        context.setArtifactRepositories(repoLocations);
        return context;
    }

    static IQueryResult<IInstallableUnit> getRootIUs(IProvisioningAgent agent, URI site, IProfile profile, String iuName, Version version, IProgressMonitor monitor) throws CoreException {
        IMetadataRepositoryManager queryable;
        if (!iuName.endsWith(".feature.group")) {
            iuName = String.valueOf(iuName) + ".feature.group";
        }
        IQuery query = QueryUtil.createIUQuery((String)iuName, (Version)version);
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IMetadataRepositoryManager repoManager = (IMetadataRepositoryManager)agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
        if (site == null) {
            queryable = repoManager;
            subMon.worked(80);
        } else {
            queryable = repoManager.loadRepository(site, (IProgressMonitor)subMon.newChild(80));
        }
        IQueryResult roots = queryable.query(QueryUtil.createLatestQuery((IQuery)query), (IProgressMonitor)subMon.newChild(10));
        if (roots.isEmpty()) {
            roots = profile.query(query, (IProgressMonitor)subMon.newChild(10));
        }
        if (roots.isEmpty()) {
            throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.no_suitable_feature_version_found_matching_0, (Object)iuName), (Object[])new Object[0]);
        }
        return roots;
    }

    static URI normalizeToURI(String surl) {
        URL url;
        try {
            url = new URL(surl);
        }
        catch (MalformedURLException e) {
            try {
                url = new File(surl).toURI().toURL();
            }
            catch (MalformedURLException e2) {
                throw new IllegalArgumentException(NLS.bind((String)Messages.URL_0_malformed, (Object)surl));
            }
        }
        return URI.create(url.toString());
    }

    static int planAndExecute(IProvisioningAgent agent, IProfile profile, ProfileChangeRequest request, ProvisioningContext context, IProgressMonitor monitor) throws CoreException {
        IPlanner planner = (IPlanner)agent.getService(IPlanner.SERVICE_NAME);
        IProvisioningPlan plan = planner.getProvisioningPlan((IProfileChangeRequest)request, context, monitor);
        IStatus status = plan.getStatus();
        if (status.getSeverity() == 8) {
            return 2;
        }
        if (status.getSeverity() == 4) {
            throw new CoreException(status);
        }
        IEngine engine = (IEngine)agent.getService(IEngine.SERVICE_NAME);
        status = engine.perform(plan, monitor);
        if (status.getSeverity() == 8) {
            return 2;
        }
        if (status.getSeverity() == 4) {
            throw new CoreException(status);
        }
        return 0;
    }

    protected void handleUnparsed(String[] unparsed) throws Exception {
        int len = unparsed.length;
        if (len > 3) {
            throw new UsageException(Messages.too_many_arguments);
        }
        if (len > 0) {
            String p2Repos = unparsed[0];
            if (p2Repos.endsWith("/headless-site.xml")) {
                p2Repos = p2Repos.substring(0, p2Repos.length() - 18);
            } else if (p2Repos.endsWith("/site.xml")) {
                p2Repos = p2Repos.substring(0, p2Repos.length() - 9);
            }
            this.site = Install.normalizeToURI(p2Repos);
        }
        if (len > 1) {
            this.feature = unparsed[1];
        }
        if (len > 2) {
            this.version = Version.parseVersion((String)unparsed[2]);
        }
    }

    protected int run(IProgressMonitor monitor) throws Exception {
        if (this.site == null) {
            throw new UsageException(Messages.no_site_provided);
        }
        if (this.feature == null) {
            throw new UsageException(Messages.no_feature_id_provided);
        }
        Buckminster bucky = Buckminster.getDefault();
        IProvisioningAgentProvider agentProvider = (IProvisioningAgentProvider)bucky.getService(IProvisioningAgentProvider.class);
        IProvisioningAgent agent = agentProvider.createAgent(null);
        String profileId = bucky.getBundle().getBundleContext().getProperty("eclipse.p2.profile");
        if (profileId == null) {
            profileId = "Buckminster";
            System.setProperty("eclipse.p2.profile", profileId);
        }
        IProfileRegistry profileRegistry = (IProfileRegistry)agent.getService(IProfileRegistry.SERVICE_NAME);
        try {
            IProfile profile = profileRegistry.getProfile(profileId);
            IQueryResult<IInstallableUnit> rootArr = Install.getRootIUs(agent, this.site, profile, this.feature, this.version, monitor);
            ProfileChangeRequest request = new ProfileChangeRequest(profile);
            Iterator iter = rootArr.iterator();
            while (iter.hasNext()) {
                request.setInstallableUnitProfileProperty((IInstallableUnit)iter.next(), "org.eclipse.equinox.p2.type.root", Boolean.TRUE.toString());
            }
            request.addAll((Collection)rootArr.toUnmodifiableSet());
            int n = Install.planAndExecute(agent, profile, request, Install.createContext(agent, this.site), monitor);
            return n;
        }
        finally {
            agent.stop();
            bucky.ungetService((Object)agentProvider);
        }
    }
}

