/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.installer;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.buckminster.cmdline.AbstractCommand;
import org.eclipse.buckminster.cmdline.SimpleErrorExitException;
import org.eclipse.buckminster.installer.Install;
import org.eclipse.buckminster.installer.Messages;
import org.eclipse.buckminster.runtime.Buckminster;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.IProvisioningAgentProvider;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.osgi.util.NLS;

public class Uninstall
extends AbstractCommand {
    private Version version;
    private String feature;

    protected void handleUnparsed(String[] unparsed) throws Exception {
        int len = unparsed.length;
        if (len > 2) {
            throw new SimpleErrorExitException(Messages.too_many_arguments);
        }
        if (len > 0) {
            this.feature = unparsed[0];
        }
        if (len > 1) {
            try {
                this.version = Version.parseVersion((String)unparsed[1]);
            }
            catch (IllegalArgumentException e) {
                throw new SimpleErrorExitException(NLS.bind((String)"Unable to parse version: {0}", (Object)unparsed[1], (Object)e.getMessage()));
            }
        }
    }

    protected int run(IProgressMonitor monitor) throws Exception {
        if (this.feature == null) {
            throw new SimpleErrorExitException(Messages.no_feature_id_provided);
        }
        monitor.beginTask(null, -1);
        Buckminster bucky = Buckminster.getDefault();
        IProvisioningAgentProvider agentProvider = (IProvisioningAgentProvider)bucky.getService(IProvisioningAgentProvider.class);
        IProvisioningAgent agent = agentProvider.createAgent(null);
        try {
            IProfileRegistry profileRegistry = (IProfileRegistry)agent.getService(IProfileRegistry.SERVICE_NAME);
            IProfile profile = profileRegistry.getProfile("_SELF_");
            IQueryResult<IInstallableUnit> rootArr = Install.getRootIUs(agent, null, profile, this.feature, this.version, monitor);
            ProfileChangeRequest request = new ProfileChangeRequest(profile);
            Iterator iter = rootArr.iterator();
            while (iter.hasNext()) {
                request.setInstallableUnitProfileProperty((IInstallableUnit)iter.next(), "org.eclipse.equinox.p2.type.root", Boolean.TRUE.toString());
            }
            request.removeAll((Collection)rootArr.toUnmodifiableSet());
            int n = Install.planAndExecute(agent, profile, request, null, monitor);
            return n;
        }
        finally {
            agent.stop();
            bucky.ungetService((Object)agentProvider);
        }
    }
}

