/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.team;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.buckminster.core.actor.AbstractActor;
import org.eclipse.buckminster.core.actor.IActionContext;
import org.eclipse.buckminster.core.cspec.IComponentIdentifier;
import org.eclipse.buckminster.core.metadata.WorkspaceInfo;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.buckminster.team.Messages;
import org.eclipse.buckminster.team.ProviderResources;
import org.eclipse.buckminster.team.TeamPerformContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.mapping.ISynchronizationScope;
import org.eclipse.team.core.mapping.provider.SynchronizationScopeManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTeamActor<C extends TeamPerformContext>
extends AbstractActor {
    public static IStatus createMultiStatus(String message, IStatus[] statuses) {
        return new MultiStatus("org.eclipse.buckminster.team", 4, statuses, message, null);
    }

    public static IStatus createStatus(String message) {
        return AbstractTeamActor.createStatus(message, null);
    }

    public static IStatus createStatus(String message, Throwable t) {
        return new Status(4, "org.eclipse.buckminster.team", message, t);
    }

    public static IStatus createStatus(Throwable t) {
        return AbstractTeamActor.createStatus(t.getMessage(), t);
    }

    protected static ResourceMapping getResourceMapping(Object o) {
        if (o instanceof ResourceMapping) {
            return (ResourceMapping)o;
        }
        if (o instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)o;
            Object adapted = adaptable.getAdapter(ResourceMapping.class);
            if (adapted instanceof ResourceMapping) {
                return (ResourceMapping)adapted;
            }
        } else {
            Object adapted = Platform.getAdapterManager().getAdapter(o, ResourceMapping.class);
            if (adapted instanceof ResourceMapping) {
                return (ResourceMapping)adapted;
            }
        }
        return null;
    }

    public abstract String getActionName(IActionContext var1);

    protected SynchronizationScopeManager createScopeManager(String scopeName, ResourceMapping[] resourceMappings) {
        return new SynchronizationScopeManager(scopeName, resourceMappings, ResourceMappingContext.LOCAL_CONTEXT, true);
    }

    protected abstract C createTeamPerformContext(IActionContext var1) throws CoreException;

    protected Map<RepositoryProvider, ProviderResources> getProviderResourcesMap(C teamPerformContext, ISynchronizationScope scope) throws CoreException {
        HashMap<RepositoryProvider, ProviderResources> result = new HashMap<RepositoryProvider, ProviderResources>();
        ResourceMapping[] resourceMappingArray = scope.getMappings();
        int n = resourceMappingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceMapping mapping = resourceMappingArray[n2];
            ResourceTraversal[] traversals = scope.getTraversals(mapping);
            IProject[] iProjectArray = mapping.getProjects();
            int n3 = iProjectArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IProject project = iProjectArray[n4];
                RepositoryProvider provider = RepositoryProvider.getProvider((IProject)project);
                if (provider != null && ((TeamPerformContext)teamPerformContext).getReaderTypeForRepositoryProvider(provider.getID()) != null) {
                    ProviderResources providerResources = result.get(provider);
                    if (providerResources == null) {
                        providerResources = new ProviderResources(provider);
                        result.put(provider, providerResources);
                    }
                    providerResources.add(traversals);
                }
                ++n4;
            }
            ++n2;
        }
        return result;
    }

    protected abstract String getTaskName(RepositoryProvider var1);

    protected IStatus internalPerform(IActionContext actionContext, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(this.getActionName(actionContext), 10000);
        try {
            C teamPerformContext = this.createTeamPerformContext(actionContext);
            IProject[] projects = WorkspaceInfo.getProjectsInResolution((IComponentIdentifier)actionContext.getCSpec().getComponentIdentifier());
            int workAmount = 10000 / (projects.length + 1);
            monitor.worked(workAmount);
            ArrayList<IStatus> statuses = null;
            IProject[] iProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                block21: {
                    IProject project = iProjectArray[n2];
                    try {
                        this.internalTeamPerform(teamPerformContext, project, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)workAmount));
                    }
                    catch (CoreException ce) {
                        ((TeamPerformContext)teamPerformContext).collectStatus(ce.getStatus());
                        if (((TeamPerformContext)teamPerformContext).hasErrors()) {
                            if (statuses == null) {
                                statuses = new ArrayList();
                            }
                            statuses.add(((TeamPerformContext)teamPerformContext).collectedStatus(NLS.bind((String)Messages.problems_during_0, (Object)NLS.bind((String)Messages.processing_of_0, (Object)project.getName()))));
                        }
                        break block21;
                    }
                    catch (Throwable t) {
                        try {
                            ((TeamPerformContext)teamPerformContext).collectStatus(AbstractTeamActor.createStatus(t));
                            if (!((TeamPerformContext)teamPerformContext).hasErrors()) break block21;
                            if (statuses == null) {
                                statuses = new ArrayList();
                            }
                            statuses.add(((TeamPerformContext)teamPerformContext).collectedStatus(NLS.bind((String)Messages.problems_during_0, (Object)NLS.bind((String)Messages.processing_of_0, (Object)project.getName()))));
                        }
                        catch (Throwable throwable) {
                            if (((TeamPerformContext)teamPerformContext).hasErrors()) {
                                if (statuses == null) {
                                    statuses = new ArrayList<IStatus>();
                                }
                                statuses.add(((TeamPerformContext)teamPerformContext).collectedStatus(NLS.bind((String)Messages.problems_during_0, (Object)NLS.bind((String)Messages.processing_of_0, (Object)project.getName()))));
                            }
                            throw throwable;
                        }
                        break block21;
                    }
                    if (!((TeamPerformContext)teamPerformContext).hasErrors()) break block21;
                    if (statuses == null) {
                        statuses = new ArrayList();
                    }
                    statuses.add(((TeamPerformContext)teamPerformContext).collectedStatus(NLS.bind((String)Messages.problems_during_0, (Object)NLS.bind((String)Messages.processing_of_0, (Object)project.getName()))));
                }
                ++n2;
            }
            if (statuses == null) {
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            IStatus iStatus = AbstractTeamActor.createMultiStatus(NLS.bind((String)Messages.problems_during_0, (Object)this.getActionName(actionContext)), statuses.toArray(new IStatus[statuses.size()]));
            return iStatus;
        }
        catch (CoreException ce) {
            throw ce;
        }
        catch (Throwable t) {
            throw new CoreException(AbstractTeamActor.createStatus(t));
        }
        finally {
            monitor.done();
        }
    }

    protected void internalTeamPerform(C teamPerformContext, IProject project, IProgressMonitor monitor) throws CoreException, InterruptedException {
        ResourceMapping resourceMapping = AbstractTeamActor.getResourceMapping(project);
        monitor.beginTask(NLS.bind((String)Messages.processing_project_0, (Object)project.getName()), 1100);
        try {
            if (this.shouldExclude(teamPerformContext, (IResource)project)) {
                return;
            }
            if (resourceMapping != null) {
                SynchronizationScopeManager scopeManager = this.createScopeManager("Scope manager for " + project.getName(), new ResourceMapping[]{resourceMapping});
                scopeManager.initialize(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)100));
                Map<RepositoryProvider, ProviderResources> providerResourcesMap = this.getProviderResourcesMap(teamPerformContext, scopeManager.getScope());
                this.processProviderResourcesMap(teamPerformContext, providerResourcesMap, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1000));
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void processNontraversedResources(C teamPerformContext, RepositoryProvider provider, IResource[] nontraversedFolders, IProgressMonitor monitor) throws CoreException, InterruptedException {
    }

    protected void processProviderResources(C teamPerformContext, ProviderResources providerResources, IProgressMonitor monitor) throws CoreException, InterruptedException {
        RepositoryProvider provider = providerResources.getProvider();
        IResource[] deepResources = providerResources.getDeepResources();
        IResource[] shallowResources = providerResources.getShallowResources();
        IResource[] nontraversedFolders = providerResources.getNontraversedFolders();
        int workAmount = (deepResources.length > 0 ? 100 : 0) + (shallowResources.length > 0 ? 100 : 0) + (nontraversedFolders.length > 0 ? 10 : 0);
        monitor.beginTask(this.getTaskName(provider), workAmount);
        try {
            if (workAmount == 0) {
                return;
            }
            IProject rule = provider.getProject();
            try {
                Job.getJobManager().beginRule((ISchedulingRule)rule, monitor);
                if (deepResources.length > 0) {
                    this.processResources(teamPerformContext, provider, deepResources, true, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)100));
                }
                if (shallowResources.length > 0) {
                    this.processResources(teamPerformContext, provider, shallowResources, false, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)100));
                }
                if (nontraversedFolders.length > 0) {
                    this.processNontraversedResources(teamPerformContext, provider, nontraversedFolders, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)10));
                }
            }
            finally {
                Job.getJobManager().endRule((ISchedulingRule)rule);
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void processProviderResourcesMap(C teamPerformContext, Map<RepositoryProvider, ProviderResources> providerResourcesMap, IProgressMonitor monitor) throws CoreException, InterruptedException {
        Set<Map.Entry<RepositoryProvider, ProviderResources>> entrySet = providerResourcesMap.entrySet();
        monitor.beginTask(null, entrySet.size() * 1000);
        for (Map.Entry<RepositoryProvider, ProviderResources> entry : entrySet) {
            ProviderResources providerResources = entry.getValue();
            monitor.setTaskName(this.getTaskName(providerResources.getProvider()));
            this.processProviderResources(teamPerformContext, providerResources, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1000));
        }
        monitor.done();
    }

    protected abstract void processResources(C var1, RepositoryProvider var2, IResource[] var3, boolean var4, IProgressMonitor var5) throws CoreException, InterruptedException;

    protected boolean shouldExclude(C teamPerformContext, IResource resource) {
        return false;
    }
}

