/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.team;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.buckminster.core.actor.IActionContext;
import org.eclipse.buckminster.core.reader.AbstractReaderType;
import org.eclipse.buckminster.core.reader.IReaderType;
import org.eclipse.buckminster.core.reader.ITeamReaderType;
import org.eclipse.buckminster.team.AbstractTeamActor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;

public class TeamPerformContext {
    private static final ITeamReaderType NO_READER_TYPE = (ITeamReaderType)Proxy.newProxyInstance(TeamPerformContext.class.getClassLoader(), new Class[]{ITeamReaderType.class}, new InvocationHandler(){

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            throw new UnsupportedOperationException();
        }
    });
    private final IActionContext actionContext;
    private HashMap<String, ITeamReaderType> readerTypeCache = new HashMap();
    private ArrayList<IStatus> statuses = new ArrayList();

    public TeamPerformContext(IActionContext actionContext) {
        this.actionContext = actionContext;
    }

    public IStatus collectedStatus(String message) {
        IStatus status = AbstractTeamActor.createMultiStatus(message, this.statuses.toArray(new IStatus[this.statuses.size()]));
        this.statuses.clear();
        return status;
    }

    public void collectStatus(IStatus status) {
        if (!status.isOK()) {
            this.statuses.add(status);
        }
    }

    public IActionContext getActionContext() {
        return this.actionContext;
    }

    public ITeamReaderType getCachedReaderTypeForRepositoryProvider(String providerID) throws IllegalStateException {
        ITeamReaderType readerType = this.readerTypeCache.get(providerID);
        if (readerType == null) {
            throw new IllegalStateException();
        }
        if (readerType == NO_READER_TYPE) {
            return null;
        }
        return readerType;
    }

    public ITeamReaderType getReaderTypeForRepositoryProvider(String providerID) throws CoreException {
        ITeamReaderType readerType = this.readerTypeCache.get(providerID);
        if (readerType == null) {
            IReaderType baseReaderType = AbstractReaderType.getTypeForRepositoryProvider((String)providerID);
            readerType = baseReaderType != null && baseReaderType instanceof ITeamReaderType ? (ITeamReaderType)baseReaderType : NO_READER_TYPE;
            this.readerTypeCache.put(providerID, readerType);
        }
        if (readerType == NO_READER_TYPE) {
            return null;
        }
        return readerType;
    }

    public boolean hasErrors() {
        return !this.statuses.isEmpty();
    }
}

