/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.cmdline;

public class OptionDescriptor {
    private final Character shortName;
    private final String longName;
    private final int type;

    public OptionDescriptor(char shortName, String longName, int type) {
        this(shortName == '\u0000' ? null : Character.valueOf(shortName), longName, type);
    }

    public OptionDescriptor(Character shortName, String longName, int type) {
        this.shortName = shortName;
        this.longName = longName;
        this.type = type;
    }

    public OptionDescriptor(String longName, int type) {
        this(null, longName, type);
    }

    public String getLongName() {
        return this.longName;
    }

    public Character getShortName() {
        return this.shortName;
    }

    public int getType() {
        return this.type;
    }

    public boolean isAcceptableName(String name, boolean isLongName, boolean exact) {
        if (!isLongName) {
            return this.shortName == null ? false : this.shortName.charValue() == name.charAt(0);
        }
        if (this.longName == null) {
            return false;
        }
        return exact ? this.longName.equals(name) : this.longName.startsWith(name);
    }
}

