/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.cvspkg.internal;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.buckminster.core.helpers.FileHandle;
import org.eclipse.buckminster.core.reader.AbstractCatalogReader;
import org.eclipse.buckminster.core.reader.IComponentReader;
import org.eclipse.buckminster.core.reader.IReaderType;
import org.eclipse.buckminster.core.reader.IStreamConsumer;
import org.eclipse.buckminster.core.version.ProviderMatch;
import org.eclipse.buckminster.cvspkg.Messages;
import org.eclipse.buckminster.cvspkg.internal.CVSReaderType;
import org.eclipse.buckminster.cvspkg.internal.CVSSession;
import org.eclipse.buckminster.cvspkg.internal.FileSystemCopier;
import org.eclipse.buckminster.cvspkg.internal.RepositoryMetaData;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.ICVSResourceVisitor;
import org.eclipse.team.internal.ccvs.core.connection.CVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolder;
import org.eclipse.team.internal.ccvs.core.resources.UpdateContentCachingService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CVSReader
extends AbstractCatalogReader {
    private final CVSTag fixed;
    private final CVSSession session;
    private RepositoryMetaData metaData;
    private RemoteFolder flatRoot;

    static synchronized Date getTagDate(CVSTag tag) {
        return tag.asDate();
    }

    public CVSReader(IReaderType readerType, ProviderMatch rInfo) throws CoreException {
        super(readerType, rInfo);
        this.session = new CVSSession(rInfo.getRepositoryURI());
        this.fixed = CVSReaderType.getCVSTag(rInfo.getVersionMatch());
    }

    public void close() {
        this.session.close();
    }

    public void innerMaterialize(IPath destination, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(null, 100);
        CVSRepositoryLocation cvsLocation = (CVSRepositoryLocation)this.session.getLocation();
        CVSTag tag = null;
        if (this.fixed.getType() == 3) {
            Date fixedDate = CVSReader.getTagDate(this.fixed);
            if (this.getMetaData(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)20)).getLastModification().compareTo(fixedDate) > 0) {
                tag = this.fixed;
            }
        } else {
            tag = this.fixed;
            MonitorUtils.worked((IProgressMonitor)monitor, (int)20);
        }
        MonitorUtils.testCancelStatus((IProgressMonitor)monitor);
        RemoteFolder root = new RemoteFolder(null, (ICVSRepositoryLocation)cvsLocation, this.session.getModuleName(), tag);
        try {
            RemoteFolder folder = UpdateContentCachingService.buildRemoteTree((CVSRepositoryLocation)cvsLocation, (ICVSFolder)root, (CVSTag)tag, (int)2, (IProgressMonitor)MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)90));
            if (folder == null) {
                throw new FileNotFoundException(this.toString());
            }
            FileSystemCopier copier = new FileSystemCopier((ICVSFolder)folder, destination, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)80));
            try {
                folder.accept((ICVSResourceVisitor)copier, true);
            }
            finally {
                copier.done();
                monitor.done();
            }
        }
        catch (IOException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
    }

    public String toString() {
        return String.valueOf(this.session.getRepository()) + ',' + this.fixed.getName();
    }

    protected boolean innerExists(String fileName, IProgressMonitor monitor) throws CoreException {
        Closeable input = null;
        try {
            this.getCVSRemoteFile(fileName, monitor);
            return true;
        }
        catch (FileNotFoundException e) {
            return false;
        }
        finally {
            IOUtils.close(input);
        }
    }

    protected FileHandle innerGetContents(String fileName, IProgressMonitor monitor) throws CoreException, IOException {
        FileHandle fileHandle;
        monitor.beginTask(null, 1000);
        monitor.subTask(NLS.bind((String)Messages.retrieving_0, (Object)fileName));
        InputStream in = null;
        BufferedOutputStream out = null;
        File tempFile = null;
        try {
            ICVSRemoteFile cvsFile = this.getCVSRemoteFile(fileName, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)500));
            in = cvsFile.getContents(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)250));
            tempFile = this.createTempFile();
            out = new BufferedOutputStream(new FileOutputStream(tempFile));
            IOUtils.copy((InputStream)in, (OutputStream)out, (IProgressMonitor)MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)250));
            FileHandle fh = new FileHandle(fileName, tempFile, true);
            tempFile = null;
            fileHandle = fh;
        }
        catch (Throwable throwable) {
            IOUtils.close(out);
            IOUtils.close(in);
            if (tempFile != null) {
                tempFile.delete();
            }
            monitor.done();
            throw throwable;
        }
        IOUtils.close((Closeable)out);
        IOUtils.close((Closeable)in);
        if (tempFile != null) {
            tempFile.delete();
        }
        monitor.done();
        return fileHandle;
    }

    protected void innerGetMatchingRootFiles(Pattern pattern, List<FileHandle> files, IProgressMonitor monitor) throws CoreException, IOException {
        monitor.beginTask(null, 1000 + (this.flatRoot == null ? 500 : 0));
        try {
            if (this.flatRoot == null) {
                this.getFlatRoot(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)500));
            }
            ArrayList<String> matching = null;
            ICVSRemoteResource[] iCVSRemoteResourceArray = this.flatRoot.getChildren();
            int n = iCVSRemoteResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICVSRemoteResource child = iCVSRemoteResourceArray[n2];
                String name = child.getName();
                if (pattern.matcher(name).matches()) {
                    if (matching == null) {
                        matching = new ArrayList<String>();
                    }
                    matching.add(name);
                }
                ++n2;
            }
            if (matching == null) {
                return;
            }
            int ticksPerMatch = 1000 / matching.size();
            for (String name : matching) {
                files.add(this.innerGetContents(name, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)ticksPerMatch)));
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void innerList(List<String> files, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(null, 1000 + (this.flatRoot == null ? 500 : 0));
        try {
            if (this.flatRoot == null) {
                this.getFlatRoot(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)500));
            }
            ICVSRemoteResource[] iCVSRemoteResourceArray = this.flatRoot.getChildren();
            int n = iCVSRemoteResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICVSRemoteResource child = iCVSRemoteResourceArray[n2];
                String name = child.getName();
                if (child.isFolder() && !name.endsWith("/")) {
                    name = String.valueOf(name) + "/";
                }
                files.add(child.getName());
                ++n2;
            }
        }
        finally {
            monitor.done();
        }
    }

    protected <T> T innerReadFile(String fileName, IStreamConsumer<T> consumer, IProgressMonitor monitor) throws CoreException, IOException {
        Object object;
        monitor.beginTask(null, 1000);
        monitor.subTask(NLS.bind((String)Messages.retrieving_0, (Object)fileName));
        InputStream in = null;
        try {
            ICVSRemoteFile cvsFile = this.getCVSRemoteFile(fileName, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)500));
            in = cvsFile.getContents(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)250));
            object = consumer.consumeStream((IComponentReader)this, fileName, in, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)250));
        }
        catch (Throwable throwable) {
            IOUtils.close(in);
            monitor.done();
            throw throwable;
        }
        IOUtils.close((Closeable)in);
        monitor.done();
        return (T)object;
    }

    private ICVSRemoteFile getCVSRemoteFile(String fileName, IProgressMonitor monitor) throws CoreException, FileNotFoundException {
        ICVSResource cvsFile;
        IPath filePath = Path.fromPortableString((String)fileName);
        RemoteFolder folder = this.flatRoot;
        if (filePath.segmentCount() > 1) {
            IPath parentPath = Path.fromPortableString((String)this.session.getModuleName()).append(filePath.removeLastSegments(1));
            CVSRepositoryLocation cvsLocation = (CVSRepositoryLocation)this.session.getLocation();
            folder = new RemoteFolder(null, (ICVSRepositoryLocation)cvsLocation, parentPath.toPortableString(), this.fixed);
            folder = UpdateContentCachingService.buildRemoteTree((CVSRepositoryLocation)cvsLocation, (ICVSFolder)folder, (CVSTag)this.fixed, (int)1, (IProgressMonitor)monitor);
        } else {
            if (this.flatRoot == null) {
                this.getFlatRoot(monitor);
            } else {
                MonitorUtils.complete((IProgressMonitor)monitor);
            }
            folder = this.flatRoot;
        }
        if (folder == null) {
            throw new FileNotFoundException(this.toString());
        }
        try {
            cvsFile = folder.getChild(filePath.lastSegment());
        }
        catch (CVSException e) {
            throw new FileNotFoundException(e.getMessage());
        }
        if (!(cvsFile instanceof ICVSRemoteFile)) {
            throw new FileNotFoundException(NLS.bind((String)Messages.file_0_appears_to_be_folder, (Object)fileName));
        }
        return (ICVSRemoteFile)cvsFile;
    }

    private void getFlatRoot(IProgressMonitor monitor) throws CoreException {
        if (this.flatRoot == null) {
            CVSRepositoryLocation cvsLocation = (CVSRepositoryLocation)this.session.getLocation();
            RemoteFolder root = new RemoteFolder(null, (ICVSRepositoryLocation)cvsLocation, this.session.getModuleName(), this.fixed);
            this.flatRoot = UpdateContentCachingService.buildRemoteTree((CVSRepositoryLocation)cvsLocation, (ICVSFolder)root, (CVSTag)this.fixed, (int)1, (IProgressMonitor)monitor);
        } else {
            MonitorUtils.complete((IProgressMonitor)monitor);
        }
    }

    private synchronized RepositoryMetaData getMetaData(IProgressMonitor monitor) throws CoreException {
        if (this.metaData == null) {
            CVSTag tag = this.fixed.getType() == 3 ? null : this.fixed;
            this.metaData = RepositoryMetaData.getMetaData(this.session, tag, monitor);
        } else {
            MonitorUtils.complete((IProgressMonitor)monitor);
        }
        return this.metaData;
    }
}

