/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde;

import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum MatchRule {
    NONE,
    PERFECT,
    UNQUALIFIED,
    EQUIVALENT,
    COMPATIBLE,
    GREATER_OR_EQUAL;


    public static MatchRule fromPDE(int match) {
        MatchRule rule;
        switch (match) {
            case 3: {
                rule = PERFECT;
                break;
            }
            case 1: {
                rule = EQUIVALENT;
                break;
            }
            case 4: {
                rule = GREATER_OR_EQUAL;
                break;
            }
            default: {
                rule = NONE;
            }
        }
        return rule;
    }

    public static MatchRule getMatchRule(String matchRuleString) {
        if (matchRuleString == null) {
            return NONE;
        }
        try {
            return MatchRule.valueOf(matchRuleString.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            return NONE;
        }
    }
}

