/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde;

import java.util.HashSet;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.buckminster.pde.IPDEConstants;
import org.eclipse.buckminster.runtime.LogAwarePlugin;
import org.eclipse.buckminster.runtime.Logger;
import org.osgi.framework.BundleContext;

public class PDEPlugin
extends LogAwarePlugin
implements IPDEConstants {
    private static final HashSet<String> namesOfInterest = new HashSet();
    private static PDEPlugin plugin;
    private static BundleContext context;
    private ResourceBundle resourceBundle;

    static {
        namesOfInterest.add("plugin.xml".toLowerCase(Locale.ENGLISH));
        namesOfInterest.add("feature.xml".toLowerCase(Locale.ENGLISH));
        namesOfInterest.add("site.xml".toLowerCase(Locale.ENGLISH));
        namesOfInterest.add("fragment.xml".toLowerCase(Locale.ENGLISH));
        namesOfInterest.add("build.properties".toLowerCase(Locale.ENGLISH));
        namesOfInterest.add("MANIFEST.MF".toLowerCase(Locale.ENGLISH));
    }

    public static BundleContext getContext() {
        return context;
    }

    public static PDEPlugin getDefault() {
        return plugin;
    }

    public static Logger getLogger() {
        return plugin.getBundleLogger();
    }

    public static String getPluginId() {
        return plugin.getBundle().getSymbolicName();
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = PDEPlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public PDEPlugin() {
        plugin = this;
    }

    public ResourceBundle getResourceBundle() {
        try {
            if (this.resourceBundle == null) {
                this.resourceBundle = ResourceBundle.getBundle("org.eclipse.buckminster.pde.PdePluginResources");
            }
        }
        catch (MissingResourceException x) {
            this.resourceBundle = null;
        }
        return this.resourceBundle;
    }

    public void start(BundleContext ctx) throws Exception {
        context = ctx;
        super.start(ctx);
    }

    public void stop(BundleContext ctx) throws Exception {
        super.stop(ctx);
        context = null;
        plugin = null;
        this.resourceBundle = null;
    }
}

