/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.commands;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.buckminster.cmdline.Option;
import org.eclipse.buckminster.cmdline.OptionDescriptor;
import org.eclipse.buckminster.cmdline.SimpleErrorExitException;
import org.eclipse.buckminster.core.commands.WorkspaceCommand;
import org.eclipse.buckminster.pde.Messages;
import org.eclipse.buckminster.pde.commands.ListTargetDefinitions;
import org.eclipse.buckminster.pde.prefs.BaselineHandler;
import org.eclipse.buckminster.runtime.Buckminster;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.api.tools.internal.model.ApiModelFactory;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.IApiBaselineManager;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetHandle;
import org.eclipse.pde.core.target.ITargetPlatformService;
import org.eclipse.pde.core.target.TargetBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddBaseline
extends WorkspaceCommand {
    private String targetDefinitionName;
    private boolean addAsActive;
    private static final OptionDescriptor OPTION_ACTIVE = new OptionDescriptor('A', "active", 1);

    public String getTargetDefinitionName() {
        return this.targetDefinitionName;
    }

    public boolean isAddAsActive() {
        return this.addAsActive;
    }

    public void setAddAsActive(boolean importAsActive) {
        this.addAsActive = importAsActive;
    }

    public void setTargetDefinitionName(String targetDefinitionName) {
        this.targetDefinitionName = targetDefinitionName;
    }

    protected void getOptionDescriptors(List<OptionDescriptor> appendHere) throws Exception {
        super.getOptionDescriptors(appendHere);
        appendHere.add(OPTION_ACTIVE);
    }

    protected void handleOption(Option option) throws Exception {
        if (option.is(OPTION_ACTIVE)) {
            this.setAddAsActive(true);
        } else {
            super.handleOption(option);
        }
    }

    protected void handleUnparsed(String[] unparsed) throws Exception {
        if (unparsed.length > 1) {
            throw new SimpleErrorExitException(org.eclipse.buckminster.core.Messages.Too_many_arguments);
        }
        if (unparsed.length < 1) {
            throw new SimpleErrorExitException(org.eclipse.buckminster.core.Messages.Too_few_arguments);
        }
        this.setTargetDefinitionName(unparsed[0]);
    }

    protected int internalRun(IProgressMonitor monitor) throws Exception {
        IApiBaselineManager baselineManager = ApiPlugin.getDefault().getApiBaselineManager();
        IApiBaseline[] iApiBaselineArray = baselineManager.getApiBaselines();
        int n = iApiBaselineArray.length;
        int n2 = 0;
        while (n2 < n) {
            IApiBaseline baseline = iApiBaselineArray[n2];
            if (baseline.getName().equals(this.targetDefinitionName)) {
                throw new SimpleErrorExitException(NLS.bind((String)Messages.Baseline_already_exists_0, (Object)this.targetDefinitionName));
            }
            ++n2;
        }
        SubMonitor submon = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        Buckminster bucky = Buckminster.getDefault();
        ITargetPlatformService service = (ITargetPlatformService)bucky.getService(ITargetPlatformService.class);
        ITargetDefinition foundTarget = null;
        ITargetHandle[] iTargetHandleArray = service.getTargets((IProgressMonitor)submon.newChild(1));
        int n3 = iTargetHandleArray.length;
        int n4 = 0;
        while (n4 < n3) {
            ITargetHandle handle = iTargetHandleArray[n4];
            ITargetDefinition target = handle.getTargetDefinition();
            String name = ListTargetDefinitions.getTargetName(target);
            if (name.equals(this.targetDefinitionName)) {
                foundTarget = target;
                break;
            }
            ++n4;
        }
        if (foundTarget == null) {
            throw new SimpleErrorExitException(NLS.bind((String)Messages.Found_no_target_definition_named_0, (Object)this.targetDefinitionName));
        }
        IApiBaseline baseline = this.createBaseline(foundTarget, (IProgressMonitor)submon.newChild(3));
        baselineManager.addApiBaseline(baseline);
        if (this.addAsActive) {
            baselineManager.setDefaultApiBaseline(this.targetDefinitionName);
            BaselineHandler.rebuildApiProjects();
        }
        return 0;
    }

    private IApiBaseline createBaseline(ITargetDefinition target, IProgressMonitor monitor) throws CoreException {
        SubMonitor submon = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        target.resolve((IProgressMonitor)submon.newChild(2));
        TargetBundle[] bundles = target.getBundles();
        ArrayList<IApiComponent> components = new ArrayList<IApiComponent>();
        IApiBaseline baseline = ApiModelFactory.newApiBaseline((String)ListTargetDefinitions.getTargetName(target));
        submon.setWorkRemaining(bundles.length);
        int i = 0;
        while (i < bundles.length) {
            IApiComponent component;
            submon.worked(1);
            if (submon.isCanceled()) {
                throw new OperationCanceledException();
            }
            if (bundles[i].getStatus().isOK() && !bundles[i].isSourceBundle() && (component = ApiModelFactory.newApiComponent((IApiBaseline)baseline, (String)URIUtil.toFile((URI)bundles[i].getBundleInfo().getLocation()).getAbsolutePath())) != null) {
                components.add(component);
            }
            ++i;
        }
        baseline.addApiComponents(components.toArray(new IApiComponent[components.size()]));
        return baseline;
    }
}

