/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.commands;

import java.util.List;
import org.eclipse.buckminster.cmdline.Option;
import org.eclipse.buckminster.cmdline.OptionDescriptor;
import org.eclipse.buckminster.cmdline.SimpleErrorExitException;
import org.eclipse.buckminster.core.commands.WorkspaceCommand;
import org.eclipse.buckminster.pde.Messages;
import org.eclipse.buckminster.pde.prefs.TargetPlatformPathHandler;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddTargetPlatform
extends WorkspaceCommand {
    private String targetPlatformPath;
    private String targetPlatformName;
    private boolean addAsActive;
    private static final OptionDescriptor OPTION_ACTIVE = new OptionDescriptor('A', "active", 1);
    private static final OptionDescriptor OPTION_NAME = new OptionDescriptor('N', "name", 3);

    public String getTargetPlatformName() {
        return this.targetPlatformName;
    }

    public String getTargetPlatformPath() {
        return this.targetPlatformPath;
    }

    public boolean isAddAsActive() {
        return this.addAsActive;
    }

    public void setAddAsActive(boolean importAsActive) {
        this.addAsActive = importAsActive;
    }

    public void setTargetPlatformName(String targetPlatformName) {
        this.targetPlatformName = targetPlatformName;
    }

    public void setTargetPlatformPath(String targetPlatformPath) {
        this.targetPlatformPath = targetPlatformPath;
    }

    protected void getOptionDescriptors(List<OptionDescriptor> appendHere) throws Exception {
        super.getOptionDescriptors(appendHere);
        appendHere.add(OPTION_ACTIVE);
        appendHere.add(OPTION_NAME);
    }

    protected void handleOption(Option option) throws Exception {
        if (option.is(OPTION_ACTIVE)) {
            this.setAddAsActive(true);
        } else if (option.is(OPTION_NAME)) {
            this.setTargetPlatformName(option.getValue());
        } else {
            super.handleOption(option);
        }
    }

    protected void handleUnparsed(String[] unparsed) throws Exception {
        if (unparsed.length > 1) {
            throw new SimpleErrorExitException(org.eclipse.buckminster.core.Messages.Too_many_arguments);
        }
        if (unparsed.length < 1) {
            throw new SimpleErrorExitException(org.eclipse.buckminster.core.Messages.Too_few_arguments);
        }
        this.setTargetPlatformPath(unparsed[0]);
        if (this.getTargetPlatformName() == null) {
            throw new SimpleErrorExitException(Messages.target_platform_must_be_named);
        }
    }

    protected int internalRun(IProgressMonitor monitor) throws Exception {
        TargetPlatformPathHandler.setTargetPlatform(this.getTargetPlatformPath(), this.getTargetPlatformName(), this.isAddAsActive());
        return 0;
    }
}

