/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.commands;

import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.List;
import org.eclipse.buckminster.cmdline.Option;
import org.eclipse.buckminster.cmdline.OptionDescriptor;
import org.eclipse.buckminster.cmdline.SimpleErrorExitException;
import org.eclipse.buckminster.core.commands.WorkspaceCommand;
import org.eclipse.buckminster.download.DownloadManager;
import org.eclipse.buckminster.pde.Messages;
import org.eclipse.buckminster.pde.PDEPlugin;
import org.eclipse.buckminster.pde.internal.PDETargetPlatform;
import org.eclipse.buckminster.runtime.Buckminster;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.buckminster.runtime.URLUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetHandle;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.core.target.ITargetPlatformService;
import org.eclipse.pde.internal.core.target.DirectoryBundleContainer;
import org.eclipse.pde.internal.core.target.IUBundleContainer;
import org.eclipse.pde.internal.core.target.TargetDefinitionPersistenceHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportTargetDefinition
extends WorkspaceCommand {
    private String targetPath;
    private boolean importAsActive;
    private static final OptionDescriptor OPTION_ACTIVE = new OptionDescriptor('A', "active", 1);

    public String getTargetPath() {
        return this.targetPath;
    }

    public boolean isImportAsActive() {
        return this.importAsActive;
    }

    public void setImportAsActive(boolean importAsActive) {
        this.importAsActive = importAsActive;
    }

    public void setTargetPath(String targetPath) {
        this.targetPath = targetPath;
    }

    protected void getOptionDescriptors(List<OptionDescriptor> appendHere) throws Exception {
        super.getOptionDescriptors(appendHere);
        appendHere.add(OPTION_ACTIVE);
    }

    protected void handleOption(Option option) throws Exception {
        if (option.is(OPTION_ACTIVE)) {
            this.setImportAsActive(true);
        } else {
            super.handleOption(option);
        }
    }

    protected void handleUnparsed(String[] unparsed) throws Exception {
        if (unparsed.length > 1) {
            throw new SimpleErrorExitException(org.eclipse.buckminster.core.Messages.Too_many_arguments);
        }
        if (unparsed.length == 1) {
            this.setTargetPath(unparsed[0]);
        }
    }

    protected int internalRun(IProgressMonitor monitor) throws Exception {
        ITargetDefinition target;
        IContainer container;
        IPath path;
        if (this.targetPath == null) {
            throw new SimpleErrorExitException(org.eclipse.buckminster.core.Messages.Too_few_arguments);
        }
        Buckminster bucky = Buckminster.getDefault();
        ITargetPlatformService service = (ITargetPlatformService)bucky.getService(ITargetPlatformService.class);
        URI uri = URLUtils.normalizeToURI((String)this.targetPath, (boolean)false);
        ITargetHandle handle = null;
        if ("file".equalsIgnoreCase(uri.getScheme()) && (path = Path.fromPortableString((String)uri.getPath())).segmentCount() > 1 && (container = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation(path.removeLastSegments(1))) != null) {
            handle = service.getTarget(container.getFile((IPath)new Path(path.lastSegment())));
        }
        if (handle == null) {
            target = service.newTarget();
            InputStream input = null;
            try {
                input = DownloadManager.read((URL)uri.toURL(), null);
                TargetDefinitionPersistenceHelper.initFromXML((ITargetDefinition)target, (InputStream)input);
            }
            catch (Throwable throwable) {
                IOUtils.close(input);
                throw throwable;
            }
            IOUtils.close((Closeable)input);
            service.saveTargetDefinition(target);
        } else {
            target = handle.getTargetDefinition();
        }
        ITargetLocation[] containers = target.getTargetLocations();
        if (containers == null) {
            throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.target_0_has_no_containers, (Object)this.targetPath), (Object[])new Object[0]);
        }
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)(containers.length * 100 + (this.importAsActive ? 0 : 50)));
        ITargetLocation[] iTargetLocationArray = containers;
        int n = containers.length;
        int n2 = 0;
        while (n2 < n) {
            ITargetLocation container2 = iTargetLocationArray[n2];
            SubMonitor child = mon.newChild(50);
            if (container2 instanceof IUBundleContainer) {
                this.verifyIUBundleContainer(target, (IUBundleContainer)container2, child);
            } else if (container2 instanceof DirectoryBundleContainer) {
                this.verifyDirectoryBundleContainer(target, (DirectoryBundleContainer)container2, child);
            } else {
                this.verifyBundleContainer(target, container2, child);
            }
            MonitorUtils.testCancelStatus((IProgressMonitor)mon);
            ++n2;
        }
        if (this.importAsActive) {
            PDETargetPlatform.setTargetActive(target, (IProgressMonitor)mon.newChild(50));
        }
        MonitorUtils.done((IProgressMonitor)monitor);
        return 0;
    }

    private void verifyBundleContainer(ITargetDefinition target, ITargetLocation container, SubMonitor monitor) throws CoreException {
        IStatus status = container.resolve(target, (IProgressMonitor)monitor);
        if (status.getSeverity() == 4) {
            throw new CoreException(status);
        }
    }

    private void verifyDirectoryBundleContainer(ITargetDefinition target, DirectoryBundleContainer container, SubMonitor monitor) throws CoreException {
        String path = container.getLocation(true);
        if (path == null) {
            throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.dc_of_target_0_lacks_location, (Object)this.targetPath), (Object[])new Object[0]);
        }
        File tpDir = new File(path);
        if (!tpDir.exists()) {
            PDEPlugin.getLogger().warning(NLS.bind((String)Messages.tpdir_0_does_not_exist, (Object)path), new Object[0]);
            tpDir.mkdirs();
            if (!tpDir.isDirectory()) {
                throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.unable_to_create_tpdir_0, (Object)path), (Object[])new Object[0]);
            }
        }
        this.verifyBundleContainer(target, (ITargetLocation)container, monitor);
    }

    private void verifyIUBundleContainer(ITargetDefinition target, IUBundleContainer container, SubMonitor monitor) throws CoreException {
        URI[] repositories = container.getRepositories();
        if (repositories == null || repositories.length == 0) {
            throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.ssc_of_target_0_lacks_repository, (Object)this.targetPath), (Object[])new Object[0]);
        }
        Buckminster bucky = Buckminster.getDefault();
        IProvisioningAgent agent = (IProvisioningAgent)bucky.getService(IProvisioningAgent.class);
        IMetadataRepositoryManager repoManager = (IMetadataRepositoryManager)agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
        int top = repositories.length;
        monitor.beginTask(null, 100 + top * 100);
        MultiStatus problems = new MultiStatus(PDEPlugin.getPluginId(), 0, NLS.bind((String)Messages.unable_to_load_all_units_for_ssc_of_target_0, (Object)this.targetPath), null);
        int idx = 0;
        while (idx < top) {
            try {
                repoManager.loadRepository(repositories[idx], (IProgressMonitor)monitor.newChild(100));
            }
            catch (CoreException e) {
                problems.add(e.getStatus());
            }
            ++idx;
        }
        try {
            this.verifyBundleContainer(target, (ITargetLocation)container, monitor.newChild(100));
        }
        catch (CoreException e) {
            problems.add(e.getStatus());
        }
        if (problems.getSeverity() == 4) {
            throw new CoreException((IStatus)problems);
        }
        monitor.done();
    }
}

