/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.commands;

import java.io.PrintStream;
import org.eclipse.buckminster.core.ITargetPlatform;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.TargetPlatform;
import org.eclipse.buckminster.core.commands.WorkspaceCommand;
import org.eclipse.buckminster.runtime.Buckminster;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetHandle;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.core.target.ITargetPlatformService;

public class ListTargetDefinitions
extends WorkspaceCommand {
    public static String getTargetName(ITargetDefinition target) throws CoreException {
        ITargetLocation[] bundleContainers;
        String name = target.getName();
        if (name != null) {
            if ((name = name.trim()).length() > 0) {
                return name;
            }
            name = null;
        }
        if ((bundleContainers = target.getTargetLocations()) != null && bundleContainers.length == 1) {
            return bundleContainers[0].getLocation(false);
        }
        return "<no name>";
    }

    protected int internalRun(IProgressMonitor monitor) throws Exception {
        String name;
        int nameLen;
        ITargetDefinition target;
        PrintStream out = System.out;
        out.println(NLS.bind((String)Messages.Using_workspace_at_0, (Object)Platform.getInstanceLocation().getURL().toString()));
        Buckminster bucky = Buckminster.getDefault();
        ITargetPlatformService service = (ITargetPlatformService)bucky.getService(ITargetPlatformService.class);
        int maxNameLen = -1;
        ITargetHandle[] handles = service.getTargets(monitor);
        int top = handles.length;
        if (top == 0) {
            out.println(Messages.No_target_definitions_found_in_workspace);
            return 0;
        }
        ITargetHandle activeHandle = service.getWorkspaceTargetHandle();
        ITargetDefinition activeTarget = null;
        ITargetDefinition[] targets = new ITargetDefinition[top];
        int idx = 0;
        while (idx < top) {
            ITargetHandle targetHandle = handles[idx];
            targets[idx] = target = targetHandle.getTargetDefinition();
            if (targetHandle.equals(activeHandle)) {
                activeTarget = target;
            }
            if ((nameLen = (name = ListTargetDefinitions.getTargetName(target)).length()) > maxNameLen) {
                maxNameLen = nameLen;
            }
            ++idx;
        }
        ITargetPlatform tp = TargetPlatform.getInstance();
        int idx2 = 0;
        while (idx2 < top) {
            target = targets[idx2];
            name = ListTargetDefinitions.getTargetName(target);
            nameLen = name.length();
            if (target == activeTarget) {
                out.print('*');
            } else {
                out.print(' ');
            }
            out.print(' ');
            out.print(name);
            while (nameLen++ < maxNameLen) {
                out.print(' ');
            }
            out.print(" : ");
            String os = target.getOS();
            String ws = target.getWS();
            String arch = target.getArch();
            String nl = target.getNL();
            if (os == null) {
                os = tp.getOS();
            }
            if (ws == null) {
                ws = tp.getWS();
            }
            if (arch == null) {
                arch = tp.getArch();
            }
            if (nl == null) {
                nl = tp.getNL();
            }
            out.print(os);
            out.print(',');
            out.print(ws);
            out.print(',');
            out.print(arch);
            if (nl != null) {
                out.print('/');
                out.print(nl);
            }
            out.println();
            ++idx2;
        }
        return 0;
    }
}

