/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.cspecgen;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.selectors.SelectorUtils;
import org.eclipse.buckminster.core.RMContext;
import org.eclipse.buckminster.core.common.model.ExpandingProperties;
import org.eclipse.buckminster.core.cspec.IComponentRequest;
import org.eclipse.buckminster.core.cspec.builder.ActionBuilder;
import org.eclipse.buckminster.core.cspec.builder.ArtifactBuilder;
import org.eclipse.buckminster.core.cspec.builder.AttributeBuilder;
import org.eclipse.buckminster.core.cspec.builder.CSpecBuilder;
import org.eclipse.buckminster.core.cspec.builder.ComponentRequestBuilder;
import org.eclipse.buckminster.core.cspec.builder.GroupBuilder;
import org.eclipse.buckminster.core.cspec.builder.PrerequisiteBuilder;
import org.eclipse.buckminster.core.cspec.model.ComponentName;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.cspec.model.UpToDatePolicy;
import org.eclipse.buckminster.core.helpers.FileHandle;
import org.eclipse.buckminster.core.helpers.FilterUtils;
import org.eclipse.buckminster.core.helpers.PropertiesParser;
import org.eclipse.buckminster.core.helpers.TextUtils;
import org.eclipse.buckminster.core.query.model.ComponentQuery;
import org.eclipse.buckminster.core.reader.ICatalogReader;
import org.eclipse.buckminster.core.reader.IStreamConsumer;
import org.eclipse.buckminster.core.resolver.NodeQuery;
import org.eclipse.buckminster.core.version.VersionHelper;
import org.eclipse.buckminster.osgi.filter.FilterFactory;
import org.eclipse.buckminster.pde.IPDEConstants;
import org.eclipse.buckminster.pde.MatchRule;
import org.eclipse.buckminster.pde.Messages;
import org.eclipse.buckminster.pde.PDEPlugin;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.buckminster.runtime.Trivial;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.StringHelper;
import org.eclipse.equinox.internal.p2.metadata.VersionFormat;
import org.eclipse.equinox.internal.p2.publisher.eclipse.IProductDescriptor;
import org.eclipse.equinox.internal.p2.publisher.eclipse.ProductFile;
import org.eclipse.equinox.p2.metadata.IVersionFormat;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.plugin.IFragment;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.build.IBuildPropertiesConstants;
import org.eclipse.pde.internal.build.IXMLConstants;
import org.eclipse.pde.internal.core.ibundle.IBundleModel;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.core.text.bundle.ManifestHeader;
import org.eclipse.pde.internal.core.text.bundle.RequireBundleObject;
import org.osgi.framework.BundleException;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CSpecGenerator
implements IBuildPropertiesConstants,
IPDEConstants,
IXMLConstants {
    public static final IPath OUTPUT_DIR_JAR = OUTPUT_DIR.append("jar");
    public static final IPath OUTPUT_DIR_SOURCE_JAR = OUTPUT_DIR.append("source.jar");
    public static final IPath OUTPUT_DIR_FRAGMENTS = OUTPUT_DIR.append("fragments");
    public static final IPath OUTPUT_DIR_FRAGMENTS_SOURCE = OUTPUT_DIR.append("fragments.source");
    public static final IPath OUTPUT_DIR_SITE = OUTPUT_DIR.append("site");
    public static final IPath OUTPUT_DIR_SITE_REPACKED = OUTPUT_DIR.append("site.repacked");
    public static final IPath OUTPUT_DIR_SITE_PACKED = OUTPUT_DIR.append("site.packed");
    public static final IPath OUTPUT_DIR_SITE_SIGNED = OUTPUT_DIR.append("site.signed");
    public static final IPath OUTPUT_DIR_TEMP = OUTPUT_DIR.append("temp");
    public static final String LAUNCHER_BUNDLE = "org.eclipse.equinox.launcher";
    public static final String LAUNCHER_FEATURE_3_2 = "org.eclipse.platform.launchers";
    public static final String LAUNCHER_FEATURE = "org.eclipse.equinox.executable";
    public static final String RCP_FEATURE = "org.eclipse.rcp";
    public static final org.eclipse.buckminster.osgi.filter.Filter SOURCE_FILTER;
    public static final org.eclipse.buckminster.osgi.filter.Filter SIGNING_ENABLED;
    public static final org.eclipse.buckminster.osgi.filter.Filter SIGNING_DISABLED;
    public static final org.eclipse.buckminster.osgi.filter.Filter PACK_ENABLED;
    public static final org.eclipse.buckminster.osgi.filter.Filter PACK_DISABLED;
    public static final org.eclipse.buckminster.osgi.filter.Filter SIGNING_AND_PACK_DISABLED;
    public static final org.eclipse.buckminster.osgi.filter.Filter SIGNING_ENABLED_AND_PACK_DISABLED;
    public static final org.eclipse.buckminster.osgi.filter.Filter INCLUDE_TOP_FILTER;
    public static final org.eclipse.buckminster.osgi.filter.Filter INCLUDE_TOP_SOURCE_FILTER;
    private static final ImportSpecification[] noRequiredBundles;
    private final CSpecBuilder cspecBuilder;
    private final ICatalogReader reader;
    private Map<String, String> properties;

    static {
        try {
            SOURCE_FILTER = FilterFactory.newInstance((String)"(!(cbi.include.source=false))");
            INCLUDE_TOP_FILTER = FilterFactory.newInstance((String)"(site.include.top=true)");
            INCLUDE_TOP_SOURCE_FILTER = FilterFactory.newInstance((String)"(&(site.include.top=true)(!(cbi.include.source=false)))");
            SIGNING_ENABLED = FilterFactory.newInstance((String)"(site.signing=true)");
            SIGNING_DISABLED = FilterFactory.newInstance((String)"(!(site.signing=true))");
            PACK_ENABLED = FilterFactory.newInstance((String)"(site.pack200=true)");
            PACK_DISABLED = FilterFactory.newInstance((String)"(!(site.pack200=true))");
            SIGNING_AND_PACK_DISABLED = FilterFactory.newInstance((String)"(&(!(site.pack200=true))(!(site.signing=true)))");
            SIGNING_ENABLED_AND_PACK_DISABLED = FilterFactory.newInstance((String)"(&(!(site.pack200=true))(site.signing=true))");
        }
        catch (InvalidSyntaxException e) {
            throw new ExceptionInInitializerError(e);
        }
        noRequiredBundles = new ImportSpecification[0];
    }

    public static VersionRange createRuleBasedRange(MatchRule matchRule, MatchRule retainLowerBound, Version version) {
        if (version == null || Version.emptyVersion.equals(version)) {
            return VersionRange.emptyRange;
        }
        boolean qualifierTag = "qualifier".equals(VersionHelper.getQualifier((Version)version));
        Version lower = version;
        if (qualifierTag) {
            lower = VersionHelper.replaceQualifier((Version)version, null);
        }
        Version upper = CSpecGenerator.limitUpperWithMatchRule(version, matchRule, qualifierTag);
        if (matchRule == MatchRule.PERFECT || matchRule == MatchRule.NONE) {
            return new VersionRange(lower, true, upper, !qualifierTag);
        }
        switch (retainLowerBound) {
            case PERFECT: {
                break;
            }
            case UNQUALIFIED: 
            case EQUIVALENT: {
                lower = CSpecGenerator.limitLowerWithMatchRule(version, retainLowerBound);
                break;
            }
            default: {
                lower = CSpecGenerator.limitLowerWithMatchRule(version, MatchRule.COMPATIBLE);
            }
        }
        return new VersionRange(lower, true, upper, matchRule == MatchRule.GREATER_OR_EQUAL);
    }

    public static Version limitLowerWithMatchRule(Version v, MatchRule matchRule) {
        if (v == null || matchRule == MatchRule.NONE || matchRule == MatchRule.PERFECT) {
            return v;
        }
        org.osgi.framework.Version ov = new org.osgi.framework.Version(v.toString());
        switch (matchRule) {
            case UNQUALIFIED: {
                v = Version.createOSGi((int)ov.getMajor(), (int)ov.getMinor(), (int)ov.getMicro());
                break;
            }
            case EQUIVALENT: {
                v = Version.createOSGi((int)ov.getMajor(), (int)ov.getMinor(), (int)0);
                break;
            }
            case COMPATIBLE: {
                v = Version.createOSGi((int)ov.getMajor(), (int)0, (int)0);
                break;
            }
            default: {
                v = Version.createOSGi((int)ov.getMajor(), (int)ov.getMinor(), (int)ov.getMicro());
            }
        }
        return v;
    }

    public static Version limitUpperWithMatchRule(Version v, MatchRule matchRule, boolean qualifierTag) {
        org.osgi.framework.Version ov = new org.osgi.framework.Version(v.toString());
        switch (matchRule) {
            case UNQUALIFIED: {
                v = Version.createOSGi((int)ov.getMajor(), (int)ov.getMinor(), (int)(ov.getMicro() + 1));
                break;
            }
            case EQUIVALENT: {
                v = Version.createOSGi((int)ov.getMajor(), (int)(ov.getMinor() + 1), (int)0);
                break;
            }
            case COMPATIBLE: {
                v = Version.createOSGi((int)(ov.getMajor() + 1), (int)0, (int)0);
                break;
            }
            case NONE: 
            case PERFECT: {
                if (!qualifierTag) break;
                v = Version.createOSGi((int)ov.getMajor(), (int)ov.getMinor(), (int)(ov.getMicro() + 1));
                break;
            }
            default: {
                v = Version.MAX_VERSION;
            }
        }
        return v;
    }

    protected static String buildArtifactName(String id, String ver, boolean asJar) {
        StringBuilder bld = new StringBuilder();
        bld.append(id);
        if (ver != null) {
            bld.append('_');
            bld.append(ver);
        }
        if (asJar) {
            bld.append(".jar");
        } else {
            bld.append('/');
        }
        return bld.toString();
    }

    protected static ImportSpecification[] getImports(IPluginBase plugin) throws CoreException {
        IPluginModelBase model = plugin.getPluginModel();
        BundleDescription bundleDesc = model.getBundleDescription();
        if (bundleDesc != null) {
            BundleSpecification[] imports = bundleDesc.getRequiredBundles();
            if (imports == null) {
                return noRequiredBundles;
            }
            int sz = imports.length;
            if (sz == 0) {
                return noRequiredBundles;
            }
            ImportSpecification[] importSpecs = new ImportSpecification[sz];
            while (--sz >= 0) {
                importSpecs[sz] = new ImportSpecification(imports[sz]);
            }
            return importSpecs;
        }
        if (!(model instanceof IBundlePluginModelBase)) {
            return noRequiredBundles;
        }
        IBundleModel bundleModel = ((IBundlePluginModelBase)model).getBundleModel();
        ManifestHeader header = (ManifestHeader)bundleModel.getBundle().getManifestHeader("Require-Bundle");
        if (header == null) {
            return noRequiredBundles;
        }
        ManifestElement[] elems = null;
        try {
            elems = ManifestElement.parseHeader((String)header.getKey(), (String)header.getValue());
        }
        catch (BundleException bundleException) {
            // empty catch block
        }
        if (elems == null) {
            return noRequiredBundles;
        }
        int sz = elems.length;
        if (sz == 0) {
            return noRequiredBundles;
        }
        ImportSpecification[] importSpecs = new ImportSpecification[sz];
        while (--sz >= 0) {
            RequireBundleObject r = new RequireBundleObject(header, elems[sz]);
            importSpecs[sz] = new ImportSpecification(r.getId(), new VersionRange(r.getVersion()), r.isReexported(), r.isOptional());
        }
        return importSpecs;
    }

    protected CSpecGenerator(CSpecBuilder cspecBuilder, ICatalogReader reader) {
        this.cspecBuilder = cspecBuilder;
        this.reader = reader;
    }

    public VersionRange convertMatchRule(MatchRule pdeMatchRule, String version) throws CoreException {
        if ((version = Trivial.trim((String)version)) == null || version.equals("0.0.0")) {
            return null;
        }
        char c = version.charAt(0);
        if (c == '[' || c == '(') {
            return new VersionRange(version);
        }
        return CSpecGenerator.createRuleBasedRange(pdeMatchRule, MatchRule.NONE, Version.parseVersion((String)version));
    }

    public abstract void generate(IProgressMonitor var1) throws CoreException;

    public CSpecBuilder getCSpec() {
        return this.cspecBuilder;
    }

    public ICatalogReader getReader() {
        return this.reader;
    }

    protected ActionBuilder addAntAction(String actionName, String targetName, boolean asPublic) throws CoreException {
        ActionBuilder action = this.cspecBuilder.addAction(actionName, asPublic, "ant", false);
        action.addActorProperty("targets", targetName, false);
        action.addActorProperty("buildFileId", "buckminster.pdetasks", false);
        return action;
    }

    protected void addBundleHostDependency(IFragmentModel fragmentModel) throws CoreException {
        IFragment fragment = fragmentModel.getFragment();
        ComponentRequestBuilder bundleHostDep = this.cspecBuilder.createDependencyBuilder();
        bundleHostDep.setName(fragment.getPluginId());
        bundleHostDep.setVersionRange(VersionHelper.createRange((IVersionFormat)VersionFormat.OSGI_FORMAT, (String)fragment.getPluginVersion()));
        bundleHostDep.setComponentTypeID("osgi.bundle");
        try {
            bundleHostDep.setFilter(FilterFactory.newInstance((String)"(bundleHost=true)"));
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
        this.addDependency(bundleHostDep);
    }

    protected boolean addDependency(ComponentRequestBuilder dependency) throws CoreException {
        return this.cspecBuilder.addDependency((IComponentRequest)dependency);
    }

    protected void addExternalPrerequisite(GroupBuilder group, IComponentRequest dependency, String name) throws CoreException {
        PrerequisiteBuilder pqBld = group.createPrerequisiteBuilder();
        pqBld.setComponentName(dependency.getName());
        pqBld.setComponentType(dependency.getComponentTypeID());
        pqBld.setVersionRange(dependency.getVersionRange());
        pqBld.setName(name);
        group.addPrerequisite(pqBld);
    }

    @Deprecated
    protected void addExternalPrerequisite(GroupBuilder group, String component, String type, String name) throws CoreException {
        PrerequisiteBuilder pqBld = group.createPrerequisiteBuilder();
        pqBld.setComponentName(component);
        pqBld.setComponentType(type);
        pqBld.setName(name);
        group.addPrerequisite(pqBld);
    }

    protected void addProductBundles(IProductDescriptor productDescriptor) throws CoreException {
        if (productDescriptor.useFeatures()) {
            return;
        }
        List bundles = productDescriptor.getBundles(true);
        if (bundles.size() == 0) {
            return;
        }
        ComponentQuery query = this.getReader().getNodeQuery().getComponentQuery();
        CSpecBuilder cspec = this.getCSpec();
        GroupBuilder fullClean = cspec.getRequiredGroup(ATTRIBUTE_FULL_CLEAN);
        GroupBuilder bundleJars = cspec.getRequiredGroup("bundle.jars");
        String self = null;
        if ("osgi.bundle".equals(cspec.getComponentTypeID())) {
            self = cspec.getName();
        }
        for (IVersionedId bundle : bundles) {
            ComponentRequestBuilder dependency;
            String pluginId = bundle.getId();
            if (self != null && self.equals(pluginId) || pluginId.equals("system.bundle") || this.skipComponent(query, dependency = this.createDependency(bundle, "osgi.bundle")) || !this.addDependency(dependency)) continue;
            fullClean.addExternalPrerequisite((IComponentRequest)dependency, ATTRIBUTE_FULL_CLEAN);
            bundleJars.addExternalPrerequisite((IComponentRequest)dependency, "bundle.jars");
        }
    }

    protected void addProductFeatures(IProductDescriptor productDescriptor) throws CoreException {
    }

    protected boolean addProducts(IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(null, 2000);
        try {
            List productConfigs = this.reader.getRootFiles(PRODUCT_CONFIGURATION_FILE_PATTERN, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)500));
            if (productConfigs.size() == 0) {
                return false;
            }
            boolean theOneAndOnly = productConfigs.size() == 1;
            int ticksPerConfig = 1500 / productConfigs.size();
            for (FileHandle productConfig : productConfigs) {
                this.addProduct(productConfig, theOneAndOnly, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)ticksPerConfig));
            }
            boolean bl = theOneAndOnly;
            return bl;
        }
        catch (IOException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
        finally {
            monitor.done();
        }
    }

    protected ActionBuilder createCopyPluginsAction() throws CoreException {
        ActionBuilder copyPlugins = this.addAntAction("copy.plugins", "copy.group", false);
        copyPlugins.addLocalPrerequisite("bundle.jars");
        if (this.isFeature()) {
            copyPlugins.addLocalPrerequisite("source.bundle.jars");
        }
        copyPlugins.setPrerequisitesAlias("action.requirements");
        copyPlugins.setProductAlias("action.output");
        copyPlugins.setProductBase(OUTPUT_DIR_SITE.append("plugins"));
        copyPlugins.setUpToDatePolicy(UpToDatePolicy.MAPPER);
        return copyPlugins;
    }

    protected ComponentRequestBuilder createDependency(ImportSpecification pluginImport, String category) throws CoreException {
        org.eclipse.buckminster.osgi.filter.Filter filter = null;
        if (pluginImport.isOptional()) {
            filter = ComponentRequest.P2_OPTIONAL_FILTER;
        }
        return this.createDependency(pluginImport.getName(), category, pluginImport.getVersionRange(), filter);
    }

    protected ComponentRequestBuilder createDependency(IVersionedId versionedName, String componentType) throws CoreException {
        String versionRange = null;
        Version v = versionedName.getVersion();
        if (v != null && !Version.emptyVersion.equals(v)) {
            versionRange = new VersionRange(v, true, v, true).toString();
        }
        return this.createDependency(versionedName.getId(), componentType, versionRange, null);
    }

    protected ComponentRequestBuilder createDependency(String name, String componentType, String versionDesignator, org.eclipse.buckminster.osgi.filter.Filter filter) throws CoreException {
        if ((versionDesignator = Trivial.trim((String)versionDesignator)) != null && versionDesignator.equals("0.0.0")) {
            versionDesignator = null;
        }
        return this.createDependency(name, componentType, VersionHelper.createRange((IVersionFormat)VersionFormat.OSGI_FORMAT, (String)versionDesignator), filter);
    }

    protected ComponentRequestBuilder createDependency(String name, String componentType, String version, MatchRule pdeMatchRule, org.eclipse.buckminster.osgi.filter.Filter filter) throws CoreException {
        return this.createDependency(name, componentType, this.convertMatchRule(pdeMatchRule, version), filter);
    }

    protected ComponentRequestBuilder createDependency(String name, String componentType, VersionRange versionRange, org.eclipse.buckminster.osgi.filter.Filter filter) throws CoreException {
        ComponentRequestBuilder bld = this.getCSpec().createDependencyBuilder();
        bld.setName(name);
        bld.setComponentTypeID(componentType);
        bld.setVersionRange(versionRange);
        bld.setFilter(filter);
        return bld;
    }

    protected void createSiteAction(String rawSiteAttribute, String siteDefiningAttribute) throws CoreException {
        ActionBuilder siteBuilder = this.getCSpec().addAction("site.p2", true, "p2SiteGenerator", false);
        siteBuilder.addLocalPrerequisite(rawSiteAttribute, "site", SIGNING_AND_PACK_DISABLED);
        siteBuilder.addLocalPrerequisite("site.packed", "site", PACK_ENABLED);
        siteBuilder.addLocalPrerequisite("site.signed", "site", SIGNING_ENABLED_AND_PACK_DISABLED);
        siteBuilder.addLocalPrerequisite(siteDefiningAttribute, "site.definer");
        siteBuilder.addLocalPrerequisite("product.configuration.exports", "product.configs");
        siteBuilder.setProductBase(IPDEConstants.OUTPUT_DIR_SITE_P2);
        siteBuilder.setUpToDatePolicy(UpToDatePolicy.ACTOR);
    }

    protected void createSitePackAction(String rawSiteAttribute) throws CoreException {
        ActionBuilder siteBuilder = this.getCSpec().addAction("site.packed", true, "jarProcessor", false);
        siteBuilder.addLocalPrerequisite(rawSiteAttribute, "jar.folder", SIGNING_DISABLED);
        siteBuilder.addLocalPrerequisite("site.signed", "jar.folder", SIGNING_ENABLED);
        siteBuilder.getProperties().put("command", (Object)"pack");
        siteBuilder.setProductBase(OUTPUT_DIR_SITE_PACKED);
        siteBuilder.setUpToDatePolicy(UpToDatePolicy.MAPPER);
    }

    protected void createSiteRepackAction(String rawSiteAttribute) throws CoreException {
        ActionBuilder siteBuilder = this.getCSpec().addAction("site.repacked", false, "jarProcessor", false);
        siteBuilder.addLocalPrerequisite(rawSiteAttribute, "jar.folder");
        siteBuilder.getProperties().put("command", (Object)"repack");
        siteBuilder.setProductBase(OUTPUT_DIR_SITE_REPACKED);
        siteBuilder.setUpToDatePolicy(UpToDatePolicy.MAPPER);
    }

    protected void createSiteSignAction(String rawSiteAttribute) throws CoreException {
        ActionBuilder siteBuilder = this.getCSpec().addAction("site.signed", true, "ant", false);
        ExpandingProperties actorProps = siteBuilder.getActorProperties();
        actorProps.put("buildFileId", "buckminster.signing");
        actorProps.put("targets", "sign.jars");
        siteBuilder.setPrerequisitesAlias("action.requirements");
        siteBuilder.addLocalPrerequisite("site.repacked", null, PACK_ENABLED);
        siteBuilder.addLocalPrerequisite(rawSiteAttribute, null, PACK_DISABLED);
        siteBuilder.setProductBase(OUTPUT_DIR_SITE_SIGNED);
        siteBuilder.setProductAlias("action.output");
        siteBuilder.setUpToDatePolicy(UpToDatePolicy.MAPPER);
    }

    protected void createSiteZipAction() throws CoreException {
        ActionBuilder siteZip = this.addAntAction("site.p2.zip", "create.site.zip", true);
        siteZip.addLocalPrerequisite("manifest", "manifest");
        siteZip.addLocalPrerequisite("site.p2", "action.requirements");
        siteZip.setProductBase(OUTPUT_DIR_SITE_ZIP);
        siteZip.setProductAlias("action.output");
        siteZip.setUpToDatePolicy(UpToDatePolicy.COUNT);
        siteZip.setProductFileCount(1);
    }

    protected String expand(String value) throws CoreException {
        if ((value = TextUtils.notEmptyTrimmedString((String)value)) == null) {
            return null;
        }
        if (value.charAt(0) != '%') {
            return value;
        }
        String expValue = this.getProperties().get(value.substring(1));
        if (expValue != null) {
            value = expValue;
        }
        return value;
    }

    protected List<String> expandBinFiles(File baseDir, IBuild build) throws CoreException {
        IBuildEntry includes = build.getEntry("bin.includes");
        IBuildEntry excludes = build.getEntry("bin.excludes");
        return this.expandFiles(baseDir, includes, excludes);
    }

    protected List<String> expandBinFiles(File baseDir, Map<String, String> props) throws CoreException {
        String includes = props.get("bin.includes");
        String excludes = props.get("bin.excludes");
        return this.expandFiles(baseDir, StringHelper.getArrayFromString((String)includes, (char)','), StringHelper.getArrayFromString((String)excludes, (char)','));
    }

    protected List<String> expandSrcFiles(File baseDir, IBuild build) throws CoreException {
        IBuildEntry includes = build.getEntry("src.includes");
        IBuildEntry excludes = build.getEntry("src.excludes");
        return this.expandFiles(baseDir, includes, excludes);
    }

    protected AttributeBuilder generateRemoveDirAction(String dirTag, IPath dirPath, boolean publ) throws CoreException {
        return this.generateRemoveDirAction(dirTag, dirPath, publ, "buckminster.rm." + dirTag + ".dir");
    }

    protected AttributeBuilder generateRemoveDirAction(String dirTag, IPath dirPath, boolean publ, String actionName) throws CoreException {
        ActionBuilder rmDir = this.addAntAction(actionName, "delete.dir", publ);
        rmDir.addProperty("dir.to.delete", dirPath.toPortableString(), false);
        return rmDir;
    }

    protected abstract String getProductOutputFolder(String var1);

    protected Map<String, String> getProperties() throws CoreException {
        if (this.properties == null) {
            try {
                this.properties = (Map)this.reader.readFile(this.getPropertyFileName(), (IStreamConsumer)new PropertiesParser(), (IProgressMonitor)new NullProgressMonitor());
            }
            catch (FileNotFoundException e) {
                this.properties = Collections.emptyMap();
            }
            catch (IOException e) {
                throw BuckminsterException.wrap((Throwable)e);
            }
        }
        return this.properties;
    }

    protected abstract String getPropertyFileName();

    protected boolean isFeature() {
        return false;
    }

    protected void setFilter(String filterStr) throws CoreException {
        if ((filterStr = TextUtils.notEmptyTrimmedString((String)filterStr)) == null) {
            return;
        }
        try {
            org.eclipse.buckminster.osgi.filter.Filter filter = FilterFactory.newInstance((String)filterStr);
            this.getCSpec().setFilter(FilterUtils.replaceAttributeNames((Filter)filter, (String)"osgi", (String)"target"));
        }
        catch (InvalidSyntaxException e) {
            NodeQuery query = this.reader.getNodeQuery();
            Status status = new Status(2, PDEPlugin.getPluginId(), String.valueOf(Messages.manifest_has_malformed_LDAP_rule_for) + "Eclipse-PlatformFilter" + ": " + e.getMessage());
            RMContext ctx = query.getContext();
            if (!ctx.isContinueOnError()) {
                throw new CoreException((IStatus)status);
            }
            ctx.addRequestStatus((IComponentRequest)query.getComponentRequest(), (IStatus)status);
        }
    }

    protected boolean skipComponent(ComponentQuery query, ComponentRequestBuilder bld) {
        return query.skipComponent(new ComponentName(bld.getName(), bld.getComponentTypeID()), (Map)this.getReader().getNodeQuery().getContext());
    }

    private void addProduct(FileHandle productConfig, boolean theOneAndOnly, IProgressMonitor monitor) throws CoreException, IOException {
        try {
            ProductFile productDescriptor;
            File productConfigFile = productConfig.getFile();
            try {
                productDescriptor = new ProductFile(productConfigFile.getAbsolutePath());
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw BuckminsterException.wrap((Throwable)e);
            }
            CSpecBuilder cspec = this.getCSpec();
            String productId = productDescriptor.getId();
            if (productId == null || productId.length() == 0) {
                PDEPlugin.getLogger().warning(NLS.bind((String)Messages.No_productId_found_in_0, (Object)productConfigFile.getAbsolutePath()), new Object[0]);
                productId = "<undefined product ID>";
            }
            ArtifactBuilder productConfigArtifact = cspec.addArtifact(productId, false, null);
            productConfigArtifact.addPath(Path.fromOSString((String)productConfigFile.getName()));
            GroupBuilder productConfigs = cspec.getGroup("product.configurations");
            if (productConfigs == null) {
                productConfigs = cspec.addGroup("product.configurations", false);
                cspec.getRequiredGroup("product.configuration.exports").addLocalPrerequisite((AttributeBuilder)productConfigs);
            }
            productConfigs.addLocalPrerequisite((AttributeBuilder)productConfigArtifact);
            if (productDescriptor.useFeatures()) {
                this.addProductFeatures((IProductDescriptor)productDescriptor);
            } else {
                this.addProductBundles((IProductDescriptor)productDescriptor);
            }
            if (!theOneAndOnly) {
                return;
            }
            if (!this.isFeature()) {
                GroupBuilder featureExports = cspec.addGroup("feature.exports", true);
                featureExports.addLocalPrerequisite((AttributeBuilder)this.createCopyPluginsAction());
                featureExports.setPrerequisiteRebase(OUTPUT_DIR_SITE);
            }
            this.createSiteRepackAction("feature.exports");
            this.createSiteSignAction("feature.exports");
            this.createSitePackAction("feature.exports");
            this.createSiteAction("feature.exports", productConfigArtifact.getName());
            this.createSiteZipAction();
        }
        finally {
            if (productConfig.isTemporary()) {
                productConfig.getFile().delete();
            }
        }
    }

    private List<String> expandFiles(File baseDir, IBuildEntry includes, IBuildEntry excludes) throws CoreException {
        if (includes == null && excludes == null) {
            return Collections.emptyList();
        }
        String[] incTokens = includes == null ? StringHelper.EMPTY_ARRAY : includes.getTokens();
        String[] excTokens = excludes == null ? StringHelper.EMPTY_ARRAY : excludes.getTokens();
        return this.expandFiles(baseDir, incTokens, excTokens);
    }

    private List<String> expandFiles(File baseDir, String[] includes, String[] excludes) throws CoreException {
        int n;
        includes = this.replaceVariables(includes);
        excludes = this.replaceVariables(excludes);
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(baseDir);
        scanner.setIncludes(includes.length == 0 ? null : includes);
        scanner.setExcludes(excludes.length == 0 ? null : excludes);
        scanner.addDefaultExcludes();
        scanner.scan();
        boolean replaceSep = File.separatorChar != '/';
        String[] excludedFiles = scanner.getExcludedFiles();
        if (excludedFiles.length > 0) {
            String[] defaultExcludes = DirectoryScanner.getDefaultExcludes();
            ArrayList<String> prunedExcludes = new ArrayList<String>();
            String[] stringArray = excludedFiles;
            int n2 = excludedFiles.length;
            n = 0;
            while (n < n2) {
                String excludedFile = stringArray[n];
                if (replaceSep) {
                    excludedFile = excludedFile.replace(File.separatorChar, '/');
                }
                boolean excludedByDefault = false;
                String[] stringArray2 = defaultExcludes;
                int n3 = defaultExcludes.length;
                int n4 = 0;
                while (n4 < n3) {
                    String defaultExclude = stringArray2[n4];
                    if (SelectorUtils.matchPath((String)defaultExclude, (String)excludedFile)) {
                        excludedByDefault = true;
                        break;
                    }
                    ++n4;
                }
                if (!excludedByDefault) {
                    prunedExcludes.add(excludedFile);
                }
                ++n;
            }
            excludedFiles = prunedExcludes.toArray(new String[prunedExcludes.size()]);
        }
        ArrayList<String> plainDirs = null;
        String[] stringArray = includes;
        n = includes.length;
        int excludedFile = 0;
        while (excludedFile < n) {
            String include = stringArray[excludedFile];
            if (include.indexOf(42) < 0 && include.charAt(include.length() - 1) == '/') {
                int idx = excludedFiles.length;
                while (--idx >= 0) {
                    if (excludedFiles[idx].startsWith(include)) break;
                }
                if (idx < 0) {
                    if (plainDirs == null) {
                        plainDirs = new ArrayList<String>();
                    }
                    plainDirs.add(include);
                }
            }
            ++excludedFile;
        }
        HashSet<String> plainDirsWithFiles = null;
        ArrayList<String> result = new ArrayList<String>();
        String[] includedFiles = scanner.getIncludedFiles();
        int top = includedFiles.length;
        int idx = 0;
        while (idx < top) {
            block19: {
                String includedFile;
                block18: {
                    includedFile = Path.fromOSString((String)includedFiles[idx]).toPortableString();
                    if (plainDirs == null) break block18;
                    int ndx = plainDirs.size();
                    while (--ndx >= 0) {
                        String plainDir = (String)plainDirs.get(ndx);
                        if (!includedFile.startsWith(plainDir)) continue;
                        if (plainDirsWithFiles == null) {
                            plainDirsWithFiles = new HashSet<String>();
                        }
                        plainDirsWithFiles.add(plainDir);
                        break;
                    }
                    if (ndx >= 0) break block19;
                }
                result.add(includedFile);
            }
            ++idx;
        }
        if (plainDirsWithFiles != null) {
            result.addAll(plainDirsWithFiles);
        }
        return result;
    }

    private String[] replaceVariables(String[] sources) throws CoreException {
        if (sources == null) {
            return StringHelper.EMPTY_ARRAY;
        }
        int top = sources.length;
        ArrayList<String> result = new ArrayList<String>(top);
        int idx = 0;
        while (idx < top) {
            String source = this.replaceVariables(sources[idx]);
            if (source != null) {
                result.add(source);
            }
            ++idx;
        }
        return result.toArray(new String[result.size()]);
    }

    private String replaceVariables(String source) throws CoreException {
        if (source == null) {
            return null;
        }
        if (source.length() >= 4) {
            source = source.replace("$ws$", "${target.ws}");
            source = source.replace("$os$", "${target.os}");
            source = source.replace("$arch$", "${target.arch}");
            source = source.replace("$nl$", "${target.nl}");
        }
        if ((source = Trivial.trim((String)((String)ExpandingProperties.expand(this.getProperties(), (Object)source, (int)0)))) != null && File.separatorChar != '/') {
            source = source.replace('\\', '/');
        }
        if (source != null && (".".equals(source) || "./".equals(source))) {
            source = null;
        }
        return source;
    }

    public static class ImportSpecification {
        private final String name;
        private final VersionRange range;
        private final boolean exported;
        private final boolean optional;

        ImportSpecification(BundleSpecification bundleSpec) {
            this.name = bundleSpec.getName();
            org.eclipse.osgi.service.resolver.VersionRange osgiRange = bundleSpec.getVersionRange();
            this.range = osgiRange == null ? null : new VersionRange(osgiRange.toString());
            this.exported = bundleSpec.isExported();
            this.optional = bundleSpec.isOptional();
        }

        ImportSpecification(String name, VersionRange range, boolean exported, boolean optional) {
            this.name = name;
            this.range = range;
            this.exported = exported;
            this.optional = optional;
        }

        public String getName() {
            return this.name;
        }

        public VersionRange getVersionRange() {
            return this.range;
        }

        public boolean isExported() {
            return this.exported;
        }

        public boolean isOptional() {
            return this.optional;
        }
    }
}

