/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.cspecgen;

import org.eclipse.buckminster.core.cspec.AbstractResolutionBuilder;
import org.eclipse.buckminster.core.cspec.builder.CSpecBuilder;
import org.eclipse.buckminster.core.metadata.model.BOMNode;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.core.metadata.model.ResolvedNode;
import org.eclipse.buckminster.core.reader.ICatalogReader;
import org.eclipse.buckminster.core.reader.IComponentReader;
import org.eclipse.buckminster.core.reader.IFileReader;
import org.eclipse.buckminster.core.reader.LocalReader;
import org.eclipse.buckminster.core.reader.ZipArchiveReader;
import org.eclipse.buckminster.core.version.ProviderMatch;
import org.eclipse.buckminster.pde.IPDEConstants;
import org.eclipse.buckminster.pde.Messages;
import org.eclipse.buckminster.pde.internal.EclipsePlatformReader;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.pde.core.IModel;

public abstract class PDEBuilder
extends AbstractResolutionBuilder
implements IPDEConstants {
    public static final String DEFAULT_TARGET = "default";
    public static final String OPTIONAL_TARGET = "optional";
    private boolean usingInstalledReader;
    private IModel model;

    public static ResolvedNode createNode(ProviderMatch providerMatch, CSpecBuilder cspecBuilder) throws CoreException {
        return new ResolvedNode(providerMatch.getNodeQuery(), new Resolution(providerMatch.createResolution(cspecBuilder, false)));
    }

    public synchronized BOMNode build(IComponentReader[] readerHandle, boolean forResolutionAidOnly, IProgressMonitor monitor) throws CoreException {
        IComponentReader reader = readerHandle[0];
        if (!(reader instanceof ICatalogReader)) {
            reader = new ZipArchiveReader((IFileReader)reader);
        }
        ICatalogReader catRdr = (ICatalogReader)reader;
        monitor.beginTask(null, forResolutionAidOnly ? 1200 : 1600);
        monitor.subTask(Messages.generating_cspec_from_PDE_artifacts);
        try {
            this.usingInstalledReader = reader instanceof EclipsePlatformReader;
            CSpecBuilder cspecBuilder = new CSpecBuilder();
            this.parseFile(cspecBuilder, forResolutionAidOnly, catRdr, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1000));
            if (!(reader instanceof LocalReader)) {
                cspecBuilder.addSourceDependency();
            }
            this.applyExtensions(cspecBuilder, forResolutionAidOnly, reader, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)200));
            ResolvedNode resolvedNode = this.createNode(reader, cspecBuilder);
            return resolvedNode;
        }
        finally {
            monitor.done();
        }
    }

    public IModel getModel() {
        return this.model;
    }

    protected boolean isUsingInstalledReader() {
        return this.usingInstalledReader;
    }

    protected abstract void parseFile(CSpecBuilder var1, boolean var2, ICatalogReader var3, IProgressMonitor var4) throws CoreException;

    protected void setModel(IModel model) {
        this.model = model;
    }
}

