/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.cspecgen.bundle;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.buckminster.core.TargetPlatform;
import org.eclipse.buckminster.core.cspec.builder.CSpecBuilder;
import org.eclipse.buckminster.core.ctype.MissingCSpecSourceException;
import org.eclipse.buckminster.core.helpers.AccessibleByteArrayOutputStream;
import org.eclipse.buckminster.core.metadata.MissingComponentException;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.core.reader.ICatalogReader;
import org.eclipse.buckminster.core.reader.IComponentReader;
import org.eclipse.buckminster.core.reader.IStreamConsumer;
import org.eclipse.buckminster.core.reader.URLCatalogReaderType;
import org.eclipse.buckminster.core.reader.URLFileReader;
import org.eclipse.buckminster.core.reader.ZipArchiveReader;
import org.eclipse.buckminster.core.version.ProviderMatch;
import org.eclipse.buckminster.core.version.VersionHelper;
import org.eclipse.buckminster.pde.Messages;
import org.eclipse.buckminster.pde.PDEPlugin;
import org.eclipse.buckminster.pde.cspecgen.CSpecGenerator;
import org.eclipse.buckminster.pde.cspecgen.PDEBuilder;
import org.eclipse.buckminster.pde.cspecgen.bundle.CSpecFromBinary;
import org.eclipse.buckminster.pde.cspecgen.bundle.CSpecFromSource;
import org.eclipse.buckminster.pde.internal.EclipseImportReader;
import org.eclipse.buckminster.pde.internal.EclipsePlatformReader;
import org.eclipse.buckminster.pde.internal.model.ExternalBuildModel;
import org.eclipse.buckminster.pde.internal.model.ExternalBundleModel;
import org.eclipse.buckminster.pde.internal.model.ExternalExtensionsModel;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.equinox.internal.p2.metadata.OSGiVersion;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.ISharedExtensionsModel;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.build.IBuildPropertiesConstants;
import org.eclipse.pde.internal.core.bundle.BundleFragmentModel;
import org.eclipse.pde.internal.core.bundle.BundlePluginModel;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IBundleModel;
import org.eclipse.pde.internal.core.plugin.ExternalFragmentModel;
import org.eclipse.pde.internal.core.plugin.ExternalPluginModel;

public class BundleBuilder
extends PDEBuilder
implements IBuildPropertiesConstants {
    private static IPath platformPluginsFolder = Path.fromOSString((String)TargetPlatform.getPlatformInstallLocation().getAbsolutePath()).append("plugins");

    private static void loadModel(ICatalogReader reader, String file, final IModel model, IProgressMonitor monitor) throws CoreException, FileNotFoundException {
        try {
            reader.readFile(file, (IStreamConsumer)new IStreamConsumer<Object>(){

                public Object consumeStream(IComponentReader fileReader, String streamName, InputStream stream, IProgressMonitor mon) throws CoreException {
                    byte[] buf = new byte[4096];
                    AccessibleByteArrayOutputStream bld = new AccessibleByteArrayOutputStream();
                    try {
                        int len;
                        while ((len = stream.read(buf)) > 0) {
                            int idx = 0;
                            while (idx < len) {
                                byte b = buf[idx];
                                if (b != 13) {
                                    bld.write((int)b);
                                }
                                ++idx;
                            }
                        }
                    }
                    catch (IOException e) {
                        throw BuckminsterException.wrap((Throwable)e);
                    }
                    model.load(bld.getInputStream(), true);
                    return null;
                }
            }, monitor);
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
    }

    private static IPluginModelBase parsePluginModelBase(ICatalogReader reader, boolean forResolutionAidOnly, IBuildModel[] buildModelHandle, IProgressMonitor monitor) throws CoreException {
        File locationFile = null;
        if (reader instanceof EclipsePlatformReader) {
            MonitorUtils.complete((IProgressMonitor)monitor);
            try {
                IPluginModelBase pluginModelBase = ((EclipsePlatformReader)reader).getPluginModelBase();
                if (forResolutionAidOnly) {
                    return pluginModelBase;
                }
                String location = pluginModelBase.getInstallLocation();
                if (location == null) {
                    throw new MissingCSpecSourceException(reader.getProviderMatch());
                }
                if (platformPluginsFolder.isPrefixOf(Path.fromOSString((String)location))) {
                    return pluginModelBase;
                }
                locationFile = new File(location);
                if (locationFile.isFile()) {
                    return pluginModelBase;
                }
                reader = (ICatalogReader)URLCatalogReaderType.getReader((URL)locationFile.toURI().toURL(), null);
            }
            catch (MissingComponentException pluginModelBase) {
            }
            catch (IllegalStateException e) {
                throw new MissingCSpecSourceException(reader.getProviderMatch());
            }
            catch (MalformedURLException e) {
                throw BuckminsterException.wrap((Throwable)e);
            }
        }
        monitor.beginTask(null, 7000);
        try {
            IComponentReader fr;
            if (locationFile == null && reader instanceof ZipArchiveReader && (fr = ((ZipArchiveReader)reader).getFileReader()) instanceof URLFileReader) {
                URI uri = ((URLFileReader)fr).getURI();
                try {
                    URL url = FileLocator.resolve((URL)uri.toURL());
                    if ("file".equalsIgnoreCase(url.getProtocol())) {
                        locationFile = new File(url.toURI());
                    }
                }
                catch (IOException url) {
                }
                catch (URISyntaxException url) {
                    // empty catch block
                }
            }
            boolean fragment = false;
            ExternalBundleModel model = new ExternalBundleModel(locationFile);
            BundleBuilder.loadModel(reader, "META-INF/MANIFEST.MF", (IModel)model, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1000));
            IBundle bundle = model.getBundle();
            if (bundle.getHeader("Bundle-SymbolicName") == null) {
                ProviderMatch pm = reader.getProviderMatch();
                String cName = pm.getComponentName();
                if (!cName.endsWith(".source")) {
                    String bundleManifestVersion = bundle.getHeader("Bundle-ManifestVersion");
                    if (bundleManifestVersion == null) {
                        throw new FileNotFoundException(Messages.not_an_OSGi_manifest);
                    }
                    PDEPlugin.getLogger().warning(NLS.bind((String)Messages.No_bundle_id_found_in_0, (Object)new File(reader.getLocation(), "META-INF/MANIFEST.MF").getAbsolutePath()), new Object[0]);
                    bundle.setHeader("Bundle-SymbolicName", "<undefined bundle id>");
                } else {
                    bundle.setHeader("Bundle-SymbolicName", cName);
                }
                Version v = pm.getVersionMatch().getVersion();
                String vstr = v == null ? null : (v instanceof OSGiVersion ? v.toString() : v.getOriginal());
                if (vstr != null) {
                    bundle.setHeader("Bundle-Version", vstr);
                }
            }
            BundleFragmentModel bmodel = (fragment = model.isFragmentModel()) ? new BundleFragmentModel() : new BundlePluginModel();
            bmodel.setBundleModel((IBundleModel)model);
            bmodel.setEnabled(true);
            if (forResolutionAidOnly) {
                BundleFragmentModel bundleFragmentModel = bmodel;
                return bundleFragmentModel;
            }
            try {
                String extensionsFile = fragment ? "fragment.xml" : "plugin.xml";
                ExternalExtensionsModel extModel = new ExternalExtensionsModel();
                BundleBuilder.loadModel(reader, extensionsFile, (IModel)extModel, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1000));
                bmodel.setExtensionsModel((ISharedExtensionsModel)extModel);
            }
            catch (FileNotFoundException extensionsFile) {
                // empty catch block
            }
            try {
                ExternalBuildModel buildModel = new ExternalBuildModel();
                BundleBuilder.loadModel(reader, "build.properties", (IModel)buildModel, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1000));
                buildModelHandle[0] = buildModel;
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            BundleFragmentModel bundleFragmentModel = bmodel;
            return bundleFragmentModel;
        }
        catch (FileNotFoundException fragment) {
            try {
                ExternalPluginModel pm = new ExternalPluginModel();
                BundleBuilder.loadModel(reader, "plugin.xml", (IModel)pm, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1000));
                ExternalPluginModel externalPluginModel = pm;
                return externalPluginModel;
            }
            catch (FileNotFoundException pm) {
                try {
                    ExternalFragmentModel pm2 = new ExternalFragmentModel();
                    BundleBuilder.loadModel(reader, "fragment.xml", (IModel)pm2, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1000));
                    ExternalFragmentModel externalFragmentModel = pm2;
                    return externalFragmentModel;
                }
                catch (FileNotFoundException e1) {
                    throw new MissingCSpecSourceException(reader.getProviderMatch());
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    public String getComponentTypeID() {
        return "osgi.bundle";
    }

    protected Resolution createResolution(IComponentReader reader, CSpecBuilder cspecBuilder) throws CoreException {
        if (reader instanceof EclipseImportReader) {
            EclipseImportReader eclipseImportReader = (EclipseImportReader)reader;
            return super.createResolution(reader, cspecBuilder, eclipseImportReader.isUnpack());
        }
        return super.createResolution(reader, cspecBuilder);
    }

    protected void parseFile(CSpecBuilder cspecBuilder, boolean forResolutionAidOnly, ICatalogReader reader, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(null, 100);
        try {
            IBuildModel[] buildModelHandle = new IBuildModel[1];
            IPluginBase pluginBase = BundleBuilder.parsePluginModelBase(reader, forResolutionAidOnly, buildModelHandle, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)50)).getPluginBase();
            cspecBuilder.setName(pluginBase.getId());
            cspecBuilder.setComponentTypeID(this.getComponentTypeID());
            cspecBuilder.setVersion(VersionHelper.parseVersion((String)pluginBase.getVersion()));
            if (forResolutionAidOnly) {
                return;
            }
            IPluginModelBase model = pluginBase.getPluginModel();
            this.setModel((IModel)model);
            IBuildModel buildModel = buildModelHandle[0];
            if (buildModel == null && model.getUnderlyingResource() != null) {
                buildModel = PluginRegistry.createBuildModel((IPluginModelBase)model);
            }
            boolean fromProject = buildModel != null;
            CSpecGenerator generator = fromProject ? new CSpecFromSource(cspecBuilder, reader, pluginBase, buildModel) : new CSpecFromBinary(cspecBuilder, reader, pluginBase);
            generator.generate(monitor);
        }
        finally {
            monitor.done();
        }
    }
}

