/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.cspecgen.bundle;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.buckminster.core.cspec.IAttribute;
import org.eclipse.buckminster.core.cspec.IComponentRequest;
import org.eclipse.buckminster.core.cspec.IGenerator;
import org.eclipse.buckminster.core.cspec.WellknownActions;
import org.eclipse.buckminster.core.cspec.builder.ActionArtifactBuilder;
import org.eclipse.buckminster.core.cspec.builder.ActionBuilder;
import org.eclipse.buckminster.core.cspec.builder.ArtifactBuilder;
import org.eclipse.buckminster.core.cspec.builder.AttributeBuilder;
import org.eclipse.buckminster.core.cspec.builder.CSpecBuilder;
import org.eclipse.buckminster.core.cspec.builder.ComponentRequestBuilder;
import org.eclipse.buckminster.core.cspec.builder.GeneratorBuilder;
import org.eclipse.buckminster.core.cspec.builder.GroupBuilder;
import org.eclipse.buckminster.core.cspec.builder.PrerequisiteBuilder;
import org.eclipse.buckminster.core.cspec.model.UpToDatePolicy;
import org.eclipse.buckminster.core.helpers.TextUtils;
import org.eclipse.buckminster.core.query.model.ComponentQuery;
import org.eclipse.buckminster.core.reader.ICatalogReader;
import org.eclipse.buckminster.core.reader.IComponentReader;
import org.eclipse.buckminster.core.reader.ProjectDescReader;
import org.eclipse.buckminster.core.version.VersionHelper;
import org.eclipse.buckminster.jdt.ClasspathReader;
import org.eclipse.buckminster.pde.cspecgen.CSpecGenerator;
import org.eclipse.buckminster.pde.tasks.VersionConsolidator;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.buckminster.runtime.Trivial;
import org.eclipse.core.internal.resources.LinkDescription;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.internal.utils.FileUtil;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.bundle.BundlePlugin;
import org.eclipse.pde.internal.core.ibundle.IBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSpecFromSource
extends CSpecGenerator {
    private static final String ATTRIBUTE_BUNDLE_EXTRAJARS = "bundle.extrajars";
    private static final String ATTRIBUTE_ECLIPSE_BUILD = WellknownActions.ECLIPSE.BUILD.toString();
    private static final String ATTRIBUTE_ECLIPSE_BUILD_REQUIREMENTS = String.valueOf(ATTRIBUTE_ECLIPSE_BUILD) + ".requirements";
    private static final String ATTRIBUTE_ECLIPSE_BUILD_SOURCE = String.valueOf(ATTRIBUTE_ECLIPSE_BUILD) + ".source";
    private static final String ATTRIBUTE_ECLIPSE_CLEAN = WellknownActions.ECLIPSE.CLEAN.toString();
    private static final String PREFIX_CREATE_JAR = "create.";
    private static final String PREFIX_ECLIPSE_BUILD_OUTPUT = "eclipse.build.output.";
    private static final String PREFIX_ROUGE_SOURCE = "rouge.sources.";
    private static final IClasspathEntry[] emptyClasspath = new IClasspathEntry[0];
    private final IBuildModel buildModel;
    private final IPluginBase plugin;
    private IProjectDescription projectDesc;

    private static String getArtifactName(IPath buildOutput) {
        return PREFIX_ECLIPSE_BUILD_OUTPUT + CSpecFromSource.pathToName(buildOutput);
    }

    private static String pathToName(IPath path) {
        if ((path = path.setDevice(null).makeRelative()).segmentCount() > 2) {
            path = path.removeFirstSegments(path.segmentCount() - 2);
        }
        return path.removeTrailingSeparator().toPortableString().replace('/', '.');
    }

    public CSpecFromSource(CSpecBuilder cspecBuilder, ICatalogReader reader, IPluginBase plugin, IBuildModel buildModel) {
        super(cspecBuilder, reader);
        this.plugin = plugin;
        this.buildModel = buildModel;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void generate(IProgressMonitor monitor) throws CoreException {
        void var32_55;
        ArtifactBuilder ab;
        IPath biPath;
        String versionQualifier;
        IBuildEntry secondaryDeps;
        ArtifactBuilder ab2;
        List<Object> srcIncludes;
        List<Object> binIncludes;
        IClasspathEntry[] classPath;
        monitor.beginTask(null, 100);
        CSpecBuilder cspec = this.getCSpec();
        GroupBuilder classpath = cspec.addGroup("java.binaries", true);
        GroupBuilder fullClean = cspec.addGroup(ATTRIBUTE_FULL_CLEAN, true);
        GroupBuilder bundleJars = cspec.addGroup("bundle.jars", true);
        cspec.addGroup("product.configuration.exports", true);
        if (this.getReader().isFileSystemReader()) {
            this.projectDesc = ProjectDescReader.getProjectDescription((IComponentReader)this.getReader(), (IProgressMonitor)MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)15));
        } else {
            this.projectDesc = null;
            MonitorUtils.worked((IProgressMonitor)monitor, (int)15);
        }
        this.addImports();
        MonitorUtils.worked((IProgressMonitor)monitor, (int)5);
        try {
            classPath = ClasspathReader.getClasspath((IComponentReader)this.getReader(), (IProgressMonitor)MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)45));
        }
        catch (CoreException e) {
            classPath = null;
        }
        if (classPath == null) {
            classPath = new IClasspathEntry[]{};
        }
        fullClean.addLocalPrerequisite(this.generateRemoveDirAction("build", OUTPUT_DIR, false));
        fullClean.addLocalPrerequisite((AttributeBuilder)cspec.addInternalAction(ATTRIBUTE_ECLIPSE_CLEAN, false));
        boolean simpleBundle = false;
        IBuild build = this.buildModel.getBuild();
        ArrayList<String> jarsToCompile = null;
        HashMap<IPath, IPath> outputMap = new HashMap<IPath, IPath>();
        IBuildEntry[] iBuildEntryArray = build.getBuildEntries();
        int n = iBuildEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            String[] tokens;
            IBuildEntry entry = iBuildEntryArray[n2];
            String name = entry.getName();
            if (name.startsWith("source.")) {
                if (name.length() == 8 && name.charAt(7) == '.') {
                    simpleBundle = true;
                } else if (name.endsWith(".jar") && name.length() > 11) {
                    if (jarsToCompile == null) {
                        jarsToCompile = new ArrayList<String>();
                    }
                    jarsToCompile.add(name.substring(7));
                }
            } else if (name.startsWith("output.") && name.length() > 7 && (tokens = entry.getTokens()).length == 1) {
                outputMap.put(Path.fromPortableString((String)tokens[0]), Path.fromPortableString((String)name.substring(7)));
            }
            ++n2;
        }
        ActionBuilder eclipseBuild = this.getAttributeEclipseBuild();
        HashSet<Object> derivedArtifacts = new HashSet<Object>();
        IPath[] projectRootReplacement = new IPath[1];
        HashMap<IPath, AttributeBuilder> eclipseBuildProducts = new HashMap<IPath, AttributeBuilder>();
        IPath componentHome = Path.fromPortableString((String)"${buckminster.home}");
        IPath defaultOutputLocation = null;
        GroupBuilder ebSrcBld = null;
        int cnt = 0;
        IClasspathEntry[] iClasspathEntryArray = classPath;
        int n3 = classPath.length;
        int n4 = 0;
        while (n4 < n3) {
            IClasspathEntry cpe = iClasspathEntryArray[n4];
            if (cpe.getEntryKind() == 3) {
                IPath cpePath = this.asProjectRelativeFolder(cpe.getPath(), projectRootReplacement);
                ArtifactBuilder ab3 = cspec.addArtifact(String.valueOf(ATTRIBUTE_ECLIPSE_BUILD_SOURCE) + '_' + cnt++, false, projectRootReplacement[0]);
                ab3.setBase(cpePath);
                if (ebSrcBld == null) {
                    ebSrcBld = this.getGroupEclipseBuildSource(true);
                }
                ebSrcBld.addLocalPrerequisite((AttributeBuilder)ab3);
                IPath output = cpe.getOutputLocation();
                if (output == null) {
                    if (defaultOutputLocation == null) {
                        defaultOutputLocation = this.getDefaultOutputLocation(classPath, projectRootReplacement);
                    }
                    output = defaultOutputLocation;
                } else {
                    output = this.asProjectRelativeFolder(output, projectRootReplacement);
                }
                if (output != null && !eclipseBuildProducts.containsKey(output)) {
                    IPath cmp;
                    IPath base;
                    IPath relPath = null;
                    if (output.isAbsolute()) {
                        base = output;
                    } else {
                        base = projectRootReplacement[0];
                        if (base == null) {
                            base = componentHome;
                        }
                        base = base.append(output);
                        relPath = (IPath)outputMap.get(output);
                        if (relPath != null && relPath.segmentCount() == 1 && ".".equals(relPath.segment(0))) {
                            relPath = null;
                        }
                        if (relPath != null) {
                            derivedArtifacts.add(relPath);
                        }
                    }
                    GroupBuilder productRebase = null;
                    String artifactName = CSpecFromSource.getArtifactName(output);
                    if (relPath != null && base.segmentCount() > relPath.segmentCount() && (cmp = base.removeFirstSegments(base.segmentCount() - relPath.segmentCount())).equals((Object)relPath)) {
                        productRebase = cspec.addGroup(artifactName, false);
                        productRebase.setName(artifactName);
                        artifactName = String.valueOf(artifactName) + ".raw";
                        productRebase.addLocalPrerequisite(artifactName);
                        productRebase.setPrerequisiteRebase(base.removeLastSegments(relPath.segmentCount()));
                    }
                    ActionArtifactBuilder ab22 = eclipseBuild.addProductArtifact(artifactName, false, base);
                    eclipseBuildProducts.put(output, (AttributeBuilder)(productRebase == null ? ab22 : productRebase));
                }
            }
            ++n4;
        }
        AttributeBuilder buildSource = null;
        if (ebSrcBld != null) {
            buildSource = this.normalizeGroup(ebSrcBld);
        }
        classpath.addLocalPrerequisite((AttributeBuilder)eclipseBuild);
        if (this.getReader().isFileSystemReader()) {
            File baseDir = this.getReader().getLocation();
            binIncludes = this.expandBinFiles(baseDir, build);
            srcIncludes = this.expandSrcFiles(baseDir, build);
        } else {
            binIncludes = Collections.emptyList();
            srcIncludes = Collections.emptyList();
        }
        String bundleClassPath = null;
        if (this.plugin instanceof BundlePlugin) {
            IBundle bundle = ((BundlePlugin)this.plugin).getBundle();
            this.setFilter(bundle.getHeader("Eclipse-PlatformFilter"));
            cspec.setShortDesc(this.expand(bundle.getHeader("Bundle-Name")));
            bundleClassPath = bundle.getHeader("Bundle-ClassPath");
            if (bundleClassPath != null) {
                cnt = 0;
                GroupBuilder eaBld = null;
                StringTokenizer tokens = new StringTokenizer(bundleClassPath, ",");
                while (tokens.hasMoreTokens()) {
                    String token = tokens.nextToken().trim();
                    if (simpleBundle && token.equals(".") || token.equals("./") || jarsToCompile != null && jarsToCompile.contains(token) || binIncludes.contains(token)) continue;
                    ab2 = cspec.addArtifact("bundle.extrajars_" + cnt++, false, null);
                    IPath eaPath = this.resolveLink(Path.fromPortableString((String)token), projectRootReplacement);
                    ab2.setBase(projectRootReplacement[0]);
                    ab2.addPath(eaPath);
                    if (eaBld == null) {
                        eaBld = this.getGroupExtraJars();
                    }
                    eaBld.addLocalPrerequisite((AttributeBuilder)ab2);
                }
                if (eaBld != null) {
                    this.normalizeGroup(eaBld);
                }
            }
        }
        if ((secondaryDeps = build.getEntry("additional.bundles")) != null) {
            ab2 = secondaryDeps.getTokens();
            int token = ((String[])ab2).length;
            int tokens = 0;
            while (tokens < token) {
                String depName = ab2[tokens];
                ComponentRequestBuilder dep = cspec.createDependencyBuilder();
                dep.setName(depName);
                dep.setComponentTypeID("osgi.bundle");
                this.addDependency(dep);
                ++tokens;
            }
        }
        IPath manifestFolder = this.resolveLink(new Path("META-INF").append("MANIFEST.MF"), null).removeLastSegments(1).addTrailingSeparator();
        ArtifactBuilder manifest = null;
        boolean versionExpansion = false;
        Version version = cspec.getVersion();
        if (version != null && (versionQualifier = VersionHelper.getQualifier((Version)version)) != null) {
            versionExpansion = versionQualifier.endsWith("qualifier");
        }
        cspec.addArtifact("build.properties", true, null).addPath((IPath)new Path("build.properties"));
        if (versionExpansion) {
            Path manifestPath = new Path("MANIFEST.MF");
            ArtifactBuilder rawManifest = cspec.addArtifact("raw.manifest", false, manifestFolder);
            rawManifest.addPath((IPath)manifestPath);
            ActionBuilder versionExpansionAction = this.addAntAction("manifest", "expand.bundle.version", false);
            versionExpansionAction.addLocalPrerequisite("raw.manifest", "manifest");
            versionExpansionAction.addLocalPrerequisite("build.properties", "properties");
            versionExpansionAction.setProductAlias("action.output");
            versionExpansionAction.setProductBase(OUTPUT_DIR_TEMP);
            versionExpansionAction.addProductPath((IPath)manifestPath);
            manifest = versionExpansionAction;
        } else {
            ArtifactBuilder rawManifest = cspec.addArtifact("manifest", true, manifestFolder);
            rawManifest.addPath((IPath)new Path("MANIFEST.MF"));
            manifest = rawManifest;
        }
        if (jarsToCompile != null) {
            for (String jarName : jarsToCompile) {
                derivedArtifacts.add(this.createJarAction(jarName, classPath, build, outputMap, simpleBundle ? eclipseBuildProducts : null));
            }
        }
        if (simpleBundle) {
            derivedArtifacts.add(new Path("."));
            derivedArtifacts.add(new Path("./"));
        }
        GroupBuilder jarContents = this.getAttributeJarContents();
        boolean includeBuildProps = false;
        boolean considerAboutMappings = VersionConsolidator.getBooleanProperty(this.getReader().getNodeQuery().getProperties(), "pde.consider.about.mappings", true);
        if (!binIncludes.isEmpty()) {
            GroupBuilder binIncludesSource = null;
            cnt = 0;
            for (String string : binIncludes) {
                if ("META-INF/MANIFEST.MF".equalsIgnoreCase(string)) continue;
                if (versionExpansion && "build.properties".equals(string)) {
                    includeBuildProps = true;
                    continue;
                }
                Path binInclude = new Path(string);
                if (derivedArtifacts.contains(binInclude)) continue;
                if (binIncludesSource == null) {
                    binIncludesSource = cspec.addGroup("bin.includes", false);
                }
                if (considerAboutMappings && "about.mappings".equalsIgnoreCase(string)) {
                    AttributeBuilder aboutMappings = this.addAboutMappingsAction((IPath)binInclude, projectRootReplacement[0]);
                    binIncludesSource.addLocalPrerequisite(aboutMappings);
                    continue;
                }
                biPath = this.resolveLink((IPath)binInclude, projectRootReplacement);
                ab = cspec.addArtifact("bin.includes_" + cnt++, false, projectRootReplacement[0]);
                ab.addPath(biPath);
                binIncludesSource.addLocalPrerequisite((AttributeBuilder)ab);
            }
            if (binIncludesSource != null) {
                this.normalizeGroup(binIncludesSource);
                jarContents.addLocalPrerequisite("bin.includes");
            }
            if (includeBuildProps) {
                jarContents.addLocalPrerequisite("build.properties");
            }
        }
        GroupBuilder srcIncludesSource = null;
        if (!srcIncludes.isEmpty()) {
            cnt = 0;
            for (String string : srcIncludes) {
                Path srcInclude = new Path(string);
                if (srcIncludesSource == null) {
                    srcIncludesSource = cspec.addGroup("src.includes", false);
                }
                biPath = this.resolveLink((IPath)srcInclude, projectRootReplacement);
                ab = cspec.addArtifact("src.includes_" + cnt++, false, projectRootReplacement[0]);
                ab.addPath(biPath);
                srcIncludesSource.addLocalPrerequisite((AttributeBuilder)ab);
            }
        }
        if (buildSource != null) {
            if (srcIncludesSource == null) {
                srcIncludesSource = cspec.addGroup("src.includes", false);
            }
            srcIncludesSource.addLocalPrerequisite(buildSource);
        }
        if (simpleBundle && !binIncludes.isEmpty()) {
            Object var32_49 = null;
            IBuildEntry excludes = build.getEntry("exclude..");
            if (excludes != null) {
                String string = TextUtils.concat((String[])excludes.getTokens(), (String)",");
            }
            for (AttributeBuilder product : eclipseBuildProducts.values()) {
                void var32_51;
                if (var32_51 == null) {
                    jarContents.addLocalPrerequisite(product);
                    continue;
                }
                String pruneName = String.valueOf(product.getName()) + ".pruned";
                ActionBuilder prune = cspec.addAction(pruneName, false, "copy", false);
                prune.addLocalPrerequisite(product);
                prune.addProperty("excludes", (String)var32_51, false);
                prune.setProductBase(OUTPUT_DIR_TEMP.append(pruneName));
                jarContents.addLocalPrerequisite((AttributeBuilder)prune);
            }
        }
        String jarName = String.valueOf(this.plugin.getId()) + '_' + this.plugin.getVersion() + ".jar";
        IPath jarPath = Path.fromPortableString((String)jarName);
        if (this.getReader().isFileSystemReader() && (this.getReader().exists(jarName, (IProgressMonitor)new NullProgressMonitor()) || this.getLinkDescriptions().containsKey(jarPath))) {
            ActionBuilder actionBuilder = this.addAntAction("bundle.jar", "copy.group", true);
            actionBuilder.setPrerequisitesAlias("action.requirements");
            IPath resolvedJarPath = this.resolveLink(jarPath, projectRootReplacement);
            ArtifactBuilder importedJar = cspec.addArtifact("imported.jar", false, projectRootReplacement[0]);
            importedJar.addPath(resolvedJarPath);
            actionBuilder.getPrerequisitesBuilder().addLocalPrerequisite((AttributeBuilder)importedJar);
        } else {
            ActionBuilder actionBuilder = this.addAntAction("bundle.jar", "create.bundle.jar", true);
            actionBuilder.addLocalPrerequisite(manifest.getName(), "manifest");
            actionBuilder.addLocalPrerequisite(jarContents.getName(), "action.requirements");
        }
        this.addGenerateApiDescription(build);
        var32_55.setProductAlias("action.output");
        var32_55.setProductBase(OUTPUT_DIR_JAR);
        var32_55.setUpToDatePolicy(UpToDatePolicy.COUNT);
        var32_55.setProductFileCount(1);
        GroupBuilder bundleAndFragments = cspec.addGroup("bundle.and.fragments", true);
        IPluginModelBase model = this.plugin.getPluginModel();
        if (model instanceof IFragmentModel) {
            this.addBundleHostDependency((IFragmentModel)model);
        } else {
            ActionBuilder copyTargetFragments = cspec.addAction("target.fragments", false, "copyTargetFragments", false);
            copyTargetFragments.setProductAlias("action.output");
            copyTargetFragments.setProductBase(OUTPUT_DIR_FRAGMENTS);
            copyTargetFragments.addLocalPrerequisite((AttributeBuilder)this.getAttributeEclipseBuild());
            copyTargetFragments.setUpToDatePolicy(UpToDatePolicy.ACTOR);
            copyTargetFragments.addProperty("fragment.attribute", "bundle.jar", false);
            bundleAndFragments.addLocalPrerequisite((AttributeBuilder)copyTargetFragments);
        }
        bundleAndFragments.addLocalPrerequisite((AttributeBuilder)var32_55);
        bundleJars.addLocalPrerequisite((AttributeBuilder)bundleAndFragments);
        GroupBuilder bundleAndFragmentsSource = cspec.addGroup("bundle.and.fragments.source", true);
        if (!(model instanceof IFragmentModel)) {
            ActionBuilder copyTargetFragmentsSource = cspec.addAction("target.fragments.source", false, "copyTargetFragments", false);
            copyTargetFragmentsSource.setProductAlias("action.output");
            copyTargetFragmentsSource.setProductBase(OUTPUT_DIR_FRAGMENTS_SOURCE);
            copyTargetFragmentsSource.setUpToDatePolicy(UpToDatePolicy.ACTOR);
            copyTargetFragmentsSource.addProperty("fragment.attribute", "source.bundle.jar", false);
            bundleAndFragmentsSource.addLocalPrerequisite((AttributeBuilder)copyTargetFragmentsSource);
        }
        if (srcIncludesSource != null) {
            ActionBuilder sourceManifestAction = this.addAntAction("source.manifest", "create.source.manifest", false);
            sourceManifestAction.addLocalPrerequisite("manifest", "manifest");
            sourceManifestAction.addLocalPrerequisite("build.properties", "properties");
            sourceManifestAction.setProductAlias("action.output");
            sourceManifestAction.setProductBase(OUTPUT_DIR_TEMP);
            Path sourceManifestPath = new Path("SOURCE_MANIFEST.MF");
            sourceManifestAction.addProductPath((IPath)sourceManifestPath);
            ActionBuilder sourceBundleAction = this.addAntAction("source.bundle.jar", "create.bundle.jar", true);
            sourceBundleAction.addLocalPrerequisite("src.includes", "action.requirements");
            sourceBundleAction.addLocalPrerequisite("source.manifest", "manifest");
            sourceBundleAction.setProductAlias("action.output");
            sourceBundleAction.setProductBase(OUTPUT_DIR_SOURCE_JAR);
            bundleAndFragmentsSource.addLocalPrerequisite((AttributeBuilder)sourceBundleAction);
            GeneratorBuilder genBld = cspec.createGeneratorBuilder();
            genBld.setAttribute("source.bundle.jar");
            genBld.setGeneratesType("osgi.bundle");
            genBld.setName(String.valueOf(cspec.getName()) + ".source");
            cspec.addGenerator((IGenerator)genBld);
        } else {
            cspec.addGroup("source.bundle.jar", true);
        }
        this.addProducts(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)20));
        monitor.done();
    }

    protected AttributeBuilder addAboutMappingsAction(IPath rawAboutMappingPath, IPath projectRoot) throws CoreException {
        ArtifactBuilder rawAboutMappings = this.getCSpec().addArtifact("raw.about.mappings", false, projectRoot);
        rawAboutMappings.addPath(rawAboutMappingPath);
        ActionBuilder mappingAction = this.addAntAction("about.mappings", "replaceTwoTokens", false);
        mappingAction.addProperty("token1", "@build@", false);
        mappingAction.addProperty("value1", "${build.id}", false);
        mappingAction.addProperty("token2", "@version@", false);
        mappingAction.addProperty("value2", "${" + this.getCSpec().getName() + ".unqualified.owner.version}", false);
        mappingAction.addLocalPrerequisite("raw.about.mappings", "action.input");
        mappingAction.addLocalPrerequisite((AttributeBuilder)this.getCSpec().addAction("ownerVersion", false, "ownerVersionExtractor", false));
        mappingAction.setProductAlias("action.output");
        mappingAction.setProductBase(OUTPUT_DIR_TEMP);
        mappingAction.addProductPath(Path.fromPortableString((String)"about.mappings"));
        return mappingAction;
    }

    protected void addGenerateApiDescription(IBuild build) throws CoreException {
        IBuildEntry apiDescription = build.getEntry("generateAPIDescription");
        if (apiDescription == null) {
            return;
        }
        String[] tokens = apiDescription.getTokens();
        if (tokens.length != 1 || !Boolean.parseBoolean(tokens[0])) {
            return;
        }
        CSpecBuilder cspec = this.getCSpec();
        GroupBuilder jarContentsOld = this.getAttributeJarContents();
        cspec.removeAttribute("jar.contents");
        jarContentsOld.setName("jar.contents.wo_apidesc");
        cspec.addAttribute((IAttribute)jarContentsOld);
        ActionBuilder apiGeneration = this.addAntAction("generate.api.description", "apigeneration", true);
        apiGeneration.addLocalPrerequisite("manifest", "manifest");
        apiGeneration.addLocalPrerequisite(jarContentsOld.getName(), "binary");
        apiGeneration.addLocalPrerequisite(ATTRIBUTE_ECLIPSE_BUILD_SOURCE, "source");
        apiGeneration.setProductAlias("action.output");
        apiGeneration.setProductBase(OUTPUT_DIR.append("api_description"));
        apiGeneration.addProductPath(Path.fromPortableString((String)".api_description"));
        GroupBuilder jarContents = this.getAttributeJarContents();
        jarContents.addLocalPrerequisite((AttributeBuilder)jarContentsOld);
        jarContents.addLocalPrerequisite((AttributeBuilder)apiGeneration);
    }

    protected void addImports() throws CoreException {
        CSpecGenerator.ImportSpecification[] imports = CSpecFromSource.getImports(this.plugin);
        if (imports.length == 0) {
            return;
        }
        ComponentQuery query = this.getReader().getNodeQuery().getComponentQuery();
        CSpecBuilder cspec = this.getCSpec();
        GroupBuilder fullClean = cspec.getRequiredGroup(ATTRIBUTE_FULL_CLEAN);
        GroupBuilder reExports = cspec.getRequiredGroup("java.binaries");
        GroupBuilder bundleJars = cspec.getRequiredGroup("bundle.jars");
        GroupBuilder productConfigExports = cspec.getRequiredGroup("product.configuration.exports");
        CSpecGenerator.ImportSpecification[] importSpecificationArray = imports;
        int n = imports.length;
        int n2 = 0;
        while (n2 < n) {
            ComponentRequestBuilder dependency;
            CSpecGenerator.ImportSpecification pluginImport = importSpecificationArray[n2];
            String pluginId = pluginImport.getName();
            if (!pluginId.equals("system.bundle") && !this.skipComponent(query, dependency = this.createDependency(pluginImport, "osgi.bundle")) && this.addDependency(dependency)) {
                this.addExternalPrerequisite(fullClean, (IComponentRequest)dependency, ATTRIBUTE_FULL_CLEAN);
                this.addExternalPrerequisite(bundleJars, (IComponentRequest)dependency, "bundle.jars");
                this.addExternalPrerequisite(this.getAttributeBuildRequirements(), (IComponentRequest)dependency, "java.binaries");
                if (pluginImport.isExported()) {
                    this.addExternalPrerequisite(reExports, (IComponentRequest)dependency, "java.binaries");
                }
                this.addExternalPrerequisite(productConfigExports, (IComponentRequest)dependency, "product.configuration.exports");
            }
            ++n2;
        }
    }

    @Override
    protected String getProductOutputFolder(String productId) {
        String[] tokens;
        IBuildEntry entry = this.buildModel.getBuild().getEntry(String.valueOf(productId) + ".topfolder");
        if (entry != null && (tokens = entry.getTokens()).length == 1) {
            return tokens[0];
        }
        return null;
    }

    @Override
    protected String getPropertyFileName() {
        return "plugin.properties";
    }

    private IPath asProjectRelativeFolder(IPath classpathEntryPath, IPath[] projectRootReplacement) {
        return this.resolveLink(classpathEntryPath.removeFirstSegments(1).addTrailingSeparator(), projectRootReplacement);
    }

    private IPath createJarAction(String jarName, IClasspathEntry[] classPath, IBuild build, Map<IPath, IPath> outputMap, Map<IPath, AttributeBuilder> eclipseBuildProducts) throws CoreException {
        int n;
        CSpecBuilder cspec = this.getCSpec();
        Path jarPath = new Path(jarName);
        String jarFlatName = CSpecFromSource.pathToName((IPath)jarPath);
        ActionBuilder action = this.addAntAction(PREFIX_CREATE_JAR + jarFlatName, "create.jar", false);
        action.setProductBase(OUTPUT_DIR_TEMP);
        action.addProductPath((IPath)jarPath);
        action.setProductAlias("action.output");
        action.setPrerequisitesAlias("action.requirements");
        this.getAttributeJarContents().addLocalPrerequisite((AttributeBuilder)action);
        IPath[][] missingEntriesRet = new IPath[1][];
        IClasspathEntry[] srcEntries = this.getSourceEntries(classPath, jarName, build, missingEntriesRet);
        IPath[] missingEntries = missingEntriesRet[0];
        if (missingEntries.length > 0) {
            ArtifactBuilder rougeSources = cspec.addArtifact(PREFIX_ROUGE_SOURCE + jarFlatName, false, null);
            IPath[] iPathArray = missingEntries;
            n = missingEntries.length;
            int n2 = 0;
            while (n2 < n) {
                IPath notFound = iPathArray[n2];
                rougeSources.addPath(notFound);
                ++n2;
            }
            action.addLocalPrerequisite((AttributeBuilder)rougeSources);
        }
        IPath[] projectRootReplacement = new IPath[1];
        IPath defaultOutputLocation = this.getDefaultOutputLocation(classPath, projectRootReplacement);
        IClasspathEntry[] iClasspathEntryArray = srcEntries;
        int n3 = srcEntries.length;
        n = 0;
        while (n < n3) {
            block11: {
                IBuildEntry excludes;
                IPath output;
                block10: {
                    block9: {
                        IClasspathEntry cpe = iClasspathEntryArray[n];
                        output = cpe.getOutputLocation();
                        if (output != null) break block9;
                        output = defaultOutputLocation;
                        if (output != null) break block10;
                        break block11;
                    }
                    output = this.asProjectRelativeFolder(output, projectRootReplacement);
                }
                String artifactName = CSpecFromSource.getArtifactName(output);
                IPath targetOutput = outputMap.get(output);
                if (targetOutput != null && (excludes = build.getEntry("exclude." + targetOutput.toPortableString())) != null) {
                    String pruneName = String.valueOf(artifactName) + ".pruned";
                    if (cspec.getAttribute(pruneName) == null) {
                        String excludesString = TextUtils.concat((String[])excludes.getTokens(), (String)",");
                        ActionBuilder prune = cspec.addAction(pruneName, false, "copy", false);
                        prune.addProperty("excludes", excludesString, false);
                        prune.addLocalPrerequisite(artifactName);
                        prune.setProductBase(OUTPUT_DIR_TEMP.append(pruneName));
                        action.addLocalPrerequisite(pruneName);
                        if (eclipseBuildProducts != null) {
                            eclipseBuildProducts.remove(output);
                        }
                    }
                } else if (action.getPrerequisite(artifactName) == null) {
                    action.addLocalPrerequisite(artifactName);
                    if (eclipseBuildProducts != null) {
                        eclipseBuildProducts.remove(output);
                    }
                }
            }
            ++n;
        }
        return jarPath;
    }

    private GroupBuilder getAttributeBuildRequirements() throws CoreException {
        CSpecBuilder cspec = this.getCSpec();
        GroupBuilder eclipseBuildReqs = cspec.getGroup(ATTRIBUTE_ECLIPSE_BUILD_REQUIREMENTS);
        if (eclipseBuildReqs == null) {
            eclipseBuildReqs = cspec.addGroup(ATTRIBUTE_ECLIPSE_BUILD_REQUIREMENTS, false);
            this.getAttributeEclipseBuild().addLocalPrerequisite((AttributeBuilder)eclipseBuildReqs);
        }
        return eclipseBuildReqs;
    }

    private ActionBuilder getAttributeEclipseBuild() throws CoreException {
        CSpecBuilder cspec = this.getCSpec();
        ActionBuilder eclipseBuild = cspec.getActionBuilder(ATTRIBUTE_ECLIPSE_BUILD);
        if (eclipseBuild == null) {
            eclipseBuild = cspec.addInternalAction(ATTRIBUTE_ECLIPSE_BUILD, false);
        }
        return eclipseBuild;
    }

    private GroupBuilder getAttributeJarContents() throws CoreException {
        CSpecBuilder cspec = this.getCSpec();
        GroupBuilder jarContent = cspec.getGroup("jar.contents");
        if (jarContent == null) {
            jarContent = cspec.addGroup("jar.contents", false);
        }
        return jarContent;
    }

    private IPath getDefaultOutputLocation(IClasspathEntry[] classPath, IPath[] projectRootReplacement) {
        IClasspathEntry[] iClasspathEntryArray = classPath;
        int n = classPath.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry cpe = iClasspathEntryArray[n2];
            if (cpe.getContentKind() == 10) {
                return this.asProjectRelativeFolder(cpe.getPath(), projectRootReplacement);
            }
            ++n2;
        }
        return null;
    }

    private GroupBuilder getGroupEclipseBuildSource(boolean createIfMissing) throws CoreException {
        CSpecBuilder cspec = this.getCSpec();
        GroupBuilder buildSource = cspec.getGroup(ATTRIBUTE_ECLIPSE_BUILD_SOURCE);
        if (buildSource == null && createIfMissing) {
            buildSource = cspec.addGroup(ATTRIBUTE_ECLIPSE_BUILD_SOURCE, true);
            this.getAttributeEclipseBuild().addLocalPrerequisite(ATTRIBUTE_ECLIPSE_BUILD_SOURCE);
        }
        return buildSource;
    }

    private GroupBuilder getGroupExtraJars() throws CoreException {
        CSpecBuilder cspec = this.getCSpec();
        GroupBuilder extraJars = cspec.getGroup(ATTRIBUTE_BUNDLE_EXTRAJARS);
        if (extraJars == null) {
            extraJars = cspec.addGroup(ATTRIBUTE_BUNDLE_EXTRAJARS, false);
            cspec.getRequiredGroup("java.binaries").addLocalPrerequisite(ATTRIBUTE_BUNDLE_EXTRAJARS);
            this.getAttributeBuildRequirements().addLocalPrerequisite(ATTRIBUTE_BUNDLE_EXTRAJARS);
        }
        return extraJars;
    }

    private Map<IPath, LinkDescription> getLinkDescriptions() {
        HashMap linkDescriptors = null;
        if (this.projectDesc instanceof ProjectDescription) {
            linkDescriptors = ((ProjectDescription)this.projectDesc).getLinks();
        }
        if (linkDescriptors == null) {
            linkDescriptors = Collections.emptyMap();
        }
        return linkDescriptors;
    }

    private IClasspathEntry[] getSourceEntries(IClasspathEntry[] classPath, String jarName, IBuild build, IPath[][] notFound) {
        IBuildEntry srcIncl = build.getEntry("source." + jarName);
        if (srcIncl == null) {
            notFound[0] = Trivial.EMPTY_PATH_ARRAY;
            return emptyClasspath;
        }
        ArrayList<IClasspathEntry> cpEntries = null;
        ArrayList<IPath> missingEntries = null;
        if (classPath == null) {
            String[] stringArray = srcIncl.getTokens();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String src = stringArray[n2];
                if (missingEntries == null) {
                    missingEntries = new ArrayList<IPath>();
                }
                missingEntries.add(this.resolveLink(Path.fromPortableString((String)src).addTrailingSeparator(), null));
                ++n2;
            }
        } else {
            String[] stringArray = srcIncl.getTokens();
            int n = stringArray.length;
            int n3 = 0;
            while (n3 < n) {
                String src = stringArray[n3];
                boolean found = false;
                IPath srcPath = this.resolveLink(Path.fromPortableString((String)src), null).addTrailingSeparator();
                IClasspathEntry[] iClasspathEntryArray = classPath;
                int n4 = classPath.length;
                int n5 = 0;
                while (n5 < n4) {
                    IPath cePath;
                    IClasspathEntry ce = iClasspathEntryArray[n5];
                    if (ce.getEntryKind() == 3 && (cePath = this.asProjectRelativeFolder(ce.getPath(), null)).equals((Object)srcPath)) {
                        found = true;
                        if (cpEntries == null) {
                            cpEntries = new ArrayList<IClasspathEntry>();
                        }
                        cpEntries.add(ce);
                        break;
                    }
                    ++n5;
                }
                if (!found) {
                    if (missingEntries == null) {
                        missingEntries = new ArrayList();
                    }
                    missingEntries.add(srcPath);
                }
                ++n3;
            }
        }
        notFound[0] = missingEntries == null ? Trivial.EMPTY_PATH_ARRAY : missingEntries.toArray(new IPath[missingEntries.size()]);
        return cpEntries == null ? emptyClasspath : cpEntries.toArray(new IClasspathEntry[cpEntries.size()]);
    }

    private AttributeBuilder normalizeGroup(GroupBuilder bld) throws CoreException {
        if (bld == null) {
            return null;
        }
        List preqs = bld.getPrerequisites();
        if (preqs.size() == 0) {
            return null;
        }
        boolean singleCanReplace = true;
        CSpecBuilder cspec = this.getCSpec();
        HashMap<IPath, ArtifactBuilder> byBase = new HashMap<IPath, ArtifactBuilder>();
        for (PrerequisiteBuilder pq : new ArrayList(preqs)) {
            if (pq.getComponentName() != null) {
                singleCanReplace = false;
                continue;
            }
            AttributeBuilder ab = cspec.getAttribute(pq.getName());
            if (!(ab instanceof ArtifactBuilder)) {
                singleCanReplace = false;
                continue;
            }
            ArtifactBuilder arb = (ArtifactBuilder)ab;
            ArtifactBuilder prev = (ArtifactBuilder)byBase.get(arb.getBase());
            if (prev == null) {
                byBase.put(arb.getBase(), arb);
                continue;
            }
            for (IPath path : arb.getPaths()) {
                prev.addPath(path);
            }
            bld.removePrerequisite(pq.toString());
            cspec.removeAttribute(arb.getName());
        }
        if (singleCanReplace && byBase.size() == 1) {
            ArtifactBuilder ab = (ArtifactBuilder)byBase.values().iterator().next();
            String name = bld.getName();
            cspec.removeAttribute(name);
            cspec.removeAttribute(ab.getName());
            ab.setName(name);
            this.getCSpec().addAttribute((IAttribute)ab);
            return ab;
        }
        return bld;
    }

    private IPath resolveLink(IPath path, IPath[] projectRootReplacement) {
        if (projectRootReplacement != null) {
            projectRootReplacement[0] = null;
        }
        if (path == null || path.isAbsolute() || path.isEmpty()) {
            return path;
        }
        for (Map.Entry<IPath, LinkDescription> entry : this.getLinkDescriptions().entrySet()) {
            IPath linkSource = entry.getKey();
            if (!linkSource.isPrefixOf(path)) continue;
            URI locationURI = entry.getValue().getLocationURI();
            URI resolvedURI = ResourcesPlugin.getWorkspace().getPathVariableManager().resolveURI(locationURI);
            IPath linkTarget = FileUtil.toPath((URI)resolvedURI);
            int sourceSegs = linkSource.segmentCount();
            if (projectRootReplacement != null && linkTarget.setDevice(null).removeFirstSegments(linkTarget.segmentCount() - sourceSegs).equals((Object)linkSource)) {
                projectRootReplacement[0] = linkTarget.removeLastSegments(sourceSegs);
                break;
            }
            if (sourceSegs == path.segmentCount()) {
                if (path.hasTrailingSeparator()) {
                    path = linkTarget.addTrailingSeparator();
                    break;
                }
                path = linkTarget;
                break;
            }
            path = linkTarget.append(path.removeFirstSegments(sourceSegs));
            break;
        }
        return path;
    }
}

