/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.cspecgen.feature;

import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.buckminster.core.cspec.IComponentRequest;
import org.eclipse.buckminster.core.cspec.builder.ActionBuilder;
import org.eclipse.buckminster.core.cspec.builder.AttributeBuilder;
import org.eclipse.buckminster.core.cspec.builder.CSpecBuilder;
import org.eclipse.buckminster.core.cspec.builder.ComponentRequestBuilder;
import org.eclipse.buckminster.core.cspec.builder.GroupBuilder;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.cspec.model.UpToDatePolicy;
import org.eclipse.buckminster.core.helpers.FilterUtils;
import org.eclipse.buckminster.core.query.model.ComponentQuery;
import org.eclipse.buckminster.core.reader.ICatalogReader;
import org.eclipse.buckminster.core.version.VersionHelper;
import org.eclipse.buckminster.osgi.filter.Filter;
import org.eclipse.buckminster.pde.MatchRule;
import org.eclipse.buckminster.pde.cspecgen.CSpecGenerator;
import org.eclipse.buckminster.pde.internal.EclipsePlatformReaderType;
import org.eclipse.buckminster.pde.tasks.VersionConsolidator;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.buckminster.runtime.Trivial;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.internal.p2.publisher.eclipse.IProductDescriptor;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginModelManager;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureChild;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeaturePlugin;

public abstract class CSpecFromFeature
extends CSpecGenerator {
    private static final String SOURCE_SUFFIX = ".source";
    private static final String SOURCE_FEATURE_SUFFIX = ".source.feature";
    private static final IFeatureChild[] noFeatures = new IFeatureChild[0];
    protected final IFeature feature;

    public static String getIdWithoutSource(String sourceId) {
        if (sourceId.endsWith(SOURCE_SUFFIX)) {
            return sourceId.substring(0, sourceId.length() - SOURCE_SUFFIX.length());
        }
        if (sourceId.endsWith(SOURCE_FEATURE_SUFFIX)) {
            return String.valueOf(sourceId.substring(0, sourceId.length() - SOURCE_FEATURE_SUFFIX.length())) + ".feature";
        }
        return null;
    }

    private static boolean isListOK(String list, Object item) {
        if (list == null || list.length() == 0) {
            return true;
        }
        StringTokenizer tokens = new StringTokenizer(list, ",");
        while (tokens.hasMoreTokens()) {
            if (!item.equals("*") && !item.equals(tokens.nextElement())) continue;
            return true;
        }
        return false;
    }

    protected CSpecFromFeature(CSpecBuilder cspecBuilder, ICatalogReader reader, IFeature feature) {
        super(cspecBuilder, reader);
        this.feature = feature;
    }

    public void generate(IProgressMonitor monitor) throws CoreException {
        CSpecBuilder cspec = this.getCSpec();
        cspec.setName(this.feature.getId());
        cspec.setVersion(VersionHelper.parseVersion((String)this.feature.getVersion()));
        cspec.setComponentTypeID("eclipse.feature");
        cspec.setFilter(FilterUtils.createFilter((String)this.feature.getOS(), (String)this.feature.getWS(), (String)this.feature.getArch(), (String)this.feature.getNL()));
        cspec.addGroup("feature.references", true);
        cspec.addGroup("source.feature.references", true).setFilter(SOURCE_FILTER);
        cspec.addGroup("bundle.jars", true);
        cspec.addGroup("source.bundle.jars", true).setFilter(SOURCE_FILTER);
        cspec.addGroup("feature.exports", true);
        cspec.addGroup("site.feature.exports", true);
        cspec.addGroup("product.configuration.exports", true);
        this.generateRemoveDirAction("build", OUTPUT_DIR, true, ATTRIBUTE_FULL_CLEAN);
        IComponentRequest licenseFeature = this.addFeatures();
        this.addPlugins();
        MonitorUtils.begin((IProgressMonitor)monitor, (int)100);
        this.createFeatureJarAction(licenseFeature, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)20));
        this.createFeatureSourceJarAction();
        this.createFeatureExportsAction();
        GroupBuilder featureJars = cspec.addGroup("feature.jars", true);
        featureJars.addLocalPrerequisite("feature.jar");
        featureJars.addLocalPrerequisite("feature.references");
        GroupBuilder sourceFeatureJars = cspec.addGroup("source.feature.jars", true);
        sourceFeatureJars.setFilter(SOURCE_FILTER);
        sourceFeatureJars.addLocalPrerequisite("source.feature.jar");
        sourceFeatureJars.addLocalPrerequisite("source.feature.references");
        this.createSiteActions(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)80));
        MonitorUtils.done((IProgressMonitor)monitor);
    }

    protected void addProductFeatures(IProductDescriptor productDescriptor) throws CoreException {
        if (!productDescriptor.useFeatures()) {
            return;
        }
        List features = productDescriptor.getFeatures();
        if (features.size() == 0) {
            return;
        }
        ComponentQuery query = this.getReader().getNodeQuery().getComponentQuery();
        CSpecBuilder cspec = this.getCSpec();
        ActionBuilder fullClean = cspec.getRequiredAction(ATTRIBUTE_FULL_CLEAN);
        GroupBuilder featureRefs = cspec.getRequiredGroup("feature.references");
        GroupBuilder featureSourceRefs = cspec.getRequiredGroup("source.feature.references");
        GroupBuilder bundleJars = cspec.getRequiredGroup("bundle.jars");
        GroupBuilder sourceBundleJars = cspec.getRequiredGroup("source.bundle.jars");
        String self = cspec.getName();
        for (IVersionedId productFeature : features) {
            ComponentRequestBuilder dep;
            if (productFeature.getId().equals(self) || this.skipComponent(query, dep = this.createDependency(productFeature, "eclipse.feature"))) continue;
            cspec.addDependency((IComponentRequest)dep);
            featureRefs.addExternalPrerequisite((IComponentRequest)dep, "feature.jars");
            featureSourceRefs.addExternalPrerequisite((IComponentRequest)dep, "source.feature.jars");
            bundleJars.addExternalPrerequisite((IComponentRequest)dep, "bundle.jars");
            sourceBundleJars.addExternalPrerequisite((IComponentRequest)dep, "source.bundle.jars");
            fullClean.addExternalPrerequisite((IComponentRequest)dep, ATTRIBUTE_FULL_CLEAN);
        }
    }

    protected String getPropertyFileName() {
        return "feature.properties";
    }

    protected boolean isFeature() {
        return true;
    }

    IComponentRequest addFeatures() throws CoreException {
        String licenseFeatureID = Trivial.trim((String)this.feature.getLicenseFeatureID());
        IFeatureChild[] features = this.feature.getIncludedFeatures();
        if (features == null) {
            features = noFeatures;
        }
        if (features.length == 0 && licenseFeatureID == null) {
            return null;
        }
        ComponentQuery query = this.getReader().getNodeQuery().getComponentQuery();
        CSpecBuilder cspec = this.getCSpec();
        ActionBuilder fullClean = cspec.getRequiredAction(ATTRIBUTE_FULL_CLEAN);
        GroupBuilder featureRefs = cspec.getRequiredGroup("feature.references");
        GroupBuilder featureSourceRefs = cspec.getRequiredGroup("source.feature.references");
        GroupBuilder bundleJars = cspec.getRequiredGroup("bundle.jars");
        GroupBuilder sourceBundleJars = cspec.getRequiredGroup("source.bundle.jars");
        GroupBuilder productConfigExports = cspec.getRequiredGroup("product.configuration.exports");
        IFeatureChild[] iFeatureChildArray = features;
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            block11: {
                boolean sourceInTP;
                ComponentRequestBuilder dep;
                block13: {
                    String idWithoutSource;
                    block12: {
                        IFeatureChild includedFeature = iFeatureChildArray[n2];
                        dep = this.createDependency(includedFeature);
                        if (this.skipComponent(query, dep)) break block11;
                        sourceInTP = false;
                        cspec.addDependency((IComponentRequest)dep);
                        idWithoutSource = CSpecFromFeature.getIdWithoutSource(dep.getName());
                        if (idWithoutSource != null) break block12;
                        featureRefs.addExternalPrerequisite((IComponentRequest)dep, "feature.jars");
                        bundleJars.addExternalPrerequisite((IComponentRequest)dep, "bundle.jars");
                        fullClean.addExternalPrerequisite((IComponentRequest)dep, ATTRIBUTE_FULL_CLEAN);
                        productConfigExports.addExternalPrerequisite((IComponentRequest)dep, "product.configuration.exports");
                        break block13;
                    }
                    if (idWithoutSource.equals(cspec.getName())) break block11;
                    IFeatureModel sourceFeature = EclipsePlatformReaderType.getBestFeature(dep.getName(), dep.getVersionRange(), null);
                    if (sourceFeature != null) {
                        featureRefs.addExternalPrerequisite((IComponentRequest)dep, "feature.jars");
                        bundleJars.addExternalPrerequisite((IComponentRequest)dep, "bundle.jars");
                        sourceInTP = true;
                    }
                }
                if (!sourceInTP) {
                    sourceBundleJars.addExternalPrerequisite((IComponentRequest)dep, "source.bundle.jars");
                    featureSourceRefs.addExternalPrerequisite((IComponentRequest)dep, "source.feature.jars");
                }
            }
            ++n2;
        }
        if (licenseFeatureID == null) {
            return null;
        }
        ComponentRequestBuilder dep = new ComponentRequestBuilder();
        dep.setName(licenseFeatureID);
        dep.setComponentTypeID("eclipse.feature");
        Version licenseFeatureVersion = VersionHelper.parseVersion((String)this.feature.getLicenseFeatureVersion());
        if (licenseFeatureVersion != null) {
            dep.setVersionRange(VersionHelper.exactRange((Version)licenseFeatureVersion));
        }
        if (this.skipComponent(query, dep)) {
            return null;
        }
        cspec.addDependency((IComponentRequest)dep);
        featureRefs.addExternalPrerequisite((IComponentRequest)dep, "feature.jars");
        bundleJars.addExternalPrerequisite((IComponentRequest)dep, "bundle.jars");
        fullClean.addExternalPrerequisite((IComponentRequest)dep, ATTRIBUTE_FULL_CLEAN);
        return dep;
    }

    void addPlugins() throws CoreException {
        String brandingPluginName = this.feature.getPlugin();
        IFeaturePlugin[] plugins = this.feature.getPlugins();
        if (plugins != null && plugins.length > 0) {
            Map props = this.getReader().getNodeQuery().getProperties();
            Object os = props.get("target.os");
            Object ws = props.get("target.ws");
            Object arch = props.get("target.arch");
            ComponentQuery query = this.getReader().getNodeQuery().getComponentQuery();
            CSpecBuilder cspec = this.getCSpec();
            ActionBuilder fullClean = cspec.getRequiredAction(ATTRIBUTE_FULL_CLEAN);
            GroupBuilder bundleJars = cspec.getRequiredGroup("bundle.jars");
            GroupBuilder sourceBundleJars = cspec.getRequiredGroup("source.bundle.jars");
            GroupBuilder productConfigExports = cspec.getRequiredGroup("product.configuration.exports");
            PluginModelManager manager = PDECore.getDefault().getModelManager();
            boolean hasBogusFragments = false;
            String id = this.feature.getId();
            hasBogusFragments = VersionConsolidator.getBooleanProperty(this.getProperties(), "buckminster.handle.incomplete.platform.features", false) ? "org.eclipse.platform".equals(id) || "org.eclipse.equinox.executable".equals(id) || "org.eclipse.rcp".equals(id) : "org.eclipse.equinox.executable".equals(id);
            IFeaturePlugin[] iFeaturePluginArray = plugins;
            int n = plugins.length;
            int n2 = 0;
            while (n2 < n) {
                IFeaturePlugin plugin = iFeaturePluginArray[n2];
                if ((CSpecFromFeature.isListOK(plugin.getOS(), os) && CSpecFromFeature.isListOK(plugin.getWS(), ws) && CSpecFromFeature.isListOK(plugin.getArch(), arch) || manager.findEntry(plugin.getId()) != null) && (!hasBogusFragments || plugin.getOS() == null && plugin.getWS() == null && plugin.getArch() == null || manager.findEntry(plugin.getId()) != null)) {
                    ComponentRequestBuilder dep = this.createDependency(plugin);
                    if (brandingPluginName != null && brandingPluginName.equals(dep.getName())) {
                        brandingPluginName = null;
                    }
                    if (!this.skipComponent(query, dep) && this.addDependency(dep)) {
                        bundleJars.addExternalPrerequisite((IComponentRequest)dep, "bundle.and.fragments");
                        if (!plugin.getId().endsWith(SOURCE_SUFFIX)) {
                            String sourceId = String.valueOf(plugin.getId()) + SOURCE_SUFFIX;
                            if (manager.findEntry(sourceId) == null) {
                                sourceBundleJars.addExternalPrerequisite((IComponentRequest)dep, "bundle.and.fragments.source");
                            } else {
                                ComponentRequestBuilder sourceDep = new ComponentRequestBuilder();
                                sourceDep.setName(sourceId);
                                sourceDep.setComponentTypeID("osgi.bundle");
                                sourceDep.setVersionRange(dep.getVersionRange());
                                this.addDependency(sourceDep);
                                sourceBundleJars.addExternalPrerequisite((IComponentRequest)sourceDep, "bundle.jar");
                            }
                        }
                        fullClean.addExternalPrerequisite((IComponentRequest)dep, ATTRIBUTE_FULL_CLEAN);
                        productConfigExports.addExternalPrerequisite((IComponentRequest)dep, "product.configuration.exports");
                    }
                }
                ++n2;
            }
        }
        if (brandingPluginName != null) {
            ComponentRequestBuilder dep = this.getCSpec().createDependencyBuilder();
            dep.setName(brandingPluginName);
            dep.setComponentTypeID("osgi.bundle");
            this.addDependency(dep);
        }
    }

    ComponentRequestBuilder createDependency(IFeatureChild featureChild) throws CoreException {
        Filter filter = FilterUtils.createFilter((String)featureChild.getOS(), (String)featureChild.getWS(), (String)featureChild.getArch(), (String)featureChild.getNL());
        if (featureChild.isOptional()) {
            filter = ComponentRequest.P2_OPTIONAL_FILTER.addFilterWithAnd(filter);
        }
        return this.createDependency(featureChild.getId(), "eclipse.feature", featureChild.getVersion(), MatchRule.fromPDE(featureChild.getMatch()), filter);
    }

    ComponentRequestBuilder createDependency(IFeaturePlugin plugin) throws CoreException {
        Filter filter = FilterUtils.createFilter((String)plugin.getOS(), (String)plugin.getWS(), (String)plugin.getArch(), (String)plugin.getNL());
        return this.createDependency(plugin.getId(), "osgi.bundle", plugin.getVersion(), MatchRule.NONE, filter);
    }

    abstract void createFeatureJarAction(IComponentRequest var1, IProgressMonitor var2) throws CoreException;

    abstract void createFeatureSourceJarAction() throws CoreException;

    abstract void createSiteActions(IProgressMonitor var1) throws CoreException;

    private ActionBuilder createCopyFeaturesAction() throws CoreException {
        ActionBuilder copyFeatures = this.addAntAction("copy.features", "copy.group", false);
        copyFeatures.addLocalPrerequisite("feature.jars");
        copyFeatures.addLocalPrerequisite("source.feature.jars");
        copyFeatures.setPrerequisitesAlias("action.requirements");
        copyFeatures.setProductAlias("action.output");
        copyFeatures.setProductBase(OUTPUT_DIR_SITE.append("features"));
        copyFeatures.setUpToDatePolicy(UpToDatePolicy.MAPPER);
        return copyFeatures;
    }

    private void createFeatureExportsAction() throws CoreException {
        GroupBuilder featureExports = this.getCSpec().getRequiredGroup("feature.exports");
        featureExports.addLocalPrerequisite((AttributeBuilder)this.createCopyFeaturesAction());
        featureExports.addLocalPrerequisite((AttributeBuilder)this.createCopyPluginsAction());
        featureExports.setPrerequisiteRebase(OUTPUT_DIR_SITE);
    }
}

