/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.cspecgen.feature;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.buckminster.core.cspec.IAttribute;
import org.eclipse.buckminster.core.cspec.IComponentRequest;
import org.eclipse.buckminster.core.cspec.IGenerator;
import org.eclipse.buckminster.core.cspec.builder.ActionArtifactBuilder;
import org.eclipse.buckminster.core.cspec.builder.ActionBuilder;
import org.eclipse.buckminster.core.cspec.builder.ArtifactBuilder;
import org.eclipse.buckminster.core.cspec.builder.AttributeBuilder;
import org.eclipse.buckminster.core.cspec.builder.CSpecBuilder;
import org.eclipse.buckminster.core.cspec.builder.GeneratorBuilder;
import org.eclipse.buckminster.core.cspec.builder.GroupBuilder;
import org.eclipse.buckminster.core.cspec.model.UpToDatePolicy;
import org.eclipse.buckminster.core.reader.ICatalogReader;
import org.eclipse.buckminster.pde.cspecgen.feature.CSpecFromFeature;
import org.eclipse.buckminster.pde.tasks.SourceFeatureCreator;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.pde.internal.core.ifeature.IFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSpecFromSource
extends CSpecFromFeature {
    private final Map<String, String> buildProperties;

    protected CSpecFromSource(CSpecBuilder cspecBuilder, ICatalogReader reader, IFeature feature, Map<String, String> buildProperties) {
        super(cspecBuilder, reader, feature);
        this.buildProperties = buildProperties;
    }

    @Override
    protected String getProductOutputFolder(String productId) {
        return this.buildProperties == null ? null : this.buildProperties.get(String.valueOf(productId) + ".topfolder");
    }

    @Override
    void createFeatureJarAction(IComponentRequest licenseFeature, IProgressMonitor monitor) throws CoreException {
        boolean versionedManifestPublic = licenseFeature == null;
        String versionedManifest = versionedManifestPublic ? "manifest" : "versioned.manifest";
        this.createBinIncludesArtifact(licenseFeature, versionedManifest, monitor);
        this.createFeatureManifestAction(versionedManifest, versionedManifestPublic);
        ActionBuilder featureJarBuilder = this.addAntAction("feature.jar", "create.feature.jar", false);
        featureJarBuilder.addLocalPrerequisite("manifest", "manifest");
        featureJarBuilder.addLocalPrerequisite("jar.contents");
        featureJarBuilder.setPrerequisitesAlias("action.requirements");
        featureJarBuilder.setProductAlias("action.output");
        featureJarBuilder.setProductBase(OUTPUT_DIR_JAR);
        featureJarBuilder.setUpToDatePolicy(UpToDatePolicy.COUNT);
        featureJarBuilder.setProductFileCount(1);
    }

    @Override
    void createFeatureSourceJarAction() throws CoreException {
        CSpecBuilder cspec = this.getCSpec();
        boolean translations = cspec.getAttribute("bin.includes") != null;
        this.createFeatureSourceManifestAction(translations);
        ActionBuilder featureJarBuilder = this.addAntAction("source.feature.jar", "create.feature.jar", false);
        featureJarBuilder.addLocalPrerequisite("source.manifest", "manifest");
        if (translations) {
            ActionBuilder srcIncludes = cspec.addAction("src.includes", false, "copy", false);
            srcIncludes.addLocalPrerequisite("bin.includes");
            srcIncludes.addProperty("excludes", "feature.properties", false);
            srcIncludes.setProductBase(OUTPUT_DIR.append("src.includes"));
            featureJarBuilder.addLocalPrerequisite((AttributeBuilder)srcIncludes);
            featureJarBuilder.addLocalPrerequisite("source.localization", "source.localization");
        }
        featureJarBuilder.setPrerequisitesAlias("action.requirements");
        featureJarBuilder.setProductAlias("action.output");
        featureJarBuilder.setProductBase(OUTPUT_DIR_SOURCE_JAR);
        featureJarBuilder.setUpToDatePolicy(UpToDatePolicy.COUNT);
        featureJarBuilder.setProductFileCount(1);
        GeneratorBuilder genBld = cspec.createGeneratorBuilder();
        genBld.setAttribute("source.feature.jar");
        genBld.setGeneratesType("eclipse.feature");
        genBld.setName(SourceFeatureCreator.createSourceFeatureId(cspec.getName()));
        cspec.addGenerator((IGenerator)genBld);
    }

    @Override
    void createSiteActions(IProgressMonitor monitor) throws CoreException {
        this.createSiteFeatureExportsAction();
        if (!this.addProducts(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)80))) {
            this.createSiteRepackAction("site.feature.exports");
            this.createSiteSignAction("site.feature.exports");
            this.createSitePackAction("site.feature.exports");
            this.createSiteAction("site.feature.exports", "manifest");
            this.createSiteZipAction();
        }
    }

    private void createBinIncludesArtifact(IComponentRequest licenseFeature, String versionedManifest, IProgressMonitor monitor) throws CoreException {
        CSpecBuilder cspec = this.getCSpec();
        ArtifactBuilder binIncludesArtifact = cspec.createArtifactBuilder();
        binIncludesArtifact.setPublic(false);
        if (this.buildProperties == null) {
            for (String path : this.getReader().list(monitor)) {
                if ("feature.xml".equals(path)) continue;
                binIncludesArtifact.addPath((IPath)new Path(path));
            }
        } else {
            List<Object> binIncludes = this.getReader().isFileSystemReader() ? this.expandBinFiles(this.getReader().getLocation(), this.buildProperties) : Collections.emptyList();
            cspec.addArtifact("build.properties", false, null).addPath((IPath)new Path("build.properties"));
            for (String string : binIncludes) {
                if ("feature.xml".equals(string)) continue;
                binIncludesArtifact.addPath((IPath)new Path(string));
            }
            MonitorUtils.complete((IProgressMonitor)monitor);
        }
        if (licenseFeature == null) {
            GroupBuilder jarContents = cspec.addGroup("jar.contents", true);
            if (!binIncludesArtifact.getPaths().isEmpty()) {
                binIncludesArtifact.setName("bin.includes");
                cspec.addAttribute((IAttribute)binIncludesArtifact);
                jarContents.addLocalPrerequisite((AttributeBuilder)binIncludesArtifact);
            }
            jarContents.addLocalPrerequisite(versionedManifest);
        } else {
            ActionBuilder mergeLicense = cspec.addAction("jar.contents", true, "mergeLicenseFeature", false);
            mergeLicense.addExternalPrerequisite(licenseFeature, "buckminster.component.self").setAlias("license.feature");
            mergeLicense.addExternalPrerequisite(licenseFeature, "jar.contents").setAlias("license.feature.contents");
            mergeLicense.addExternalPrerequisite(licenseFeature, "manifest").setAlias("license.manifest");
            if (!binIncludesArtifact.getPaths().isEmpty()) {
                binIncludesArtifact.setName("bin.includes.raw");
                cspec.addAttribute((IAttribute)binIncludesArtifact);
                mergeLicense.addLocalPrerequisite((AttributeBuilder)binIncludesArtifact).setAlias("bin.includes");
            }
            mergeLicense.addLocalPrerequisite(versionedManifest, "manifest");
            ActionArtifactBuilder actionArtifactBuilder = mergeLicense.addProductArtifact("bin.includes", true, OUTPUT_DIR.append("bin.includes"));
            actionArtifactBuilder.setAlias("action.output");
            ActionArtifactBuilder manifest = mergeLicense.addProductArtifact("manifest", true, OUTPUT_DIR_TEMP.append("manifest"));
            manifest.setAlias("manifest");
            manifest.addPath(Path.fromPortableString((String)"feature.xml"));
        }
    }

    private ActionBuilder createCopySiteFeaturesAction() throws CoreException {
        ActionBuilder copyFeatures = this.addAntAction("copy.subfeatures", "copy.group", false);
        copyFeatures.addLocalPrerequisite("feature.references");
        copyFeatures.addLocalPrerequisite("source.feature.references");
        copyFeatures.addLocalPrerequisite("feature.jar", null, INCLUDE_TOP_FILTER);
        copyFeatures.addLocalPrerequisite("source.feature.jar", null, INCLUDE_TOP_SOURCE_FILTER);
        copyFeatures.setPrerequisitesAlias("action.requirements");
        copyFeatures.setProductAlias("action.output");
        copyFeatures.setProductBase(OUTPUT_DIR_SITE.append("features"));
        copyFeatures.setUpToDatePolicy(UpToDatePolicy.MAPPER);
        return copyFeatures;
    }

    private void createFeatureManifestAction(String actionName, boolean asPublic) throws CoreException {
        Path featureFile = new Path("feature.xml");
        ArtifactBuilder rawManifest = this.getCSpec().addArtifact("raw.manifest", false, null);
        rawManifest.addPath((IPath)featureFile);
        ActionBuilder manifest = this.addAntAction(actionName, "expand.feature.version", asPublic);
        manifest.addLocalPrerequisite("raw.manifest", "manifest");
        manifest.addLocalPrerequisite("bundle.jars", "bundles");
        manifest.addLocalPrerequisite("feature.references", "features");
        if (this.getCSpec().getAttribute("build.properties") != null) {
            manifest.addLocalPrerequisite("build.properties", "properties");
        }
        manifest.setProductAlias("action.output");
        manifest.setProductBase(OUTPUT_DIR_TEMP.append(actionName));
        manifest.addProductPath((IPath)featureFile);
    }

    private void createFeatureSourceManifestAction(boolean translations) throws CoreException {
        ActionBuilder manifest;
        IPath productCommonPath = OUTPUT_DIR_TEMP.append("source");
        if (translations) {
            manifest = this.addAntAction("source.manifest.with.localization", "create.source.feature", true);
            ActionArtifactBuilder manifestResult = manifest.addProductArtifact("source.manifest", true, productCommonPath);
            manifestResult.addPath((IPath)new Path("feature.xml"));
            manifestResult.setAlias("action.output");
            ActionArtifactBuilder translatedResult = manifest.addProductArtifact("source.localization", true, productCommonPath);
            translatedResult.addPath((IPath)new Path("feature.properties"));
            manifest.addLocalPrerequisite("bin.includes", "translations");
        } else {
            manifest = this.addAntAction("source.manifest", "create.source.feature", true);
            manifest.setProductAlias("action.output");
            manifest.setProductBase(productCommonPath);
            manifest.addProductPath((IPath)new Path("feature.xml"));
            this.getCSpec().addGroup("empty.translations", false);
            manifest.addLocalPrerequisite("empty.translations", "translations");
        }
        manifest.addLocalPrerequisite("manifest", "manifest");
        manifest.addLocalPrerequisite("source.bundle.jars", "bundles");
        manifest.addLocalPrerequisite("source.feature.references", "features");
    }

    private void createSiteFeatureExportsAction() throws CoreException {
        GroupBuilder featureExports = this.getCSpec().getRequiredGroup("site.feature.exports");
        featureExports.addLocalPrerequisite((AttributeBuilder)this.createCopySiteFeaturesAction());
        featureExports.addLocalPrerequisite("copy.plugins");
        featureExports.setPrerequisiteRebase(OUTPUT_DIR_SITE);
    }
}

