/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.cspecgen.feature;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import org.eclipse.buckminster.core.cspec.builder.CSpecBuilder;
import org.eclipse.buckminster.core.ctype.IResolutionBuilder;
import org.eclipse.buckminster.core.ctype.MissingCSpecSourceException;
import org.eclipse.buckminster.core.helpers.PropertiesParser;
import org.eclipse.buckminster.core.reader.ICatalogReader;
import org.eclipse.buckminster.core.reader.IStreamConsumer;
import org.eclipse.buckminster.core.reader.URLFileReader;
import org.eclipse.buckminster.core.reader.ZipArchiveReader;
import org.eclipse.buckminster.pde.Messages;
import org.eclipse.buckminster.pde.PDEPlugin;
import org.eclipse.buckminster.pde.cspecgen.CSpecGenerator;
import org.eclipse.buckminster.pde.cspecgen.PDEBuilder;
import org.eclipse.buckminster.pde.cspecgen.feature.CSpecFromBinary;
import org.eclipse.buckminster.pde.cspecgen.feature.CSpecFromFeature;
import org.eclipse.buckminster.pde.cspecgen.feature.CSpecFromSource;
import org.eclipse.buckminster.pde.internal.EclipsePlatformReader;
import org.eclipse.buckminster.pde.internal.FeatureModelReader;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;

public class FeatureBuilder
extends PDEBuilder {
    public int compareTo(IResolutionBuilder other) {
        return 1;
    }

    public String getComponentTypeID() {
        return "eclipse.feature";
    }

    protected void parseFile(CSpecBuilder cspecBuilder, boolean forResolutionAidOnly, ICatalogReader reader, IProgressMonitor monitor) throws CoreException {
        CSpecFromFeature generator;
        IFeature feature;
        monitor.beginTask(null, 100);
        try {
            IFeatureModel model;
            if (reader instanceof EclipsePlatformReader) {
                model = ((EclipsePlatformReader)reader).getFeatureModel();
                MonitorUtils.worked((IProgressMonitor)monitor, (int)40);
            } else {
                try {
                    model = (IFeatureModel)reader.readFile("feature.xml", (IStreamConsumer)new FeatureModelReader(), MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)40));
                }
                catch (FileNotFoundException e) {
                    model = null;
                }
            }
            if (model == null) {
                throw new MissingCSpecSourceException(reader.getProviderMatch());
            }
            this.setModel((IModel)model);
            feature = model.getFeature();
        }
        catch (IOException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
        String featureId = feature.getId();
        if (featureId == null || featureId.length() == 0) {
            PDEPlugin.getLogger().warning(NLS.bind((String)Messages.No_feature_id_found_in_0, (Object)new File(reader.getLocation(), "feature.xml").getAbsolutePath()), new Object[0]);
            feature.setId("<undefined feature id>");
        }
        if (reader instanceof EclipsePlatformReader) {
            String location = ((EclipsePlatformReader)reader).getFeatureModel().getInstallLocation();
            generator = new CSpecFromBinary(cspecBuilder, reader, feature, new Path(location));
        } else if (reader instanceof ZipArchiveReader && ((ZipArchiveReader)reader).getFileReader() instanceof URLFileReader) {
            URI uri = ((URLFileReader)((ZipArchiveReader)reader).getFileReader()).getURI();
            generator = new CSpecFromBinary(cspecBuilder, reader, feature, new Path(uri.getPath()));
        } else {
            Map buildProperties = null;
            if (!forResolutionAidOnly) {
                try {
                    buildProperties = (Map)reader.readFile("build.properties", (IStreamConsumer)new PropertiesParser(), MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)40));
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                catch (IOException e) {
                    throw BuckminsterException.wrap((Throwable)e);
                }
            }
            generator = new CSpecFromSource(cspecBuilder, reader, feature, buildProperties);
        }
        ((CSpecGenerator)generator).generate(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)20));
        monitor.done();
    }
}

