/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.internal;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.resolver.NodeQuery;
import org.eclipse.buckminster.pde.Messages;
import org.eclipse.buckminster.pde.internal.EclipseImportReaderType;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.URLUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class EclipseImportBase {
    static final String PARAM_IMPORT_TYPE = "importType";
    static final String IMPORT_TYPE_BINARY = "binary";
    static final String IMPORT_TYPE_LINKED = "linked";
    static final String IMPORT_TYPE_SOURCE = "source";
    private final int type;
    private final boolean platform;
    private final boolean feature;
    private final Key key;
    private final String query;
    private final File location;
    private final URL remoteLocation;
    private boolean unpack = false;
    private static final UUID CACHE_IMPORT_BASE_CACHE = UUID.randomUUID();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EclipseImportBase obtain(NodeQuery query, String repositoryURI) throws CoreException {
        Map<Key, EclipseImportBase> cache;
        Key key = new Key(repositoryURI, query.getComponentRequest());
        Map<Key, EclipseImportBase> map = cache = EclipseImportBase.getImportBaseCacheCache(query.getContext().getUserCache());
        synchronized (map) {
            EclipseImportBase importBase = cache.get(key);
            if (importBase == null) {
                importBase = new EclipseImportBase(key);
                cache.put(key, importBase);
            }
            return importBase;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map<Key, EclipseImportBase> getImportBaseCacheCache(Map<UUID, Object> ctxUserCache) {
        Map<UUID, Object> map = ctxUserCache;
        synchronized (map) {
            Map listCache = (Map)ctxUserCache.get(CACHE_IMPORT_BASE_CACHE);
            if (listCache == null) {
                listCache = Collections.synchronizedMap(new HashMap());
                ctxUserCache.put(CACHE_IMPORT_BASE_CACHE, listCache);
            }
            return listCache;
        }
    }

    private EclipseImportBase(Key key) throws CoreException {
        URI uri;
        try {
            uri = new URI(key.getRepositoryURI());
        }
        catch (URISyntaxException e) {
            throw BuckminsterException.fromMessage((String)e.getMessage(), (Object[])new Object[0]);
        }
        String scheme = uri.getScheme();
        String path = uri.getPath();
        URL remoteLoc = null;
        File loc = null;
        boolean platf = false;
        if (scheme == null) {
            if (path == null || path.length() == 0) {
                platf = true;
            } else {
                loc = new File(path);
            }
        } else if ("file".equalsIgnoreCase(scheme)) {
            loc = new File(path);
        } else {
            try {
                if (!(path.endsWith("/") || path.endsWith(".map") || path.endsWith(".xml") || path.endsWith(".jar"))) {
                    path = String.valueOf(path) + '/';
                }
                remoteLoc = new URL(scheme, uri.getHost(), uri.getPort(), path);
            }
            catch (MalformedURLException e) {
                throw BuckminsterException.fromMessage((String)e.getMessage(), (Object[])new Object[0]);
            }
        }
        this.location = loc;
        this.remoteLocation = remoteLoc;
        this.platform = platf;
        this.query = uri.getQuery();
        this.key = key;
        this.feature = "eclipse.feature".equals(key.getRequest().getComponentTypeID());
        Map params = URLUtils.queryAsParameters((String)uri.getQuery());
        String importType = (String)params.get(PARAM_IMPORT_TYPE);
        if (importType == null) {
            this.type = 0;
        } else if (IMPORT_TYPE_BINARY.equalsIgnoreCase(importType)) {
            this.type = 1;
        } else if (IMPORT_TYPE_LINKED.equalsIgnoreCase(importType)) {
            this.type = 2;
        } else if (IMPORT_TYPE_SOURCE.equalsIgnoreCase(importType)) {
            this.type = 3;
        } else {
            throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.invalid_import_type_0, (Object)importType), (Object[])new Object[0]);
        }
    }

    public boolean equals(Object o) {
        return o == this || o instanceof EclipseImportBase && ((EclipseImportBase)o).key.equals(this.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    String getComponentName() {
        return this.key.getRequest().getName();
    }

    List<IFeatureModel> getFeatureModels(EclipseImportReaderType readerType, IProgressMonitor monitor) throws CoreException {
        return readerType.getFeatureModels(this.getLocation(), this.getComponentName(), monitor);
    }

    Key getKey() {
        return this.key;
    }

    final File getLocation() throws CoreException {
        if (this.location == null && !this.platform) {
            throw BuckminsterException.fromMessage((String)Messages.site_is_not_local, (Object[])new Object[0]);
        }
        return this.location;
    }

    List<IPluginModelBase> getPluginModels(EclipseImportReaderType readerType, IProgressMonitor monitor) throws CoreException {
        return readerType.getPluginModels(this.getLocation(), this.getComponentName(), monitor);
    }

    String getQuery() {
        return this.query;
    }

    final URL getRemoteLocation() throws CoreException {
        if (this.remoteLocation == null) {
            try {
                return this.location.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw BuckminsterException.wrap((Throwable)e);
            }
        }
        return this.remoteLocation;
    }

    int getType() {
        return this.type;
    }

    boolean isFeature() {
        return this.feature;
    }

    boolean isLocal() {
        return this.remoteLocation == null;
    }

    boolean isUnpack() {
        return this.unpack;
    }

    void setUnpack(boolean unpack) {
        this.unpack = unpack;
    }

    static class Key {
        private final String repositoryURI;
        private final ComponentRequest request;

        Key(String repositoryURI, ComponentRequest request) {
            this.repositoryURI = repositoryURI;
            this.request = request;
        }

        public boolean equals(Object o) {
            return this == o || o instanceof Key && this.repositoryURI.equals(((Key)o).repositoryURI) && this.request.equals((Object)((Key)o).request);
        }

        public String getRepositoryURI() {
            return this.repositoryURI;
        }

        public ComponentRequest getRequest() {
            return this.request;
        }

        public int hashCode() {
            return this.repositoryURI.hashCode() * 37 + this.request.hashCode();
        }
    }
}

