/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.internal;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.eclipse.buckminster.core.RMContext;
import org.eclipse.buckminster.core.cspec.model.ComponentIdentifier;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.ctype.IComponentType;
import org.eclipse.buckminster.core.helpers.FileUtils;
import org.eclipse.buckminster.core.helpers.TextUtils;
import org.eclipse.buckminster.core.materializer.MaterializationContext;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.core.mspec.ConflictResolution;
import org.eclipse.buckminster.core.reader.CatalogReaderType;
import org.eclipse.buckminster.core.reader.IComponentReader;
import org.eclipse.buckminster.core.reader.IVersionFinder;
import org.eclipse.buckminster.core.reader.P2ReaderType;
import org.eclipse.buckminster.core.resolver.NodeQuery;
import org.eclipse.buckminster.core.rmap.model.Provider;
import org.eclipse.buckminster.core.version.ProviderMatch;
import org.eclipse.buckminster.core.version.VersionHelper;
import org.eclipse.buckminster.core.version.VersionMatch;
import org.eclipse.buckminster.download.DownloadManager;
import org.eclipse.buckminster.pde.IPDEConstants;
import org.eclipse.buckminster.pde.Messages;
import org.eclipse.buckminster.pde.PDEPlugin;
import org.eclipse.buckminster.pde.internal.EclipseImportBase;
import org.eclipse.buckminster.pde.internal.EclipseImportReader;
import org.eclipse.buckminster.pde.internal.imports.PluginImportOperation;
import org.eclipse.buckminster.pde.mapfile.MapFile;
import org.eclipse.buckminster.pde.mapfile.MapFileEntry;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.buckminster.runtime.URLUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.equinox.internal.p2.artifact.repository.ArtifactRequest;
import org.eclipse.equinox.internal.p2.repository.Transport;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.processing.ProcessingStepHandler;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRequest;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDEState;
import org.eclipse.pde.internal.core.feature.ExternalFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseImportReaderType
extends CatalogReaderType
implements IPDEConstants {
    private static final UUID CACHE_KEY_SITE_CACHE = UUID.randomUUID();
    private final Map<IProject, IClasspathEntry[]> classpaths = new HashMap<IProject, IClasspathEntry[]>();
    private final HashMap<File, IFeatureModel[]> featureCache = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getTempSite(Map<UUID, Object> ucache) throws CoreException {
        Map<String, File> siteCache;
        Map<String, File> map = siteCache = EclipseImportReaderType.getSiteCache(ucache);
        synchronized (map) {
            String key = String.valueOf(EclipseImportReaderType.class.getSimpleName()) + ":tempSite";
            File tempSite = siteCache.get(key);
            if (tempSite != null) {
                return tempSite;
            }
            tempSite = FileUtils.createTempFolder((String)"bmsite", (String)".tmp");
            new File(tempSite, "plugins").mkdir();
            new File(tempSite, "features").mkdir();
            siteCache.put(key, tempSite);
            return tempSite;
        }
    }

    static URL createRemoteComponentURL(URL remoteLocation, IConnectContext cctx, ComponentIdentifier cid, String subDir) throws CoreException {
        if (remoteLocation.getPath().endsWith(".jar")) {
            return remoteLocation;
        }
        if (remoteLocation.getPath().endsWith(".map")) {
            for (MapFileEntry entry : EclipseImportReaderType.getMapEntries(remoteLocation, cctx)) {
                ComponentIdentifier entryCid = entry.getComponentIdentifier();
                if (!entryCid.getName().equals(cid.getName()) || !entryCid.getComponentTypeID().equals(cid.getComponentTypeID()) || !VersionHelper.equalsUnqualified((Version)cid.getVersion(), (Version)entryCid.getVersion())) continue;
                try {
                    return new URL(entry.getProperties().get("src"));
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.unable_to_find_0_in_map_1, (Object)cid.getName(), (Object)remoteLocation), (Object[])new Object[0]);
        }
        try {
            return new URL(remoteLocation, String.valueOf(subDir) + '/' + cid.getName() + '_' + cid.getVersion() + ".jar");
        }
        catch (MalformedURLException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
    }

    /*
     * Loose catch block
     */
    static List<MapFileEntry> getMapEntries(URL location, IConnectContext cctx) throws CoreException {
        InputStream input = null;
        try {
            ArrayList<MapFileEntry> mapEntries = new ArrayList<MapFileEntry>();
            input = DownloadManager.read((URL)location, (IConnectContext)cctx);
            MapFile.parse(input, location.toString(), null, null, mapEntries);
            ArrayList<MapFileEntry> binaryEntries = new ArrayList<MapFileEntry>();
            for (MapFileEntry entry : mapEntries) {
                Map<String, String> props;
                String src;
                if (!"url".equals(entry.getReaderType().getId()) || (src = (props = entry.getProperties()).get("src")) == null || !src.endsWith(".jar") && !src.endsWith(".zip")) continue;
                binaryEntries.add(entry);
            }
            ArrayList<MapFileEntry> arrayList = binaryEntries;
            IOUtils.close((Closeable)input);
            return arrayList;
        }
        catch (FileNotFoundException e) {
            List<MapFileEntry> list = Collections.emptyList();
            return list;
        }
        catch (IOException e2) {
            throw BuckminsterException.wrap((Throwable)e2);
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            IOUtils.close(input);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map<String, File> getSiteCache(Map<UUID, Object> ctxUserCache) {
        Map<UUID, Object> map = ctxUserCache;
        synchronized (map) {
            Map siteCache = (Map)ctxUserCache.get(CACHE_KEY_SITE_CACHE);
            if (siteCache == null) {
                siteCache = Collections.synchronizedMap(new HashMap());
                ctxUserCache.put(CACHE_KEY_SITE_CACHE, siteCache);
            }
            return siteCache;
        }
    }

    public synchronized void addProjectClasspath(IProject project, IClasspathEntry[] classPath) {
        this.classpaths.put(project, classPath);
    }

    public URI getArtifactURL(Resolution resolution, RMContext context) throws CoreException {
        try {
            boolean isFeature;
            URL siteURL = new URL(resolution.getRepository());
            String sitePath = siteURL.getPath();
            if (!(sitePath.endsWith(".map") || sitePath.endsWith(".xml") || sitePath.endsWith(".jar"))) {
                siteURL = URLUtils.appendTrailingSlash((URL)siteURL);
            }
            String subDir = (isFeature = "eclipse.feature".equals(resolution.getComponentTypeId())) ? "features" : "plugins";
            return EclipseImportReaderType.createRemoteComponentURL(siteURL, null, resolution.getComponentIdentifier(), subDir).toURI();
        }
        catch (MalformedURLException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
        catch (URISyntaxException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
    }

    public IComponentReader getReader(ProviderMatch providerMatch, IProgressMonitor monitor) throws CoreException {
        MonitorUtils.complete((IProgressMonitor)monitor);
        return new EclipseImportReader(this, providerMatch);
    }

    public String getRecommendedMaterializer() {
        return "p2";
    }

    public IVersionFinder getVersionFinder(Provider provider, IComponentType ctype, NodeQuery nodeQuery, IProgressMonitor monitor) throws CoreException {
        throw new UnsupportedOperationException("import reader can not be used for resolution");
    }

    public synchronized void postMaterialization(MaterializationContext context, IProgressMonitor monitor) throws CoreException {
        PluginImportOperation.setClasspaths(monitor, this.classpaths);
        this.featureCache.clear();
        this.classpaths.clear();
    }

    IInstallableUnit getCachedInstallableUnit(IMetadataRepository mdr, ProviderMatch providerMatch) throws CoreException {
        IQueryResult c;
        NodeQuery query = providerMatch.getNodeQuery();
        Version bv = providerMatch.getVersionMatch().getVersion();
        if (bv == null) {
            return null;
        }
        VersionRange vr = new VersionRange(bv, true, bv, true);
        ComponentRequest cr = query.getComponentRequest();
        String name = cr.getName();
        if ("eclipse.feature".equals(cr.getComponentTypeID()) && !name.endsWith(".feature.group")) {
            name = String.valueOf(name) + ".feature.group";
        }
        if ((c = mdr.query(QueryUtil.createIUQuery((String)name, (VersionRange)vr), null)).isEmpty()) {
            return null;
        }
        return (IInstallableUnit)c.iterator().next();
    }

    IFeatureModel getFeatureModel(ProviderMatch rInfo, IProgressMonitor monitor) throws CoreException {
        IFeatureModel model = null;
        EclipseImportBase localBase = this.localizeContents(rInfo, false, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)90));
        String version = rInfo.getVersionMatch().getVersion().toString();
        for (IFeatureModel candidate : localBase.getFeatureModels(this, monitor)) {
            if (!version.equals(candidate.getFeature().getVersion())) continue;
            model = candidate;
            break;
        }
        return model;
    }

    List<IFeatureModel> getFeatureModels(File location, String featureName, IProgressMonitor monitor) throws CoreException {
        ArrayList<IFeatureModel> candidates = new ArrayList<IFeatureModel>();
        IFeatureModel[] iFeatureModelArray = this.getSiteFeatures(location, monitor);
        int n = iFeatureModelArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFeatureModel model = iFeatureModelArray[n2];
            if (model.getFeature().getId().equals(featureName)) {
                candidates.add(model);
            }
            ++n2;
        }
        return candidates;
    }

    IPluginModelBase getPluginModel(ProviderMatch rInfo, IProgressMonitor monitor) throws CoreException {
        IPluginModelBase model = null;
        EclipseImportBase localBase = this.localizeContents(rInfo, true, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)90));
        String version = rInfo.getVersionMatch().getVersion().toString();
        for (IPluginModelBase candidate : localBase.getPluginModels(this, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)10))) {
            if (!version.equals(candidate.getBundleDescription().getVersion().toString())) continue;
            model = candidate;
            break;
        }
        return model;
    }

    List<IPluginModelBase> getPluginModels(File location, String pluginName, IProgressMonitor monitor) throws CoreException {
        ArrayList<IPluginModelBase> candidates = new ArrayList<IPluginModelBase>();
        IPluginModelBase[] iPluginModelBaseArray = this.getSitePlugins(location, monitor);
        int n = iPluginModelBaseArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginModelBase model = iPluginModelBaseArray[n2];
            if (model.getPluginBase().getId().equals(pluginName)) {
                candidates.add(model);
            }
            ++n2;
        }
        return candidates;
    }

    synchronized EclipseImportBase localizeContents(ProviderMatch rInfo, boolean isPlugin, IProgressMonitor monitor) throws CoreException {
        NodeQuery query = rInfo.getNodeQuery();
        EclipseImportBase base = EclipseImportBase.obtain(query, rInfo.getRepositoryURI());
        if (base.isLocal() && rInfo.getVersionMatch().getArtifactInfo() == null) {
            return base;
        }
        Map userCache = query.getContext().getUserCache();
        String name = base.getComponentName();
        monitor.beginTask(null, 1000);
        monitor.subTask(NLS.bind((String)Messages.localizing_0, (Object)name));
        try {
            IConnectContext cctx = rInfo.getConnectContext();
            String typeDir = isPlugin ? "plugins" : "features";
            File tempSite = EclipseImportReaderType.getTempSite(userCache);
            File subDir = new File(tempSite, typeDir);
            String jarName = null;
            File jarFile = null;
            VersionMatch vm = rInfo.getVersionMatch();
            if (vm.getArtifactInfo() != null) {
                IInstallableUnit iu = P2ReaderType.getIU((ProviderMatch)rInfo, (IProgressMonitor)monitor);
                IArtifactRepository ar = P2ReaderType.getArtifactRepository((ProviderMatch)rInfo, (IProgressMonitor)monitor);
                Transport transport = (Transport)ar.getProvisioningAgent().getService(Transport.SERVICE_NAME);
                for (IArtifactKey ak : iu.getArtifacts()) {
                    IStatus status = ar.getArtifacts(new IArtifactRequest[]{new CopyRequest(ak, transport, jarFile = new File(subDir, jarName = String.valueOf(ak.getId()) + '_' + ak.getVersion() + ".jar"))}, monitor);
                    if (status.isOK()) continue;
                    throw new CoreException(status);
                }
                if (jarFile == null) {
                    throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.IU_0_1_has_no_artifacts, (Object)iu.getId(), (Object)iu.getVersion()), (Object[])new Object[0]);
                }
            } else {
                URL pluginURL = EclipseImportReaderType.createRemoteComponentURL(base.getRemoteLocation(), cctx, new ComponentIdentifier(rInfo.getComponentName(), rInfo.getComponentType().getId(), vm.getVersion()), typeDir);
                IPath path = Path.fromPortableString((String)pluginURL.getPath());
                jarName = path.lastSegment();
                if (!jarName.endsWith(".jar") && !jarName.endsWith(".zip")) {
                    throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.invalid_url_fore_remote_import_0, (Object)pluginURL), (Object[])new Object[0]);
                }
                jarFile = new File(subDir, jarName);
                InputStream input = null;
                try {
                    input = DownloadManager.getCache().open(pluginURL, cctx, null, null, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)900));
                    FileUtils.copyFile((InputStream)input, (File)subDir, (String)jarName, (IProgressMonitor)MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)900));
                }
                catch (Throwable ak) {
                    IOUtils.close(input);
                    throw ak;
                }
                IOUtils.close((Closeable)input);
            }
            EclipseImportBase.Key remoteKey = base.getKey();
            base = EclipseImportBase.obtain(query, new URI("file", null, tempSite.toURI().getPath(), base.getQuery(), name).toString());
            File destDir = null;
            boolean unpack = true;
            ConflictResolution cres = ConflictResolution.REPLACE;
            if (jarName.endsWith(".zip")) {
                destDir = subDir;
                cres = ConflictResolution.UPDATE;
            } else {
                if (!base.isFeature()) {
                    JarFile jf = new JarFile(jarFile);
                    Manifest mf = jf.getManifest();
                    if (mf != null) {
                        String[] classPath = TextUtils.split((String)mf.getMainAttributes().getValue("Bundle-ClassPath"), (String)",");
                        int top = classPath.length;
                        unpack = top > 0;
                        int idx = 0;
                        while (idx < top) {
                            if (classPath[idx].trim().equals(".")) {
                                unpack = false;
                                break;
                            }
                            ++idx;
                        }
                    }
                    jf.close();
                }
                if (unpack) {
                    String vcName = jarName.substring(0, jarName.length() - 4);
                    destDir = new File(subDir, vcName);
                }
            }
            if (unpack) {
                FileInputStream input = new FileInputStream(jarFile);
                try {
                    FileUtils.unzip((InputStream)input, null, (File)destDir, (ConflictResolution)cres, (IProgressMonitor)MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)100));
                }
                finally {
                    IOUtils.close((Closeable)input);
                }
                jarFile.delete();
            }
            base.setUnpack(unpack);
            EclipseImportBase.getImportBaseCacheCache(userCache).put(remoteKey, base);
            EclipseImportBase eclipseImportBase = base;
            return eclipseImportBase;
        }
        catch (URISyntaxException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
        catch (IOException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
        finally {
            monitor.done();
        }
    }

    private CoreException createException(ArrayList<IStatus> resultStatus) {
        int errCount = resultStatus.size();
        if (errCount == 1) {
            return new CoreException(resultStatus.get(0));
        }
        IStatus[] children = resultStatus.toArray(new IStatus[errCount]);
        MultiStatus multiStatus = new MultiStatus(PDEPlugin.getPluginId(), 0, children, Messages.problems_loading_feature, null);
        return new CoreException((IStatus)multiStatus);
    }

    private IFeatureModel[] getPlatformFeatures() {
        return PDECore.getDefault().getFeatureModelManager().getModels();
    }

    private IPluginModelBase[] getPlatformPlugins() {
        return PDECore.getDefault().getModelManager().getExternalModels();
    }

    private synchronized IFeatureModel[] getSiteFeatures(File location, IProgressMonitor monitor) throws CoreException {
        if (location == null) {
            return this.getPlatformFeatures();
        }
        IFeatureModel[] result = this.featureCache.get(location);
        if (result != null) {
            return result;
        }
        File[] dirs = (location = new File(location, "features")).listFiles();
        if (dirs == null || dirs.length == 0) {
            return new IFeatureModel[0];
        }
        monitor.beginTask(null, dirs.length);
        monitor.subTask(NLS.bind((String)Messages.building_feature_list_for_site_0, (Object)location));
        ArrayList<ExternalFeatureModel> models = new ArrayList<ExternalFeatureModel>(dirs.length);
        ArrayList<IStatus> resultStatus = null;
        File[] fileArray = dirs;
        int n = dirs.length;
        int n2 = 0;
        while (n2 < n) {
            block13: {
                File dir = fileArray[n2];
                File manifest = new File(dir, "feature.xml");
                FileInputStream manifestInput = null;
                try {
                    manifestInput = new FileInputStream(manifest);
                    ExternalFeatureModel model = new ExternalFeatureModel();
                    model.setInstallLocation(dir.getAbsolutePath());
                    model.load((InputStream)manifestInput, false);
                    if (!model.isValid()) {
                        throw new CoreException((IStatus)new Status(2, PDEPlugin.getPluginId(), 0, NLS.bind((String)Messages.import_location_0_contains_invalid_feature, (Object)dir), null));
                    }
                    models.add(model);
                }
                catch (FileNotFoundException model) {
                    IOUtils.close(manifestInput);
                    MonitorUtils.worked((IProgressMonitor)monitor, (int)1);
                    break block13;
                }
                catch (CoreException e) {
                    try {
                        if (resultStatus == null) {
                            resultStatus = new ArrayList<IStatus>();
                        }
                        resultStatus.add(e.getStatus());
                    }
                    catch (Throwable throwable) {
                        IOUtils.close(manifestInput);
                        MonitorUtils.worked((IProgressMonitor)monitor, (int)1);
                        throw throwable;
                    }
                    IOUtils.close((Closeable)manifestInput);
                    MonitorUtils.worked((IProgressMonitor)monitor, (int)1);
                    break block13;
                }
                IOUtils.close((Closeable)manifestInput);
                MonitorUtils.worked((IProgressMonitor)monitor, (int)1);
            }
            ++n2;
        }
        if (resultStatus != null) {
            throw this.createException(resultStatus);
        }
        result = models.toArray(new IFeatureModel[models.size()]);
        this.featureCache.put(location, result);
        return result;
    }

    private synchronized IPluginModelBase[] getSitePlugins(File location, IProgressMonitor monitor) throws CoreException {
        if (location == null) {
            return this.getPlatformPlugins();
        }
        monitor.beginTask(null, 2);
        monitor.subTask(NLS.bind((String)Messages.building_plugin_list_for_site_0, (Object)location));
        try {
            File pluginsRoot = new File(location, "plugins");
            if (!pluginsRoot.isDirectory()) {
                IPluginModelBase[] iPluginModelBaseArray = new IPluginModelBase[]{};
                return iPluginModelBaseArray;
            }
            File[] files = pluginsRoot.listFiles();
            int idx = files.length;
            URL[] pluginURLs = new URL[idx];
            while (--idx >= 0) {
                pluginURLs[idx] = files[idx].toURI().toURL();
            }
            MonitorUtils.worked((IProgressMonitor)monitor, (int)1);
            PDEState state = new PDEState(pluginURLs, false, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1));
            IPluginModelBase[] iPluginModelBaseArray = state.getTargetModels();
            return iPluginModelBaseArray;
        }
        catch (IOException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
        finally {
            monitor.done();
        }
    }

    public static class CopyRequest
    extends ArtifactRequest {
        private final File destination;

        public CopyRequest(IArtifactKey key, Transport transport, File destination) {
            super(key, transport);
            this.destination = destination;
        }

        public void perform(IArtifactRepository sourceRepository, IProgressMonitor monitor) {
            monitor.subTask(NLS.bind((String)Messages.downloading_0, (Object)this.getArtifactKey().getId()));
            this.setSourceRepository(sourceRepository);
            IArtifactDescriptor optimized = null;
            IArtifactDescriptor canonical = null;
            IArtifactDescriptor descriptor = null;
            IArtifactDescriptor[] descriptors = this.source.getArtifactDescriptors(this.getArtifactKey());
            if (descriptors.length > 0) {
                int i = 0;
                while (i < descriptors.length) {
                    if (descriptors[i].getProperty("format") == null) {
                        canonical = descriptors[i];
                    } else if (ProcessingStepHandler.canProcess((IArtifactDescriptor)descriptors[i])) {
                        optimized = descriptors[i];
                    }
                    ++i;
                }
                boolean chooseCanonical = this.source.getLocation().equals("file");
                IArtifactDescriptor iArtifactDescriptor = descriptor = chooseCanonical ? canonical : optimized;
                if (descriptor == null) {
                    IArtifactDescriptor iArtifactDescriptor2 = descriptor = !chooseCanonical ? canonical : optimized;
                }
            }
            if (descriptor == null) {
                this.setResult((IStatus)new Status(4, PDEPlugin.getPluginId(), NLS.bind((String)Messages.artifact_not_found_0, (Object)this.getArtifactKey())));
                return;
            }
            IStatus status = this.transfer(descriptor, monitor);
            if (monitor.isCanceled()) {
                this.setResult(Status.CANCEL_STATUS);
                return;
            }
            if (status.isOK() || status.getSeverity() == 8) {
                this.setResult(status);
                return;
            }
            if (descriptor == canonical || canonical == null) {
                this.setResult(status);
                return;
            }
            this.setResult(this.transfer(canonical, monitor));
        }

        private IStatus transfer(IArtifactDescriptor descriptor, IProgressMonitor monitor) {
            IStatus status;
            while ((status = this.transferSingle(descriptor, monitor)).getSeverity() == 4 && status.getCode() == 13) {
            }
            return status;
        }

        private IStatus transferSingle(IArtifactDescriptor descriptor, IProgressMonitor monitor) {
            IStatus status;
            block5: {
                FileOutputStream output = null;
                status = null;
                try {
                    try {
                        output = new FileOutputStream(this.destination);
                        status = this.source.getArtifact(descriptor, (OutputStream)output, monitor);
                    }
                    catch (IOException e) {
                        status = BuckminsterException.createStatus((Throwable)e);
                        IOUtils.close((Closeable)output);
                        break block5;
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.close(output);
                    throw throwable;
                }
                IOUtils.close((Closeable)output);
            }
            return status;
        }
    }
}

