/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.internal;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.buckminster.core.RMContext;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.ctype.IComponentType;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.core.reader.CatalogReaderType;
import org.eclipse.buckminster.core.reader.IComponentReader;
import org.eclipse.buckminster.core.reader.IReaderType;
import org.eclipse.buckminster.core.reader.IVersionFinder;
import org.eclipse.buckminster.core.resolver.NodeQuery;
import org.eclipse.buckminster.core.resolver.ResolverDecisionType;
import org.eclipse.buckminster.core.rmap.model.Provider;
import org.eclipse.buckminster.core.version.ProviderMatch;
import org.eclipse.buckminster.core.version.VersionHelper;
import org.eclipse.buckminster.pde.Messages;
import org.eclipse.buckminster.pde.internal.EclipsePlatformReader;
import org.eclipse.buckminster.pde.internal.EclipsePlatformVersionFinder;
import org.eclipse.buckminster.pde.internal.PDETargetPlatform;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.IPluginModelListener;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginModelDelta;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.osgi.framework.Version;

public class EclipsePlatformReaderType
extends CatalogReaderType {
    private static final Map<String, IPluginModelBase[]> activeMap = new HashMap<String, IPluginModelBase[]>();

    static {
        PDECore.getDefault().getModelManager().addPluginModelListener(new IPluginModelListener(){

            public void modelsChanged(PluginModelDelta delta) {
                if (delta.getKind() != 0) {
                    EclipsePlatformReaderType.clearCache();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCache() {
        Map<String, IPluginModelBase[]> map = activeMap;
        synchronized (map) {
            activeMap.clear();
        }
    }

    public static IFeatureModel getBestFeature(String componentName, VersionRange versionDesignator, NodeQuery query) {
        return PDETargetPlatform.getBestFeature(componentName, versionDesignator, query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IPluginModelBase getBestPlugin(String componentName, VersionRange versionDesignator, NodeQuery query) {
        IPluginModelBase candidate = null;
        org.eclipse.equinox.p2.metadata.Version candidateVersion = null;
        Map<String, IPluginModelBase[]> map = activeMap;
        synchronized (map) {
            IPluginModelBase[] mbArr;
            int n;
            block18: {
                if (activeMap.isEmpty()) {
                    IPluginModelBase[] iPluginModelBaseArray = PluginRegistry.getAllModels();
                    n = iPluginModelBaseArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IPluginModelBase model = iPluginModelBaseArray[n2];
                        BundleDescription desc = model.getBundleDescription();
                        if (desc != null) {
                            String id = desc.getSymbolicName();
                            IPluginModelBase[] mbArr2 = activeMap.get(id);
                            if (mbArr2 == null) {
                                mbArr2 = new IPluginModelBase[]{model};
                            } else {
                                IPluginModelBase[] newArr = new IPluginModelBase[mbArr2.length + 1];
                                System.arraycopy(mbArr2, 0, newArr, 0, mbArr2.length);
                                newArr[mbArr2.length] = model;
                                mbArr2 = newArr;
                            }
                            activeMap.put(id, mbArr2);
                        }
                        ++n2;
                    }
                }
                if ((mbArr = activeMap.get(componentName)) != null) break block18;
                return null;
            }
            IPluginModelBase[] iPluginModelBaseArray = mbArr;
            int n3 = mbArr.length;
            n = 0;
            while (n < n3) {
                IPluginModelBase model = iPluginModelBaseArray[n];
                BundleDescription desc = model.getBundleDescription();
                if (desc != null) {
                    Version ov = desc.getVersion();
                    if (ov == null) {
                        if (candidate == null && versionDesignator == null) {
                            candidate = model;
                        }
                    } else {
                        org.eclipse.equinox.p2.metadata.Version v = org.eclipse.equinox.p2.metadata.Version.createOSGi((int)ov.getMajor(), (int)ov.getMinor(), (int)ov.getMicro(), (String)ov.getQualifier());
                        if (versionDesignator != null && !versionDesignator.isIncluded(v)) {
                            if (query != null) {
                                query.logDecision(ResolverDecisionType.VERSION_REJECTED, new Object[]{v, NLS.bind((String)Messages.not_designated_by_0, (Object)versionDesignator)});
                            }
                        } else if (candidateVersion == null || candidateVersion.compareTo((Object)v) < 0) {
                            candidate = model;
                            candidateVersion = v;
                        }
                    }
                }
                ++n;
            }
            return candidate;
        }
    }

    static File getBundleLocation(BundleInfo plugin) {
        if (plugin == null) {
            return null;
        }
        URI il = plugin.getLocation();
        if (il == null) {
            return null;
        }
        if (!"file".equalsIgnoreCase(il.getScheme())) {
            URL fileIL;
            block6: {
                try {
                    fileIL = FileLocator.toFileURL((URL)il.toURL());
                    if (!"file".equalsIgnoreCase(fileIL.getProtocol())) break block6;
                    return null;
                }
                catch (Exception e) {
                    return null;
                }
            }
            il = fileIL.toURI();
        }
        return new File(il);
    }

    public URI getArtifactURL(Resolution resolution, RMContext context) throws CoreException {
        return null;
    }

    public IPath getFixedLocation(Resolution cr) {
        String location;
        org.eclipse.equinox.p2.metadata.Version version = cr.getVersion();
        VersionRange vd = version == null ? null : VersionHelper.exactRange((org.eclipse.equinox.p2.metadata.Version)version);
        ComponentRequest rq = cr.getRequest();
        if ("eclipse.feature".equals(rq.getComponentTypeID())) {
            IFeatureModel model = PDETargetPlatform.getBestFeature(rq.getName(), vd, null);
            if (model == null) {
                return null;
            }
            location = model.getInstallLocation();
        } else {
            BundleInfo plugin = PDETargetPlatform.getBestPlugin(rq.getName(), vd, null);
            if (plugin == null) {
                return null;
            }
            File fileLoc = EclipsePlatformReaderType.getBundleLocation(plugin);
            if (fileLoc == null) {
                return null;
            }
            location = fileLoc.getAbsolutePath();
        }
        Path path = null;
        if (location != null && (path = new Path(location)).toFile().isDirectory()) {
            path = path.addTrailingSeparator();
        }
        return path;
    }

    public IComponentReader getReader(ProviderMatch providerMatch, IProgressMonitor monitor) throws CoreException {
        MonitorUtils.complete((IProgressMonitor)monitor);
        return new EclipsePlatformReader((IReaderType)this, providerMatch);
    }

    public IVersionFinder getVersionFinder(Provider provider, IComponentType ctype, NodeQuery nodeQuery, IProgressMonitor monitor) throws CoreException {
        MonitorUtils.complete((IProgressMonitor)monitor);
        return new EclipsePlatformVersionFinder((IReaderType)this, provider, ctype, nodeQuery);
    }
}

