/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.internal;

import java.util.Locale;
import org.eclipse.buckminster.core.ctype.IComponentType;
import org.eclipse.buckminster.core.reader.IReaderType;
import org.eclipse.buckminster.core.resolver.NodeQuery;
import org.eclipse.buckminster.core.rmap.model.MalformedProviderURIException;
import org.eclipse.buckminster.core.rmap.model.Provider;
import org.eclipse.buckminster.core.version.AbstractVersionFinder;
import org.eclipse.buckminster.core.version.VersionHelper;
import org.eclipse.buckminster.core.version.VersionMatch;
import org.eclipse.buckminster.pde.internal.PDETargetPlatform;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;

public class EclipsePlatformVersionFinder
extends AbstractVersionFinder {
    private final String componentName;
    private final InstalledType type;

    public EclipsePlatformVersionFinder(IReaderType readerType, Provider provider, IComponentType ctype, NodeQuery query) throws CoreException {
        super(provider, ctype, query);
        String uri = provider.getURI(query.getProperties());
        Path path = new Path(uri);
        if (path.segmentCount() == 2) {
            this.type = InstalledType.valueOf(path.segment(0).toUpperCase(Locale.ENGLISH));
            if (this.type != null) {
                this.componentName = path.segment(1);
                return;
            }
        }
        throw new MalformedProviderURIException(readerType, uri);
    }

    public VersionMatch getBestVersion(IProgressMonitor monitor) throws CoreException {
        Version v = null;
        NodeQuery query = this.getQuery();
        VersionRange dsg = query.getVersionRange();
        if (this.type == InstalledType.PLUGIN) {
            BundleInfo plugin = PDETargetPlatform.getBestPlugin(this.componentName, dsg, query);
            if (plugin != null) {
                v = VersionHelper.parseVersion((String)plugin.getVersion());
            }
        } else {
            IFeatureModel feature = PDETargetPlatform.getBestFeature(this.componentName, dsg, query);
            if (feature != null) {
                v = VersionHelper.parseVersion((String)feature.getFeature().getVersion());
            }
        }
        return v == null ? null : new VersionMatch(v, null, -1L, null, null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum InstalledType {
        FEATURE,
        PLUGIN;

    }
}

