/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.internal;

import java.net.URL;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.cspec.IComponentRequest;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.ctype.IComponentType;
import org.eclipse.buckminster.core.ctype.IResolutionBuilder;
import org.eclipse.buckminster.core.metadata.StorageManager;
import org.eclipse.buckminster.core.metadata.model.BOMNode;
import org.eclipse.buckminster.core.metadata.model.Materialization;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.core.query.builder.ComponentQueryBuilder;
import org.eclipse.buckminster.core.reader.IComponentReader;
import org.eclipse.buckminster.core.reader.IReaderType;
import org.eclipse.buckminster.core.resolver.LocalResolver;
import org.eclipse.buckminster.core.resolver.ResolutionContext;
import org.eclipse.buckminster.core.rmap.model.Provider;
import org.eclipse.buckminster.core.version.VersionMatch;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class ImportBundle {
    private final URL siteURL;
    private final IPath outputDir;
    private final String bundleName;

    public ImportBundle(String bundleName, URL siteURL, IPath outputDir) {
        this.bundleName = bundleName;
        this.outputDir = outputDir.addTrailingSeparator();
        this.siteURL = siteURL;
    }

    public void execute() throws Exception {
        ComponentQueryBuilder queryBld = new ComponentQueryBuilder();
        queryBld.setRootRequest((IComponentRequest)new ComponentRequest(this.bundleName, "osgi.bundle", null));
        queryBld.setPlatformAgnostic(true);
        ResolutionContext context = new ResolutionContext(queryBld.createComponentQuery());
        IComponentType ctype = CorePlugin.getDefault().getComponentType("osgi.bundle");
        Provider provider = Provider.immutableProvider((String)"eclipse.import", (String)ctype.getId(), (String)this.siteURL.toString());
        NullProgressMonitor monitor = new NullProgressMonitor();
        IReaderType rt = provider.getReaderType();
        IComponentReader[] reader = new IComponentReader[]{rt.getReader(provider, ctype, context.getRootNodeQuery(), VersionMatch.DEFAULT, (IProgressMonitor)monitor)};
        try {
            IResolutionBuilder builder = CorePlugin.getDefault().getResolutionBuilder("plugin2cspec");
            BOMNode node = builder.build(reader, false, (IProgressMonitor)monitor);
            reader[0].materialize(this.outputDir, null, null, (IProgressMonitor)monitor);
            StorageManager sm = StorageManager.getDefault();
            Resolution newRes = LocalResolver.fromPath((IPath)this.outputDir, (String)this.bundleName);
            newRes = new Resolution(newRes.getCSpec(), node.getResolution());
            newRes.store(sm);
            Materialization mat = new Materialization(this.outputDir, newRes.getComponentIdentifier());
            mat.store(sm);
        }
        finally {
            reader[0].close();
        }
        rt.postMaterialization(null, (IProgressMonitor)monitor);
    }
}

