/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.ITargetPlatform;
import org.eclipse.buckminster.core.cspec.model.ComponentIdentifier;
import org.eclipse.buckminster.core.helpers.AbstractExtension;
import org.eclipse.buckminster.core.resolver.NodeQuery;
import org.eclipse.buckminster.core.resolver.ResolverDecisionType;
import org.eclipse.buckminster.pde.Messages;
import org.eclipse.buckminster.runtime.Buckminster;
import org.eclipse.buckminster.runtime.Logger;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.TargetPlatform;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetHandle;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.core.target.ITargetPlatformService;
import org.eclipse.pde.core.target.LoadTargetDefinitionJob;
import org.eclipse.pde.core.target.TargetBundle;
import org.eclipse.pde.core.target.TargetFeature;
import org.eclipse.pde.internal.core.ExternalFeatureModelManager;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.target.DirectoryBundleContainer;
import org.eclipse.pde.internal.core.target.TargetPlatformService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDETargetPlatform
extends AbstractExtension
implements ITargetPlatform {
    private static final String defaultTP = "Buckminster Default TP";
    private static ITargetDefinition currentDefinition;
    private static ITargetHandle currentHandle;

    public static IFeatureModel getBestFeature(final String componentName, final VersionRange versionDesignator, final NodeQuery query) {
        return PDETargetPlatform.doWithActivePlatform(new ITargetDefinitionOperation<IFeatureModel>(){

            @Override
            public IFeatureModel run(ITargetDefinition target) throws CoreException {
                TargetFeature[] allFeatures = target.getAllFeatures();
                if (allFeatures == null) {
                    return null;
                }
                TargetFeature candidate = null;
                Version candidateVersion = null;
                TargetFeature[] targetFeatureArray = allFeatures;
                int n = allFeatures.length;
                int n2 = 0;
                while (n2 < n) {
                    TargetFeature targetFeature = targetFeatureArray[n2];
                    if (componentName.equals(targetFeature.getId())) {
                        Version v = Version.create((String)targetFeature.getVersion());
                        if (v == null) {
                            if (candidate == null && versionDesignator == null) {
                                candidate = targetFeature;
                            }
                        } else if (versionDesignator != null && !versionDesignator.isIncluded(v)) {
                            if (query != null) {
                                query.logDecision(ResolverDecisionType.VERSION_REJECTED, new Object[]{v, NLS.bind((String)Messages.not_designated_by_0, (Object)versionDesignator)});
                            }
                        } else if (candidateVersion == null || candidateVersion.compareTo((Object)v) < 0) {
                            candidate = targetFeature;
                            candidateVersion = v;
                        }
                    }
                    ++n2;
                }
                IFeatureModel model = null;
                if (candidate != null) {
                    model = ExternalFeatureModelManager.createModel((File)new File(candidate.getLocation(), "feature.xml"));
                }
                return model;
            }
        });
    }

    public static BundleInfo getBestPlugin(final String componentName, final VersionRange versionDesignator, final NodeQuery query) {
        return PDETargetPlatform.doWithActivePlatform(new ITargetDefinitionOperation<BundleInfo>(){

            @Override
            public BundleInfo run(ITargetDefinition target) throws CoreException {
                TargetBundle[] allBundles = target.getAllBundles();
                if (allBundles == null) {
                    return null;
                }
                BundleInfo candidate = null;
                Version candidateVersion = null;
                TargetBundle[] targetBundleArray = allBundles;
                int n = allBundles.length;
                int n2 = 0;
                while (n2 < n) {
                    TargetBundle targetBundle = targetBundleArray[n2];
                    BundleInfo bi = targetBundle.getBundleInfo();
                    if (componentName.equals(bi.getSymbolicName())) {
                        Version v = Version.create((String)bi.getVersion());
                        if (v == null) {
                            if (candidate == null && versionDesignator == null) {
                                candidate = bi;
                            }
                        } else if (versionDesignator != null && !versionDesignator.isIncluded(v)) {
                            if (query != null) {
                                query.logDecision(ResolverDecisionType.VERSION_REJECTED, new Object[]{v, NLS.bind((String)Messages.not_designated_by_0, (Object)versionDesignator)});
                            }
                        } else if (candidateVersion == null || candidateVersion.compareTo((Object)v) < 0) {
                            candidate = bi;
                            candidateVersion = v;
                        }
                    }
                    ++n2;
                }
                return candidate;
            }
        });
    }

    public static void setTargetActive(ITargetDefinition target, IProgressMonitor monitor) throws CoreException {
        MonitorUtils.begin((IProgressMonitor)monitor, (int)100);
        target.resolve(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)50));
        LoadTargetDefinitionJob job = new LoadTargetDefinitionJob(target);
        IStatus status = job.run(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)50));
        if (status.getSeverity() == 4) {
            throw new CoreException(status);
        }
        currentDefinition = target;
        currentHandle = target.getHandle();
        MonitorUtils.done((IProgressMonitor)monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T doWithActivePlatform(ITargetDefinitionOperation<T> operation) {
        Buckminster bucky = Buckminster.getDefault();
        ITargetPlatformService service = null;
        try {
            ITargetPlatformService iTargetPlatformService = service = (ITargetPlatformService)bucky.getService(ITargetPlatformService.class);
            synchronized (iTargetPlatformService) {
                IStatus status;
                ITargetHandle activeHandle;
                block12: {
                    activeHandle = service.getWorkspaceTargetHandle();
                    if (activeHandle != null) break block12;
                    return null;
                }
                if (currentDefinition == null || currentHandle == null || !activeHandle.equals(currentHandle)) {
                    currentDefinition = activeHandle.getTargetDefinition();
                    currentHandle = activeHandle;
                }
                if (!currentDefinition.isResolved() && (status = currentDefinition.resolve((IProgressMonitor)new NullProgressMonitor())).getSeverity() == 4) {
                    throw new CoreException(status);
                }
            }
            T t = operation.run(currentDefinition);
            return t;
        }
        catch (CoreException e) {
            Buckminster.getLogger().warning((Throwable)e, e.getLocalizedMessage(), new Object[0]);
            return null;
        }
        finally {
            bucky.ungetService((Object)service);
        }
    }

    private static File getLocation(ITargetDefinition target) throws CoreException {
        ITargetLocation[] containers = target.getTargetLocations();
        if (containers == null) {
            return null;
        }
        ITargetLocation[] iTargetLocationArray = containers;
        int n = containers.length;
        int n2 = 0;
        while (n2 < n) {
            ITargetLocation container = iTargetLocationArray[n2];
            if (container instanceof DirectoryBundleContainer) {
                return new File(((DirectoryBundleContainer)container).getLocation(true));
            }
            ++n2;
        }
        return null;
    }

    public String getArch() {
        String arch = PDETargetPlatform.doWithActivePlatform(new ITargetDefinitionOperation<String>(){

            @Override
            public String run(ITargetDefinition target) {
                return target.getArch();
            }
        });
        return arch == null ? TargetPlatform.getOSArch() : arch;
    }

    public List<ComponentIdentifier> getComponents() throws CoreException {
        return PDETargetPlatform.doWithActivePlatform(new ITargetDefinitionOperation<List<ComponentIdentifier>>(){

            @Override
            public List<ComponentIdentifier> run(ITargetDefinition target) {
                if (!target.isResolved()) {
                    target.resolve((IProgressMonitor)new NullProgressMonitor());
                }
                ArrayList<ComponentIdentifier> result = new ArrayList<ComponentIdentifier>();
                TargetFeature[] targetFeatureArray = target.getAllFeatures();
                int n = targetFeatureArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TargetFeature feature = targetFeatureArray[n2];
                    result.add(new ComponentIdentifier(feature.getId(), "eclipse.feature", Version.parseVersion((String)feature.getVersion())));
                    ++n2;
                }
                targetFeatureArray = target.getBundles();
                n = targetFeatureArray.length;
                n2 = 0;
                while (n2 < n) {
                    TargetFeature bundle = targetFeatureArray[n2];
                    BundleInfo b = bundle.getBundleInfo();
                    result.add(new ComponentIdentifier(b.getSymbolicName(), "osgi.bundle", Version.parseVersion((String)b.getVersion())));
                    ++n2;
                }
                return result;
            }
        });
    }

    public ITargetDefinition getDefaultPlatform(boolean asActive) throws CoreException {
        LoadTargetDefinitionJob job;
        IStatus status;
        Buckminster bucky = Buckminster.getDefault();
        ITargetPlatformService service = (ITargetPlatformService)bucky.getService(ITargetPlatformService.class);
        ITargetDefinition dflt = null;
        ITargetHandle[] iTargetHandleArray = service.getTargets(null);
        int n = iTargetHandleArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITargetHandle handle = iTargetHandleArray[n2];
            ITargetDefinition target = handle.getTargetDefinition();
            if (defaultTP.equals(target.getName())) {
                if (!asActive) {
                    return target;
                }
                ITargetHandle activeHandle = service.getWorkspaceTargetHandle();
                if (activeHandle != null && activeHandle.equals(handle)) {
                    return target;
                }
                dflt = target;
                break;
            }
            ++n2;
        }
        if (dflt == null) {
            IProject buckyProj = CorePlugin.getDefault().getBuckminsterProject(true, null);
            IFolder tpFolder = buckyProj.getFolder("tp");
            if (!tpFolder.exists()) {
                tpFolder.create(true, false, null);
            }
            dflt = ((TargetPlatformService)service).newDefaultTarget();
            ITargetLocation runningInstance = dflt.getTargetLocations()[0];
            ITargetLocation directory = service.newDirectoryLocation(tpFolder.getLocation().toOSString());
            dflt.setTargetLocations(new ITargetLocation[]{directory, runningInstance});
            dflt.setName(defaultTP);
            service.saveTargetDefinition(dflt);
        }
        if (asActive && (status = (job = new LoadTargetDefinitionJob(dflt)).run((IProgressMonitor)new NullProgressMonitor())).getSeverity() == 4) {
            throw new CoreException(status);
        }
        return dflt;
    }

    public File getDefaultPlatformLocation(boolean asActive) throws CoreException {
        return PDETargetPlatform.getLocation(this.getDefaultPlatform(asActive));
    }

    public File getLocation() {
        File location = PDETargetPlatform.doWithActivePlatform(new ITargetDefinitionOperation<File>(){

            @Override
            public File run(ITargetDefinition target) throws CoreException {
                return PDETargetPlatform.getLocation(target);
            }
        });
        return location;
    }

    public String getNL() {
        String nl = PDETargetPlatform.doWithActivePlatform(new ITargetDefinitionOperation<String>(){

            @Override
            public String run(ITargetDefinition target) {
                return target.getNL();
            }
        });
        return nl == null ? TargetPlatform.getNL() : nl;
    }

    public String getOS() {
        String os = PDETargetPlatform.doWithActivePlatform(new ITargetDefinitionOperation<String>(){

            @Override
            public String run(ITargetDefinition target) {
                return target.getOS();
            }
        });
        return os == null ? TargetPlatform.getOS() : os;
    }

    public String getWS() {
        String ws = PDETargetPlatform.doWithActivePlatform(new ITargetDefinitionOperation<String>(){

            @Override
            public String run(ITargetDefinition target) {
                return target.getWS();
            }
        });
        return ws == null ? TargetPlatform.getWS() : ws;
    }

    public void locationsChanged(Set<File> locations) {
        ITargetDefinition target;
        ITargetPlatformService service;
        Buckminster bucky;
        Logger log;
        block11: {
            ITargetLocation[] containers;
            block10: {
                ITargetHandle activeHandle;
                block9: {
                    log = Buckminster.getLogger();
                    bucky = Buckminster.getDefault();
                    service = null;
                    log.debug("Processing changes in target platform locations...", new Object[0]);
                    service = (ITargetPlatformService)bucky.getService(ITargetPlatformService.class);
                    activeHandle = service.getWorkspaceTargetHandle();
                    if (activeHandle != null) break block9;
                    log.debug("Found no active target handle", new Object[0]);
                    bucky.ungetService((Object)service);
                    log.debug("Done processing changes in target platform locations", new Object[0]);
                    return;
                }
                target = activeHandle.getTargetDefinition();
                containers = target.getTargetLocations();
                if (containers != null && containers.length != 0) break block10;
                log.debug("Active target handle has no containers", new Object[0]);
                bucky.ungetService((Object)service);
                log.debug("Done processing changes in target platform locations", new Object[0]);
                return;
            }
            boolean found = false;
            ITargetLocation[] iTargetLocationArray = containers;
            int n = containers.length;
            int n2 = 0;
            while (n2 < n) {
                ITargetLocation container = iTargetLocationArray[n2];
                if (container instanceof DirectoryBundleContainer && locations.contains(new File(((DirectoryBundleContainer)container).getLocation(true)))) {
                    found = true;
                    break;
                }
                ++n2;
            }
            if (found) break block11;
            log.debug("Active target handle has no containers of type DirectoryBundleContainer that matches the given locations", new Object[0]);
            bucky.ungetService((Object)service);
            log.debug("Done processing changes in target platform locations", new Object[0]);
            return;
        }
        try {
            try {
                this.refresh(target);
            }
            catch (CoreException e) {
                log.warning((Throwable)e, e.getLocalizedMessage(), new Object[0]);
                bucky.ungetService((Object)service);
                log.debug("Done processing changes in target platform locations", new Object[0]);
            }
        }
        catch (Throwable throwable) {
            bucky.ungetService(service);
            log.debug("Done processing changes in target platform locations", new Object[0]);
            throw throwable;
        }
        bucky.ungetService((Object)service);
        log.debug("Done processing changes in target platform locations", new Object[0]);
    }

    public void refresh() {
        PDETargetPlatform.doWithActivePlatform(new ITargetDefinitionOperation<Object>(){

            @Override
            public Object run(ITargetDefinition target) throws CoreException {
                PDETargetPlatform.this.refresh(target);
                return null;
            }
        });
    }

    private void refresh(ITargetDefinition target) throws CoreException {
        Logger log = Buckminster.getLogger();
        log.info(NLS.bind((String)Messages.resetting_target_platform_0, (Object)target.getName()), new Object[0]);
        PDETargetPlatform.setTargetActive(target, (IProgressMonitor)new NullProgressMonitor());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface ITargetDefinitionOperation<T> {
        public T run(ITargetDefinition var1) throws CoreException;
    }
}

