/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.internal.actor;

import java.util.Collections;
import java.util.Map;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.actor.AbstractActor;
import org.eclipse.buckminster.core.actor.IActionContext;
import org.eclipse.buckminster.core.actor.IPerformManager;
import org.eclipse.buckminster.core.common.model.ExpandingProperties;
import org.eclipse.buckminster.core.cspec.PathGroup;
import org.eclipse.buckminster.core.cspec.model.Action;
import org.eclipse.buckminster.core.cspec.model.Attribute;
import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.core.cspec.model.ComponentIdentifier;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.helpers.FilterUtils;
import org.eclipse.buckminster.core.metadata.WorkspaceInfo;
import org.eclipse.buckminster.core.metadata.model.IModelCache;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.core.version.VersionHelper;
import org.eclipse.buckminster.osgi.filter.FilterFactory;
import org.eclipse.buckminster.pde.Messages;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;

public class FragmentsActor
extends AbstractActor {
    public static final String ID = "copyTargetFragments";
    public static final String PROP_FRAGMENT_ATTRIBUTE = "fragment.attribute";

    public boolean isUpToDate(Action action, IModelCache ctx, long prerequisiteAge, long oldestTarget) throws CoreException {
        ComponentIdentifier cid = action.getCSpec().getComponentIdentifier();
        IPath outputDir = action.getProductBase();
        if (outputDir == null) {
            throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.missing_product_base_in_0_actor, (Object)ID), (Object[])new Object[0]);
        }
        Map properties = ctx.getProperties();
        outputDir = new Path((String)ExpandingProperties.expand((Map)properties, (Object)outputDir.toPortableString(), (int)0));
        IPluginModelBase plugin = PluginRegistry.findModel((String)cid.getName());
        if (plugin == null) {
            return true;
        }
        BundleDescription bundle = plugin.getBundleDescription();
        if (bundle == null) {
            return true;
        }
        BundleDescription[] fragments = bundle.getFragments();
        if (fragments == null || fragments.length == 0) {
            return true;
        }
        int count = 0;
        BundleDescription[] bundleDescriptionArray = fragments;
        int n = fragments.length;
        int n2 = 0;
        while (n2 < n) {
            block12: {
                BundleDescription fragment = bundleDescriptionArray[n2];
                String fragmentName = fragment.getName();
                if (!(fragmentName.contains(".compatibility") || fragmentName.endsWith(".test") || fragmentName.endsWith(".dummy"))) {
                    Resolution res;
                    ComponentRequest request;
                    block11: {
                        request = new ComponentRequest(fragmentName, "osgi.bundle", VersionHelper.exactRange((Version)fragment.getVersion()));
                        String filterStr = fragment.getPlatformFilter();
                        if (filterStr != null) {
                            try {
                                org.eclipse.buckminster.osgi.filter.Filter filter = FilterFactory.newInstance((String)fragment.getPlatformFilter());
                                filter = FilterUtils.replaceAttributeNames((Filter)filter, (String)"osgi", (String)"target");
                                if (filter.matches(properties)) break block11;
                                break block12;
                            }
                            catch (InvalidSyntaxException e) {
                                throw BuckminsterException.wrap((Throwable)e);
                            }
                        }
                    }
                    if ((res = WorkspaceInfo.getResolution((ComponentRequest)request, (boolean)false)) != null) {
                        ++count;
                    }
                }
            }
            ++n2;
        }
        if (count == 0) {
            return true;
        }
        String[] fragFiles = outputDir.toFile().list();
        return fragFiles != null && fragFiles.length >= count;
    }

    protected IStatus internalPerform(IActionContext ctx, IProgressMonitor monitor) throws CoreException {
        ComponentIdentifier cid = ctx.getCSpec().getComponentIdentifier();
        IPath outputDir = ctx.getAction().getProductBase();
        if (outputDir == null) {
            throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.missing_product_base_in_0_actor, (Object)ID), (Object[])new Object[0]);
        }
        Map properties = ctx.getProperties();
        outputDir = new Path((String)ExpandingProperties.expand((Map)properties, (Object)outputDir.toPortableString(), (int)0));
        IPluginModelBase launcherPlugin = PluginRegistry.findModel((String)cid.getName());
        if (launcherPlugin == null) {
            MonitorUtils.complete((IProgressMonitor)monitor);
            return Status.OK_STATUS;
        }
        BundleDescription bundle = launcherPlugin.getBundleDescription();
        if (bundle == null) {
            MonitorUtils.complete((IProgressMonitor)monitor);
            return Status.OK_STATUS;
        }
        BundleDescription[] fragments = bundle.getFragments();
        if (fragments == null || fragments.length == 0) {
            MonitorUtils.complete((IProgressMonitor)monitor);
            return Status.OK_STATUS;
        }
        String fragmentAttribute = (String)properties.get(PROP_FRAGMENT_ATTRIBUTE);
        if (fragmentAttribute == null) {
            fragmentAttribute = "bundle.jar";
        }
        monitor.beginTask(null, 100 + 100 * fragments.length);
        IPerformManager performManager = CorePlugin.getPerformManager();
        try {
            BundleDescription[] bundleDescriptionArray = fragments;
            int n = fragments.length;
            int n2 = 0;
            while (n2 < n) {
                block17: {
                    BundleDescription fragment = bundleDescriptionArray[n2];
                    String fragmentName = fragment.getName();
                    if (!fragmentName.contains(".compatibility")) {
                        Resolution res;
                        ComponentRequest request;
                        block16: {
                            request = new ComponentRequest(fragmentName, "osgi.bundle", VersionHelper.exactRange((Version)fragment.getVersion()));
                            String filterStr = fragment.getPlatformFilter();
                            if (filterStr != null) {
                                try {
                                    org.eclipse.buckminster.osgi.filter.Filter filter = FilterFactory.newInstance((String)fragment.getPlatformFilter());
                                    filter = FilterUtils.replaceAttributeNames((Filter)filter, (String)"osgi", (String)"target");
                                    if (filter.matches(properties)) break block16;
                                    break block17;
                                }
                                catch (InvalidSyntaxException e) {
                                    throw BuckminsterException.wrap((Throwable)e);
                                }
                            }
                        }
                        if ((res = WorkspaceInfo.getResolution((ComponentRequest)request, (boolean)false)) == null) {
                            MonitorUtils.worked((IProgressMonitor)monitor, (int)100);
                        } else {
                            CSpec cspec = res.getCSpec();
                            Attribute bundleJar = cspec.getAttribute(fragmentAttribute);
                            performManager.perform(Collections.singletonList(bundleJar), ctx.getGlobalContext(), MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)70));
                            PathGroup[] groups = bundleJar.getPathGroups((IModelCache)ctx, null);
                            IProgressMonitor copyMon = MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)30);
                            copyMon.beginTask(null, groups.length * 100);
                            PathGroup[] pathGroupArray = groups;
                            int n3 = groups.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                PathGroup pathGroup = pathGroupArray[n4];
                                pathGroup.copyTo(outputDir, MonitorUtils.subMonitor((IProgressMonitor)copyMon, (int)100));
                                ++n4;
                            }
                            copyMon.done();
                        }
                    }
                }
                ++n2;
            }
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }
}

