/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.internal.actor;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.eclipse.buckminster.core.actor.AbstractActor;
import org.eclipse.buckminster.core.actor.IActionContext;
import org.eclipse.buckminster.core.actor.MissingPrerequisiteException;
import org.eclipse.buckminster.core.cspec.PathGroup;
import org.eclipse.buckminster.core.cspec.model.Action;
import org.eclipse.buckminster.core.cspec.model.Attribute;
import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.core.cspec.model.Prerequisite;
import org.eclipse.buckminster.core.metadata.model.IModelCache;
import org.eclipse.buckminster.pde.Messages;
import org.eclipse.buckminster.pde.internal.model.EditableFeatureModel;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.buckminster.runtime.Trivial;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.FileUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureInfo;

public class MergeLicenseFeature
extends AbstractActor {
    public static final String ID = "mergeLicenseFeature";
    private static final Pattern propertyFilePattern = Pattern.compile("feature.*\\.properties");
    private static FileFilter featurePropertyFiles = new FileFilter(){

        public boolean accept(File file) {
            return propertyFilePattern.matcher(file.getName()).matches();
        }
    };

    private static void copyBinIncludes(Attribute binIncludes, File attributeBase, IPath outputPath, IActionContext ctx, IProgressMonitor monitor) throws CoreException {
        PathGroup base = new PathGroup(Path.fromOSString((String)attributeBase.getAbsolutePath()), new IPath[0]);
        PathGroup[] pathGroupArray = binIncludes.getPathGroups((IModelCache)ctx, null);
        int n = pathGroupArray.length;
        int n2 = 0;
        while (n2 < n) {
            PathGroup pg = pathGroupArray[n2];
            IPath[] iPathArray = pg.getPaths();
            int n3 = iPathArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String name;
                IPath path = iPathArray[n4];
                if (path.segmentCount() != 1 || !"feature.xml".equals(name = path.segment(0)) && !propertyFilePattern.matcher(name).matches()) {
                    base.copyPathTo(path, outputPath, monitor);
                }
                ++n4;
            }
            ++n2;
        }
    }

    private static Properties loadFile(File file) throws IOException {
        BufferedInputStream fis = new BufferedInputStream(new FileInputStream(file));
        try {
            Properties props = new Properties();
            props.load(fis);
            Properties properties = props;
            return properties;
        }
        finally {
            IOUtils.close((Closeable)fis);
        }
    }

    protected IStatus internalPerform(IActionContext ctx, IProgressMonitor monitor) throws CoreException {
        Action action = ctx.getAction();
        IPath outputPath = AbstractActor.getProductPath((IActionContext)ctx, (String)"action.output", (boolean)true);
        IPath manifestPath = AbstractActor.getProductPath((IActionContext)ctx, (String)"manifest", (boolean)true);
        IPath licenseFeaturePath = null;
        IPath versionedManifestPath = null;
        IPath licenseManifestPath = null;
        CSpec cspec = action.getCSpec();
        Attribute binIncludes = null;
        Attribute licenseFeatureContents = null;
        for (Prerequisite preq : action.getPrerequisites()) {
            Attribute rt;
            if ("license.feature".equals(preq.getAlias())) {
                rt = preq.getReferencedAttribute(cspec, (IModelCache)ctx);
                if (rt == null) continue;
                licenseFeaturePath = AbstractActor.getSingleAttributePath((IActionContext)ctx, (Attribute)rt, (boolean)true);
                continue;
            }
            if ("manifest".equals(preq.getAlias())) {
                rt = preq.getReferencedAttribute(cspec, (IModelCache)ctx);
                if (rt == null) continue;
                versionedManifestPath = AbstractActor.getSingleAttributePath((IActionContext)ctx, (Attribute)rt, (boolean)true);
                continue;
            }
            if ("license.manifest".equals(preq.getAlias())) {
                rt = preq.getReferencedAttribute(cspec, (IModelCache)ctx);
                if (rt == null) continue;
                licenseManifestPath = AbstractActor.getSingleAttributePath((IActionContext)ctx, (Attribute)rt, (boolean)true);
                continue;
            }
            if ("bin.includes".equals(preq.getAlias())) {
                binIncludes = preq.getReferencedAttribute(cspec, (IModelCache)ctx);
                continue;
            }
            if (!"license.feature.contents".equals(preq.getAlias())) continue;
            licenseFeatureContents = preq.getReferencedAttribute(cspec, (IModelCache)ctx);
        }
        if (licenseFeaturePath == null) {
            throw new MissingPrerequisiteException(action, (Object)"license.feature");
        }
        if (versionedManifestPath == null) {
            throw new MissingPrerequisiteException(action, (Object)"manifest");
        }
        if (!outputPath.hasTrailingSeparator()) {
            throw new IllegalArgumentException(NLS.bind((String)org.eclipse.buckminster.core.Messages.output_of_action_0_must_be_folder, (Object)action.getQualifiedName()));
        }
        try {
            File payloadFeatureDir;
            File licenseFeatureDir;
            File outputDir = outputPath.toFile().getAbsoluteFile();
            outputDir.mkdirs();
            Map props = ctx.getProperties();
            File licenseFeatureFile = licenseFeaturePath.toFile().getAbsoluteFile();
            if (licenseFeatureFile.isDirectory()) {
                licenseFeatureDir = licenseFeatureFile;
            } else {
                licenseFeatureDir = new File(new File(props.get("buckminster.temp").toString()), "licenseFeature");
                licenseFeatureDir.mkdirs();
                FileUtils.unzipFile((File)licenseFeatureFile, (File)licenseFeatureDir);
            }
            File payloadFeatureFile = ctx.getComponentLocation().toFile();
            if (payloadFeatureFile.isDirectory()) {
                payloadFeatureDir = payloadFeatureFile;
            } else {
                payloadFeatureDir = new File(new File(props.get("buckminster.temp").toString()), "payloadFeature");
                payloadFeatureDir.mkdirs();
                FileUtils.unzipFile((File)payloadFeatureFile, (File)payloadFeatureDir);
            }
            if (binIncludes != null) {
                MergeLicenseFeature.copyBinIncludes(binIncludes, payloadFeatureDir, outputPath, ctx, monitor);
            }
            if (licenseFeatureContents != null) {
                MergeLicenseFeature.copyBinIncludes(licenseFeatureContents, licenseFeatureDir, outputPath, ctx, monitor);
            }
            this.mergeProperties(licenseFeatureDir, payloadFeatureDir, outputDir);
            EditableFeatureModel payloadFeatureModel = new EditableFeatureModel(versionedManifestPath.append("feature.xml").toFile());
            payloadFeatureModel.load();
            EditableFeatureModel licenseFeatureModel = new EditableFeatureModel(licenseManifestPath.append("feature.xml").toFile());
            licenseFeatureModel.load();
            IFeature payloadFeature = payloadFeatureModel.getFeature();
            IFeature licenseFeature = licenseFeatureModel.getFeature();
            IFeatureInfo info = licenseFeature.getFeatureInfo(2);
            if (info != null) {
                payloadFeature.setFeatureInfo(info, 2);
            }
            if ((info = licenseFeature.getFeatureInfo(1)) != null) {
                payloadFeature.setFeatureInfo(info, 1);
            }
            if (Trivial.trim((String)payloadFeature.getProviderName()) == null) {
                payloadFeature.setProviderName(licenseFeature.getProviderName());
            }
            payloadFeature.setLicenseFeatureID(null);
            payloadFeature.setLicenseFeatureVersion(null);
            File manifestDir = manifestPath.toFile();
            manifestDir.mkdirs();
            payloadFeatureModel.save(new File(manifestDir, "feature.xml"));
        }
        catch (IOException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
        return Status.OK_STATUS;
    }

    private void mergeProperties(File licenseFeatureDir, File payloadFeatureDir, File targetDir) throws CoreException, IOException {
        File[] licensePropertyFiles;
        File[] payloadPropertyFiles;
        File[] fileArray = payloadPropertyFiles = payloadFeatureDir.listFiles(featurePropertyFiles);
        int n = payloadPropertyFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File payloadPropertyFile = fileArray[n2];
            org.eclipse.buckminster.core.helpers.FileUtils.copyFile((File)payloadPropertyFile, (File)targetDir, (String)payloadPropertyFile.getName(), null);
            ++n2;
        }
        File[] fileArray2 = licensePropertyFiles = licenseFeatureDir.listFiles(featurePropertyFiles);
        int n3 = licensePropertyFiles.length;
        n = 0;
        while (n < n3) {
            File licensePropertyFile = fileArray2[n];
            File featurePropertyFile = new File(targetDir, licensePropertyFile.getName());
            if (featurePropertyFile.exists()) {
                Properties licenseProperties = MergeLicenseFeature.loadFile(licensePropertyFile);
                Properties featureProperties = MergeLicenseFeature.loadFile(featurePropertyFile);
                Enumeration<Object> licenseKeys = licenseProperties.keys();
                while (licenseKeys.hasMoreElements()) {
                    String licenseKey = (String)licenseKeys.nextElement();
                    if (!featureProperties.containsKey(licenseKey)) continue;
                    throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.error_conflictingProperties, (Object[])new String[]{licenseKey, licensePropertyFile.getAbsolutePath(), featurePropertyFile.getAbsolutePath()}), (Object[])new Object[0]);
                }
            }
            FileWriter featurePropertyWriter = null;
            FileReader licensePropertyReader = new FileReader(licensePropertyFile);
            try {
                featurePropertyWriter = new FileWriter(featurePropertyFile, true);
                char[] buffer = new char[2048];
                int bytesRead = licensePropertyReader.read(buffer);
                while (bytesRead > -1) {
                    featurePropertyWriter.write(buffer, 0, bytesRead);
                    bytesRead = licensePropertyReader.read(buffer);
                }
            }
            catch (Throwable throwable) {
                IOUtils.close(featurePropertyWriter);
                IOUtils.close((Closeable)licensePropertyReader);
                throw throwable;
            }
            IOUtils.close((Closeable)featurePropertyWriter);
            IOUtils.close((Closeable)licensePropertyReader);
            ++n;
        }
    }
}

